/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class NativeHBaseTypesIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initTableValues() throws Exception {
        String tableName = SchemaUtil.getTableName((String)NativeHBaseTypesIT.generateUniqueName(), (String)NativeHBaseTypesIT.generateUniqueName());
        byte[] tableBytes = tableName.getBytes();
        byte[] familyName = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"1"));
        byte[][] splits = new byte[][]{Bytes.toBytes((int)20), Bytes.toBytes((int)30)};
        try (Admin admin = driver.getConnectionQueryServices(NativeHBaseTypesIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).getAdmin();){
            admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableBytes)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build(), (byte[][])splits);
        }
        ConnectionQueryServices services = driver.getConnectionQueryServices(NativeHBaseTypesIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        try (Table hTable = services.getTable(tableBytes);){
            byte[] key;
            ArrayList<Object> mutations = new ArrayList<Object>();
            byte[] family = Bytes.toBytes((String)"1");
            byte[] uintCol = Bytes.toBytes((String)"UINT_COL");
            byte[] ulongCol = Bytes.toBytes((String)"ULONG_COL");
            byte[] bKey = key = ByteUtil.concat((byte[])Bytes.toBytes((int)20), (byte[][])new byte[][]{Bytes.toBytes((long)200L), Bytes.toBytes((String)"b")});
            Put put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)5000));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)50000L));
            mutations.add(put);
            long ts = EnvironmentEdgeManager.currentTimeMillis();
            Delete del = new Delete(key, ts);
            mutations.add(del);
            put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)2000));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)20000L));
            mutations.add(put);
            key = ByteUtil.concat((byte[])Bytes.toBytes((int)10), (byte[][])new byte[][]{Bytes.toBytes((long)100L), Bytes.toBytes((String)"a")});
            put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)5));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)50L));
            mutations.add(put);
            put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)10));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)100L));
            mutations.add(put);
            key = ByteUtil.concat((byte[])Bytes.toBytes((int)30), (byte[][])new byte[][]{Bytes.toBytes((long)300L), Bytes.toBytes((String)"c")});
            put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)3000));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)30000L));
            mutations.add(put);
            key = ByteUtil.concat((byte[])Bytes.toBytes((int)40), (byte[][])new byte[][]{Bytes.toBytes((long)400L), Bytes.toBytes((String)"d")});
            put = new Put(key);
            put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)4000));
            put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)40000L));
            mutations.add(put);
            hTable.batch(mutations, null);
            Result r = hTable.get(new Get(bKey));
            Assert.assertFalse((boolean)r.isEmpty());
        }
        String ddl = "create table " + tableName + "   (uint_key unsigned_int not null,    ulong_key unsigned_long not null,    string_key varchar not null,\n    \"1\".uint_col unsigned_int,    \"1\".ulong_col unsigned_long    CONSTRAINT pk PRIMARY KEY (uint_key, ulong_key, string_key))\n" + "DATA_BLOCK_ENCODING" + "='" + DataBlockEncoding.NONE + "'";
        try (Connection conn = DriverManager.getConnection(url);){
            conn.createStatement().execute(ddl);
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeQuery1() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT uint_key, ulong_key, string_key FROM " + tableName + " WHERE uint_key > 20 and ulong_key >= 400";
        try (Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)40L, (long)rs.getInt(1));
            Assert.assertEquals((long)400L, (long)rs.getLong(2));
            Assert.assertEquals((Object)"d", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeQuery2() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT uint_key, ulong_key, string_key FROM " + tableName + " WHERE uint_key > 20 and uint_key < 40";
        try (Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)30L, (long)rs.getInt(1));
            Assert.assertEquals((long)300L, (long)rs.getLong(2));
            Assert.assertEquals((Object)"c", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeQuery3() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT uint_key, ulong_key, string_key FROM " + tableName + " WHERE ulong_key > 200 and ulong_key < 400";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)30L, (long)rs.getInt(1));
            Assert.assertEquals((long)300L, (long)rs.getLong(2));
            Assert.assertEquals((Object)"c", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeAgainstUnsignedNone() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT uint_key, ulong_key, string_key FROM " + tableName + " WHERE ulong_key < -1";
        try (Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeAgainstUnsignedAll() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT string_key FROM " + tableName + " WHERE ulong_key > -100";
        try (Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testNegativeAddNegativeValue() throws Exception {
        String tableName = this.initTableValues();
        Connection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl());
        try {
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + "(uint_key,ulong_key,string_key, uint_col) VALUES(?,?,?,?)");
            stmt.setInt(1, -1);
            stmt.setLong(2, 2L);
            stmt.setString(3, "foo");
            stmt.setInt(4, 3);
            stmt.execute();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
    }

    @Test
    public void testNegativeCompareNegativeValue() throws Exception {
        String tableName = this.initTableValues();
        String query = "SELECT string_key FROM " + tableName + " WHERE uint_key > 100000";
        PhoenixConnection conn = DriverManager.getConnection(NativeHBaseTypesIT.getUrl()).unwrap(PhoenixConnection.class);
        Table hTable = conn.getQueryServices().getTable(tableName.getBytes());
        ArrayList<Put> mutations = new ArrayList<Put>();
        byte[] family = Bytes.toBytes((String)"1");
        byte[] uintCol = Bytes.toBytes((String)"UINT_COL");
        byte[] ulongCol = Bytes.toBytes((String)"ULONG_COL");
        byte[] key = ByteUtil.concat((byte[])Bytes.toBytes((int)-10), (byte[][])new byte[][]{Bytes.toBytes((long)100L), Bytes.toBytes((String)"e")});
        Put put = new Put(key);
        put.addColumn(family, uintCol, Long.MAX_VALUE, Bytes.toBytes((int)10));
        put.addColumn(family, ulongCol, Long.MAX_VALUE, Bytes.toBytes((long)100L));
        put.addColumn(family, QueryConstants.EMPTY_COLUMN_BYTES, Long.MAX_VALUE, ByteUtil.EMPTY_BYTE_ARRAY);
        mutations.add(put);
        hTable.batch(mutations, null);
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"e", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

