/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class NamespaceSchemaMappingIT
extends ParallelStatsDisabledIT {
    @Test
    public void testBackWardCompatibility() throws Exception {
        String namespace;
        String schemaName = namespace = NamespaceSchemaMappingIT.generateUniqueName();
        String tableName = NamespaceSchemaMappingIT.generateUniqueName();
        String phoenixFullTableName = schemaName + "." + tableName;
        String hbaseFullTableName = schemaName + ":" + tableName;
        Admin admin = driver.getConnectionQueryServices(NamespaceSchemaMappingIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)namespace).build());
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)namespace, (String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES)).build());
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)phoenixFullTableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES)).build());
        Put put = new Put(PVarchar.INSTANCE.toBytes((Object)phoenixFullTableName));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        Table phoenixSchematable = admin.getConnection().getTable(TableName.valueOf((String)phoenixFullTableName));
        phoenixSchematable.put(put);
        put = new Put(PVarchar.INSTANCE.toBytes((Object)hbaseFullTableName));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        Table namespaceMappedtable = admin.getConnection().getTable(TableName.valueOf((String)hbaseFullTableName));
        namespaceMappedtable.put(put);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(NamespaceSchemaMappingIT.getUrl(), props);
        String ddl = "create table " + phoenixFullTableName + "(tableName varchar primary key) COLUMN_ENCODED_BYTES=NONE";
        conn.createStatement().execute(ddl);
        String query = "select tableName from " + phoenixFullTableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        TestUtil.dumpTable(namespaceMappedtable);
        TestUtil.dumpTable(phoenixSchematable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)phoenixFullTableName, (Object)rs.getString(1));
        namespaceMappedtable.close();
        phoenixSchematable.close();
        Table metatable = admin.getConnection().getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (ReadOnlyProps)conn.unwrap(PhoenixConnection.class).getQueryServices().getProps()));
        Put p = new Put(SchemaUtil.getTableKey(null, (String)schemaName, (String)tableName));
        p.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES, PBoolean.INSTANCE.toBytes((Object)true));
        metatable.put(p);
        metatable.close();
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        phxConn.getQueryServices().clearCache();
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)hbaseFullTableName, (Object)rs.getString(1));
        admin.close();
        conn.close();
    }
}

