/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.Repeat;
import org.apache.phoenix.util.RunUntilFailure;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=RunUntilFailure.class)
public class MutationStateIT
extends ParallelStatsDisabledIT {
    private static final String DDL = " (ORGANIZATION_ID CHAR(15) NOT NULL, SCORE DOUBLE, ENTITY_ID CHAR(15) NOT NULL, TAGS VARCHAR, CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (ORGANIZATION_ID, ENTITY_ID DESC)) MULTI_TENANT=TRUE";
    private static final Random RAND = new Random(5L);
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    private void upsertRows(PhoenixConnection conn, String fullTableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + fullTableName + " (organization_id, entity_id, score) values (?,?,?)");
        for (int i = 0; i < 10000; ++i) {
            stmt.setString(1, "AAAA" + i);
            stmt.setString(2, "BBBB" + i);
            stmt.setInt(3, 1);
            stmt.execute();
        }
    }

    public static String randString(int length) {
        return new BigInteger(164, RAND).toString().substring(0, length);
    }

    private static void mutateRandomly(final String upsertStmt, String fullTableName, int nThreads, final int nRows, int nIndexValues, final int batchSize, final CountDownLatch doneSignal) {
        int i;
        Runnable[] runnables = new Runnable[nThreads];
        for (i = 0; i < nThreads; ++i) {
            runnables[i] = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn = DriverManager.getConnection(MutationStateIT.getUrl());
                        for (int i = 0; i < nRows; ++i) {
                            PreparedStatement statement = conn.prepareStatement(upsertStmt);
                            int index = 0;
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(1));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
                            statement.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
                            statement.setString(++index, MutationStateIT.randString(1));
                            statement.setString(++index, MutationStateIT.randString(1));
                            statement.setBoolean(++index, false);
                            statement.setString(++index, MutationStateIT.randString(1));
                            statement.setString(++index, MutationStateIT.randString(1));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setString(++index, MutationStateIT.randString(15));
                            statement.setInt(++index, RAND.nextInt());
                            statement.execute();
                            if (i % batchSize != 0) continue;
                            conn.commit();
                        }
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
        }
        for (i = 0; i < nThreads; ++i) {
            Thread t = new Thread(runnables[i]);
            t.start();
        }
    }

    @Test
    @Repeat(value=10)
    public void testOnlyIndexTableWriteFromClientSide() throws SQLException, InterruptedException, IOException {
        String schemaName = MutationStateIT.generateUniqueName();
        String tableName = MutationStateIT.generateUniqueName();
        String indexName1 = MutationStateIT.generateUniqueName();
        String indexName2 = MutationStateIT.generateUniqueName();
        String indexName3 = MutationStateIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName1 = SchemaUtil.getTableName((String)schemaName, (String)indexName1);
        String CREATE_DATA_TABLE = "CREATE TABLE IF NOT EXISTS " + fullTableName + " ( \n    USER1_ID CHAR(15) NOT NULL,\n    ELEMENT1_ID CHAR(15) NOT NULL,\n    ELEMENT_ID CHAR(15) NOT NULL,\n    ELEMENT_TYPE VARCHAR(1) NOT NULL,\n    TYPE_ID CHAR(15) NOT NULL,\n    USER_ID CHAR(15) NOT NULL,\n    ELEMENT4_TIME TIMESTAMP,\n    ELEMENT_UPDATE TIMESTAMP,\n    ELEMENT_SCORE DOUBLE,\n    ELEMENT2_TYPE VARCHAR(1),\n    ELEMENT1_TYPE VARCHAR(1),\n    ELEMENT1_IS_SYS_GEN BOOLEAN,\n    ELEMENT1_STATUS VARCHAR(1),\n    ELEMENT1_VISIBILITY VARCHAR(1),\n    ELEMENT3_ID CHAR(15),\n    ELEMENT4_BY CHAR(15),\n    BEST_ELEMENT_ID CHAR(15),\n    ELEMENT_COUNT INTEGER,\n    CONSTRAINT PK PRIMARY KEY\n    (\n     USER1_ID,\n     ELEMENT1_ID,\n     ELEMENT_ID,\n     ELEMENT_TYPE,\n     TYPE_ID,\n     USER_ID\n )\n ) VERSIONS=1,MULTI_TENANT=TRUE,TTL=31536000\n";
        String CREATE_INDEX_1 = "CREATE INDEX IF NOT EXISTS " + indexName1 + " \n     ON " + fullTableName + " (\n     TYPE_ID,\n     ELEMENT_ID,\n     ELEMENT_TYPE,\n     USER_ID,\n     ELEMENT4_TIME DESC,\n     ELEMENT1_ID DESC\n     ) INCLUDE (\n     ELEMENT2_TYPE,\n     ELEMENT1_TYPE,\n     ELEMENT1_IS_SYS_GEN,\n     ELEMENT1_STATUS,\n     ELEMENT1_VISIBILITY,\n     ELEMENT3_ID,\n     ELEMENT4_BY,\n     BEST_ELEMENT_ID,\n     ELEMENT_COUNT\n     )\n";
        String CREATE_INDEX_2 = " CREATE INDEX IF NOT EXISTS " + indexName2 + "\n     ON " + fullTableName + " (\n     TYPE_ID,\n     ELEMENT_ID,\n     ELEMENT_TYPE,\n     USER_ID,\n     ELEMENT_UPDATE DESC,\n     ELEMENT1_ID DESC\n     ) INCLUDE (\n     ELEMENT2_TYPE,\n     ELEMENT1_TYPE,\n     ELEMENT1_IS_SYS_GEN,\n     ELEMENT1_STATUS,\n     ELEMENT1_VISIBILITY,\n     ELEMENT3_ID,\n     ELEMENT4_BY,\n     BEST_ELEMENT_ID,\n     ELEMENT_COUNT\n     )\n";
        String CREATE_INDEX_3 = "CREATE INDEX IF NOT EXISTS " + indexName3 + "\n     ON " + fullTableName + " (\n     TYPE_ID,\n     ELEMENT_ID,\n     ELEMENT_TYPE,\n     USER_ID,\n     ELEMENT_SCORE DESC,\n     ELEMENT1_ID DESC\n     ) INCLUDE (\n     ELEMENT2_TYPE,\n     ELEMENT1_TYPE,\n     ELEMENT1_IS_SYS_GEN,\n     ELEMENT1_STATUS,\n     ELEMENT1_VISIBILITY,\n     ELEMENT3_ID,\n     ELEMENT4_BY,\n     BEST_ELEMENT_ID,\n     ELEMENT_COUNT\n     )\n";
        String UPSERT_INTO_DATA_TABLE = "UPSERT INTO " + fullTableName + "\n(\n    USER1_ID,\n    ELEMENT1_ID,\n    ELEMENT_ID,\n    ELEMENT_TYPE,\n    TYPE_ID,\n    USER_ID,\n    ELEMENT4_TIME,\n    ELEMENT_UPDATE,\n    ELEMENT2_TYPE,\n    ELEMENT1_TYPE,\n    ELEMENT1_IS_SYS_GEN,\n    ELEMENT1_STATUS,\n    ELEMENT1_VISIBILITY,\n    ELEMENT3_ID,\n    ELEMENT4_BY,\n    BEST_ELEMENT_ID,\n    ELEMENT_COUNT\n)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int nThreads = 1;
        int nRows = 5000;
        int nIndexValues = 4000;
        int batchSize = 200;
        CountDownLatch doneSignal = new CountDownLatch(nThreads);
        try (Connection conn = DriverManager.getConnection(MutationStateIT.getUrl());){
            conn.createStatement().execute(CREATE_DATA_TABLE);
            conn.createStatement().execute(CREATE_INDEX_1);
            conn.createStatement().execute(CREATE_INDEX_2);
            conn.createStatement().execute(CREATE_INDEX_3);
            conn.commit();
            MutationStateIT.mutateRandomly(UPSERT_INTO_DATA_TABLE, fullTableName, nThreads, nRows, nIndexValues, batchSize, doneSignal);
            Thread.sleep(200L);
            MutationStateIT.unassignRegionAsync(fullIndexName1);
            Assert.assertTrue((String)"Ran out of time", (boolean)doneSignal.await(120L, TimeUnit.SECONDS));
            long dataTableRows = TestUtil.getRowCount(conn, fullTableName);
            ResultSet rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)schemaName), null, new String[]{PTableType.INDEX.toString()});
            while (rs.next()) {
                String indexState = rs.getString("INDEX_STATE");
                String indexName = rs.getString(3);
                long rowCountIndex = TestUtil.getRowCount(conn, SchemaUtil.getTableName((String)schemaName, (String)indexName));
                if (indexState.equals(PIndexState.ACTIVE.name())) {
                    Assert.assertTrue((dataTableRows == rowCountIndex ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((dataTableRows > rowCountIndex ? 1 : 0) != 0);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Test
    public void testDeleteMaxMutationSize() throws SQLException {
        String tableName = MutationStateIT.generateUniqueName();
        int NUMBER_OF_ROWS = 20;
        String ddl = "CREATE TABLE " + tableName + " (V BIGINT PRIMARY KEY, K BIGINT)";
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl());
        conn.createStatement().execute(ddl);
        for (int i = 0; i < NUMBER_OF_ROWS; ++i) {
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (" + i + ", " + i + ")");
            conn.commit();
        }
        Properties props = new Properties();
        props.setProperty("phoenix.mutate.maxSize", String.valueOf(NUMBER_OF_ROWS / 2));
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), props);
        connection.setAutoCommit(false);
        try {
            for (int i = 0; i < NUMBER_OF_ROWS; ++i) {
                connection.createStatement().execute("DELETE FROM " + tableName + " WHERE K = " + i);
            }
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED.getMessage()));
        }
        props.setProperty("phoenix.mutate.maxSizeBytes", "10");
        props.setProperty("phoenix.mutate.maxSize", "10000");
        connection = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), props);
        connection.setAutoCommit(false);
        try {
            connection.createStatement().execute("DELETE FROM " + tableName);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.MAX_MUTATION_SIZE_BYTES_EXCEEDED.getMessage()));
        }
    }

    @Test
    public void testUpsertMaxMutationSize() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.mutate.maxSize", "3");
        connectionProperties.setProperty("phoenix.mutate.maxSizeBytes", "1000000");
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), connectionProperties);
        String fullTableName = MutationStateIT.generateUniqueName();
        try (Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + DDL);
        }
        try {
            this.upsertRows(connection, fullTableName);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED.getMessage()));
            Assert.assertTrue((boolean)e.getMessage().contains(connectionProperties.getProperty("phoenix.mutate.maxSize")));
        }
        connectionProperties.setProperty("phoenix.mutate.maxSize", "1000");
        connectionProperties.setProperty("phoenix.mutate.maxSizeBytes", "4");
        connection = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), connectionProperties);
        try {
            this.upsertRows(connection, fullTableName);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MAX_MUTATION_SIZE_BYTES_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.MAX_MUTATION_SIZE_BYTES_EXCEEDED.getMessage()));
            Assert.assertTrue((boolean)e.getMessage().contains(connectionProperties.getProperty("phoenix.mutate.maxSizeBytes")));
        }
    }

    @Test
    public void testMutationEstimatedSize() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl());
        conn.setAutoCommit(false);
        String fullTableName = MutationStateIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + DDL);
        }
        MutationState state = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getMutationState();
        long prevEstimatedSize = state.getEstimatedSize();
        this.upsertRows(conn, fullTableName);
        Assert.assertTrue((String)"Mutation state size should have increased", (state.getEstimatedSize() > prevEstimatedSize ? 1 : 0) != 0);
        conn.commit();
        Assert.assertEquals((String)"Mutation state size should be zero after commit", (long)0L, (long)state.getEstimatedSize());
        this.upsertRows(conn, fullTableName);
        conn.rollback();
        Assert.assertEquals((String)"Mutation state size should be zero after rollback", (long)0L, (long)state.getEstimatedSize());
        PreparedStatement stmt = conn.prepareStatement("upsert into " + fullTableName + " (organization_id, entity_id, score) values (?,?,?)");
        stmt.setString(1, "ZZZZ");
        stmt.setString(2, "YYYY");
        stmt.setInt(3, 1);
        stmt.execute();
        Assert.assertTrue((String)"Mutation state size should be greater than zero ", (state.getEstimatedSize() > 0L ? 1 : 0) != 0);
        prevEstimatedSize = state.getEstimatedSize();
        stmt.setString(1, "ZZZZ");
        stmt.setString(2, "YYYY");
        stmt.setInt(3, 1);
        stmt.execute();
        Assert.assertEquals((String)"Mutation state size should only increase 4 bytes (size of the new statement index)", (long)(prevEstimatedSize + 4L), (long)state.getEstimatedSize());
        prevEstimatedSize = state.getEstimatedSize();
        stmt = conn.prepareStatement("upsert into " + fullTableName + " (organization_id, entity_id, score, tags) values (?,?,?,?)");
        stmt.setString(1, "ZZZZ");
        stmt.setString(2, "YYYY");
        stmt.setInt(3, 1);
        stmt.setString(4, "random text string random text string random text string");
        stmt.execute();
        Assert.assertTrue((String)"Mutation state size should increase", (prevEstimatedSize + 4L < state.getEstimatedSize() ? 1 : 0) != 0);
        prevEstimatedSize = state.getEstimatedSize();
        stmt = conn.prepareStatement("upsert into " + fullTableName + " (organization_id, entity_id, score, tags) values (?,?,?,?)");
        stmt.setString(1, "ZZZZ");
        stmt.setString(2, "YYYY");
        stmt.setInt(3, 1);
        stmt.setString(4, "");
        stmt.execute();
        Assert.assertTrue((String)"Mutation state size should decrease", (prevEstimatedSize + 4L > state.getEstimatedSize() ? 1 : 0) != 0);
    }

    @Test
    public void testSplitMutationsIntoSameGroupForSingleRow() throws Exception {
        String tableName = "TBL_" + MutationStateIT.generateUniqueName();
        String indexName = "IDX_" + MutationStateIT.generateUniqueName();
        Properties props = new Properties();
        props.put("phoenix.mutate.batchSize", "2");
        try (PhoenixConnection conn = DriverManager.getConnection(MutationStateIT.getUrl(), props).unwrap(PhoenixConnection.class);){
            conn.setAutoCommit(false);
            conn.createStatement().executeUpdate("CREATE TABLE " + tableName + " (A VARCHAR NOT NULL PRIMARY KEY,B VARCHAR,C VARCHAR,D VARCHAR) COLUMN_ENCODED_BYTES = 0");
            conn.createStatement().executeUpdate("CREATE INDEX " + indexName + " on " + tableName + " (C) INCLUDE(D)");
            conn.createStatement().executeUpdate("UPSERT INTO " + tableName + "(A,B,C,D) VALUES ('A2','B2','C2','D2')");
            conn.createStatement().executeUpdate("UPSERT INTO " + tableName + "(A,B,C,D) VALUES ('A3','B3', 'C3', null)");
            conn.commit();
            Table htable = conn.getQueryServices().getTable(Bytes.toBytes((String)tableName));
            Scan scan = new Scan();
            scan.setRaw(true);
            Iterator scannerIter = htable.getScanner(scan).iterator();
            while (scannerIter.hasNext()) {
                long ts = -1L;
                Result r = (Result)scannerIter.next();
                for (Cell cell : r.listCells()) {
                    if (ts == -1L) {
                        ts = cell.getTimestamp();
                        continue;
                    }
                    Assert.assertEquals((String)("(" + cell.toString() + ") has different ts"), (long)ts, (long)cell.getTimestamp());
                }
            }
            htable.close();
        }
    }

    @Test
    public void testDDLwithPendingMutations() throws Exception {
        String tableName = MutationStateIT.generateUniqueName();
        MutationStateIT.ensureTableCreated(MutationStateIT.getUrl(), tableName, "PTSDB", null, null, null);
        Properties props = new Properties();
        props.setProperty("phoenix.pending.mutations.before.ddl.throw", Boolean.toString(true));
        try (Connection conn = DriverManager.getConnection(MutationStateIT.getUrl(), props);){
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (inst,host,\"DATE\") VALUES(?,'b',CURRENT_DATE())");
            stmt.setString(1, "a");
            stmt.execute();
            String tableName2 = MutationStateIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName2 + " (V BIGINT PRIMARY KEY, K BIGINT)";
            this.exceptionRule.expect(SQLException.class);
            this.exceptionRule.expectMessage(SQLExceptionCode.CANNOT_PERFORM_DDL_WITH_PENDING_MUTATIONS.getMessage());
            conn.createStatement().execute(ddl);
        }
    }

    @Test
    public void testNoPendingMutationsOnDDL() throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.pending.mutations.before.ddl.throw", Boolean.toString(true));
        String tableName = MutationStateIT.generateUniqueName();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), props);){
            String ddl = "create table " + tableName + " ( id1 UNSIGNED_INT not null primary key,appId1 VARCHAR)";
            conn.createStatement().execute(ddl);
            Admin admin = driver.getConnectionQueryServices(MutationStateIT.getUrl(), props).getAdmin();
            Assert.assertNotNull((Object)admin.getDescriptor(TableName.valueOf((String)tableName)));
            Assert.assertNotNull((Object)conn.getTableNoCache(tableName));
        }
    }

    @Test
    public void testUpsertMaxColumnAllowanceForSingleCellArrayWithOffsets() throws Exception {
        this.testUpsertColumnExceedsMaxAllowanceSize("SINGLE_CELL_ARRAY_WITH_OFFSETS");
    }

    @Test
    public void testUpsertMaxColumnAllowanceForOneCellPerColumn() throws Exception {
        this.testUpsertColumnExceedsMaxAllowanceSize("ONE_CELL_PER_COLUMN");
    }

    public void testUpsertColumnExceedsMaxAllowanceSize(String storageScheme) throws Exception {
        block41: {
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("hbase.client.keyvalue.maxsize", "20");
            try (PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(MutationStateIT.getUrl(), connectionProperties);){
                String fullTableName = MutationStateIT.generateUniqueName();
                String pk1Name = MutationStateIT.generateUniqueName();
                String pk2Name = MutationStateIT.generateUniqueName();
                String ddl = "CREATE IMMUTABLE TABLE " + fullTableName + " (" + pk1Name + " VARCHAR(15) NOT NULL, " + pk2Name + " VARCHAR(15) NOT NULL, PAYLOAD1 VARCHAR, PAYLOAD2 VARCHAR,PAYLOAD3 VARCHAR CONSTRAINT PK PRIMARY KEY (" + pk1Name + "," + pk2Name + ")) IMMUTABLE_STORAGE_SCHEME =" + storageScheme;
                try (Statement stmt = connection.createStatement();){
                    stmt.execute(ddl);
                }
                String sql = "UPSERT INTO " + fullTableName + " (" + pk1Name + "," + pk2Name + ",PAYLOAD1,PAYLOAD2,PAYLOAD2) VALUES (?,?,?,?,?)";
                String pk1Value = MutationStateIT.generateUniqueName();
                String pk2Value = MutationStateIT.generateUniqueName();
                String payload1Value = MutationStateIT.generateUniqueName();
                String payload3Value = MutationStateIT.generateUniqueName();
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                    preparedStatement.setString(1, pk1Value);
                    preparedStatement.setString(2, pk2Value);
                    preparedStatement.setString(3, payload1Value);
                    preparedStatement.setString(4, "1234567890");
                    preparedStatement.setString(5, payload3Value);
                    preparedStatement.execute();
                    try {
                        preparedStatement.setString(1, pk1Value);
                        preparedStatement.setString(2, pk2Value);
                        preparedStatement.setString(3, payload1Value);
                        preparedStatement.setString(4, "12345678901234567890");
                        preparedStatement.setString(5, payload3Value);
                        preparedStatement.execute();
                        if (storageScheme.equals("ONE_CELL_PER_COLUMN")) {
                            Assert.fail();
                        }
                    }
                    catch (SQLException e) {
                        if (!storageScheme.equals("ONE_CELL_PER_COLUMN")) {
                            Assert.fail();
                            break block41;
                        }
                        Assert.assertEquals((long)SQLExceptionCode.MAX_HBASE_CLIENT_KEYVALUE_MAXSIZE_EXCEEDED.getErrorCode(), (long)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.MAX_HBASE_CLIENT_KEYVALUE_MAXSIZE_EXCEEDED.getMessage()));
                        Assert.assertTrue((boolean)e.getMessage().contains(connectionProperties.getProperty("hbase.client.keyvalue.maxsize")));
                    }
                }
            }
        }
    }
}

