/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseMutationBatchFailedStateMetricIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.ImmutableIndexIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class MutationBatchFailedStateMetricWithAllDeleteIT
extends BaseMutationBatchFailedStateMetricIT {
    String transactionProvider;

    public MutationBatchFailedStateMetricWithAllDeleteIT(String transactionProvider) {
        super(transactionProvider);
        this.transactionProvider = transactionProvider;
    }

    @Test
    public void testFailedDelete() throws Exception {
        block3: {
            int numDeleteCount = 0;
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(MutationBatchFailedStateMetricWithAllDeleteIT.getUrl(), props);
                Statement stmt = conn.createStatement();
                TestUtil.addCoprocessor(conn, this.deleteTableName, ImmutableIndexIT.DeleteFailingRegionObserver.class);
                ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + this.deleteTableName + " where val1 > 1");
                rs.next();
                numDeleteCount = rs.getInt(1);
                String dml = String.format("DELETE FROM %s where val1 >  1", this.deleteTableName);
                stmt.execute(dml);
                conn.commit();
                Assert.fail((String)"Commit should not have succeeded");
            }
            catch (SQLException e) {
                Map mutationMetrics = conn.unwrap(PhoenixConnection.class).getMutationMetrics();
                int dbfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.DELETE_BATCH_FAILED_SIZE)).intValue();
                int upfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.UPSERT_BATCH_FAILED_SIZE)).intValue();
                int mfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.MUTATION_BATCH_FAILED_SIZE)).intValue();
                long gfs = GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue();
                Assert.assertEquals((long)numDeleteCount, (long)dbfs);
                Assert.assertEquals((long)0L, (long)upfs);
                Assert.assertEquals((long)numDeleteCount, (long)mfs);
                if (this.transactionProvider == null) {
                    Assert.assertEquals((long)(2 * numDeleteCount), (long)gfs);
                }
                if (!this.transactionProvider.equals("OMID")) break block3;
                Assert.assertEquals((long)numDeleteCount, (long)gfs);
            }
        }
    }
}

