/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class MultiCfQueryExecIT
extends ParallelStatsEnabledIT {
    private String fullTableName;

    @Before
    public void generateTableNames() throws SQLException {
        String schemaName = "S";
        String tableName = "T_" + MultiCfQueryExecIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
    }

    private void createTable(Connection conn) throws SQLException {
        conn.createStatement().execute("create table " + this.fullTableName + "   (id char(15) not null primary key,\n    a.unique_user_count integer,\n    b.unique_org_count integer,\n    c.db_cpu_utilization decimal(31,10),\n    d.transaction_count bigint,\n    e.cpu_utilization decimal(31,10),\n    f.response_time bigint,\n    g.response_time bigint)");
    }

    private void initTableValues(Connection conn) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.fullTableName + "(    ID,     TRANSACTION_COUNT,     CPU_UTILIZATION,     DB_CPU_UTILIZATION,    UNIQUE_USER_COUNT,    F.RESPONSE_TIME,    G.RESPONSE_TIME)VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "000000000000001");
        stmt.setInt(2, 100);
        stmt.setBigDecimal(3, BigDecimal.valueOf(0.5));
        stmt.setBigDecimal(4, BigDecimal.valueOf(0.2));
        stmt.setInt(5, 1000);
        stmt.setLong(6, 11111L);
        stmt.setLong(7, 11112L);
        stmt.execute();
        stmt.setString(1, "000000000000002");
        stmt.setInt(2, 200);
        stmt.setBigDecimal(3, BigDecimal.valueOf(2.5));
        stmt.setBigDecimal(4, BigDecimal.valueOf(2.2));
        stmt.setInt(5, 2000);
        stmt.setLong(6, 2222L);
        stmt.setLong(7, 22222L);
        stmt.execute();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantCount() throws Exception {
        String query = "SELECT count(1) from " + this.fullTableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCFToDisambiguateInSelectOnly1() throws Exception {
        String query = "SELECT F.RESPONSE_TIME,G.RESPONSE_TIME from " + this.fullTableName + " where ID = '000000000000002'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2222L, (long)rs.getLong(1));
            Assert.assertEquals((long)22222L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCFToDisambiguateInSelectOnly2() throws Exception {
        String query = "SELECT F.RESPONSE_TIME,G.RESPONSE_TIME from " + this.fullTableName + " where TRANSACTION_COUNT = 200";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2222L, (long)rs.getLong(1));
            Assert.assertEquals((long)22222L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuidePostsForMultiCFs() throws Exception {
        String query = "SELECT F.RESPONSE_TIME,G.RESPONSE_TIME from " + this.fullTableName + " where F.RESPONSE_TIME = 2222";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2222L, (long)rs.getLong(1));
            Assert.assertEquals((long)22222L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
            List<KeyRange> splits = TestUtil.getAllSplits(conn, this.fullTableName, "e.cpu_utilization IS NOT NULL", "COUNT(*)");
            Assert.assertEquals((long)3L, (long)splits.size());
            splits = TestUtil.getAllSplits(conn, this.fullTableName, "g.response_time IS NOT NULL", "COUNT(*)");
            Assert.assertEquals((long)3L, (long)splits.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuidePostsForMultiCFsOverUnevenDistrib() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl(), props);
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " (K1 CHAR(1) NOT NULL, K2 VARCHAR NOT NULL, CF1.A INTEGER, CF2.B INTEGER, CF3.C INTEGER, CF4.D INTEGER, CF5.E INTEGER, CF6.F INTEGER CONSTRAINT PK PRIMARY KEY (K1,K2)) SPLIT ON ('B','C','D')");
        for (int i = 0; i < 100; ++i) {
            String upsert = "UPSERT INTO " + this.fullTableName + "(K1,K2,A) VALUES('" + Character.toString((char)(65 + i % 10)) + "','" + i * 10 + "'," + i + ")";
            conn.createStatement().execute(upsert);
            if (i % 10 != 0) continue;
            conn.createStatement().execute("UPSERT INTO " + this.fullTableName + "(K1,K2,F) VALUES('" + Character.toString((char)(65 + i % 10)) + "','" + i * 10 + "'," + i * 10 + ")");
        }
        conn.commit();
        try {
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement("select count(*) from " + this.fullTableName + " where f < 400");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            List<KeyRange> splits = TestUtil.getAllSplits(conn, this.fullTableName, "f < 400", "COUNT(*)");
            Assert.assertEquals((long)14L, (long)splits.size());
            splits = TestUtil.getAllSplits(conn, this.fullTableName, "a < 80", "COUNT(*)");
            Assert.assertEquals((long)104L, (long)splits.size());
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testGuidePostsRetrievedForMultiCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl(), props);
        conn.createStatement().execute("CREATE TABLE " + this.fullTableName + " (  k INTEGER PRIMARY KEY, A.V1 VARCHAR, B.V2 VARCHAR, C.V3 VARCHAR)");
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + " VALUES(?,?,?,?)");
        stmt.setInt(1, 1);
        stmt.setString(2, "A");
        stmt.setString(3, "B");
        stmt.setString(4, "C");
        stmt.execute();
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + " VALUES(?,?,?,?)");
        stmt.setInt(1, 2);
        stmt.setString(2, "D");
        stmt.setString(3, "E");
        stmt.setString(4, "F");
        stmt.execute();
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + "(k, A.V1, C.V3) VALUES(?,?,?)");
        stmt.setInt(1, 3);
        stmt.setString(2, "E");
        stmt.setString(3, "X");
        stmt.execute();
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + this.fullTableName + "(k, A.V1, C.V3) VALUES(?,?,?)");
        stmt.setInt(1, 4);
        stmt.setString(2, "F");
        stmt.setString(3, "F");
        stmt.execute();
        conn.commit();
        TestUtil.analyzeTable(conn, this.fullTableName);
        ResultSet rs = conn.createStatement().executeQuery("SELECT B.V2 FROM " + this.fullTableName + " WHERE B.V2 = 'B'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"B", (Object)rs.getString(1));
        List<KeyRange> splits = TestUtil.getAllSplits(conn, this.fullTableName, "C.V3 = 'X'", "A.V1");
        Assert.assertEquals((long)5L, (long)splits.size());
        splits = TestUtil.getAllSplits(conn, this.fullTableName, "B.V2 = 'B'", "B.V2");
        Assert.assertEquals((long)3L, (long)splits.size());
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCFToDisambiguate2() throws Exception {
        String query = "SELECT F.RESPONSE_TIME,G.RESPONSE_TIME from " + this.fullTableName + " where G.RESPONSE_TIME-1 = F.RESPONSE_TIME";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)11111L, (long)rs.getLong(1));
            Assert.assertEquals((long)11112L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultCFToDisambiguate() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        this.createTable(conn);
        this.initTableValues(conn);
        String ddl = "ALTER TABLE " + this.fullTableName + " ADD response_time BIGINT";
        conn.createStatement().execute(ddl);
        String dml = "upsert into " + this.fullTableName + "(    ID,     RESPONSE_TIME)VALUES ('000000000000003', 333)";
        conn.createStatement().execute(dml);
        conn.commit();
        TestUtil.analyzeTable(conn, this.fullTableName);
        String query = "SELECT ID,RESPONSE_TIME from " + this.fullTableName + " where RESPONSE_TIME = 333";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"000000000000003", (Object)rs.getString(1));
            Assert.assertEquals((long)333L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEssentialColumnFamilyForRowKeyFilter() throws Exception {
        String query = "SELECT F.RESPONSE_TIME,G.RESPONSE_TIME from " + this.fullTableName + " where SUBSTR(ID, 15) = '2'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            this.createTable(conn);
            this.initTableValues(conn);
            TestUtil.analyzeTable(conn, this.fullTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2222L, (long)rs.getLong(1));
            Assert.assertEquals((long)22222L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCFWildcardProjection() throws Exception {
        try (Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl());){
            String tableName = MultiCfQueryExecIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 INTEGER NOT NULL PRIMARY KEY, x.v1 VARCHAR, y.v2 INTEGER)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 'test', 2)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT x.* FROM " + tableName + " WHERE y.v2 = 2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            rs.close();
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_IDX ON " + tableName + "(y.v2)");
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT x.* FROM " + tableName + " WHERE y.v2 = 2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            rs.close();
            rs = conn.createStatement().executeQuery("SELECT y.* FROM " + tableName + " WHERE x.v1 <> 'blah'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs.close();
        }
    }

    @Test
    public void testMultipleCFWildcardProjection() throws Exception {
        try (Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl());){
            String tableName = MultiCfQueryExecIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 INTEGER NOT NULL PRIMARY KEY, x.v1 VARCHAR, y.v2 INTEGER, z.v3 INTEGER)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 'test', 2, 3)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT x.*, z.* FROM " + tableName + " WHERE y.v2 = 2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            rs.close();
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_IDX ON " + tableName + "(y.v2)");
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT x.*, z.* FROM " + tableName + " WHERE y.v2 = 2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            rs.close();
            rs = conn.createStatement().executeQuery("SELECT x.*, y.* FROM " + tableName + " WHERE z.v3 = 3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            rs.close();
        }
    }

    @Test
    public void testMixedDefaultAndExplicitCFs() throws Exception {
        try (Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl());){
            String tableName = MultiCfQueryExecIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (pk1 INTEGER NOT NULL PRIMARY KEY, v1 VARCHAR, y.v1 INTEGER)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 'test', 2)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            rs.close();
            conn.createStatement().execute("CREATE LOCAL INDEX " + tableName + "_IDX ON " + tableName + "(v1)");
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            rs.close();
        }
    }

    @Test
    public void testBug3890() throws Exception {
        try (Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl());){
            String tableName = MultiCfQueryExecIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (HOST CHAR(2) NOT NULL, DOMAIN VARCHAR NOT NULL, FEATURE VARCHAR NOT NULL, DATE DATE NOT NULL, USAGE.CORE BIGINT, USAGE.DB BIGINT, STATS.ACTIVE_VISITOR INTEGER CONSTRAINT PK PRIMARY KEY (HOST, DOMAIN, FEATURE, DATE))";
            conn.createStatement().execute(ddl);
            String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(upsert);){
                stmt.setString(1, "H1");
                stmt.setString(2, "Salesforce");
                stmt.setString(3, "F1");
                stmt.setDate(4, new Date(100L));
                stmt.setLong(5, 100L);
                stmt.setLong(6, 2000L);
                stmt.setLong(7, 10L);
                stmt.executeUpdate();
                stmt.setString(1, "H2");
                stmt.setString(2, "Heroku");
                stmt.setString(3, "F1");
                stmt.setDate(4, new Date(100L));
                stmt.setLong(5, 100L);
                stmt.setLong(6, 1000L);
                stmt.setLong(7, 10L);
                stmt.executeUpdate();
                conn.commit();
            }
            String query = "SELECT DOMAIN, AVG(CORE) Average_CPU_Usage, AVG(DB) Average_DB_Usage FROM " + tableName + " GROUP BY DOMAIN ORDER BY DOMAIN DESC";
            ResultSet rs = conn.createStatement().executeQuery(query);
            rs.next();
            Assert.assertEquals((Object)"Salesforce", (Object)rs.getString(1));
            Assert.assertEquals((long)0L, (long)Double.compare(100.0, rs.getDouble(2)));
            Assert.assertEquals((long)0L, (long)Double.compare(2000.0, rs.getDouble(3)));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Heroku", (Object)rs.getString(1));
            Assert.assertEquals((long)0L, (long)Double.compare(100.0, rs.getDouble(2)));
            Assert.assertEquals((long)0L, (long)Double.compare(1000.0, rs.getDouble(3)));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT TRUNC(DATE,'DAY') DAY, SUM(CORE) TOTAL_CPU_Usage, MIN(CORE) MIN_CPU_Usage, MAX(CORE) MAX_CPU_Usage FROM " + tableName + " WHERE DOMAIN LIKE 'Salesforce%' GROUP BY TRUNC(DATE,'DAY')";
            rs = conn.createStatement().executeQuery(query);
            rs.next();
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertEquals((Object)100L, (Object)rs.getLong(2));
            Assert.assertEquals((Object)100L, (Object)rs.getLong(3));
            Assert.assertEquals((Object)100L, (Object)rs.getLong(4));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT HOST, SUM(ACTIVE_VISITOR) TOTAL_ACTIVE_VISITORS FROM " + tableName + " WHERE DB > (CORE * 10) GROUP BY HOST";
            rs = conn.createStatement().executeQuery(query);
            rs.next();
            Assert.assertEquals((Object)"H1", (Object)rs.getString(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBug4658() throws Exception {
        try (Connection conn = DriverManager.getConnection(MultiCfQueryExecIT.getUrl());
             Statement stmt = conn.createStatement();){
            String tableName = MultiCfQueryExecIT.generateUniqueName();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 VARCHAR NOT NULL,COL2 VARCHAR NOT NULL,COL3 VARCHAR,FAM.COL4 VARCHAR,CONSTRAINT TRADE_EVENT_PK PRIMARY KEY (COL1, COL2))");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) values ('111', 'AAA')");
            stmt.execute("UPSERT INTO " + tableName + " (COL1, COL2) values ('222', 'AAA')");
            conn.commit();
            try (ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE COL2 = 'AAA' ORDER BY COL1 DESC");){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString("COL1"), (Object)"222");
                Assert.assertEquals((Object)rs.getString("COL2"), (Object)"AAA");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString("COL1"), (Object)"111");
                Assert.assertEquals((Object)rs.getString("COL2"), (Object)"AAA");
                Assert.assertFalse((boolean)rs.next());
            }
            String query = "SELECT /*+ FORWARD_SCAN */ * FROM " + tableName + " WHERE COL2 = 'AAA' ORDER BY COL1 DESC";
            try (ResultSet rs = stmt.executeQuery("EXPLAIN " + query);){
                String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertFalse((boolean)explainPlan.contains("REVERSE"));
            }
            rs = stmt.executeQuery(query);
            var8_14 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString("COL1"), (Object)"222");
                Assert.assertEquals((Object)rs.getString("COL2"), (Object)"AAA");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString("COL1"), (Object)"111");
                Assert.assertEquals((Object)rs.getString("COL2"), (Object)"AAA");
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var8_14 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_14 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_14.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }
}

