/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MinMaxAggregateFunctionIT
extends ParallelStatsDisabledIT {
    private static final String TABLE_NAME = MinMaxAggregateFunctionIT.generateUniqueName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinMaxAggregateFunctions() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(MinMaxAggregateFunctionIT.getUrl(), props);){
            conn.prepareStatement("create table " + TABLE_NAME + "(VAL1 integer not null, VAL2 char(2), VAL3 varchar, VAL4 varchar constraint PK primary key (VAL1))").execute();
            conn.commit();
            conn.prepareStatement("upsert into " + TABLE_NAME + " values (0, '00', '00', '0')").execute();
            conn.prepareStatement("upsert into " + TABLE_NAME + " values (1, '01', '01', '1')").execute();
            conn.prepareStatement("upsert into " + TABLE_NAME + " values (2, '02', '02', '2')").execute();
            conn.commit();
            ResultSet rs = conn.prepareStatement("select min(VAL2) from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00", (Object)rs.getString(1));
            rs = conn.prepareStatement("select min(VAL3) from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00", (Object)rs.getString(1));
            rs = conn.prepareStatement("select max(VAL2)from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"02", (Object)rs.getString(1));
            rs = conn.prepareStatement("select max(VAL3)from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"02", (Object)rs.getString(1));
            rs = conn.prepareStatement("select min(VAL1), min(VAL2), min(VAL3), min(VAL4) from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"00", (Object)rs.getString(2));
            Assert.assertEquals((Object)"00", (Object)rs.getString(3));
            Assert.assertEquals((Object)"0", (Object)rs.getString(4));
            rs = conn.prepareStatement("select max(VAL1), max(VAL2), max(VAL3), max(VAL4) from " + TABLE_NAME).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"02", (Object)rs.getString(2));
            Assert.assertEquals((Object)"02", (Object)rs.getString(3));
            Assert.assertEquals((Object)"2", (Object)rs.getString(4));
        }
    }
}

