/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.UpgradeInProgressException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MigrateSystemTablesToSystemNamespaceIT
extends BaseTest {
    private static final Set<String> PHOENIX_SYSTEM_TABLES = new HashSet<String>(Arrays.asList("SYSTEM.CATALOG", "SYSTEM.SEQUENCE", "SYSTEM.STATS", "SYSTEM.FUNCTION", "SYSTEM.MUTEX", "SYSTEM.LOG", "SYSTEM.CHILD_LINK", "SYSTEM.TASK", "SYSTEM.TRANSFORM", "SYSTEM.CDC_STREAM_STATUS", "SYSTEM.CDC_STREAM"));
    private static final Set<String> PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES = new HashSet<String>(Arrays.asList("SYSTEM:CATALOG", "SYSTEM:SEQUENCE", "SYSTEM:STATS", "SYSTEM:FUNCTION", "SYSTEM:MUTEX", "SYSTEM:LOG", "SYSTEM:CHILD_LINK", "SYSTEM:TASK", "SYSTEM:TRANSFORM", "SYSTEM:CDC_STREAM_STATUS", "SYSTEM:CDC_STREAM"));
    private static final String SCHEMA_NAME = "MIGRATETEST";
    private static final String TABLE_NAME = "MIGRATETEST." + MigrateSystemTablesToSystemNamespaceIT.class.getSimpleName().toUpperCase();
    private static final int NUM_RECORDS = 5;
    private HBaseTestingUtility testUtil = null;
    private Set<String> hbaseTables;
    final UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[0]);
    final UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[0]);
    final UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])new String[0]);
    final UserGroupInformation user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])new String[0]);

    @BeforeClass
    public static synchronized void registerTestDriver() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
    }

    public final void doSetup(boolean systemMappingEnabled) throws Exception {
        this.testUtil = new HBaseTestingUtility();
        Configuration conf = this.testUtil.getConfiguration();
        conf.set("hbase.coprocessor.regionserver.classes", PhoenixRegionServerEndpointTestImpl.class.getName());
        this.enableNamespacesOnServer(conf, systemMappingEnabled);
        this.configureRandomHMasterPort(conf);
        this.testUtil.startMiniCluster(1);
    }

    @After
    public void tearDownMiniCluster() {
        try {
            if (this.testUtil != null) {
                boolean refCountLeaked = MigrateSystemTablesToSystemNamespaceIT.isAnyStoreRefCountLeaked();
                ServerMetadataCacheTestImpl.resetCache();
                this.testUtil.shutdownMiniCluster();
                this.testUtil = null;
                Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void freshClientsCreateNamespaceMappedSystemTables() throws Exception {
        this.doSetup(true);
        this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                MigrateSystemTablesToSystemNamespaceIT.this.createTable(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
        this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                MigrateSystemTablesToSystemNamespaceIT.this.readTable(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                return null;
            }
        });
    }

    @Test
    public void migrateSystemTablesInExistingCluster() throws Exception {
        this.doSetup(false);
        this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled());
                MigrateSystemTablesToSystemNamespaceIT.this.createTable(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled());
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_SYSTEM_TABLES));
        this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                MigrateSystemTablesToSystemNamespaceIT.this.readTable(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
    }

    @Test
    public void oldClientsAfterSystemTableMigrationShouldFail() throws Exception {
        this.doSetup(true);
        this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((this.hbaseTables.size() == PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
        try {
            this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled());
                    return null;
                }
            });
            Assert.fail((String)"Client should not be able to connect to cluster with inconsistent SYSTEM table namespace properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((this.hbaseTables.size() == PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
    }

    @Test
    public void onlyOneClientCanMigrate() throws Exception {
        block2: {
            this.doSetup(false);
            this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled());
                    return null;
                }
            });
            this.hbaseTables = this.getHBaseTables();
            Assert.assertTrue((this.hbaseTables.size() == PHOENIX_SYSTEM_TABLES.size() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_SYSTEM_TABLES));
            this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    MigrateSystemTablesToSystemNamespaceIT.this.changeMutexLock(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled(), true);
                    return null;
                }
            });
            this.hbaseTables = this.getHBaseTables();
            Assert.assertTrue((this.hbaseTables.size() == PHOENIX_SYSTEM_TABLES.size() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_SYSTEM_TABLES));
            try {
                this.user3.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                        return null;
                    }
                });
                Assert.fail((String)"Multiple clients should not be able to migrate simultaneously.");
            }
            catch (Exception e) {
                if (e.getCause() instanceof UpgradeInProgressException) break block2;
                Assert.fail((String)"UpgradeInProgressException expected since the user is trying to migrate when SYSMUTEX is locked.");
            }
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((this.hbaseTables.size() == PHOENIX_SYSTEM_TABLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_SYSTEM_TABLES));
        this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.changeMutexLock(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingDisabled(), false);
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((this.hbaseTables.size() == PHOENIX_SYSTEM_TABLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_SYSTEM_TABLES));
        this.user3.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                MigrateSystemTablesToSystemNamespaceIT.this.createConnection(MigrateSystemTablesToSystemNamespaceIT.this.getClientPropertiesWithSystemMappingEnabled());
                return null;
            }
        });
        this.hbaseTables = this.getHBaseTables();
        Assert.assertTrue((this.hbaseTables.size() == PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.hbaseTables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
    }

    private void changeMutexLock(Properties clientProps, boolean acquire) throws SQLException, IOException {
        ConnectionQueryServices services = null;
        try (Connection conn = DriverManager.getConnection(this.getJdbcUrl(), clientProps);){
            services = conn.unwrap(PhoenixConnection.class).getQueryServices();
            if (acquire) {
                Assert.assertTrue((boolean)((ConnectionQueryServicesImpl)services).acquireUpgradeMutex(0L));
            } else {
                services.deleteMutexCell(null, "SYSTEM", "CATALOG", null, null);
            }
        }
    }

    private void enableNamespacesOnServer(Configuration conf, boolean systemMappingEnabled) {
        conf.set("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        conf.set("phoenix.schema.mapSystemTablesToNamespace", systemMappingEnabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    private void configureRandomHMasterPort(Configuration conf) {
        conf.setInt("hbase.master.info.port", -1);
    }

    private Properties getClientPropertiesWithSystemMappingEnabled() {
        Properties clientProps = new Properties();
        clientProps.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        clientProps.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.TRUE.toString());
        return clientProps;
    }

    private Properties getClientPropertiesWithSystemMappingDisabled() {
        Properties clientProps = new Properties();
        clientProps.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        clientProps.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.FALSE.toString());
        return clientProps;
    }

    private Set<String> getHBaseTables() throws IOException {
        HashSet<String> tables = new HashSet<String>();
        for (TableName tn : this.testUtil.getAdmin().listTableNames()) {
            tables.add(tn.getNameAsString());
        }
        return tables;
    }

    private void createConnection(Properties clientProps) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(this.getJdbcUrl(), clientProps);
             Statement stmt = conn.createStatement();){
            this.verifySyscatData(clientProps, conn.toString(), stmt);
        }
    }

    private void createTable(Properties clientProps) throws SQLException {
        try (Connection conn = DriverManager.getConnection(this.getJdbcUrl(), clientProps);
             Statement stmt = conn.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + TABLE_NAME));
            stmt.execute("CREATE SCHEMA MIGRATETEST");
            Assert.assertFalse((boolean)stmt.execute("CREATE TABLE " + TABLE_NAME + "(pk INTEGER not null primary key, data VARCHAR)"));
            try (PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + TABLE_NAME + " values(?, ?)");){
                for (int i = 0; i < 5; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setString(2, Integer.toString(i));
                    Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                }
            }
            conn.commit();
        }
    }

    private void readTable(Properties clientProps) throws SQLException {
        try (Connection conn = DriverManager.getConnection(this.getJdbcUrl(), clientProps);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT pk, data FROM " + TABLE_NAME);
            Assert.assertNotNull((Object)rs);
            int i = 0;
            while (rs.next()) {
                Assert.assertEquals((long)i, (long)rs.getInt(1));
                Assert.assertEquals((Object)Integer.toString(i), (Object)rs.getString(2));
                ++i;
            }
            Assert.assertEquals((long)5L, (long)i);
        }
    }

    private void verifySyscatData(Properties clientProps, String connName, Statement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery("SELECT * FROM SYSTEM.CATALOG");
        ReadOnlyProps props = new ReadOnlyProps((Map)clientProps);
        boolean systemTablesMapped = SchemaUtil.isNamespaceMappingEnabled((PTableType)PTableType.SYSTEM, (ReadOnlyProps)props);
        boolean systemSchemaExists = false;
        HashSet<String> namespaceMappedSystemTablesSet = new HashSet<String>(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES);
        HashSet<String> systemTablesSet = new HashSet<String>(PHOENIX_SYSTEM_TABLES);
        while (rs.next()) {
            if (rs.getString("IS_NAMESPACE_MAPPED") == null) {
                systemSchemaExists = rs.getString("TABLE_SCHEM").equals("SYSTEM") ? true : systemSchemaExists;
                continue;
            }
            if (rs.getString("COLUMN_NAME") != null) continue;
            String schemaName = rs.getString("TABLE_SCHEM");
            String tableName = rs.getString("TABLE_NAME");
            if (!schemaName.equals("SYSTEM")) continue;
            if (systemTablesMapped) {
                namespaceMappedSystemTablesSet.remove(String.valueOf(TableName.valueOf((String)(schemaName + ":" + tableName))));
                Assert.assertTrue((boolean)rs.getString("IS_NAMESPACE_MAPPED").equals(Boolean.TRUE.toString()));
                continue;
            }
            systemTablesSet.remove(String.valueOf(TableName.valueOf((String)(schemaName + "." + tableName))));
            Assert.assertTrue((boolean)rs.getString("IS_NAMESPACE_MAPPED").equals(Boolean.FALSE.toString()));
        }
        if (systemTablesMapped) {
            if (!systemSchemaExists) {
                Assert.fail((String)"SYSTEM entry doesn't exist in SYSTEM.CATALOG table.");
            }
            Assert.assertTrue((boolean)namespaceMappedSystemTablesSet.isEmpty());
        } else {
            Assert.assertTrue((boolean)systemTablesSet.isEmpty());
        }
    }

    private String getJdbcUrl() {
        return "jdbc:phoenix+zk:localhost:" + this.testUtil.getZkCluster().getClientPort() + ":/hbase";
    }
}

