/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MetaDataEndpointImplIT
extends ParallelStatsDisabledIT {
    private final TableName catalogTable = TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
    private final TableName linkTable = TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES);

    @Test
    public void testGettingChildrenAndParentViews() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String leftChild = MetaDataEndpointImplIT.generateUniqueName();
        String rightChild = MetaDataEndpointImplIT.generateUniqueName();
        String leftGrandChild = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + rightChild + " AS SELECT * FROM " + baseTable);
        conn.createStatement().execute("CREATE VIEW " + leftChild + " (carrier VARCHAR) AS SELECT * FROM " + baseTable);
        conn.createStatement().execute("CREATE VIEW " + leftGrandChild + " (dropped_calls BIGINT) AS SELECT * FROM " + leftChild);
        PTable table = conn.getTable(baseTable.toUpperCase());
        PTable rightChildTable = conn.getTable(rightChild.toUpperCase());
        System.err.println(rightChildTable);
        TableViewFinderResult childViews = new TableViewFinderResult();
        ViewUtil.findAllRelatives((Table)MetaDataEndpointImplIT.getUtility().getConnection().getTable(this.linkTable), (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])table.getSchemaName().getBytes(), (byte[])table.getTableName().getBytes(), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)childViews);
        Assert.assertEquals((long)3L, (long)childViews.getLinks().size());
        PTable childMostView = conn.getTable(leftGrandChild.toUpperCase());
        TableViewFinderResult parentViews = new TableViewFinderResult();
        ViewUtil.findAllRelatives((Table)MetaDataEndpointImplIT.getUtility().getConnection().getTable(this.catalogTable), (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])childMostView.getSchemaName().getBytes(), (byte[])childMostView.getTableName().getBytes(), (PTable.LinkType)PTable.LinkType.PARENT_TABLE, (TableViewFinderResult)parentViews);
        Assert.assertEquals((long)1L, (long)parentViews.getLinks().size());
        this.assertColumnNamesEqual(conn.getTable(childMostView.getName().getString()), "PK2", "V1", "V2", "CARRIER", "DROPPED_CALLS");
    }

    @Test
    public void testUpsertIntoChildViewWithPK() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String view = MetaDataEndpointImplIT.generateUniqueName();
        String childView = MetaDataEndpointImplIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());){
            String baseTableDDL = "CREATE TABLE IF NOT EXISTS " + baseTable + " (TENANT_ID VARCHAR NOT NULL, KEY_PREFIX CHAR(3) NOT NULL, V1 VARCHAR CONSTRAINT PK PRIMARY KEY(TENANT_ID, KEY_PREFIX)) VERSIONS=1, IMMUTABLE_ROWS=TRUE";
            conn.createStatement().execute(baseTableDDL);
            String view1DDL = "CREATE VIEW IF NOT EXISTS " + view + "(V2 VARCHAR NOT NULL,V3 BIGINT NOT NULL, V4 VARCHAR CONSTRAINT PKVIEW PRIMARY KEY(V2, V3)) AS SELECT * FROM " + baseTable + " WHERE KEY_PREFIX = '0CY'";
            conn.createStatement().execute(view1DDL);
            String childViewDDL = "CREATE VIEW IF NOT EXISTS " + childView + " (V5 VARCHAR NOT NULL, V6 VARCHAR NOT NULL CONSTRAINT PK PRIMARY KEY (V5, V6)) AS SELECT * FROM " + view;
            conn.createStatement().execute(childViewDDL);
            String upsert = "UPSERT INTO " + childView + " (TENANT_ID, V2, V3, V5, V6) VALUES ('00D005000000000',  'zzzzz', 10, 'zzzzz', 'zzzzz')";
            conn.createStatement().executeUpdate(upsert);
            conn.commit();
        }
    }

    @Test
    public void testUpsertIntoTenantChildViewWithPK() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String view = MetaDataEndpointImplIT.generateUniqueName();
        String childView = MetaDataEndpointImplIT.generateUniqueName();
        String tenantId = "TENANT";
        try (Connection conn = DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());){
            String baseTableDDL = "CREATE TABLE IF NOT EXISTS " + baseTable + " (TENANT_ID VARCHAR NOT NULL, KEY_PREFIX CHAR(3) NOT NULL, V1 VARCHAR CONSTRAINT PK PRIMARY KEY(TENANT_ID, KEY_PREFIX)) MULTI_TENANT=TRUE, VERSIONS=1, IMMUTABLE_ROWS=TRUE";
            conn.createStatement().execute(baseTableDDL);
            String view1DDL = "CREATE VIEW IF NOT EXISTS " + view + "(V2 VARCHAR NOT NULL,V3 BIGINT NOT NULL, V4 VARCHAR CONSTRAINT PKVIEW PRIMARY KEY(V2, V3)) AS SELECT * FROM " + baseTable + " WHERE KEY_PREFIX = '0CY'";
            conn.createStatement().execute(view1DDL);
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(MetaDataEndpointImplIT.getUrl(), tenantProps);){
                String childViewDDL = "CREATE VIEW IF NOT EXISTS " + childView + " (V5 VARCHAR NOT NULL, V6 VARCHAR NOT NULL CONSTRAINT PK PRIMARY KEY (V5, V6)) AS SELECT * FROM " + view;
                tenantConn.createStatement().execute(childViewDDL);
                String upsert = "UPSERT INTO " + childView + " (TENANT_ID, V2, V3, V5, V6) VALUES ('00D005000000000',  'zzzzz', 10, 'zzzzz', 'zzzzz')";
                tenantConn.createStatement().executeUpdate(upsert);
                tenantConn.commit();
            }
            conn.commit();
        }
    }

    @Test
    public void testGettingOneChild() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String leftChild = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + leftChild + " (carrier VARCHAR) AS SELECT * FROM " + baseTable);
        this.assertColumnNamesEqual(conn.getTable(leftChild.toUpperCase()), "PK2", "V1", "V2", "CARRIER");
    }

    @Test
    public void testDroppingADerivedColumn() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String childView = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE " + baseTable + " (A VARCHAR PRIMARY KEY, B VARCHAR, C VARCHAR)";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + childView + " (D VARCHAR) AS SELECT * FROM " + baseTable);
        this.assertColumnNamesEqual(conn.getTable(childView.toUpperCase()), "A", "B", "C", "D");
        conn.createStatement().execute("ALTER VIEW " + childView + " DROP COLUMN C");
        this.assertColumnNamesEqual(conn.getTableNoCache(childView.toUpperCase()), "A", "B", "D");
    }

    @Test
    public void testUpdateCacheWithAlteringColumns() throws Exception {
        String tableName = MetaDataEndpointImplIT.generateUniqueName();
        try (PhoenixConnection conn = DriverManager.getConnection(MetaDataEndpointImplIT.getUrl()).unwrap(PhoenixConnection.class);){
            String ddlFormat = "CREATE TABLE IF NOT EXISTS " + tableName + "  ( PK2 INTEGER NOT NULL, V1 INTEGER, V2 INTEGER  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
            conn.createStatement().execute(ddlFormat);
            conn.createStatement().execute("ALTER TABLE " + tableName + " ADD V3 integer");
            PTable table = conn.getTable(tableName.toUpperCase());
            this.assertColumnNamesEqual(table, "PK2", "V1", "V2", "V3");
            Properties props = PropertiesUtil.deepCopy((Properties)conn.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(table.getTimeStamp()));
            try (PhoenixConnection metaConnection = new PhoenixConnection(conn, conn.getQueryServices(), props);){
                table = metaConnection.getTableNoCache(tableName.toUpperCase());
                this.assertColumnNamesEqual(table, "PK2", "V1", "V2", "V3");
            }
        }
    }

    @Test
    public void testDroppingAColumn() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String childView = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE " + baseTable + " (A VARCHAR PRIMARY KEY, B VARCHAR, C VARCHAR)";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + childView + " (D VARCHAR) AS SELECT * FROM " + baseTable);
        this.assertColumnNamesEqual(conn.getTable(childView.toUpperCase()), "A", "B", "C", "D");
        conn.createStatement().execute("ALTER TABLE " + baseTable + " DROP COLUMN C");
        this.assertColumnNamesEqual(conn.getTableNoCache(childView.toUpperCase()), "A", "B", "D");
    }

    @Test
    public void testAlteringBaseColumns() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String leftChild = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + leftChild + " (carrier VARCHAR) AS SELECT * FROM " + baseTable);
        PTable childPTable = conn.getTable(leftChild.toUpperCase());
        this.assertColumnNamesEqual(childPTable, "PK2", "V1", "V2", "CARRIER");
        conn.createStatement().execute("ALTER TABLE " + baseTable + " ADD V3 integer");
        PTable table = conn.getTableNoCache(baseTable.toUpperCase());
        this.assertColumnNamesEqual(table, "PK2", "V1", "V2", "V3");
        childPTable = conn.getTableNoCache(leftChild.toUpperCase());
        this.assertColumnNamesEqual(childPTable, "PK2", "V1", "V2", "V3", "CARRIER");
    }

    @Test
    public void testAddingAColumnWithADifferentDefinition() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String view = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + view + " (carrier BIGINT) AS SELECT * FROM " + baseTable);
        ImmutableMap expected = new ImmutableMap.Builder().put((Object)"PK2", (Object)"VARCHAR").put((Object)"V1", (Object)"VARCHAR").put((Object)"V2", (Object)"VARCHAR").put((Object)"CARRIER", (Object)"BIGINT").build();
        this.assertColumnNamesAndDefinitionsEqual(conn.getTable(view.toUpperCase()), (Map<String, String>)expected);
        try {
            conn.createStatement().execute("ALTER TABLE " + baseTable + " ADD carrier VARCHAR");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
        }
        ImmutableMap expectedBaseTableColumns = new ImmutableMap.Builder().put((Object)"PK2", (Object)"VARCHAR").put((Object)"V1", (Object)"VARCHAR").put((Object)"V2", (Object)"VARCHAR").build();
        this.assertColumnNamesAndDefinitionsEqual(conn.getTable(baseTable.toUpperCase()), (Map<String, String>)expectedBaseTableColumns);
        ImmutableMap expectedViewColumnDefinition = new ImmutableMap.Builder().put((Object)"PK2", (Object)"VARCHAR").put((Object)"V1", (Object)"VARCHAR").put((Object)"V2", (Object)"VARCHAR").put((Object)"CARRIER", (Object)"BIGINT").build();
        this.assertColumnNamesAndDefinitionsEqual(conn.getTable(view.toUpperCase()), (Map<String, String>)expectedViewColumnDefinition);
    }

    public void testDropCascade() throws Exception {
        String baseTable = MetaDataEndpointImplIT.generateUniqueName();
        String child = MetaDataEndpointImplIT.generateUniqueName();
        String grandChild = MetaDataEndpointImplIT.generateUniqueName();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String ddlFormat = "CREATE TABLE IF NOT EXISTS " + baseTable + "  ( PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (PK2) )";
        conn.createStatement().execute(ddlFormat);
        conn.createStatement().execute("CREATE VIEW " + child + " (A VARCHAR) AS SELECT * FROM " + baseTable);
        conn.createStatement().execute("CREATE VIEW " + grandChild + " (B VARCHAR) AS SELECT * FROM " + child);
        PTable childMostView = conn.getTable(child.toUpperCase());
        PTable grandChildPTable = conn.getTable(childMostView.getName().getString());
        this.assertColumnNamesEqual(grandChildPTable, "PK2", "V1", "V2", "A");
        conn.createStatement().execute("DROP TABLE " + baseTable + " CASCADE");
        try {
            conn.getTableNoCache(baseTable);
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            conn.getTableNoCache(child);
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            conn.getTableNoCache(grandChild);
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testWhereClause() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndpointImplIT.getUrl());
        String baseTableName = MetaDataEndpointImplIT.generateUniqueName();
        String childViewName = MetaDataEndpointImplIT.generateUniqueName();
        String grandChildViewName = MetaDataEndpointImplIT.generateUniqueName();
        String baseTableDdl = "CREATE TABLE " + baseTableName + " (A0 CHAR(1) NOT NULL PRIMARY KEY,A1 CHAR(1), A2 CHAR (1))";
        conn.createStatement().execute(baseTableDdl);
        conn.createStatement().execute("CREATE VIEW " + childViewName + " AS SELECT * FROM " + baseTableName + " WHERE A1 = 'X'");
        conn.createStatement().execute("CREATE VIEW " + grandChildViewName + " AS SELECT * FROM " + childViewName + " WHERE A2 = 'Y'");
        PTable childViewTable = conn.getTableNoCache(childViewName);
        PTable grandChildViewTable = conn.getTableNoCache(grandChildViewName);
        Assert.assertNotNull((Object)childViewTable.getColumnForColumnName("A1").getViewConstant());
        Assert.assertNotNull((Object)grandChildViewTable.getColumnForColumnName("A1").getViewConstant());
        Assert.assertNotNull((Object)grandChildViewTable.getColumnForColumnName("A2").getViewConstant());
    }

    private void assertColumnNamesEqual(PTable table, String ... cols) {
        ArrayList actual = Lists.newArrayList();
        for (PColumn column : table.getColumns()) {
            actual.add(column.getName().getString().trim());
        }
        List<String> expected = Arrays.asList(cols);
        Assert.assertEquals((Object)Joiner.on((String)", ").join(expected), (Object)Joiner.on((String)", ").join((Iterable)actual));
    }

    private void assertColumnNamesAndDefinitionsEqual(PTable table, Map<String, String> expected) {
        HashMap actual = Maps.newHashMap();
        for (PColumn column : table.getColumns()) {
            actual.put(column.getName().getString().trim(), column.getDataType().getSqlTypeName());
        }
        Assert.assertEquals(expected, (Object)actual);
    }
}

