/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.monitoring.IndexMetricsIT;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.metrics.MetricsMetadataSourceFactory;
import org.apache.phoenix.schema.metrics.MetricsMetadataSourceImpl;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MetaDataEndPointIT
extends ParallelStatsDisabledIT {
    @Test
    public void testUpdateIndexState() throws Throwable {
        String schemaName = MetaDataEndPointIT.generateUniqueName();
        String tableName = MetaDataEndPointIT.generateUniqueName();
        String indexName1 = MetaDataEndPointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName1 = SchemaUtil.getTableName((String)schemaName, (String)indexName1);
        try (Connection conn = DriverManager.getConnection(MetaDataEndPointIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true, GUIDE_POSTS_WIDTH=1000");
            conn.createStatement().execute("CREATE INDEX " + indexName1 + " ON " + fullTableName + " (v1) INCLUDE (v2)");
            conn.commit();
            Table metaTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            MetaDataProtocol.MutationCode code = IndexUtil.updateIndexState((String)fullIndexName1, (long)0L, (Table)metaTable, (PIndexState)PIndexState.DISABLE).getMutationCode();
            Assert.assertEquals((Object)MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, (Object)code);
            long ts = EnvironmentEdgeManager.currentTimeMillis();
            code = IndexUtil.updateIndexState((String)fullIndexName1, (long)ts, (Table)metaTable, (PIndexState)PIndexState.INACTIVE).getMutationCode();
            Assert.assertEquals((Object)MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, (Object)code);
        }
    }

    @Test
    public void testMetadataMetricsOfCreateTable() throws Throwable {
        String schemaName = MetaDataEndPointIT.generateUniqueName();
        String tableName = MetaDataEndPointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndPointIT.getUrl());){
            MetricsMetadataSourceImpl metricsSource = (MetricsMetadataSourceImpl)MetricsMetadataSourceFactory.getMetadataMetricsSource();
            DynamicMetricsRegistry registry = metricsSource.getMetricsRegistry();
            long expectedCreateTableCount = IndexMetricsIT.getCounterValueByName("createTableCount", registry);
            long expectedCacheUsedSize = IndexMetricsIT.getCounterValueByName("metadataCacheEstimatedUsedSize", registry);
            long expectedCacheAddCount = IndexMetricsIT.getCounterValueByName("metadataCacheAddCount", registry);
            String ddl = "CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true, GUIDE_POSTS_WIDTH=1000";
            conn.createStatement().execute(ddl);
            IndexMetricsIT.verifyCounterWithValue("createTableCount", registry, ++expectedCreateTableCount);
            PTable table = conn.getTable(fullTableName);
            IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, expectedCacheUsedSize += (long)table.getEstimatedSize());
            IndexMetricsIT.verifyCounterWithValue("metadataCacheAddCount", registry, ++expectedCacheAddCount);
        }
    }

    @Test
    public void testMetadataMetricsOfDropTable() throws Throwable {
        String schemaName = MetaDataEndPointIT.generateUniqueName();
        String tableName = MetaDataEndPointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndPointIT.getUrl());){
            MetricsMetadataSourceImpl metricsSource = (MetricsMetadataSourceImpl)MetricsMetadataSourceFactory.getMetadataMetricsSource();
            DynamicMetricsRegistry registry = metricsSource.getMetricsRegistry();
            String ddl = "CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true, GUIDE_POSTS_WIDTH=1000";
            conn.createStatement().execute(ddl);
            long expectedDropTableCount = IndexMetricsIT.getCounterValueByName("dropTableCount", registry);
            long expectedCacheUsedSize = IndexMetricsIT.getCounterValueByName("metadataCacheEstimatedUsedSize", registry);
            PTable table = conn.getTable(fullTableName);
            ddl = "DROP TABLE " + fullTableName;
            conn.createStatement().execute(ddl);
            IndexMetricsIT.verifyCounterWithValue("dropTableCount", registry, ++expectedDropTableCount);
            IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, expectedCacheUsedSize -= (long)table.getEstimatedSize());
        }
    }

    @Test
    public void testMetadataMetricsOfAlterTableAddCol() throws Throwable {
        String schemaName = MetaDataEndPointIT.generateUniqueName();
        String tableName = MetaDataEndPointIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MetaDataEndPointIT.getUrl());){
            MetricsMetadataSourceImpl metricsSource = (MetricsMetadataSourceImpl)MetricsMetadataSourceFactory.getMetadataMetricsSource();
            DynamicMetricsRegistry registry = metricsSource.getMetricsRegistry();
            String ddl = "CREATE TABLE " + fullTableName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) ";
            conn.createStatement().execute(ddl);
            long expectedDropTableCount = IndexMetricsIT.getCounterValueByName("alterAddColumnCount", registry);
            long prevCacheUsedSize = IndexMetricsIT.getCounterValueByName("metadataCacheEstimatedUsedSize", registry);
            ddl = "ALTER TABLE " + fullTableName + " ADD b_string VARCHAR  NULL PRIMARY KEY  ";
            conn.createStatement().execute(ddl);
            IndexMetricsIT.verifyCounterWithValue("alterAddColumnCount", registry, ++expectedDropTableCount);
            long currCacheUsedSize = IndexMetricsIT.getCounterValueByName("metadataCacheEstimatedUsedSize", registry);
            Assert.assertTrue((currCacheUsedSize >= prevCacheUsedSize ? 1 : 0) != 0);
        }
    }
}

