/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.util.MergeViewIndexIdSequencesTool;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MergeViewIndexIdSequencesToolIT
extends ParallelStatsDisabledIT {
    private final String CLEAN_QUERY = "DELETE FROM SYSTEM.\"SEQUENCE\"";
    private final String COUNT_QUERY = "SELECT COUNT(*) FROM SYSTEM.\"SEQUENCE\"";
    private final String UPSERT_QUERY = "UPSERT INTO SYSTEM.\"SEQUENCE\" (TENANT_ID, SEQUENCE_SCHEMA, SEQUENCE_NAME, START_WITH, CURRENT_VALUE, INCREMENT_BY,CACHE_SIZE,MIN_VALUE,MAX_VALUE,CYCLE_FLAG,LIMIT_REACHED_FLAG) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private final String OLD_SEQUENCE_SCHEMA = "_SEQ_TEST.B";
    private final String OLD_SEQUENCE_NAME = "_ID_";
    private final String NEW_SEQUENCE_SCHEMA = "TEST";
    private final String NEW_SEQUENCE_NAME = "B_ID_";

    @Test
    public void testOldSequenceFormat() throws Exception {
        this.testSequenceRowCount(true);
    }

    @Test
    public void testNewSequenceFormat() throws Exception {
        this.testSequenceRowCount(false);
    }

    private void testSequenceRowCount(boolean isTestingOldFormat) throws Exception {
        int expectedRowCount = isTestingOldFormat ? 2 : 1;
        MergeViewIndexIdSequencesTool tool = new MergeViewIndexIdSequencesTool();
        tool.setConf(config);
        try (Connection conn = DriverManager.getConnection(MergeViewIndexIdSequencesToolIT.getUrl());){
            conn.createStatement().execute("DELETE FROM SYSTEM.\"SEQUENCE\"");
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO SYSTEM.\"SEQUENCE\" (TENANT_ID, SEQUENCE_SCHEMA, SEQUENCE_NAME, START_WITH, CURRENT_VALUE, INCREMENT_BY,CACHE_SIZE,MIN_VALUE,MAX_VALUE,CYCLE_FLAG,LIMIT_REACHED_FLAG) VALUES (?,?,?,?,?,?,?,?,?,?,?)");){
                preparedStatement.setString(1, null);
                if (isTestingOldFormat) {
                    preparedStatement.setString(2, "_SEQ_TEST.B");
                    preparedStatement.setString(3, "_ID_");
                } else {
                    preparedStatement.setString(2, "TEST");
                    preparedStatement.setString(3, "B_ID_");
                }
                preparedStatement.setLong(4, -32768L);
                preparedStatement.setLong(5, -32767L);
                preparedStatement.setInt(6, 1);
                preparedStatement.setInt(7, 1);
                preparedStatement.setLong(8, Long.MIN_VALUE);
                preparedStatement.setLong(9, Long.MAX_VALUE);
                preparedStatement.setBoolean(10, false);
                preparedStatement.setBoolean(11, false);
                preparedStatement.execute();
                conn.commit();
            }
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM SYSTEM.\"SEQUENCE\"");
            TestCase.assertTrue((boolean)rs.next());
            TestCase.assertEquals((int)1, (int)rs.getInt(1));
            int status = tool.run(new String[]{"-r"});
            TestCase.assertEquals((int)0, (int)status);
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM SYSTEM.\"SEQUENCE\"");
            TestCase.assertTrue((boolean)rs.next());
            TestCase.assertEquals((int)expectedRowCount, (int)rs.getInt(1));
        }
    }
}

