/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MaxLookbackIT
extends BaseTest {
    private static final int MAX_LOOKBACK_AGE = 15;
    private static final int ROWS_POPULATED = 2;
    public static final int WAIT_AFTER_TABLE_CREATION_MILLIS = 1;
    private String tableDDLOptions;
    private StringBuilder optionBuilder;
    ManualEnvironmentEdge injectEdge;
    private int ttl;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(15));
        props.put("phoenix.compaction.enabled", Boolean.toString(false));
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        MaxLookbackIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void beforeTest() {
        EnvironmentEdgeManager.reset();
        this.optionBuilder = new StringBuilder();
        this.tableDDLOptions = this.optionBuilder.toString();
        this.ttl = 0;
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    @After
    public synchronized void afterTest() throws Exception {
        boolean refCountLeaked = MaxLookbackIT.isAnyStoreRefCountLeaked();
        EnvironmentEdgeManager.reset();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testTooLowSCNWithMaxLookbackAge() throws Exception {
        String dataTableName = MaxLookbackIT.generateUniqueName();
        this.createTable(dataTableName);
        this.injectEdge.setValue(System.currentTimeMillis());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
        this.injectEdge.incrementValue(1L);
        this.populateTable(dataTableName);
        long populateTime = EnvironmentEdgeManager.currentTimeMillis();
        this.injectEdge.incrementValue(16000L);
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(populateTime));
        try (Connection connscn = DriverManager.getConnection(MaxLookbackIT.getUrl(), props);){
            connscn.createStatement().executeQuery("select * from " + dataTableName);
        }
        catch (SQLException se) {
            SQLExceptionCode code = SQLExceptionCode.CANNOT_QUERY_TABLE_WITH_SCN_OLDER_THAN_MAX_LOOKBACK_AGE;
            TestUtil.assertSqlExceptionCode(code, se);
            return;
        }
        Assert.fail((String)"We should have thrown an exception for the too-early SCN");
    }

    @Test(timeout=120000L)
    public void testRecentlyDeletedRowsNotCompactedAway() throws Exception {
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            String dataTableName = MaxLookbackIT.generateUniqueName();
            String indexName = MaxLookbackIT.generateUniqueName();
            this.createTable(dataTableName);
            TableName dataTable = TableName.valueOf((String)dataTableName);
            this.populateTable(dataTableName);
            this.createIndex(dataTableName, indexName, 1);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            TableName indexTable = TableName.valueOf((String)indexName);
            this.injectEdge.incrementValue(1L);
            long beforeDeleteSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(10L);
            Statement stmt = conn.createStatement();
            stmt.execute("DELETE FROM " + dataTableName + " WHERE  id = 'a'");
            Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
            conn.commit();
            String sql = String.format("SELECT * FROM %s WHERE id = 'a'", dataTableName);
            String indexSql = String.format("SELECT * FROM %s WHERE val1 = 'ab'", dataTableName);
            int rowsPlusDeleteMarker = 2;
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), sql, beforeDeleteSCN, true);
            MaxLookbackIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), indexSql, beforeDeleteSCN, true);
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), sql, beforeDeleteSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), indexSql, beforeDeleteSCN, true);
            long beforeFirstCompactSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, rowsPlusDeleteMarker);
            TestUtil.assertRawRowCount(conn, indexTable, rowsPlusDeleteMarker);
            this.injectEdge.incrementValue(15000L);
            long beforeSecondCompactSCN = EnvironmentEdgeManager.currentTimeMillis();
            String notDeletedRowSql = String.format("SELECT * FROM %s WHERE id = 'b'", dataTableName);
            String notDeletedIndexRowSql = String.format("SELECT * FROM %s WHERE val1 = 'bc'", dataTableName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), notDeletedRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), notDeletedIndexRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRawRowCount(conn, dataTable, 2);
            TestUtil.assertRawRowCount(conn, indexTable, 2);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cde', 'cdef')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 2);
            TestUtil.assertRawRowCount(conn, indexTable, 2);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), sql, beforeSecondCompactSCN, false);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), indexSql, beforeSecondCompactSCN, false);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), notDeletedRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), notDeletedIndexRowSql, beforeSecondCompactSCN, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTTLAndMaxLookbackAge() throws Exception {
        this.ttl = 20;
        this.optionBuilder.append("TTL=" + this.ttl);
        this.tableDDLOptions = this.optionBuilder.toString();
        Configuration conf = MaxLookbackIT.getUtility().getConfiguration();
        long oldMemstoreFlushInterval = conf.getLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000L);
        conf.setLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, 0L);
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            String dataTableName = MaxLookbackIT.generateUniqueName();
            String indexName = MaxLookbackIT.generateUniqueName();
            this.createTable(dataTableName);
            this.populateTable(dataTableName);
            this.createIndex(dataTableName, indexName, 1);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.injectEdge.incrementValue(1L);
            long afterFirstInsertSCN = EnvironmentEdgeManager.currentTimeMillis();
            TableName dataTable = TableName.valueOf((String)dataTableName);
            TableName indexTable = TableName.valueOf((String)indexName);
            TestUtil.assertTTLValue(conn, dataTable, this.ttl);
            TestUtil.assertTTLValue(conn, indexTable, this.ttl);
            String sql = String.format("SELECT val2 FROM %s WHERE id = 'a'", dataTableName);
            String indexSql = String.format("SELECT val2 FROM %s WHERE val1 = 'ab'", dataTableName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), sql, afterFirstInsertSCN, true);
            MaxLookbackIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackIT.getUrl(), indexSql, afterFirstInsertSCN, true);
            int originalRowCount = 2;
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            MaxLookbackIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            long timeToAdvance = 15000L - (EnvironmentEdgeManager.currentTimeMillis() - afterFirstInsertSCN);
            if (timeToAdvance > 0L) {
                this.injectEdge.incrementValue(timeToAdvance);
            }
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            this.injectEdge.incrementValue(1L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            timeToAdvance = (long)(this.ttl * 1000) - (EnvironmentEdgeManager.currentTimeMillis() - afterFirstInsertSCN);
            if (timeToAdvance > 0L) {
                this.injectEdge.incrementValue(timeToAdvance);
            }
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 0);
            TestUtil.assertRawRowCount(conn, indexTable, 0);
        }
        finally {
            conf.setLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, oldMemstoreFlushInterval);
        }
    }

    @Test(timeout=60000L)
    public void testRecentMaxVersionsNotCompactedAway() throws Exception {
        int versions = 2;
        this.optionBuilder.append("VERSIONS=" + versions);
        this.tableDDLOptions = this.optionBuilder.toString();
        String firstValue = "abc";
        String secondValue = "def";
        String thirdValue = "ghi";
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            String dataTableName = MaxLookbackIT.generateUniqueName();
            String indexName = MaxLookbackIT.generateUniqueName();
            this.createTable(dataTableName);
            this.populateTable(dataTableName);
            this.createIndex(dataTableName, indexName, versions);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.injectEdge.incrementValue(1L);
            this.injectEdge.incrementValue(1L);
            long afterInsertSCN = EnvironmentEdgeManager.currentTimeMillis();
            TableName dataTable = TableName.valueOf((String)dataTableName);
            TableName indexTable = TableName.valueOf((String)indexName);
            TestUtil.assertTableHasVersions(conn, dataTable, versions);
            TestUtil.assertTableHasVersions(conn, indexTable, versions);
            String dataTableSelectSql = String.format("SELECT val2 FROM %s WHERE id = 'a'", dataTableName);
            String indexTableSelectSql = String.format("SELECT val2 FROM %s WHERE val1 = 'ab'", dataTableName);
            MaxLookbackIT.assertExplainPlan(conn, indexTableSelectSql, dataTableName, indexName);
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackIT.getUrl(), dataTableSelectSql, afterInsertSCN, firstValue);
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackIT.getUrl(), indexTableSelectSql, afterInsertSCN, firstValue);
            this.injectEdge.incrementValue(1L);
            this.updateColumn(conn, dataTableName, "id", "a", "val2", secondValue);
            this.injectEdge.incrementValue(1L);
            long afterFirstUpdateSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            this.updateColumn(conn, dataTableName, "id", "a", "val2", thirdValue);
            this.injectEdge.incrementValue(1L);
            long afterSecondUpdateSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            String[] allValues = new String[]{firstValue, secondValue, thirdValue};
            long[] allSCNs = new long[]{afterInsertSCN, afterFirstUpdateSCN, afterSecondUpdateSCN};
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.flush(dataTable);
            this.flush(indexTable);
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.injectEdge.incrementValue(15000L);
            long afterLookbackAgeSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"a"), 6);
            TestUtil.assertRawCellCount(conn, indexTable, Bytes.toBytes((String)"ab\u0000a"), 6);
            TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"b"), 4);
            TestUtil.assertRawCellCount(conn, indexTable, Bytes.toBytes((String)"bc\u0000b"), 3);
        }
    }

    private void flush(TableName table) throws IOException {
        Admin admin = MaxLookbackIT.getUtility().getAdmin();
        admin.flush(table);
    }

    private void majorCompact(TableName table) throws Exception {
        TestUtil.majorCompact(MaxLookbackIT.getUtility(), table);
    }

    private void assertMultiVersionLookbacks(String dataTableSelectSql, String[] values, long[] scns) throws Exception {
        for (int k = 0; k < values.length; ++k) {
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackIT.getUrl(), dataTableSelectSql, scns[k], values[k]);
        }
    }

    private void updateColumn(Connection conn, String dataTableName, String idColumn, String id, String valueColumn, String value) throws SQLException {
        String upsertSql = String.format("UPSERT INTO %s (%s, %s) VALUES ('%s', '%s')", dataTableName, idColumn, valueColumn, id, value);
        conn.createStatement().execute(upsertSql);
        conn.commit();
    }

    private void createTable(String tableName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            String createSql = "create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions;
            conn.createStatement().execute(createSql);
            conn.commit();
        }
    }

    private void populateTable(String tableName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
        }
    }

    private void createIndex(String dataTableName, String indexTableName, int indexVersions) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackIT.getUrl());){
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3) VERSIONS=" + indexVersions);
            conn.commit();
        }
    }

    public static void assertExplainPlan(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
    }
}

