/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.CompactionScanner;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class MaxLookbackExtendedIT
extends BaseTest {
    private static final int MAX_LOOKBACK_AGE = 15;
    private static final int ROWS_POPULATED = 2;
    public static final int WAIT_AFTER_TABLE_CREATION_MILLIS = 1;
    private String tableDDLOptions;
    private StringBuilder optionBuilder;
    ManualEnvironmentEdge injectEdge;
    private int ttl;
    private boolean multiCF;

    public MaxLookbackExtendedIT(boolean multiCF) {
        this.multiCF = multiCF;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(15));
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        props.put(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, "0");
        MaxLookbackExtendedIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void beforeTest() {
        EnvironmentEdgeManager.reset();
        this.optionBuilder = new StringBuilder();
        this.ttl = 30;
        this.optionBuilder.append(" TTL=" + this.ttl);
        this.tableDDLOptions = this.optionBuilder.toString();
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    @After
    public synchronized void afterTest() throws Exception {
        boolean refCountLeaked = MaxLookbackExtendedIT.isAnyStoreRefCountLeaked();
        EnvironmentEdgeManager.reset();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Parameterized.Parameters(name="MaxLookbackExtendedIT_multiCF={0}")
    public static Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    @Test
    public void testKeepDeletedCellsWithMaxLookbackAge() throws Exception {
        int versions = 2;
        this.optionBuilder.append(", VERSIONS=" + versions);
        this.optionBuilder.append(", KEEP_DELETED_CELLS=TRUE");
        this.tableDDLOptions = this.optionBuilder.toString();
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String dataTableName = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(dataTableName);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab1', 'abc1', 'abcd1')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc1', 'bcd1', 'bcde1')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab2', 'abc2', 'abcd2')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab3', 'abc3', 'abcd3')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            this.injectEdge.incrementValue(15000L);
            dml = "DELETE from " + dataTableName + " WHERE id  = 'b'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            this.injectEdge.incrementValue(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc2', 'bcd2', 'bcde2')");
            conn.commit();
            dml = "DELETE from " + dataTableName + " WHERE id  = 'b'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            this.injectEdge.incrementValue(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd3', 'bcde3')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd4', 'bcde4')");
            conn.commit();
            TableName dataTable = TableName.valueOf((String)dataTableName);
            TestUtil.doMajorCompaction(conn, dataTableName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + dataTableName + " where id = 'b'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            TestUtil.assertRawRowCount(conn, dataTable, 2);
            if (this.multiCF) {
                TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"a"), 11);
            } else {
                TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"a"), 9);
            }
            if (this.multiCF) {
                TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"b"), 22);
            } else {
                TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"b"), 18);
            }
        }
    }

    @Test
    public void testTooLowSCNWithMaxLookbackAge() throws Exception {
        String dataTableName = MaxLookbackExtendedIT.generateUniqueName();
        this.createTable(dataTableName);
        this.injectEdge.setValue(System.currentTimeMillis());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
        this.injectEdge.incrementValue(1L);
        this.populateTable(dataTableName);
        long populateTime = EnvironmentEdgeManager.currentTimeMillis();
        this.injectEdge.incrementValue(16000L);
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(populateTime));
        try (Connection connscn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl(), props);){
            connscn.createStatement().executeQuery("select * from " + dataTableName);
        }
        catch (SQLException se) {
            SQLExceptionCode code = SQLExceptionCode.CANNOT_QUERY_TABLE_WITH_SCN_OLDER_THAN_MAX_LOOKBACK_AGE;
            TestUtil.assertSqlExceptionCode(code, se);
            return;
        }
        Assert.fail((String)"We should have thrown an exception for the too-early SCN");
    }

    @Test(timeout=120000L)
    public void testRecentlyDeletedRowsNotCompactedAway() throws Exception {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String dataTableName = MaxLookbackExtendedIT.generateUniqueName();
            String indexName = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(dataTableName);
            TableName dataTable = TableName.valueOf((String)dataTableName);
            this.populateTable(dataTableName);
            this.createIndex(dataTableName, indexName, 1);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            TableName indexTable = TableName.valueOf((String)indexName);
            this.injectEdge.incrementValue(1L);
            long beforeDeleteSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(10L);
            Statement stmt = conn.createStatement();
            stmt.execute("DELETE FROM " + dataTableName + " WHERE  id = 'a'");
            Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
            conn.commit();
            String sql = String.format("SELECT * FROM %s WHERE id = 'a'", dataTableName);
            String indexSql = String.format("SELECT * FROM %s WHERE val1 = 'ab'", dataTableName);
            int rowsPlusDeleteMarker = 2;
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), sql, beforeDeleteSCN, true);
            MaxLookbackExtendedIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), indexSql, beforeDeleteSCN, true);
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), sql, beforeDeleteSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), indexSql, beforeDeleteSCN, true);
            long beforeFirstCompactSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            this.majorCompact(dataTable);
            TestUtil.assertRawRowCount(conn, dataTable, rowsPlusDeleteMarker);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, indexTable, rowsPlusDeleteMarker);
            this.injectEdge.incrementValue(15000L);
            long beforeSecondCompactSCN = EnvironmentEdgeManager.currentTimeMillis();
            String notDeletedRowSql = String.format("SELECT * FROM %s WHERE id = 'b'", dataTableName);
            String notDeletedIndexRowSql = String.format("SELECT * FROM %s WHERE val1 = 'bc'", dataTableName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), notDeletedRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), notDeletedIndexRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRawRowCount(conn, dataTable, 2);
            TestUtil.assertRawRowCount(conn, indexTable, 2);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cde', 'cdef')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            this.flush(dataTable);
            this.majorCompact(dataTable);
            TestUtil.assertRawRowCount(conn, dataTable, 2);
            this.flush(indexTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, indexTable, 2);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), sql, beforeSecondCompactSCN, false);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), indexSql, beforeSecondCompactSCN, false);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), notDeletedRowSql, beforeSecondCompactSCN, true);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), notDeletedIndexRowSql, beforeSecondCompactSCN, true);
        }
    }

    @Test(timeout=60000L)
    public void testViewIndexIsCompacted() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)"SCHEMA1", (String)MaxLookbackExtendedIT.generateUniqueName());
        String globalViewName = MaxLookbackExtendedIT.generateUniqueName();
        String fullGlobalViewName = SchemaUtil.getTableName((String)"SCHEMA2", (String)globalViewName);
        String globalViewIdx = MaxLookbackExtendedIT.generateUniqueName();
        TableName dataTable = TableName.valueOf((String)baseTable);
        TableName indexTable = TableName.valueOf((String)("_IDX_" + baseTable));
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + baseTable + " (TENANT_ID CHAR(15) NOT NULL, PK2 INTEGER NOT NULL, PK3 INTEGER NOT NULL, COL1 VARCHAR, COL2 VARCHAR, COL3 CHAR(15) CONSTRAINT PK PRIMARY KEY(TENANT_ID, PK2, PK3)) MULTI_TENANT=true");
            conn.createStatement().execute("CREATE VIEW " + fullGlobalViewName + " AS SELECT * FROM " + baseTable);
            conn.createStatement().execute("CREATE INDEX " + globalViewIdx + " ON " + fullGlobalViewName + " (COL1) INCLUDE (COL2)");
            conn.createStatement().executeUpdate("UPSERT INTO  " + fullGlobalViewName + " (TENANT_ID, PK2, PK3, COL1, COL2) VALUES ('TenantId1',1, 2, 'a', 'b')");
            conn.commit();
            String query = "SELECT COL2 FROM " + fullGlobalViewName + " WHERE  COL1 = 'a'";
            ResultSet rs = conn.createStatement().executeQuery(query);
            PTable table = ((PhoenixResultSet)rs).getContext().getCurrentTable().getTable();
            Assert.assertTrue((table.getSchemaName().getString().equals("SCHEMA2") && table.getTableName().getString().equals(globalViewIdx) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 1);
            TestUtil.assertRawRowCount(conn, indexTable, 1);
            conn.createStatement().execute("DELETE FROM " + fullGlobalViewName + " WHERE TENANT_ID = 'TenantId1'");
            conn.commit();
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 1);
            TestUtil.assertRawRowCount(conn, indexTable, 1);
            this.injectEdge.setValue(System.currentTimeMillis() + 15000L + 1L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 0);
            TestUtil.assertRawRowCount(conn, indexTable, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTTLAndMaxLookbackAge() throws Exception {
        Configuration conf = MaxLookbackExtendedIT.getUtility().getConfiguration();
        long oldMemstoreFlushInterval = conf.getLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000L);
        conf.setLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, 0L);
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String dataTableName = MaxLookbackExtendedIT.generateUniqueName();
            String indexName = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(dataTableName);
            this.populateTable(dataTableName);
            this.createIndex(dataTableName, indexName, 1);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.injectEdge.incrementValue(1L);
            long afterFirstInsertSCN = EnvironmentEdgeManager.currentTimeMillis();
            TableName dataTable = TableName.valueOf((String)dataTableName);
            TableName indexTable = TableName.valueOf((String)indexName);
            TestUtil.assertTTLValue(conn, dataTable, this.ttl);
            TestUtil.assertTTLValue(conn, indexTable, this.ttl);
            String sql = String.format("SELECT val2 FROM %s WHERE id = 'a'", dataTableName);
            String indexSql = String.format("SELECT val2 FROM %s WHERE val1 = 'ab'", dataTableName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), sql, afterFirstInsertSCN, true);
            MaxLookbackExtendedIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            TestUtil.assertRowExistsAtSCN(MaxLookbackExtendedIT.getUrl(), indexSql, afterFirstInsertSCN, true);
            int originalRowCount = 2;
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            this.flush(dataTable);
            this.flush(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            MaxLookbackExtendedIT.assertExplainPlan(conn, indexSql, dataTableName, indexName);
            long timeToAdvance = 15000L - (EnvironmentEdgeManager.currentTimeMillis() - afterFirstInsertSCN);
            if (timeToAdvance > 0L) {
                this.injectEdge.incrementValue(timeToAdvance);
            }
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            this.injectEdge.incrementValue(1L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, originalRowCount);
            TestUtil.assertRawRowCount(conn, indexTable, originalRowCount);
            timeToAdvance = (long)this.ttl * 1000L - (EnvironmentEdgeManager.currentTimeMillis() - afterFirstInsertSCN);
            if (timeToAdvance > 0L) {
                this.injectEdge.incrementValue(timeToAdvance);
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery(indexSql);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            this.injectEdge.incrementValue(15000L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawRowCount(conn, dataTable, 0);
            TestUtil.assertRawRowCount(conn, indexTable, 0);
        }
        finally {
            conf.setLong(HRegion.MEMSTORE_PERIODIC_FLUSH_INTERVAL, oldMemstoreFlushInterval);
        }
    }

    @Test(timeout=60000L)
    public void testRecentMaxVersionsNotCompactedAway() throws Exception {
        int versions = 2;
        this.optionBuilder.append(", VERSIONS=" + versions);
        this.tableDDLOptions = this.optionBuilder.toString();
        String firstValue = "abc";
        String secondValue = "def";
        String thirdValue = "ghi";
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String dataTableName = MaxLookbackExtendedIT.generateUniqueName();
            String indexName = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(dataTableName);
            this.createIndex(dataTableName, indexName, versions);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            this.populateTable(dataTableName);
            this.injectEdge.incrementValue(1L);
            long afterInsertSCN = EnvironmentEdgeManager.currentTimeMillis();
            TableName dataTable = TableName.valueOf((String)dataTableName);
            TableName indexTable = TableName.valueOf((String)indexName);
            TestUtil.assertTableHasVersions(conn, dataTable, versions);
            TestUtil.assertTableHasVersions(conn, indexTable, versions);
            String dataTableSelectSql = String.format("SELECT val2 FROM %s WHERE id = 'a'", dataTableName);
            String indexTableSelectSql = String.format("SELECT val2 FROM %s WHERE val1 = 'ab'", dataTableName);
            MaxLookbackExtendedIT.assertExplainPlan(conn, indexTableSelectSql, dataTableName, indexName);
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackExtendedIT.getUrl(), dataTableSelectSql, afterInsertSCN, firstValue);
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackExtendedIT.getUrl(), indexTableSelectSql, afterInsertSCN, firstValue);
            this.injectEdge.incrementValue(1L);
            this.updateColumn(conn, dataTableName, "id", "a", "val2", secondValue);
            this.injectEdge.incrementValue(1L);
            long afterFirstUpdateSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            this.updateColumn(conn, dataTableName, "id", "a", "val2", thirdValue);
            this.injectEdge.incrementValue(1L);
            long afterSecondUpdateSCN = EnvironmentEdgeManager.currentTimeMillis();
            this.injectEdge.incrementValue(1L);
            String[] allValues = new String[]{firstValue, secondValue, thirdValue};
            long[] allSCNs = new long[]{afterInsertSCN, afterFirstUpdateSCN, afterSecondUpdateSCN};
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.flush(dataTable);
            this.flush(indexTable);
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            this.assertMultiVersionLookbacks(dataTableSelectSql, allValues, allSCNs);
            this.assertMultiVersionLookbacks(indexTableSelectSql, allValues, allSCNs);
            this.injectEdge.setValue(afterInsertSCN + 15000L);
            this.majorCompact(dataTable);
            this.majorCompact(indexTable);
            TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"a"), 8);
            TestUtil.assertRawCellCount(conn, indexTable, Bytes.toBytes((String)"ab\u0000a"), 9);
            TestUtil.assertRawCellCount(conn, dataTable, Bytes.toBytes((String)"b"), 4);
            TestUtil.assertRawCellCount(conn, indexTable, Bytes.toBytes((String)"bc\u0000b"), 3);
        }
    }

    @Test(timeout=60000L)
    public void testOverrideMaxLookbackForCompaction() throws Exception {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String tableNameOne = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(tableNameOne);
            String tableNameTwo = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(tableNameTwo);
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            int maxLookbackOne = 20;
            int maxLookbackTwo = 25;
            CompactionScanner.overrideMaxLookback((String)tableNameOne, (String)"0", (long)(maxLookbackOne * 1000));
            CompactionScanner.overrideMaxLookback((String)tableNameTwo, (String)"0", (long)(maxLookbackTwo * 1000));
            if (this.multiCF) {
                CompactionScanner.overrideMaxLookback((String)tableNameOne, (String)"A", (long)(maxLookbackOne * 1000));
                CompactionScanner.overrideMaxLookback((String)tableNameOne, (String)"B", (long)(maxLookbackOne * 1000));
                CompactionScanner.overrideMaxLookback((String)tableNameTwo, (String)"A", (long)(maxLookbackTwo * 1000));
                CompactionScanner.overrideMaxLookback((String)tableNameTwo, (String)"B", (long)(maxLookbackTwo * 1000));
            }
            this.injectEdge.incrementValue(1000L);
            this.populateTable(tableNameOne);
            this.populateTable(tableNameTwo);
            this.injectEdge.incrementValue(1000L);
            this.populateTable(tableNameOne);
            this.populateTable(tableNameTwo);
            this.injectEdge.incrementValue(1000L);
            conn.createStatement().executeUpdate("DELETE FROM " + tableNameOne);
            conn.createStatement().executeUpdate("DELETE FROM " + tableNameTwo);
            conn.commit();
            this.injectEdge.incrementValue((long)(maxLookbackOne * 1000));
            this.flush(TableName.valueOf((String)tableNameOne));
            this.flush(TableName.valueOf((String)tableNameTwo));
            this.majorCompact(TableName.valueOf((String)tableNameOne));
            this.majorCompact(TableName.valueOf((String)tableNameTwo));
            if (this.multiCF) {
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameOne), Bytes.toBytes((String)"a"), 7);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameOne), Bytes.toBytes((String)"b"), 7);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameTwo), Bytes.toBytes((String)"a"), 11);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameTwo), Bytes.toBytes((String)"b"), 11);
            } else {
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameOne), Bytes.toBytes((String)"a"), 5);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameOne), Bytes.toBytes((String)"b"), 5);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameTwo), Bytes.toBytes((String)"a"), 9);
                TestUtil.assertRawCellCount(conn, TableName.valueOf((String)tableNameTwo), Bytes.toBytes((String)"b"), 9);
            }
        }
    }

    @Test(timeout=60000L)
    public void testRetainingLastRowVersion() throws Exception {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String tableName = MaxLookbackExtendedIT.generateUniqueName();
            this.createTable(tableName);
            long timeIntervalBetweenTwoUpserts = this.ttl / 4 + 1;
            this.injectEdge.setValue(System.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            TableName dataTableName = TableName.valueOf((String)tableName);
            this.injectEdge.incrementValue(1L);
            Statement stmt = conn.createStatement();
            stmt.execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            this.injectEdge.incrementValue(timeIntervalBetweenTwoUpserts * 1000L);
            this.flush(dataTableName);
            this.injectEdge.incrementValue(1L);
            stmt.execute("upsert into " + tableName + " values ('a', 'ab1')");
            conn.commit();
            this.injectEdge.incrementValue(timeIntervalBetweenTwoUpserts * 1000L);
            this.flush(dataTableName);
            this.injectEdge.incrementValue(1L);
            stmt.execute("upsert into " + tableName + " values ('a', 'ab2')");
            conn.commit();
            this.injectEdge.incrementValue(timeIntervalBetweenTwoUpserts * 1000L);
            this.flush(dataTableName);
            this.injectEdge.incrementValue(1L);
            TestUtil.minorCompact(utility, dataTableName);
            this.injectEdge.incrementValue(1L);
            stmt.execute("upsert into " + tableName + " values ('a', 'ab3')");
            conn.commit();
            this.injectEdge.incrementValue(timeIntervalBetweenTwoUpserts * 1000L);
            this.flush(dataTableName);
            this.injectEdge.incrementValue(1L);
            stmt.execute("upsert into " + tableName + " values ('a', 'ab4')");
            conn.commit();
            this.injectEdge.incrementValue(1L);
            this.flush(dataTableName);
            TestUtil.dumpTable(conn, dataTableName);
            this.injectEdge.incrementValue(1L);
            TestUtil.minorCompact(utility, dataTableName);
            this.injectEdge.incrementValue(14999L);
            TestUtil.dumpTable(conn, dataTableName);
            this.majorCompact(dataTableName);
            this.injectEdge.incrementValue(1L);
            TestUtil.dumpTable(conn, dataTableName);
            ResultSet rs = stmt.executeQuery("select * from " + dataTableName + " where id = 'a'");
            while (rs.next()) {
                Assert.assertNotNull((Object)rs.getString(3));
                Assert.assertNotNull((Object)rs.getString(4));
            }
        }
    }

    private void flush(TableName table) throws IOException {
        Admin admin = MaxLookbackExtendedIT.getUtility().getAdmin();
        admin.flush(table);
    }

    private void majorCompact(TableName table) throws Exception {
        TestUtil.majorCompact(MaxLookbackExtendedIT.getUtility(), table);
    }

    private void assertMultiVersionLookbacks(String dataTableSelectSql, String[] values, long[] scns) throws Exception {
        for (int k = 0; k < values.length; ++k) {
            TestUtil.assertRowHasExpectedValueAtSCN(MaxLookbackExtendedIT.getUrl(), dataTableSelectSql, scns[k], values[k]);
        }
    }

    private void updateColumn(Connection conn, String dataTableName, String idColumn, String id, String valueColumn, String value) throws SQLException {
        String upsertSql = String.format("UPSERT INTO %s (%s, %s) VALUES ('%s', '%s')", dataTableName, idColumn, valueColumn, id, value);
        conn.createStatement().execute(upsertSql);
        conn.commit();
    }

    private void createTable(String tableName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            String createSql = this.multiCF ? "create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), a.val2 varchar(10), b.val3 varchar(10))" + this.tableDDLOptions : "create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions;
            conn.createStatement().execute(createSql);
            conn.commit();
        }
    }

    private void populateTable(String tableName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
        }
    }

    private void createIndex(String dataTableName, String indexTableName, int indexVersions) throws SQLException {
        try (Connection conn = DriverManager.getConnection(MaxLookbackExtendedIT.getUrl());){
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3) VERSIONS=" + indexVersions);
            conn.commit();
        }
    }

    public static void assertExplainPlan(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
    }
}

