/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MathTrigFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        this.tableName = MathTrigFunctionEnd2EndIT.generateUniqueName();
        try {
            conn = DriverManager.getConnection(MathTrigFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.tableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub DOUBLE)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateTableSpec(Connection conn, double data, String tableName) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
        stmt.setString(1, KEY);
        stmt.setDouble(2, data);
        stmt.executeUpdate();
        conn.commit();
    }

    private void testNumberSpec(Connection conn, double data, String tableName) throws Exception {
        this.updateTableSpec(conn, data, tableName);
        ResultSet rs = conn.createStatement().executeQuery("SELECT SIN(doub),COS(doub),TAN(doub) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertTrue((boolean)MathTrigFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.sin(data)));
        Assert.assertTrue((boolean)MathTrigFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.cos(data)));
        Assert.assertTrue((boolean)MathTrigFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.tan(data)));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void test() throws Exception {
        Connection conn = DriverManager.getConnection(MathTrigFunctionEnd2EndIT.getUrl());
        for (double d : new double[]{0.0, 1.0, -1.0, 123.1234, -123.1234}) {
            this.testNumberSpec(conn, d, this.tableName);
        }
    }
}

