/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MathPIFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    @Test
    public void testGetMathPIValue() throws Exception {
        Connection conn = DriverManager.getConnection(MathPIFunctionEnd2EndIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT PI()");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)MathPIFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.PI));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMathPIRoundTwoDecimal() throws Exception {
        Connection conn = DriverManager.getConnection(MathPIFunctionEnd2EndIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(PI(), 2)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)MathPIFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), 3.14));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMathPIFunctionWithIncorrectFormat() throws Exception {
        Connection conn = DriverManager.getConnection(MathPIFunctionEnd2EndIT.getUrl());
        try {
            conn.createStatement().executeQuery("SELECT PI(1)");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.FUNCTION_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

