/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.LogicalTableNameBaseIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class LogicalTableNameExtendedIT
extends LogicalTableNameBaseIT {
    private Properties propsNamespace = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        LogicalTableNameExtendedIT.initCluster(true);
    }

    public LogicalTableNameExtendedIT() {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" ,IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN");
        this.dataTableDdl = optionBuilder.toString();
        this.propsNamespace.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
    }

    @Test
    public void testUpdatePhysicalTableName_namespaceMapped() throws Exception {
        String schemaName = "S_" + LogicalTableNameExtendedIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view1Name = "VW1_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view1IndexName1 = "VW1IDX1_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view1IndexName2 = "VW1IDX2_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view2Name = "VW2_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view2IndexName1 = "VW2IDX1_" + LogicalTableNameExtendedIT.generateUniqueName();
        try (Connection conn = this.getConnection(this.propsNamespace);
             Connection conn2 = this.getConnection(this.propsNamespace);){
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            this.testWithViewsAndIndex_BaseTableChange(conn, conn2, null, schemaName, tableName, view1Name, view1IndexName1, view1IndexName2, view2Name, view2IndexName1, true, false);
            this.populateView(conn, schemaName + "." + view2Name, 10, 1);
            ResultSet rs = conn2.createStatement().executeQuery("SELECT * FROM " + schemaName + "." + view2IndexName1 + " WHERE \":PK1\"='PK10'");
            Assert.assertEquals((Object)true, (Object)rs.next());
        }
    }

    private void test_bothTableAndIndexHaveDifferentNames(Connection conn, Connection conn2, String schemaName, String tableName, String indexName) throws Exception {
        String fullTableHName = schemaName + ":" + tableName;
        String fullIndexHName = schemaName + ":" + indexName;
        conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        this.test_IndexTableChange(conn, conn2, schemaName, tableName, indexName, QueryConstants.UNVERIFIED_BYTES, true);
        LogicalTableNameExtendedIT.createAndPointToNewPhysicalTable(conn, fullTableHName, true);
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)fullTableHName)));
            Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)fullIndexHName)));
        }
    }

    @Test
    public void testUpdatePhysicalTableName_bothTableAndIndexHaveDifferentNames() throws Exception {
        String schemaName = "S_" + LogicalTableNameExtendedIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameExtendedIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullTableHName = schemaName + ":" + tableName;
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String fullIndexHName = schemaName + ":" + indexName;
        String fullNewTableHName = schemaName + ":NEW_TBL_" + tableName;
        try (Connection conn = this.getConnection(this.propsNamespace);
             Connection conn2 = this.getConnection(this.propsNamespace);){
            this.test_bothTableAndIndexHaveDifferentNames(conn, conn2, schemaName, tableName, indexName);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                conn2.setAutoCommit(true);
                this.populateTable(conn2, fullTableName, 10, 1);
                ResultSet rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK10'");
                Assert.assertEquals((Object)true, (Object)rs.next());
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE PK1='PK10'");
                Assert.assertEquals((Object)true, (Object)rs.next());
                conn.createStatement().execute("DELETE from " + fullTableName + " WHERE PK1='PK10'");
                rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK10'");
                Assert.assertEquals((Object)false, (Object)rs.next());
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE PK1='PK10'");
                Assert.assertEquals((Object)false, (Object)rs.next());
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK30'");
                Assert.assertEquals((Object)false, (Object)rs.next());
                try (Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullNewTableHName));){
                    Put put = new Put(ByteUtil.concat((byte[])Bytes.toBytes((String)"PK30"), (byte[][])new byte[0][]));
                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V1"), Bytes.toBytes((String)"V30"));
                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V2"), PInteger.INSTANCE.toBytes((Object)32));
                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V3"), PInteger.INSTANCE.toBytes((Object)33));
                    htable.put(put);
                }
                IndexToolIT.runIndexTool(false, schemaName, tableName, indexName);
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK30'");
                Assert.assertEquals((Object)true, (Object)rs.next());
                conn2.createStatement().execute("DROP TABLE " + fullTableName);
                Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)fullNewTableHName)));
                Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)(schemaName + ":NEW_IDXTBL_" + indexName))));
            }
        }
    }

    @Test
    public void testUpdatePhysicalTableName_alterTable() throws Exception {
        String schemaName = "S_" + LogicalTableNameExtendedIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameExtendedIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullTableHName = schemaName + ":" + tableName;
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String fullIndexHName = schemaName + ":" + indexName;
        String fullNewTableHName = schemaName + ":NEW_TBL_" + tableName;
        try (Connection conn = this.getConnection(this.propsNamespace);
             Connection conn2 = this.getConnection(this.propsNamespace);){
            this.test_bothTableAndIndexHaveDifferentNames(conn, conn2, schemaName, tableName, indexName);
            conn2.setAutoCommit(true);
            conn2.createStatement().execute("ALTER TABLE " + fullTableName + " ADD new_column_1 VARCHAR(64) CASCADE INDEX ALL");
            conn2.createStatement().execute("UPSERT INTO " + fullTableName + " (PK1, V1, new_column_1) VALUES ('a', 'v1', 'new_col_val')");
            ResultSet rs = conn2.createStatement().executeQuery("SELECT \"0:NEW_COLUMN_1\" FROM " + fullIndexName);
            Assert.assertEquals((Object)true, (Object)rs.next());
            rs = conn.createStatement().executeQuery("SELECT NEW_COLUMN_1 FROM " + fullTableName + " WHERE NEW_COLUMN_1 IS NOT NULL");
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)false, (Object)rs.next());
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " DROP COLUMN NEW_COLUMN_1");
        }
    }

    @Test
    public void testHint() throws Exception {
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameExtendedIT.generateUniqueName();
        String indexName2 = "IDX2_" + LogicalTableNameExtendedIT.generateUniqueName();
        try (Connection conn = this.getConnection(this.propsNamespace);){
            conn.setAutoCommit(true);
            this.createTable(conn, tableName);
            this.createIndexOnTable(conn, tableName, indexName);
            this.createIndexOnTable(conn, tableName, indexName2);
            this.populateTable(conn, tableName, 1, 2);
            String tableSelect = "SELECT V1,V2,V3 FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + tableSelect);
            String plan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)true, (Object)(plan.contains(indexName) || plan.contains(indexName2) ? 1 : 0));
            String hintedIndex = QueryUtil.getExplainPlan((ResultSet)rs).contains(indexName) ? indexName2 : indexName;
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                String snapshotName = hintedIndex + "-Snapshot";
                admin.snapshot(snapshotName, TableName.valueOf((String)hintedIndex));
                String newName = "NEW_" + hintedIndex;
                admin.cloneSnapshot(snapshotName, TableName.valueOf((String)newName));
                LogicalTableNameExtendedIT.renameAndDropPhysicalTable(conn, "NULL", null, hintedIndex, newName, true);
            }
            String indexSelect = "SELECT /*+ INDEX(" + tableName + " " + hintedIndex + ")*/ V1,V2,V3 FROM " + tableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + indexSelect);
            Assert.assertEquals((Object)true, (Object)QueryUtil.getExplainPlan((ResultSet)rs).contains(hintedIndex));
            rs = conn.createStatement().executeQuery(indexSelect);
            Assert.assertEquals((Object)true, (Object)rs.next());
        }
    }

    @Test
    public void testUpdatePhysicalTableName_tenantViews() throws Exception {
        try (Connection conn = this.getConnection(this.propsNamespace);){
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS TEST_ENTITY");
        }
        this.testGlobalViewAndTenantView(false, true);
        this.testGlobalViewAndTenantView(true, true);
    }

    @Test
    public void testUpdatePhysicalTableName_localIndex() throws Exception {
        String schemaName = "S_" + LogicalTableNameExtendedIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String indexName = "LCL_IDX_" + LogicalTableNameExtendedIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String fullHTableName = schemaName + ":" + tableName;
        try (Connection conn = this.getConnection(this.propsNamespace);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            this.createTable(conn, fullTableName);
            this.createIndexOnTable(conn, fullTableName, indexName, true);
            HashMap<String, ArrayList<String>> expected = this.populateTable(conn, fullTableName, 1, 2);
            LogicalTableNameExtendedIT.createAndPointToNewPhysicalTable(conn, fullHTableName, true);
            String select = "SELECT * FROM " + fullIndexName;
            ResultSet rs = conn.createStatement().executeQuery(select);
            Assert.assertEquals((Object)true, (Object)rs.next());
            this.validateIndex(conn, fullIndexName, false, expected);
            conn.createStatement().execute("DROP INDEX " + indexName + " ON " + fullTableName);
            this.createIndexOnTable(conn, fullTableName, indexName, true);
            rs = conn.createStatement().executeQuery(select);
            Assert.assertEquals((Object)true, (Object)rs.next());
            this.validateIndex(conn, fullIndexName, false, expected);
        }
    }

    @Test
    public void testUpdatePhysicalTableName_viewIndexSequence() throws Exception {
        String schemaName = "S_" + LogicalTableNameExtendedIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameExtendedIT.generateUniqueName();
        String viewName = "VW1_" + LogicalTableNameExtendedIT.generateUniqueName();
        String viewName2 = "VW2_" + LogicalTableNameExtendedIT.generateUniqueName();
        String viewIndexName1 = "VWIDX1_" + LogicalTableNameExtendedIT.generateUniqueName();
        String viewIndexName2 = "VWIDX2_" + LogicalTableNameExtendedIT.generateUniqueName();
        String view2IndexName1 = "VW2IDX1_" + LogicalTableNameExtendedIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String fullViewName2 = SchemaUtil.getTableName((String)schemaName, (String)viewName2);
        String fullViewIndex1Name = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName1);
        String fullViewIndex2Name = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName2);
        String fullView2Index1Name = SchemaUtil.getTableName((String)schemaName, (String)view2IndexName1);
        String fullTableHName = schemaName + ":" + tableName;
        try (Connection conn = this.getConnection(this.propsNamespace);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            this.createTable(conn, fullTableName);
            this.createViewAndIndex(conn, schemaName, tableName, viewName, viewIndexName1);
            HashMap<String, ArrayList<String>> expected = this.populateView(conn, fullViewName, 1, 1);
            LogicalTableNameExtendedIT.createAndPointToNewPhysicalTable(conn, fullTableHName, true);
            this.validateIndex(conn, fullViewIndex1Name, true, expected);
            String indexDDL = "CREATE INDEX IF NOT EXISTS " + viewIndexName2 + " ON " + fullViewName + " (VIEW_COL1) include (VIEW_COL2) ";
            conn.createStatement().execute(indexDDL);
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + fullViewIndex2Name);
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)"VIEW_COL1_1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"PK1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"VIEW_COL2_1", (Object)rs.getString(3));
            Assert.assertEquals((Object)false, (Object)rs.next());
            expected.putAll(this.populateView(conn, fullViewName, 10, 1));
            this.validateIndex(conn, fullViewIndex1Name, true, expected);
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullViewIndex2Name + " WHERE \"0:VIEW_COL1\"='VIEW_COL1_10'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)"VIEW_COL1_10", (Object)rs.getString(1));
            Assert.assertEquals((Object)"PK10", (Object)rs.getString(2));
            Assert.assertEquals((Object)"VIEW_COL2_10", (Object)rs.getString(3));
            Assert.assertEquals((Object)false, (Object)rs.next());
            conn.createStatement().execute("CREATE VIEW " + fullViewName2 + "  (VIEW_COL1 VARCHAR, VIEW_COL2 VARCHAR) AS SELECT * FROM " + fullTableName);
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + view2IndexName1 + " ON " + fullViewName2 + " (VIEW_COL1) include (VIEW_COL2)");
            this.populateView(conn, fullViewName2, 20, 1);
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullView2Index1Name + " WHERE \"0:VIEW_COL1\"='VIEW_COL1_10'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)"VIEW_COL1_10", (Object)rs.getString(1));
            Assert.assertEquals((Object)"PK10", (Object)rs.getString(2));
            Assert.assertEquals((Object)"VIEW_COL2_10", (Object)rs.getString(3));
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
    }
}

