/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.LogicalTableNameIT;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.end2end.ViewTTLIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;

public abstract class LogicalTableNameBaseIT
extends BaseTest {
    protected String dataTableDdl = "";
    public static final String NEW_TABLE_PREFIX = "NEW_TBL_";
    private Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    static void initCluster(boolean isNamespaceMapped) throws Exception {
        ConcurrentMap props = Maps.newConcurrentMap();
        props.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600000));
        if (isNamespaceMapped) {
            props.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        }
        LogicalTableNameBaseIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    protected Connection getConnection(Properties props) throws Exception {
        props.setProperty("phoenix.schema.dropMetaData", Boolean.toString(true));
        props.setProperty("phoenix.jdbc.extra.arguments", "");
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"PRINCIPAL");
        return DriverManager.getConnection(url, props);
    }

    public static void createAndPointToNewPhysicalTable(Connection conn, String fullTableHName, boolean isNamespaceEnabled) throws Exception {
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableHName);
        String newTableName = NEW_TABLE_PREFIX + tableName;
        LogicalTableNameBaseIT.createAndPointToNewPhysicalTable(conn, fullTableHName, newTableName, isNamespaceEnabled);
    }

    public static void createAndPointToNewPhysicalTable(Connection conn, String fullTableHName, String newTableName, boolean isNamespaceEnabled) throws Exception {
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableHName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullTableHName);
        String fullNewTableHName = schemaName + (isNamespaceEnabled ? ":" : ".") + newTableName;
        String snapshotName = tableName + "-Snapshot";
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            admin.snapshot(snapshotName, TableName.valueOf((String)fullTableHName));
            admin.cloneSnapshot(snapshotName, TableName.valueOf((String)fullNewTableHName));
            admin.deleteSnapshot(snapshotName);
            LogicalTableNameIT.renameAndDropPhysicalTable(conn, null, schemaName, tableName, newTableName, isNamespaceEnabled);
        }
    }

    protected HashMap<String, ArrayList<String>> testBaseTableWithIndex_BaseTableChange(Connection conn, Connection conn2, String schemaName, String tableName, String indexName, boolean isNamespaceEnabled, boolean createChildAfterRename) throws Exception {
        conn.setAutoCommit(true);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        this.createTable(conn, fullTableName);
        if (!createChildAfterRename) {
            this.createIndexOnTable(conn, fullTableName, indexName);
        }
        HashMap<String, ArrayList<String>> expected = this.populateTable(conn, fullTableName, 1, 2);
        String newTableName = NEW_TABLE_PREFIX + tableName;
        String fullNewTableName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            String snapshotName = fullTableName + "-Snapshot";
            admin.snapshot(snapshotName, TableName.valueOf((String)fullTableName));
            admin.cloneSnapshot(snapshotName, TableName.valueOf((String)fullNewTableName));
            admin.deleteSnapshot(snapshotName);
            try (Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullNewTableName));){
                Put put = new Put(ByteUtil.concat((byte[])Bytes.toBytes((String)"PK3"), (byte[][])new byte[0][]));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V1"), Bytes.toBytes((String)"V13"));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V2"), PInteger.INSTANCE.toBytes((Object)3));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V3"), PInteger.INSTANCE.toBytes((Object)4));
                htable.put(put);
                expected.put("PK3", Lists.newArrayList((Object[])new String[]{"PK3", "V13", "3", "4"}));
            }
        }
        String selectTable1 = "SELECT PK1, V1, V2, V3 FROM " + fullTableName + " ORDER BY PK1 DESC";
        ResultSet rs1 = conn2.createStatement().executeQuery(selectTable1);
        Assert.assertTrue((boolean)rs1.next());
        LogicalTableNameBaseIT.renameAndDropPhysicalTable(conn, "NULL", schemaName, tableName, newTableName, isNamespaceEnabled);
        if (createChildAfterRename) {
            this.createIndexOnTable(conn, fullTableName, indexName);
        }
        return expected;
    }

    protected HashMap<String, ArrayList<String>> test_IndexTableChange(Connection conn, Connection conn2, String schemaName, String tableName, String indexName, byte[] verifiedBytes, boolean isNamespaceEnabled) throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        conn.setAutoCommit(true);
        this.createTable(conn, fullTableName);
        this.createIndexOnTable(conn, fullTableName, indexName);
        HashMap<String, ArrayList<String>> expected = this.populateTable(conn, fullTableName, 1, 2);
        String newTableName = "NEW_IDXTBL_" + indexName;
        String fullNewTableName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
        String fullIndexTableHbaseName = fullIndexName;
        if (isNamespaceEnabled) {
            fullNewTableName = schemaName + ":" + newTableName;
            fullIndexTableHbaseName = schemaName + ":" + indexName;
        }
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            String snapshotName = indexName + "-Snapshot";
            admin.snapshot(snapshotName, TableName.valueOf((String)fullIndexTableHbaseName));
            admin.cloneSnapshot(snapshotName, TableName.valueOf((String)fullNewTableName));
            admin.deleteSnapshot(snapshotName);
            try (Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullNewTableName));){
                Put put = new Put(ByteUtil.concat((byte[])Bytes.toBytes((String)"V13"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"PK3")}));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, verifiedBytes);
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"0:V2"), PInteger.INSTANCE.toBytes((Object)3));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"0:V3"), PInteger.INSTANCE.toBytes((Object)4));
                htable.put(put);
                expected.put("PK3", Lists.newArrayList((Object[])new String[]{"PK3", "V13", "3", "4"}));
            }
        }
        String selectTable1 = "SELECT * FROM " + fullIndexName;
        ResultSet rs1 = conn2.createStatement().executeQuery(selectTable1);
        Assert.assertTrue((boolean)rs1.next());
        LogicalTableNameBaseIT.renameAndDropPhysicalTable(conn, "NULL", schemaName, indexName, newTableName, isNamespaceEnabled);
        return expected;
    }

    protected HashMap<String, ArrayList<String>> testWithViewsAndIndex_BaseTableChange(Connection conn, Connection conn2, String tenantName, String schemaName, String tableName, String viewName1, String v1_indexName1, String v1_indexName2, String viewName2, String v2_indexName1, boolean isNamespaceEnabled, boolean createChildAfterRename) throws Exception {
        conn.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullViewName1 = SchemaUtil.getTableName((String)schemaName, (String)viewName1);
        String fullViewName2 = SchemaUtil.getTableName((String)schemaName, (String)viewName2);
        this.createTable(conn, fullTableName);
        HashMap<String, ArrayList<String>> expected = new HashMap<String, ArrayList<String>>();
        if (!createChildAfterRename) {
            this.createViewAndIndex(conn2, schemaName, tableName, viewName1, v1_indexName1);
            this.createViewAndIndex(conn2, schemaName, tableName, viewName1, v1_indexName2);
            this.createViewAndIndex(conn2, schemaName, tableName, viewName2, v2_indexName1);
            expected.putAll(this.populateView(conn, fullViewName1, 1, 2));
            expected.putAll(this.populateView(conn, fullViewName2, 10, 2));
        }
        String newTableName = NEW_TABLE_PREFIX + LogicalTableNameBaseIT.generateUniqueName();
        String fullNewTableName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
        String fullTableHbaseName = fullTableName;
        if (isNamespaceEnabled) {
            fullNewTableName = schemaName + ":" + newTableName;
            fullTableHbaseName = schemaName + ":" + tableName;
        }
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            String snapshotName = fullTableName + "-Snapshot";
            admin.snapshot(snapshotName, TableName.valueOf((String)fullTableHbaseName));
            admin.cloneSnapshot(snapshotName, TableName.valueOf((String)fullNewTableName));
            admin.deleteSnapshot(snapshotName);
            try (Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullNewTableName));){
                Put put = new Put(ByteUtil.concat((byte[])Bytes.toBytes((String)"PK3"), (byte[][])new byte[0][]));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V1"), Bytes.toBytes((String)"V13"));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V2"), PInteger.INSTANCE.toBytes((Object)3));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V3"), PInteger.INSTANCE.toBytes((Object)4));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"VIEW_COL1"), Bytes.toBytes((String)"VIEW_COL1_3"));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"VIEW_COL2"), Bytes.toBytes((String)"VIEW_COL2_3"));
                htable.put(put);
                expected.put("PK3", Lists.newArrayList((Object[])new String[]{"PK3", "V13", "3", "4", "VIEW_COL1_3", "VIEW_COL2_3"}));
            }
        }
        if (tenantName != null) {
            String selectTable1 = "SELECT PK1, V1, V2, V3 FROM " + fullTableName + " ORDER BY PK1 DESC";
            ResultSet rs1 = conn2.createStatement().executeQuery(selectTable1);
            if (!createChildAfterRename) {
                Assert.assertTrue((boolean)rs1.next());
            }
        }
        LogicalTableNameBaseIT.renameAndDropPhysicalTable(conn, "NULL", schemaName, tableName, newTableName, isNamespaceEnabled);
        conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
        if (createChildAfterRename) {
            this.createViewAndIndex(conn2, schemaName, tableName, viewName1, v1_indexName1);
            this.createViewAndIndex(conn2, schemaName, tableName, viewName1, v1_indexName2);
            this.createViewAndIndex(conn2, schemaName, tableName, viewName2, v2_indexName1);
            expected.putAll(this.populateView(conn2, fullViewName1, 1, 2));
            expected.putAll(this.populateView(conn2, fullViewName2, 10, 2));
        }
        return expected;
    }

    protected PhoenixTestBuilder.SchemaBuilder testGlobalViewAndTenantView(boolean createChildAfterRename, boolean isNamespaceEnabled) throws Exception {
        int numOfRows = 5;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        tableOptions.setTableProps(" MULTI_TENANT=true, COLUMN_ENCODED_BYTES=0 " + this.dataTableDdl);
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = null;
        if (!createChildAfterRename) {
            schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(LogicalTableNameBaseIT.getUrl());
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
        } else {
            schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(LogicalTableNameBaseIT.getUrl());
            schemaBuilder.withTableOptions(tableOptions).build();
        }
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        String newBaseTableName = NEW_TABLE_PREFIX + tableName;
        String fullNewBaseTableName = SchemaUtil.getTableName((String)schemaName, (String)newBaseTableName);
        String fullTableName = table.getName().getString();
        String fullTableHName = schemaName + ":" + tableName;
        String fullNewTableHName = schemaName + ":" + newBaseTableName;
        try (Connection conn = this.getConnection(this.props);){
            LogicalTableNameBaseIT.createAndPointToNewPhysicalTable(conn, fullTableHName, newBaseTableName, isNamespaceEnabled);
        }
        if (createChildAfterRename) {
            schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(LogicalTableNameBaseIT.getUrl());
            schemaBuilder.withDataOptions(schemaBuilder.getDataOptions()).withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
        }
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String id = String.format("00A0y000%07d", rowIndex);
                String zid = String.format("00B0y000%07d", rowIndex);
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{id, zid, col4, col5, col6, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
        String tenantConnectUrl = LogicalTableNameBaseIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId();
        try (Connection tenantConnection = DriverManager.getConnection(tenantConnectUrl);){
            tenantConnection.setAutoCommit(true);
            dataWriter.setConnection(tenantConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            dataWriter.upsertRows(1, numOfRows);
            org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> upsertedData = dataWriter.getDataTable();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            dataReader.setValidationColumns(columns);
            dataReader.setRowKeyColumns(rowKeyColumns);
            dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            dataReader.setConnection(tenantConnection);
            dataReader.readRows();
            org.apache.phoenix.thirdparty.com.google.common.collect.Table<String, String, Object> fetchedData = dataReader.getDataTable();
            Assert.assertNotNull((String)"Fetched data should not be null", fetchedData);
            ViewTTLIT.verifyRowsBeforeTTLExpiration(upsertedData, fetchedData);
        }
        return schemaBuilder;
    }

    protected void createTable(Connection conn, String tableName) throws Exception {
        String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1)) COLUMN_ENCODED_BYTES=0 " + this.dataTableDdl;
        conn.createStatement().execute(createTableSql);
    }

    protected void createIndexOnTable(Connection conn, String tableName, String indexName, boolean isLocal) throws SQLException {
        String createIndexSql = "CREATE " + (isLocal ? " LOCAL " : "") + " INDEX " + indexName + " ON " + tableName + " (V1) INCLUDE (V2, V3) ";
        conn.createStatement().execute(createIndexSql);
    }

    protected void createIndexOnTable(Connection conn, String tableName, String indexName) throws SQLException {
        this.createIndexOnTable(conn, tableName, indexName, false);
    }

    protected void dropIndex(Connection conn, String tableName, String indexName) throws SQLException {
        String sql = "DROP INDEX " + indexName + " ON " + tableName;
        conn.createStatement().execute(sql);
    }

    protected HashMap<String, ArrayList<String>> populateTable(Connection conn, String tableName, int startnum, int numOfRows) throws SQLException {
        String upsert = "UPSERT INTO " + tableName + " (PK1, V1,  V2, V3) VALUES (?,?,?,?)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        for (int i = startnum; i < startnum + numOfRows; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            upsertStmt.setString(1, "PK" + i);
            row.add("PK" + i);
            upsertStmt.setString(2, "V1" + i);
            row.add("V1" + i);
            upsertStmt.setInt(3, i);
            row.add(String.valueOf(i));
            upsertStmt.setInt(4, i + 1);
            row.add(String.valueOf(i + 1));
            upsertStmt.executeUpdate();
            result.put("PK" + i, row);
        }
        return result;
    }

    protected HashMap<String, ArrayList<String>> populateView(Connection conn, String viewName, int startNum, int numOfRows) throws SQLException {
        String upsert = "UPSERT INTO " + viewName + " (PK1, V1,  V2, V3, VIEW_COL1, VIEW_COL2) VALUES (?,?,?,?,?,?)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        for (int i = startNum; i < startNum + numOfRows; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            upsertStmt.setString(1, "PK" + i);
            row.add("PK" + i);
            upsertStmt.setString(2, "V1" + i);
            row.add("V1" + i);
            upsertStmt.setInt(3, i);
            row.add(String.valueOf(i));
            upsertStmt.setInt(4, i + 1);
            row.add(String.valueOf(i + 1));
            upsertStmt.setString(5, "VIEW_COL1_" + i);
            row.add("VIEW_COL1_" + i);
            upsertStmt.setString(6, "VIEW_COL2_" + i);
            row.add("VIEW_COL2_" + i);
            upsertStmt.executeUpdate();
            result.put("PK" + i, row);
        }
        return result;
    }

    protected void createViewAndIndex(Connection conn, String schemaName, String tableName, String viewName, String viewIndexName) throws SQLException {
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String view1DDL = "CREATE VIEW IF NOT EXISTS " + fullViewName + " ( VIEW_COL1 VARCHAR, VIEW_COL2 VARCHAR) AS SELECT * FROM " + fullTableName;
        conn.createStatement().execute(view1DDL);
        String indexDDL = "CREATE INDEX IF NOT EXISTS " + viewIndexName + " ON " + fullViewName + " (V1) include (V2, V3, VIEW_COL2) ";
        conn.createStatement().execute(indexDDL);
        conn.commit();
    }

    protected void validateTable(Connection connection, String tableName) throws SQLException {
        String selectTable = "SELECT PK1, V1, V2, V3 FROM " + tableName + " ORDER BY PK1 DESC";
        ResultSet rs = connection.createStatement().executeQuery(selectTable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"PK3", (Object)rs.getString(1));
        Assert.assertEquals((Object)"V13", (Object)rs.getString(2));
        Assert.assertEquals((long)3L, (long)rs.getInt(3));
        Assert.assertEquals((long)4L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"PK2", (Object)rs.getString(1));
        Assert.assertEquals((Object)"V12", (Object)rs.getString(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertEquals((long)3L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"PK1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"V11", (Object)rs.getString(2));
        Assert.assertEquals((long)1L, (long)rs.getInt(3));
        Assert.assertEquals((long)2L, (long)rs.getInt(4));
    }

    protected void validateIndex(Connection connection, String tableName, boolean isViewIndex, HashMap<String, ArrayList<String>> expected) throws SQLException {
        String selectTable = "SELECT * FROM " + tableName;
        ResultSet rs = connection.createStatement().executeQuery(selectTable);
        int cnt = 0;
        while (rs.next()) {
            String pk = rs.getString(2);
            Assert.assertTrue((boolean)expected.containsKey(pk));
            ArrayList<String> row = expected.get(pk);
            Assert.assertEquals((Object)row.get(1), (Object)rs.getString(1));
            Assert.assertEquals((Object)row.get(2), (Object)rs.getString(3));
            Assert.assertEquals((Object)row.get(3), (Object)rs.getString(4));
            if (isViewIndex) {
                Assert.assertEquals((Object)row.get(5), (Object)rs.getString(5));
            }
            ++cnt;
        }
        Assert.assertEquals((long)cnt, (long)expected.size());
    }

    public static void renameAndDropPhysicalTable(Connection conn, String tenantId, String schema, String tableName, String physicalName, boolean isNamespaceEnabled) throws Exception {
        long lastDDLTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        String changeName = String.format("UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, PHYSICAL_TABLE_NAME, LAST_DDL_TIMESTAMP) VALUES (%s, %s, '%s', NULL, NULL, '%s', %d)", tenantId, schema == null ? null : "'" + schema + "'", tableName, physicalName, lastDDLTimestamp);
        conn.createStatement().execute(changeName);
        conn.commit();
        ServerMetadataCacheTestImpl.resetCache();
        String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
        if (isNamespaceEnabled && !Strings.isNullOrEmpty((String)schema) && !"NULL".equals(schema)) {
            fullTableName = schema + ":" + tableName;
        }
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        TableName hTableName = TableName.valueOf((String)fullTableName);
        admin.disableTable(hTableName);
        admin.deleteTable(hTableName);
        conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
    }
}

