/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class LikeExpressionIT
extends ParallelStatsDisabledIT {
    private String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        this.tableName = LikeExpressionIT.generateUniqueName();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
            String ddl = "CREATE TABLE " + this.tableName + " (k VARCHAR NOT NULL PRIMARY KEY, i INTEGER)";
            conn.createStatement().execute(ddl);
            this.insertRow(conn, "123n7-app-2-", 1);
            this.insertRow(conn, "132n7-App-2-", 2);
            this.insertRow(conn, "213n7-app-2-", 4);
            this.insertRow(conn, "231n7-App-2-", 8);
            this.insertRow(conn, "312n7-app-2-", 16);
            this.insertRow(conn, "321n7-App-2-", 32);
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void insertRow(Connection conn, String k, int i) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (?, ?)");
        stmt.setString(1, k);
        stmt.setInt(2, i);
        stmt.executeUpdate();
        conn.commit();
    }

    private void testLikeExpression(Connection conn, String likeStr, int numResult, int expectedSum) throws Exception {
        String cmd = "select k, i from " + this.tableName + " where k like '" + likeStr + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(cmd);
        int sum = 0;
        for (int i = 0; i < numResult; ++i) {
            Assert.assertTrue((boolean)rs.next());
            sum += rs.getInt("i");
        }
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((long)sum, (long)expectedSum);
    }

    @Test
    public void testLikeExpression() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        this.testLikeExpression(conn, "%1%3%7%2%", 3, 7);
        this.testLikeExpression(conn, "%A%", 3, 42);
        conn.close();
    }

    @Test
    public void testLikeEverythingExpression() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        String table = LikeExpressionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table + " (k1 VARCHAR, k2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES('aa','bb')");
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES('ab','bc')");
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES(null,'cc')");
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES('dd',null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE k1 LIKE '%'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bb", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"dd", (Object)rs.getString(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE k2 LIKE '%'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"cc", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bb", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE k2 LIKE '%%'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"cc", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bb", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE k2 NOT LIKE '%'");
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE k2 NOT LIKE '%%'");
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testLikeWithEscapenLParen() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        String t = LikeExpressionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + t + " (k VARCHAR, v VARCHAR, CONSTRAINT pk PRIMARY KEY (k))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('aa','bb')");
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('a\\(d','xx')");
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('dd',null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k not like '%\\(%'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bb", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"dd", (Object)rs.getString(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNewLine() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        String t = LikeExpressionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + t + " (k VARCHAR NOT NULL PRIMARY KEY)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('AA\nA')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like 'AA%'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"AA\nA", (Object)rs.getString(1));
        rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like 'AA_A'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"AA\nA", (Object)rs.getString(1));
        rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like 'AA%A'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"AA\nA", (Object)rs.getString(1));
        rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like 'AA_'");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOneChar() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        String t = LikeExpressionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + t + " (k VARCHAR NOT NULL PRIMARY KEY)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('A')");
        conn.createStatement().execute("UPSERT INTO " + t + " VALUES('AA')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like '_'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"A", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + t + " WHERE k like '_A'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"AA", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNull() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        String table = LikeExpressionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table + " (pk INTEGER PRIMARY KEY, str VARCHAR)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES(0,'aa')");
        conn.createStatement().execute("UPSERT INTO " + table + " VALUES(1, null)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT str LIKE '%' FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT str LIKE '%%' FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT str NOT LIKE '%' FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT str NOT LIKE '%%' FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT NOT (str LIKE '%') FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT NOT(str LIKE '%%') FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMultiCFLikeExpressionWithLimitOffset() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String ddl = "create table " + tableName + " (id integer not null primary key, cf.col1 varchar, cf.col2 varchar, cf2.col3 varchar, cf2.col4 varchar)";
        String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());){
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 1; i <= 10; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, i + "col1");
                stmt.setString(3, i + "col2");
                stmt.setString(4, i + "col3");
                stmt.setString(5, i + "col4");
                stmt.executeUpdate();
            }
            conn.commit();
            String query = "select cf.* from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            ResultSet rs = conn.createStatement().executeQuery(query);
            int expectedCount = 8;
            int i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
            query = "select cf.*, cf2.* from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            rs = conn.createStatement().executeQuery(query);
            i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
                Assert.assertTrue((boolean)rs.getString("COL3").contains("col3"));
                Assert.assertTrue((boolean)rs.getString("COL4").contains("col4"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
            query = "select * from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            rs = conn.createStatement().executeQuery(query);
            i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
                Assert.assertTrue((boolean)rs.getString("COL3").contains("col3"));
                Assert.assertTrue((boolean)rs.getString("COL4").contains("col4"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
        }
    }

    @Test
    public void testSingleCFLikeExpressionWithLimitOffset() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String ddl = "create table " + tableName + " (id integer not null primary key, cf.col1 varchar, cf.col2 varchar, cf.col3 varchar, cf.col4 varchar)";
        String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());){
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 1; i <= 10; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, i + "col1");
                stmt.setString(3, i + "col2");
                stmt.setString(4, i + "col3");
                stmt.setString(5, i + "col4");
                stmt.executeUpdate();
            }
            conn.commit();
            String query = "select cf.* from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            ResultSet rs = conn.createStatement().executeQuery(query);
            int expectedCount = 8;
            int i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
            query = "select cf.* from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            rs = conn.createStatement().executeQuery(query);
            i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
                Assert.assertTrue((boolean)rs.getString("COL3").contains("col3"));
                Assert.assertTrue((boolean)rs.getString("COL4").contains("col4"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
            query = "select cf.* from " + tableName + " where cf.col1 like '%col1%' limit 10 offset 2";
            rs = conn.createStatement().executeQuery(query);
            i = 0;
            while (rs.next()) {
                ++i;
                Assert.assertTrue((boolean)rs.getString("COL1").contains("col1"));
                Assert.assertTrue((boolean)rs.getString("COL2").contains("col2"));
                Assert.assertTrue((boolean)rs.getString("COL3").contains("col3"));
                Assert.assertTrue((boolean)rs.getString("COL4").contains("col4"));
            }
            Assert.assertEquals((long)expectedCount, (long)i);
        }
    }

    @Test
    public void testParameterizedLikeExpression() throws Exception {
        Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
        PreparedStatement select = conn.prepareStatement("select k from " + this.tableName + " where k like ?");
        select.setString(1, "12%");
        ResultSet rs = select.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"123n7-app-2-", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        select.setString(1, null);
        rs = select.executeQuery();
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLikeExpressionWithoutWildcards() throws Exception {
        String table = LikeExpressionIT.generateUniqueName();
        String createTable = "CREATE TABLE " + table + " (ID BIGINT NOT NULL PRIMARY KEY, USER_NAME VARCHAR(255))";
        String upsertTable = "UPSERT INTO " + table + " VALUES(1, 'Some Name')";
        String likeSelect = "SELECT * FROM " + table + " WHERE USER_NAME LIKE 'Some Name'";
        String iLikeSelect = "SELECT * FROM " + table + " WHERE USER_NAME ILIKE 'soMe nAme'";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());){
            conn.setAutoCommit(true);
            conn.createStatement().execute(createTable);
            conn.createStatement().executeUpdate(upsertTable);
            try (ResultSet rs = conn.createStatement().executeQuery(likeSelect);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertFalse((boolean)rs.next());
            }
            rs = conn.createStatement().executeQuery(iLikeSelect);
            var9_11 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var9_11 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testLikeWithIndexDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name varchar, type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type, name desc)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy012', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthIndexDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name char(5), type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type, name desc)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithIndexAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name varchar, type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type, name)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthIndexAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name char(5), type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type, name)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id varchar, name varchar, type decimal, status integer CONSTRAINT pk PRIMARY KEY(id desc, type))");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyz', 'xyz' , 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyabc', 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xx', 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xz', 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xxyz', 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy123', 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy', 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y', 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y012x', 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('w', 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('wxy01', 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xx", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id char(5) not null, name varchar, type decimal, status integer CONSTRAINT pk PRIMARY KEY(id desc, type))");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyz', 'xyz' , 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyabc', 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xx', 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xz', 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xxyz', 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy123', 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy', 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y', 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y012x', 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('w', 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('wxy01', 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xx", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id varchar, name varchar, type decimal, status integer CONSTRAINT pk PRIMARY KEY(id, type))");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyz', 'xyz' , 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyabc', 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xx', 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xz', 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xxyz', 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy123', 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy', 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y', 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y012x', 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('w', 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('wxy01', 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xx", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id char(5) not null, name varchar, type decimal, status integer CONSTRAINT pk PRIMARY KEY(id, type))");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyz', 'xyz' , 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xyabc', 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xx', 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xz', 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xxyz', 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy123', 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('xy', 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y', 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('y012x', 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('w', 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES('wxy01', 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xy%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'x%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xx", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'z012%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'v0%'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and id like 'xz%'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xz", (Object)rs.getString(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithOrderByDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name varchar, type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthOrderByDesc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name char(5), type integer, status integer )");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%' order by name desc");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%' order by name desc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithOrderByAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name varchar, type integer, status integer)");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLikeWithFixedWidthOrderByAsc() throws Exception {
        String tableName = LikeExpressionIT.generateUniqueName();
        String indexName = tableName + "_IDX";
        try (Connection conn = DriverManager.getConnection(LikeExpressionIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key, name char(5), type integer, status integer)");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(status, type)");
            conn.commit();
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(1, 'xyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(2, 'xyabc', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(3, 'xx', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(4, 'xz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(5, 'xxyz', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(6, 'xy123', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(7, 'xy', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'y', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'y012x', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(8, 'w', 1, 1)");
            stmt.executeUpdate("UPSERT INTO " + tableName + " VALUES(9, 'wxy01', 1, 1)");
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xy%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'x%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xx", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xxyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xy123", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyabc", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'z012%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'v0%' order by name");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " where type = 1 and status = 1 and name like 'xz%' order by name");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"xz", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

