/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class LastValuesFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void simpleTest() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 9, 5, 10)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (7, 9, 6, 13)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (8, 9, 7, 8)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (9, 9, 8, 6)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 3) WITHIN GROUP (ORDER BY dates DESC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((int[])new int[]{7, 9, 4}, (int[])((int[])rs.getArray(1).getArray()));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((int[])new int[]{10, 13, 8}, (int[])((int[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void varcharDatatypeSimpleTest() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String table_name = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table_name + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" VARCHAR(3), \"value\" VARCHAR(3))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + table_name + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, '1', '3')");
        conn.createStatement().execute("UPSERT INTO " + table_name + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, '2', '7')");
        conn.createStatement().execute("UPSERT INTO " + table_name + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, '3', '9')");
        conn.createStatement().execute("UPSERT INTO " + table_name + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, '4', '2')");
        conn.createStatement().execute("UPSERT INTO " + table_name + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, '5', '4')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2) WITHIN GROUP (ORDER BY \"DATE\" ASC) FROM " + table_name + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((Object[])new String[]{"4", "2"}, (Object[])((String[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void floatDatatypeSimpleTest() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" FLOAT, \"value\" FLOAT)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 1, 300)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 2, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, 3, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, 5, 400)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2) WITHIN GROUP (ORDER BY \"DATE\" ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)((float[])rs.getArray(1).getArray())[0], (double)400.0, (double)1.0E-6);
        Assert.assertEquals((double)((float[])rs.getArray(1).getArray())[1], (double)2.0, (double)1.0E-6);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void doubleDatatypeSimpleTest() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" DOUBLE, \"value\" DOUBLE)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 1, 300)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 2, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, 3, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, 5, 400)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2) WITHIN GROUP (ORDER BY \"DATE\" ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)((double[])rs.getArray(1).getArray())[0], (double)400.0, (double)1.0E-6);
        Assert.assertEquals((double)((double[])rs.getArray(1).getArray())[1], (double)2.0, (double)1.0E-6);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void offsetValueAscOrder() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" INTEGER, \"value\" UNSIGNED_LONG)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 0, 300)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (6, 8, 5, 150)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2)  WITHIN GROUP (ORDER BY \"DATE\" ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{150L, 2L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void simpleTestNoGroupBy() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 2) WITHIN GROUP (ORDER BY dates DESC) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((int[])new int[]{7, 9}, (int[])((int[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void rowLessThanOffsetNoGroupBy() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 3) WITHIN GROUP (ORDER BY dates DESC) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((int[])new int[]{7, 9}, (int[])((int[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void offsetValueDescOrder() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" INTEGER, \"value\" UNSIGNED_LONG)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 0, 300)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (6, 8, 5, 150)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2)  WITHIN GROUP (ORDER BY \"DATE\" DESC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{300L, 7L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void offsetValueSubAggregation() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" INTEGER, \"value\" UNSIGNED_LONG)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 0, 300)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 9, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 9, 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 10, 4, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (6, 10, 5, 150)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(SUM_VALUE, 2) WITHIN GROUP (ORDER BY MIN_DATE ASC) FROM (SELECT MIN(\"DATE\") AS MIN_DATE, SUM(\"value\") AS SUM_VALUE FROM " + tableName + " GROUP BY page_id) x");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{152L, 13L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void offsetValueLastMismatchByColumn() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, \"DATE\" INTEGER, \"value\" UNSIGNED_LONG)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (1, 8, 5, 8)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (2, 8, 2, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (3, 8, 1, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (4, 8, 4, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (5, 8, 3, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, \"DATE\", \"value\") VALUES (6, 8, 0, 1)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2)  WITHIN GROUP (ORDER BY \"DATE\" DESC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{1L, 9L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSortOrderInDataColWithOffset() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL, page_id UNSIGNED_LONG, dates BIGINT NOT NULL, \"value\" BIGINT NOT NULL CONSTRAINT pk PRIMARY KEY (id, dates, \"value\" DESC))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (1, 8, 1, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (2, 8, 2, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (3, 8, 3, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (5, 8, 5, 158)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (4, 8, 4, 5)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2)  WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{158L, 5L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void nonUniqueValuesInOrderByAsc() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 3) WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        int[] result = null;
        Assert.assertTrue((boolean)rs.next());
        result = (int[])rs.getArray(1).getArray();
        Assert.assertEquals((long)result[0], (long)3L);
        this.assertInIntArray(new int[]{2, 4, 9}, result[1]);
        this.assertInIntArray(new int[]{2, 4, 9}, result[2]);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void nonUniqueValuesInOrderByAscSkipDuplicit() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 5) WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        int[] result = null;
        Assert.assertTrue((boolean)rs.next());
        result = (int[])rs.getArray(1).getArray();
        Assert.assertEquals((long)result[0], (long)3L);
        this.assertInIntArray(new int[]{2, 4, 9}, result[1]);
        this.assertInIntArray(new int[]{2, 4, 9}, result[2]);
        this.assertInIntArray(new int[]{2, 4, 9}, result[3]);
        Assert.assertEquals((long)result[4], (long)7L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void nonUniqueValuesInOrderByDesc() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 1, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 2, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 3) WITHIN GROUP (ORDER BY dates DESC) FROM " + tableName + " GROUP BY page_id");
        int[] result = null;
        Assert.assertTrue((boolean)rs.next());
        result = (int[])rs.getArray(1).getArray();
        Assert.assertEquals((long)result[0], (long)7L);
        this.assertInIntArray(new int[]{2, 4, 9}, result[1]);
        this.assertInIntArray(new int[]{2, 4, 9}, result[2]);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void nonUniqueValuesInOrderNextValueDesc() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 0, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 1, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (7, 8, 3, 5)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 2) WITHIN GROUP (ORDER BY dates DESC) FROM " + tableName + " GROUP BY page_id");
        int[] result = null;
        Assert.assertTrue((boolean)rs.next());
        result = (int[])rs.getArray(1).getArray();
        Assert.assertEquals((long)result[0], (long)7L);
        Assert.assertEquals((long)result[1], (long)9L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void nonUniqueValuesInOrderNextValueAsc() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 0, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 1, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (7, 8, 3, 5)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 5) WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        int[] result = null;
        Assert.assertTrue((boolean)rs.next());
        result = (int[])rs.getArray(1).getArray();
        this.assertInIntArray(new int[]{3, 5}, result[0]);
        this.assertInIntArray(new int[]{3, 5}, result[1]);
        this.assertInIntArray(new int[]{2, 4}, result[2]);
        this.assertInIntArray(new int[]{2, 4}, result[3]);
        Assert.assertEquals((long)result[4], (long)9L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void ignoreNullValues() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL, page_id UNSIGNED_LONG, dates BIGINT NOT NULL, \"value\" BIGINT NULL CONSTRAINT pk PRIMARY KEY (id, dates))";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (1, 8, 1, 1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (2, 8, 2, NULL)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (3, 8, 3, NULL)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (5, 8, 4, NULL)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, \"value\") VALUES (4, 8, 5, 5)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(\"value\", 2)  WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((long[])new long[]{5L, 1L}, (long[])((long[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void rowLessThanOffsetWithGroupBy() throws Exception {
        Connection conn = DriverManager.getConnection(LastValuesFunctionIT.getUrl());
        String tableName = LastValuesFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL PRIMARY KEY, page_id UNSIGNED_LONG, dates INTEGER, val INTEGER)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (2, 8, 0, 7)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (3, 8, 1, 9)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (4, 8, 2, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (5, 8, 2, 2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (6, 8, 3, 3)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (id, page_id, dates, val) VALUES (7, 9, 3, 5)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LAST_VALUES(val, 2)  WITHIN GROUP (ORDER BY dates ASC) FROM " + tableName + " GROUP BY page_id");
        Assert.assertTrue((boolean)rs.next());
        int[] result = (int[])rs.getArray(1).getArray();
        Assert.assertEquals((long)result[0], (long)3L);
        this.assertInIntArray(new int[]{2, 4}, result[1]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((int[])new int[]{5}, (int[])((int[])rs.getArray(1).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    private void assertInIntArray(int[] should, int actualValue) {
        ArrayList<Integer> shouldList = new ArrayList<Integer>();
        for (int i : should) {
            shouldList.add(i);
        }
        Assert.assertTrue((boolean)shouldList.contains(actualValue));
    }
}

