/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class KeyOnlyIT
extends ParallelStatsEnabledIT {
    private String tableName;

    @Before
    public void createTable() throws SQLException {
        this.tableName = KeyOnlyIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(KeyOnlyIT.getUrl(), props);){
            conn.createStatement().execute("create table " + this.tableName + "   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
        }
    }

    @Test
    public void testKeyOnly() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(KeyOnlyIT.getUrl(), props);
        this.initTableValues(conn);
        TestUtil.analyzeTable(conn, this.tableName);
        String query = "SELECT i1, i2 FROM " + this.tableName;
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        List<KeyRange> splits = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)3L, (long)splits.size());
        conn.createStatement().execute("ALTER TABLE " + this.tableName + " ADD s1 varchar");
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 5);
        stmt.setInt(2, 6);
        stmt.setString(3, "foo");
        stmt.execute();
        conn.commit();
        TestUtil.analyzeTable(conn, this.tableName);
        query = "SELECT i1 FROM " + this.tableName;
        statement = conn.prepareStatement(query);
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        query = "SELECT i1,s1 FROM " + this.tableName;
        statement = conn.prepareStatement(query);
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"foo", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testOr() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(KeyOnlyIT.getUrl(), props);
        this.initTableValues(conn);
        TestUtil.analyzeTable(conn, this.tableName);
        String query = "SELECT i1 FROM " + this.tableName + " WHERE i1 < 2 or i1 = 3";
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testQueryWithLimitAndStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(KeyOnlyIT.getUrl(), props);
        this.initTableValues(conn, 100);
        TestUtil.analyzeTable(conn, this.tableName);
        String query = "SELECT i1 FROM " + this.tableName + " LIMIT 1";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"SERIAL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((long)1L, (long)explainPlanAttributes.getServerRowLimit().intValue());
        Assert.assertEquals((long)1L, (long)explainPlanAttributes.getClientRowLimit().intValue());
    }

    @Test
    public void testDescKeys() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(KeyOnlyIT.getUrl(), props);
        String tableName = KeyOnlyIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("create table " + tableName + " (k varchar primary key desc)");
            stmt.execute("upsert into " + tableName + " values ('a')");
            stmt.execute("upsert into " + tableName + " values ('aa')");
            stmt.execute("upsert into " + tableName + " values ('aaa')");
            stmt.execute("upsert into " + tableName + " values ('aaab')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select * from " + tableName + " where k > 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaab", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k >= 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaab", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k >= 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaab", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k > 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k < 'a'");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k <= 'a'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k < 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k <= 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k > 'a' and k < 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k > 'a' and k <= 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + tableName + " where k >= 'a' and k <= 'aaa'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"aa", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void initTableValues(Connection conn) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        stmt.setInt(1, 1);
        stmt.setInt(2, 2);
        stmt.execute();
        stmt.setInt(1, 3);
        stmt.setInt(2, 4);
        stmt.execute();
        conn.commit();
    }

    private void initTableValues(Connection conn, int nRows) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        for (int i = 0; i < nRows; ++i) {
            stmt.setInt(1, i);
            stmt.setInt(2, i + 1);
            stmt.execute();
        }
        conn.commit();
    }
}

