/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexWithDefaultValueIT
extends ParallelStatsDisabledIT {
    @Test
    public void testQueryTableWithIndex() throws Exception {
        String tableName = IndexWithDefaultValueIT.generateUniqueName();
        String indexName = IndexWithDefaultValueIT.generateUniqueName();
        Properties props = new Properties();
        String schema = IndexWithDefaultValueIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl(), props);
        conn.setSchema(schema);
        conn.createStatement().execute("\ncreate table " + tableName + "(\npk VARCHAR,\nb VARCHAR,\nc VARCHAR default '0',\nCONSTRAINT my_pk PRIMARY KEY (pk)\n)");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values('1','1','1')");
        conn.commit();
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(pk, b, c)");
        conn.commit();
        PreparedStatement select = conn.prepareStatement("select * from " + tableName);
        ResultSet rs = select.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        conn.close();
    }

    @Test
    public void testQueryTableWithIndexBigintDefault() throws Exception {
        String tableName = IndexWithDefaultValueIT.generateUniqueName();
        String indexName = IndexWithDefaultValueIT.generateUniqueName();
        Properties props = new Properties();
        String schema = IndexWithDefaultValueIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl(), props);
        conn.setSchema(schema);
        conn.createStatement().execute("\ncreate table " + tableName + "(\nid CHAR(32) NOT NULL,\nno CHAR(32) default 'AB',total BIGINT default 0,\nscore INTEGER default 0,CONSTRAINT my_pk PRIMARY KEY (id)\n)");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + "(id, no, total, score) values ('1111','1112', 1113, 1114)");
        conn.createStatement().execute("upsert into " + tableName + "(id, total) values ('1121', 1123)");
        conn.commit();
        conn.createStatement().execute("CREATE INDEX " + indexName + " on " + tableName + " (no, total, score)");
        conn.commit();
        PreparedStatement select = conn.prepareStatement("select * from " + tableName);
        ResultSet rs = select.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)1113L, (Object)rs.getObject(3));
        Assert.assertEquals((Object)1114, (Object)rs.getObject(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"AB", (Object)rs.getObject(2));
        Assert.assertEquals((Object)1123L, (Object)rs.getObject(3));
        Assert.assertEquals((Object)0, (Object)rs.getObject(4));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        conn.close();
    }

    @Test
    public void testQueryTableWithIndexDefaultValue() throws Exception {
        String tableName = IndexWithDefaultValueIT.generateUniqueName();
        String indexName = IndexWithDefaultValueIT.generateUniqueName();
        Properties props = new Properties();
        String schema = IndexWithDefaultValueIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl(), props);
        conn.setSchema(schema);
        conn.createStatement().execute("\ncreate table " + tableName + "(\npk1 INTEGER NOT NULL, pk2 INTEGER DEFAULT 10, CONSTRAINT my_pk PRIMARY KEY (pk1)\n)");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + "(pk1, pk2) values (1,1)");
        conn.createStatement().execute("upsert into " + tableName + "(pk1, pk2) values (2, null)");
        conn.createStatement().execute("upsert into " + tableName + "(pk1) values (3)");
        conn.commit();
        conn.createStatement().execute("CREATE INDEX " + indexName + " on " + tableName + " (pk1, pk2)");
        conn.commit();
        PreparedStatement select = conn.prepareStatement("select * from " + tableName);
        ResultSet rs = select.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)1, (Object)rs.getObject(1));
        Assert.assertEquals((Object)1, (Object)rs.getObject(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)2, (Object)rs.getObject(1));
        Assert.assertEquals(null, (Object)rs.getObject(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)3, (Object)rs.getObject(1));
        Assert.assertEquals((Object)10, (Object)rs.getObject(2));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        conn.close();
    }

    @Test
    public void testDefaultLocalIndexed() throws Exception {
        String table = IndexWithDefaultValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = IndexWithDefaultValueIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + idx + " on " + table + " (c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " (pk, c1) VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 100");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 5");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultIndexed() throws Exception {
        String table = IndexWithDefaultValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = IndexWithDefaultValueIT.generateUniqueName();
        ddl = "CREATE INDEX " + idx + " on " + table + " (c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " (pk, c1) VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 100");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 5");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultColumnValue() throws Exception {
        String sharedTable1 = IndexWithDefaultValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + sharedTable1 + " (pk1 INTEGER NOT NULL, pk2 INTEGER DEFAULT 10, CONSTRAINT NAME_PK PRIMARY KEY (pk1))";
        Connection conn = DriverManager.getConnection(IndexWithDefaultValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + sharedTable1 + " VALUES (1, 1)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + sharedTable1 + " VALUES (2, null)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + sharedTable1 + " VALUES (3)";
        conn.createStatement().execute(dml);
        conn.commit();
        String projection = "*";
        ResultSet rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + sharedTable1 + " WHERE pk1 = 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + sharedTable1 + " WHERE pk1 = 3");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }
}

