/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexVerificationOldDesignIT
extends BaseTest {
    ManualEnvironmentEdge injectEdge;

    @BeforeClass
    public static synchronized void setup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        serverProps.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.toString(false));
        IndexVerificationOldDesignIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexToolOnlyVerifyOption() throws Exception {
        long ttl = 3600L;
        String schemaName = IndexVerificationOldDesignIT.generateUniqueName();
        String dataTableName = IndexVerificationOldDesignIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexVerificationOldDesignIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexVerificationOldDesignIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, CODE VARCHAR) COLUMN_ENCODED_BYTES=0, TTL=" + ttl);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (CODE)", indexTableName, dataTableFullName));
            this.upsertValidRows(conn, dataTableFullName);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)6L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            conn.createStatement().execute("upsert into " + indexTableFullName + " values ('Phoenix5', 6,'G')");
            conn.commit();
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)5L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            this.injectEdge = new ManualEnvironmentEdge();
            this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis() + ttl * 1000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.injectEdge);
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testIndexToolOnlyVerifyOption_viewIndex() throws Exception {
        String schemaName = IndexVerificationOldDesignIT.generateUniqueName();
        String dataTableName = IndexVerificationOldDesignIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexVerificationOldDesignIT.generateUniqueName();
        String viewName = IndexVerificationOldDesignIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexVerificationOldDesignIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, CODE VARCHAR) COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + dataTableFullName);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (CODE)", indexTableName, fullViewName));
            this.upsertValidRows(conn, fullViewName);
            IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            conn.createStatement().execute("upsert into " + indexTableFullName + " values ('Phoenix5', 6,'G')");
            conn.createStatement().execute("delete from " + indexTableFullName + " where \"0:CODE\" = 'D'");
            conn.commit();
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexVerificationOldDesignIT.getUtility().getConfiguration())) {
                Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            } else {
                Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            }
        }
    }

    private void upsertValidRows(Connection conn, String table) throws SQLException {
        conn.createStatement().execute("upsert into " + table + " values (1, 'Phoenix', 'A')");
        conn.createStatement().execute("upsert into " + table + " values (2, 'Phoenix1', 'B')");
        conn.createStatement().execute("upsert into " + table + " values (3, 'Phoenix2', 'C')");
        conn.createStatement().execute("upsert into " + table + " values (4, 'Phoenix3', 'D')");
        conn.createStatement().execute("upsert into " + table + " values (5, 'Phoenix4', 'E')");
        conn.createStatement().execute("upsert into " + table + " values (6, 'Phoenix5', 'F')");
        conn.commit();
    }
}

