/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexToolTimeRangeIT
extends BaseTest {
    private static final String CREATE_TABLE_DDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) COLUMN_ENCODED_BYTES=0";
    public static final String CREATE_INDEX_DDL = "CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)";
    private static final String UPSERT_TABLE_DML = "UPSERT INTO %s VALUES(?,?,?)";
    private static String dataTableFullName;
    private static String indexTableFullName;
    private static String schemaName;
    private static String dataTableName;
    private static String indexTableName;
    static MyClock myClock;

    @BeforeClass
    public static synchronized void setup() throws Exception {
        IndexToolTimeRangeIT.setupMiniCluster();
        IndexToolTimeRangeIT.createTableAndIndex();
        IndexToolTimeRangeIT.populateDataTable();
    }

    private static void createTableAndIndex() throws SQLException {
        schemaName = IndexToolTimeRangeIT.generateUniqueName();
        dataTableName = "D_" + IndexToolTimeRangeIT.generateUniqueName();
        dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        indexTableName = "I_" + IndexToolTimeRangeIT.generateUniqueName();
        indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        try (Connection conn = IndexToolTimeRangeIT.getConnection();){
            conn.createStatement().execute(String.format(CREATE_TABLE_DDL, dataTableFullName));
            conn.commit();
            conn.createStatement().execute(String.format(CREATE_INDEX_DDL, indexTableName, dataTableFullName));
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateDataTable() throws SQLException {
        myClock = new MyClock();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)myClock);
        try {
            myClock.tickTime();
            myClock.tickTime();
            try (Connection conn = IndexToolTimeRangeIT.getConnection();){
                for (int i = 0; i < 5; ++i) {
                    myClock.tickTime();
                    PreparedStatement ps = conn.prepareStatement(String.format(UPSERT_TABLE_DML, dataTableFullName));
                    ps.setInt(1, i + 1);
                    ps.setInt(2, (i + 1) * 10);
                    ps.setInt(3, (i + 1) * 100);
                    ps.execute();
                    conn.commit();
                }
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static void setupMiniCluster() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        IndexToolTimeRangeIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    private int countRowsInIndex() throws SQLException {
        String select = "SELECT COUNT(*) FROM " + indexTableFullName;
        try (Connection conn = IndexToolTimeRangeIT.getConnection();){
            ResultSet rs = conn.createStatement().executeQuery(select);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return -1;
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(IndexToolTimeRangeIT.getUrl());
    }

    @Test
    public void testValidTimeRange() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild", "--start-time", myClock.getRelativeTimeAsString(1L), "--end-time", myClock.getRelativeTimeAsString(9L)};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)5L, (long)this.countRowsInIndex());
    }

    @Test
    public void testValidTimeRange_startTimeInBetween() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild", "--start-time", myClock.getRelativeTimeAsString(6L), "--end-time", myClock.getRelativeTimeAsString(9L)};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)3L, (long)this.countRowsInIndex());
    }

    @Test
    public void testValidTimeRange_endTimeInBetween() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild", "--start-time", myClock.getRelativeTimeAsString(1L), "--end-time", myClock.getRelativeTimeAsString(6L)};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)2L, (long)this.countRowsInIndex());
    }

    @Test
    public void testNoTimeRangePassed() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild"};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)5L, (long)this.countRowsInIndex());
    }

    @Test
    public void testValidTimeRange_onlyStartTimePassed() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild", "--start-time", myClock.getRelativeTimeAsString(8L)};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)1L, (long)this.countRowsInIndex());
    }

    @Test
    public void testValidTimeRange_onlyEndTimePassed() throws Exception {
        String[] args = new String[]{"--delete-all-and-rebuild", "--end-time", myClock.getRelativeTimeAsString(5L)};
        this.runIndexTool(args, 0);
        Assert.assertEquals((long)1L, (long)this.countRowsInIndex());
    }

    private void runIndexTool(String[] args, int expectedStatus) throws Exception {
        IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, expectedStatus, IndexTool.IndexVerifyType.NONE, args);
    }

    @AfterClass
    public static synchronized void teardown() throws Exception {
        boolean refCountLeaked = IndexToolTimeRangeIT.isAnyStoreRefCountLeaked();
        IndexToolTimeRangeIT.tearDownMiniCluster(2);
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    private static class MyClock
    extends EnvironmentEdge {
        public long epoch;
        public volatile long time;

        public MyClock() {
            this.time = this.epoch = System.currentTimeMillis();
        }

        public long currentTime() {
            return this.time;
        }

        public long getRelativeTime(long n) {
            return this.epoch + n - 1L;
        }

        public String getRelativeTimeAsString(long n) {
            return Long.toString(this.getRelativeTime(n));
        }

        public void tickTime() {
            ++this.time;
        }
    }
}

