/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.BaseOwnClusterIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexToolForPartialBuildIT
extends BaseOwnClusterIT {
    protected boolean isNamespaceEnabled = false;
    protected final String tableDDLOptions;

    public IndexToolForPartialBuildIT() {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" SPLIT ON(1,2)");
        this.tableDDLOptions = optionBuilder.toString();
    }

    public static Map<String, String> getServerProperties() {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)10);
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put(" yarn.scheduler.capacity.maximum-am-resource-percent", "1.0");
        serverProps.put("hbase.client.retries.number", "2");
        serverProps.put("hbase.rpc.timeout", "10000");
        serverProps.put("hbase.client.pause", "5000");
        serverProps.put("phoenix.index.failure.handling.rebuild", Boolean.FALSE.toString());
        serverProps.put("phoenix.index.failure.disable.index", Boolean.TRUE.toString());
        serverProps.put("phoenix.index.failure.handling.rebuild.overlap.forward.time", Long.toString(2000L));
        return serverProps;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Map<String, String> serverProps = IndexToolForPartialBuildIT.getServerProperties();
        IndexToolForPartialBuildIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), ReadOnlyProps.EMPTY_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryIndex() throws Exception {
        String schemaName = IndexToolForPartialBuildIT.generateUniqueName();
        String dataTableName = IndexToolForPartialBuildIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indxTable = String.format("%s_IDX", dataTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.transactions.enabled", Boolean.TRUE.toString());
        props.setProperty("phoenix.explain.displayRowCount", Boolean.FALSE.toString());
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceEnabled));
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(IndexToolForPartialBuildIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        try (Admin admin = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().getAdmin();){
            int i;
            if (this.isNamespaceEnabled) {
                conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            }
            stmt.execute(String.format("CREATE IMMUTABLE TABLE %s (ID BIGINT NOT NULL, NAME VARCHAR, ZIP INTEGER CONSTRAINT PK PRIMARY KEY(ID ROW_TIMESTAMP)) %s", fullTableName, this.tableDDLOptions));
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", fullTableName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 1000);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 2000);
            conn.commit();
            stmt.execute(String.format("CREATE INDEX %s ON %s  (LPAD(UPPER(NAME),11,'x')||'_xyz') ", indxTable, fullTableName));
            IndexToolForPartialBuildIT.upsertRow(stmt1, 3000);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 4000);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 5000);
            conn.commit();
            PTable pindexTable = conn.getTable(SchemaUtil.getTableName((String)schemaName, (String)indxTable));
            try (Table hTable = admin.getConnection().getTable(TableName.valueOf((String)pindexTable.getPhysicalName().toString()));){
                Scan scan = new Scan();
                ResultScanner scanner = hTable.getScanner(scan);
                int cnt = 0;
                Result res = scanner.next();
                while (res != null) {
                    if (++cnt > 2) {
                        hTable.delete(new Delete(res.getRow()));
                    }
                    res = scanner.next();
                }
            }
            TestUtil.doMajorCompaction((Connection)conn, pindexTable.getPhysicalName().toString());
            conn.createStatement().execute(String.format("ALTER INDEX %s on %s REBUILD ASYNC", indxTable, fullTableName));
            ResultSet rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)schemaName), indxTable, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indxTable, (Object)rs.getString(3));
            String indexState = rs.getString("INDEX_STATE");
            Assert.assertEquals((Object)PIndexState.BUILDING.toString(), (Object)indexState);
            Assert.assertFalse((boolean)rs.next());
            IndexToolForPartialBuildIT.upsertRow(stmt1, 6000);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 7000);
            conn.commit();
            String selectSql = String.format("SELECT LPAD(UPPER(NAME),11,'x')||'_xyz',ID FROM %s", fullTableName);
            ExplainPlan plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)dataTableName, (boolean)this.isNamespaceEnabled).toString(), (Object)explainPlanAttributes.getTableName());
            rs = stmt1.executeQuery(selectSql);
            for (i = 1; i <= 7; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)("xxUNAME" + i * 1000 + "_xyz"), (Object)rs.getString(1));
            }
            rs = stmt1.executeQuery(String.format("SELECT * FROM %s", SchemaUtil.getTableName((String)schemaName, (String)indxTable)));
            for (i = 1; i <= 2; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)("xxUNAME" + i * 1000 + "_xyz"), (Object)rs.getString(1));
            }
            for (i = 6; i <= 7; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)("xxUNAME" + i * 1000 + "_xyz"), (Object)rs.getString(1));
            }
            Assert.assertFalse((boolean)rs.next());
            IndexTool indexingTool = new IndexTool();
            Configuration conf = new Configuration(IndexToolForPartialBuildIT.getUtility().getConfiguration());
            conf.set("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceEnabled));
            indexingTool.setConf(conf);
            String[] cmdArgs = this.getArgValues(schemaName, dataTableName, indxTable);
            int status = indexingTool.run(cmdArgs);
            Assert.assertEquals((long)0L, (long)status);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 8000);
            IndexToolForPartialBuildIT.upsertRow(stmt1, 9000);
            conn.commit();
            plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)indxTable, (boolean)this.isNamespaceEnabled).toString(), (Object)explainPlanAttributes.getTableName());
            rs = stmt.executeQuery(selectSql);
            for (int i2 = 1; i2 <= 9; ++i2) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)("xxUNAME" + i2 * 1000 + "_xyz"), (Object)rs.getString(1));
            }
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    public String[] getArgValues(String schemaName, String dataTable, String indexName) {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("-s");
            args.add(schemaName);
        }
        args.add("-dt");
        args.add(dataTable);
        args.add("-it");
        args.add(indexName);
        args.add("-runfg");
        args.add("-op");
        args.add("/tmp/output/partialTable_");
        return args.toArray(new String[0]);
    }

    public static void upsertRow(PreparedStatement stmt, int i) throws SQLException {
        stmt.setInt(1, i);
        stmt.setString(2, "uname" + String.valueOf(i));
        stmt.setInt(3, 95050 + i);
        stmt.executeUpdate();
    }
}

