/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRow;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class IndexToolForNonTxGlobalIndexIT
extends BaseTest {
    public static final int MAX_LOOKBACK_AGE = 3600;
    private final String tableDDLOptions;
    private final boolean useSnapshot = false;
    private final boolean mutable;
    private final String indexDDLOptions;
    private boolean singleCell;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    public IndexToolForNonTxGlobalIndexIT(boolean mutable, boolean singleCell) {
        StringBuilder optionBuilder = new StringBuilder();
        StringBuilder indexOptionBuilder = new StringBuilder();
        this.mutable = mutable;
        if (!mutable) {
            optionBuilder.append(" IMMUTABLE_ROWS=true ");
        }
        optionBuilder.append(" SPLIT ON(1,2)");
        this.tableDDLOptions = optionBuilder.toString();
        if (singleCell) {
            indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS,COLUMN_ENCODED_BYTES=2");
        }
        this.singleCell = singleCell;
        this.indexDDLOptions = indexOptionBuilder.toString();
    }

    @Parameterized.Parameters(name="mutable={0}, singleCellIndex={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @BeforeClass
    public static synchronized void setup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)8);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        serverProps.put("phoenix.max.lookback.age.seconds", Long.toString(3600L));
        serverProps.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        serverProps.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        serverProps.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        serverProps.put("hbase.regionserver.rpc.retry.interval", Long.toString(0L));
        serverProps.put("hbase.procedure.remote.dispatcher.delay.msec", Integer.toString(0));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)4);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        IndexToolForNonTxGlobalIndexIT.destroyDriver();
        IndexToolForNonTxGlobalIndexIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration().set("phoenix.index.rebuild.rpc.retries.counter", "1");
    }

    @After
    public void cleanup() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            this.deleteAllRows(conn, TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES));
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"));
        }
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testWithSetNull() throws Exception {
        if (!this.mutable) {
            return;
        }
        int NROWS = 210;
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            String upsertStmt = "UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(upsertStmt);
            IndexToolIT.setEveryNthRowWithNull(210, 2, stmt);
            conn.commit();
            IndexToolIT.setEveryNthRowWithNull(210, 3, stmt);
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName));
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, new String[0]);
            Assert.assertEquals((long)210L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertTrue((String)"Index rebuild failed!", (boolean)indexTool.getJob().isSuccessful());
            TestUtil.assertIndexState(conn, indexTableFullName, PIndexState.ACTIVE, null);
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)210L, (long)actualRowCount);
            IndexToolIT.setEveryNthRowWithNull(210, 5, stmt);
            conn.commit();
            actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)210L, (long)actualRowCount);
            IndexToolIT.setEveryNthRowWithNull(210, 7, stmt);
            conn.commit();
            actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)210L, (long)actualRowCount);
            actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)210L, (long)actualRowCount);
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)210L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)210L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)210L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
        }
    }

    @Test
    public void testIndexToolVerifyWithExpiredIndexRows() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, CODE VARCHAR) COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute("upsert into " + dataTableFullName + " values (1, 'Phoenix', 'A')");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (CODE) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName));
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration())) {
                Cell cell = IndexToolIT.getErrorMessageFromIndexToolOutputTable(conn, dataTableFullName, indexTableFullName);
                try {
                    String expectedErrorMsg = "Missing index row";
                    String actualErrorMsg = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    Assert.assertEquals((Object)expectedErrorMsg, (Object)actualErrorMsg);
                }
                catch (Exception ex) {
                    Assert.fail((String)"Fail to parsing the error message from IndexToolOutputTable");
                }
            } else {
                Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            }
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            TableName indexTable = TableName.valueOf((String)indexTableFullName);
            ColumnFamilyDescriptor desc = admin.getDescriptor(indexTable).getColumnFamilies()[0];
            ColumnFamilyDescriptor newDesc = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)desc).setTimeToLive(1).build();
            Future modifyColumnFams = admin.modifyColumnFamilyAsync(indexTable, newDesc);
            modifyColumnFams.get(41000L, TimeUnit.MILLISECONDS);
            TableName indexToolOutputTable = TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES);
            admin.disableTable(indexToolOutputTable);
            admin.deleteTable(indexToolOutputTable);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Scan scan = new Scan();
            Table hIndexToolTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(indexToolOutputTable.getName());
            Result r = hIndexToolTable.getScanner(scan).next();
            Assert.assertNull((Object)r);
        }
    }

    @Test
    public void testSecondaryGlobalIndexFailure() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            conn.commit();
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexToolIT.upsertRow(stmt1, 2);
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s  (LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz') " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            conn.commit();
            String qIndexTableName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexTableName);
            Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)TestUtil.getIndexState(conn, qIndexTableName));
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Admin admin = queryServices.getAdmin();
            TableName tn = TableName.valueOf((byte[])Bytes.toBytes((String)dataTableFullName));
            TableDescriptor td = admin.getDescriptor(tn);
            CoprocessorDescriptor cd = CoprocessorDescriptorBuilder.newBuilder((String)FastFailRegionObserver.class.getName()).setPriority(1).build();
            TableDescriptor newTD = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setCoprocessor(cd).build();
            admin.modifyTable(newTD);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, -1, new String[0]);
            Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)TestUtil.getIndexState(conn, qIndexTableName));
        }
    }

    @Test
    public void testBuildSecondaryIndexAndScrutinize() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            int NROWS = 1000;
            for (int i = 0; i < 1000; ++i) {
                IndexToolIT.upsertRow(stmt1, i);
            }
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)1000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)1000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)1000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration())) {
                Assert.assertEquals((long)1000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
                Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            } else {
                Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
                Assert.assertEquals((long)1000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            }
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)1000L, (long)actualRowCount);
            for (int i = 1000; i < 2000; ++i) {
                IndexToolIT.upsertRow(stmt1, i);
            }
            conn.commit();
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BOTH, new String[0]);
            Assert.assertEquals((long)2000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)2000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)2000L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)2000L, (long)actualRowCount);
        }
    }

    @Ignore(value="HBase 1.7 is required for this test")
    @Test
    public void testCleanUpOldDesignIndexRows() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            int N_ROWS = 100;
            int N_OLD_ROWS = 10;
            for (int i = 0; i < 100; ++i) {
                IndexToolIT.upsertRow(stmt1, i);
            }
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)100L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)100L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)100L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)100L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)100L, (long)actualRowCount);
            String stmtString3 = String.format("UPSERT INTO %s SELECT * FROM %s LIMIT %d", indexTableFullName, indexTableFullName, 10);
            conn.createStatement().execute(stmtString3);
            conn.commit();
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)10L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)10L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)100L, (long)actualRowCount);
        }
    }

    @Test
    public void testIndexToolVerifyBeforeAndBothOptions() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String viewName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName);
            conn.commit();
            conn.createStatement().execute("upsert into " + viewFullName + " values (1, 'Phoenix', 12345)");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, viewFullName));
            TestUtil.addCoprocessor(conn, "_IDX_" + dataTableFullName, IndexToolIT.MutationCountingRegionObserver.class);
            IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            Assert.assertEquals((long)1L, (long)IndexToolIT.MutationCountingRegionObserver.getMutationCount());
            IndexToolIT.MutationCountingRegionObserver.setMutationCount(0);
            IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)0L, (long)IndexToolIT.MutationCountingRegionObserver.getMutationCount());
            IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.BOTH, new String[0]);
            Assert.assertEquals((long)0L, (long)IndexToolIT.MutationCountingRegionObserver.getMutationCount());
        }
    }

    @Test
    public void testIndexToolVerifyAfterOption() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String viewName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName);
            conn.commit();
            conn.createStatement().execute("upsert into " + viewFullName + " values (1, 'Phoenix', 12345)");
            conn.commit();
            IndexRebuildRegionScanner.setIgnoreIndexRebuildForTesting((boolean)true);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, viewFullName));
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration())) {
                IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, -1, IndexTool.IndexVerifyType.AFTER, new String[0]);
                Cell cell = IndexToolIT.getErrorMessageFromIndexToolOutputTable(conn, dataTableFullName, "_IDX_" + dataTableFullName);
                try {
                    String expectedErrorMsg = "Missing index row";
                    String actualErrorMsg = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    Assert.assertEquals((Object)expectedErrorMsg, (Object)actualErrorMsg);
                }
                catch (Exception ex) {
                    Assert.fail((String)"Fail to parsing the error message from IndexToolOutputTable");
                }
            } else {
                IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
                Assert.assertEquals((long)1L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            }
            IndexRebuildRegionScanner.setIgnoreIndexRebuildForTesting((boolean)false);
        }
    }

    @Test
    public void testIndexToolFailedMapperNotRecordToResultTable() throws Exception {
        Assume.assumeTrue((this.mutable && this.singleCell ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
            String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableFullName + " values (1, 'Phoenix', 12345)");
            conn.commit();
            IndexRebuildRegionScanner.setThrowExceptionForRebuild((boolean)true);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName));
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, -1, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((Object)PIndexState.BUILDING, (Object)TestUtil.getIndexState(conn, indexTableFullName));
            Long scn = it.getJob().getConfiguration().getLong("phoenix.mr.currentscn.value", 1L);
            IndexRebuildRegionScanner.setThrowExceptionForRebuild((boolean)false);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, "-rv", Long.toString(scn));
            Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)TestUtil.getIndexState(conn, indexTableFullName));
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableFullName);
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testIndexToolOnlyVerifyOption() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, CODE VARCHAR) COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute("upsert into " + dataTableFullName + " values (1, 'Phoenix', 'A')");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (CODE) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName));
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration())) {
                Cell cell = IndexToolIT.getErrorMessageFromIndexToolOutputTable(conn, dataTableFullName, indexTableFullName);
                try {
                    String expectedErrorMsg = "Missing index row";
                    String actualErrorMsg = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    Assert.assertEquals((Object)expectedErrorMsg, (Object)actualErrorMsg);
                }
                catch (Exception ex) {
                    Assert.fail((String)"Fail to parsing the error message from IndexToolOutputTable");
                }
            }
            Assert.assertEquals((Object)PIndexState.BUILDING, (Object)TestUtil.getIndexState(conn, indexTableFullName));
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
        }
    }

    @Test
    public void testIndexToolForIncrementalRebuild() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        ArrayList<String> expectedStatus = new ArrayList<String>();
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, CODE VARCHAR) " + this.tableDDLOptions);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (CODE) " + this.indexDDLOptions, indexTableName, dataTableFullName));
            conn.createStatement().execute("upsert into " + dataTableFullName + " values (1, 'Phoenix', 'A')");
            conn.createStatement().execute("upsert into " + dataTableFullName + " values (2, 'Phoenix1', 'B')");
            conn.commit();
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            Long scn = it.getJob().getConfiguration().getLong("phoenix.mr.currentscn.value", 1L);
            expectedStatus.add("Executed");
            expectedStatus.add("Executed");
            expectedStatus.add("Executed");
            try {
                this.verifyRunStatusFromResultTable(conn, scn, indexTableFullName, 3, expectedStatus);
            }
            catch (AssertionError ae) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"));
                throw ae;
            }
            this.deleteOneRowFromResultTable(conn, scn, indexTableFullName);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, "-rv", Long.toString(scn));
            scn = it.getJob().getConfiguration().getLong("phoenix.mr.currentscn.value", 1L);
            expectedStatus.set(0, "Executed");
            expectedStatus.set(1, "Skipped");
            expectedStatus.set(2, "Skipped");
            this.verifyRunStatusFromResultTable(conn, scn, indexTableFullName, 5, expectedStatus);
            this.deleteAllRows(conn, TableName.valueOf((String)indexTableFullName));
            expectedStatus.set(0, "Skipped");
            expectedStatus.set(1, "Skipped");
            expectedStatus.set(2, "Skipped");
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, "-rv", Long.toString(scn));
            scn = it.getJob().getConfiguration().getLong("phoenix.mr.currentscn.value", 1L);
            this.verifyRunStatusFromResultTable(conn, scn, indexTableFullName, 8, expectedStatus);
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + indexTableFullName);
            Assert.assertFalse((boolean)rs.next());
            Assert.assertFalse((boolean)it.isValidLastVerifyTime(Long.valueOf(10L)));
            Assert.assertFalse((boolean)it.isValidLastVerifyTime(Long.valueOf(EnvironmentEdgeManager.currentTimeMillis() - 1000L)));
            Assert.assertTrue((boolean)it.isValidLastVerifyTime(scn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexToolForIncrementalVerify() throws Exception {
        ManualEnvironmentEdge customEdge = new ManualEnvironmentEdge();
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String viewName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String viewIndexName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        long waitForUpsert = 2L;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (key1 BIGINT NOT NULL, key2 BIGINT NOT NULL, val1 VARCHAR, val2 BIGINT, val3 BIGINT, val4 DOUBLE, val5 BIGINT, val6 VARCHAR CONSTRAINT my_pk PRIMARY KEY(key1, key2)) " + this.tableDDLOptions);
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName);
            conn.createStatement().execute(String.format("CREATE INDEX " + viewIndexName + " ON " + viewFullName + " (val3) INCLUDE(val5) " + this.indexDDLOptions, new Object[0]));
            conn.createStatement().execute(String.format("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (val3) INCLUDE(val5) " + this.indexDDLOptions, new Object[0]));
            customEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customEdge);
            long t0 = customEdge.currentTime();
            customEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + "(key1, key2, val1, val2) VALUES (4,5,'abc',3)");
            customEdge.incrementValue(waitForUpsert);
            long t1 = customEdge.currentTime();
            customEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + "(key1, key2, val1, val2) VALUES (1,2,'abc',3)");
            customEdge.incrementValue(waitForUpsert);
            long t2 = customEdge.currentTime();
            customEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + "(key1, key2, val3, val4) VALUES (1,2,4,1.2)");
            customEdge.incrementValue(waitForUpsert);
            long t3 = customEdge.currentTime();
            customEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + "(key1, key2, val5, val6) VALUES (1,2,5,'def')");
            customEdge.incrementValue(waitForUpsert);
            long t4 = customEdge.currentTime();
            customEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("DELETE FROM " + viewFullName + " WHERE key1=4");
            customEdge.incrementValue(waitForUpsert);
            long t5 = customEdge.currentTime();
            customEdge.incrementValue(10L);
            long t6 = customEdge.currentTime();
            if (!this.mutable) {
                IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t0), "-et", String.valueOf(t2));
                this.verifyCounters(it, 2, 2);
                customEdge.incrementValue(waitForUpsert);
                it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t2));
                this.verifyCounters(it, 1, 1);
                customEdge.incrementValue(waitForUpsert);
                it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t5), "-et", String.valueOf(t6));
                this.verifyCounters(it, 0, 0);
                customEdge.incrementValue(waitForUpsert);
                it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t0), "-et", String.valueOf(t2));
                this.verifyCounters(it, 2, 2);
                customEdge.incrementValue(waitForUpsert);
                it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t2));
                this.verifyCounters(it, 1, 1);
                customEdge.incrementValue(waitForUpsert);
                it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t5), "-et", String.valueOf(t6));
                this.verifyCounters(it, 0, 0);
                customEdge.incrementValue(waitForUpsert);
                return;
            }
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t0), "-et", String.valueOf(t4));
            this.verifyCounters(it, 2, 3);
            customEdge.incrementValue(waitForUpsert);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t0), "-et", String.valueOf(t2));
            this.verifyCounters(it, 2, 2);
            customEdge.incrementValue(waitForUpsert);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t3));
            this.verifyCounters(it, 1, 2);
            customEdge.incrementValue(waitForUpsert);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t2), "-et", String.valueOf(t4));
            this.verifyCounters(it, 1, 2);
            customEdge.incrementValue(waitForUpsert);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t4), "-et", String.valueOf(t5));
            this.verifyCounters(it, 1, 1);
            customEdge.incrementValue(waitForUpsert);
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t5), "-et", String.valueOf(t6));
            this.verifyCounters(it, 0, 0);
            customEdge.incrementValue(waitForUpsert);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexToolForIncrementalVerify_viewIndex() throws Exception {
        ManualEnvironmentEdge customeEdge = new ManualEnvironmentEdge();
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String viewName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewIndexName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        long waitForUpsert = 2L;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (key1 BIGINT NOT NULL, key2 BIGINT NOT NULL, val1 VARCHAR, val2 BIGINT, val3 BIGINT, val4 DOUBLE, val5 BIGINT, val6 VARCHAR CONSTRAINT my_pk PRIMARY KEY(key1, key2)) COLUMN_ENCODED_BYTES=0");
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName + " WHERE val6 = 'def'");
            conn.createStatement().execute(String.format("CREATE INDEX " + viewIndexName + " ON " + viewFullName + " (val3) INCLUDE(val5) " + this.indexDDLOptions, new Object[0]));
            customeEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customeEdge);
            long t1 = customeEdge.currentTime();
            customeEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + " VALUES (5,6,'abc',8,4,1.3,6,'def')");
            customeEdge.incrementValue(waitForUpsert);
            long t2 = customeEdge.currentTime();
            customeEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("UPSERT INTO " + viewFullName + " VALUES (1,2,'abc',3,4,1.2,5,'def')");
            customeEdge.incrementValue(waitForUpsert);
            long t3 = customeEdge.currentTime();
            customeEdge.incrementValue(waitForUpsert);
            conn.createStatement().execute("DELETE FROM " + viewFullName + " WHERE key1=5");
            customeEdge.incrementValue(waitForUpsert);
            long t4 = customeEdge.currentTime();
            customeEdge.incrementValue(10L);
            long t5 = customeEdge.currentTime();
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t4));
            this.verifyCounters(it, 2, 2);
            it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t2));
            this.verifyCounters(it, 1, 1);
            it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t2), "-et", String.valueOf(t3));
            this.verifyCounters(it, 1, 1);
            it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t1), "-et", String.valueOf(t3));
            this.verifyCounters(it, 2, 2);
            it = IndexToolIT.runIndexTool(false, schemaName, viewName, viewIndexName, null, 0, IndexTool.IndexVerifyType.ONLY, "-st", String.valueOf(t4), "-et", String.valueOf(t5));
            this.verifyCounters(it, 0, 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private void verifyCounters(IndexTool it, int scanned, int valid) throws IOException {
        Assert.assertEquals((long)scanned, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)valid, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
        Assert.assertEquals((long)0L, (long)it.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
    }

    @Test
    public void testDisableOutputLogging() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexToolIT.upsertRow(stmt1, 2);
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s (LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz') ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            conn.commit();
            this.assertDisableLogging(conn, 0, IndexTool.IndexVerifyType.ONLY, IndexTool.IndexDisableLoggingType.BEFORE, null, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexAndIndexToolTables(indexTableFullName);
            this.assertDisableLogging(conn, 0, IndexTool.IndexVerifyType.AFTER, IndexTool.IndexDisableLoggingType.AFTER, null, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexAndIndexToolTables(indexTableFullName);
            this.assertDisableLogging(conn, 0, IndexTool.IndexVerifyType.BEFORE, IndexTool.IndexDisableLoggingType.BEFORE, null, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexAndIndexToolTables(indexTableFullName);
            boolean MaxLookbackEnabled = BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration());
            this.assertDisableLogging(conn, MaxLookbackEnabled ? 2 : 0, IndexTool.IndexVerifyType.BOTH, IndexTool.IndexDisableLoggingType.AFTER, IndexVerificationOutputRepository.PHASE_BEFORE_VALUE, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexAndIndexToolTables(indexTableFullName);
            this.assertDisableLogging(conn, 0, IndexTool.IndexVerifyType.BOTH, IndexTool.IndexDisableLoggingType.BEFORE, IndexVerificationOutputRepository.PHASE_AFTER_VALUE, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexAndIndexToolTables(indexTableFullName);
            this.assertDisableLogging(conn, 0, IndexTool.IndexVerifyType.BOTH, IndexTool.IndexDisableLoggingType.BOTH, IndexVerificationOutputRepository.PHASE_BEFORE_VALUE, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableOutputLoggingForMaxLookback() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl());){
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) ";
            conn.createStatement().execute(stmString1);
            conn.commit();
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexToolIT.upsertRow(stmt1, 2);
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s (LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz') ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            conn.commit();
            ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
            injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
            injectEdge.incrementValue(1L);
            injectEdge.incrementValue(3600000L);
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration().set("phoenix.index.mr.log.beyond.max.lookback.errors", "true");
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            Counters counters = it.getJob().getCounters();
            System.out.println(counters.toString());
            Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            injectEdge.incrementValue(1L);
            IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(Bytes.toBytes((String)indexTableFullName), conn);
            List outputRows = outputRepository.getAllOutputRows();
            Assert.assertEquals((long)2L, (long)outputRows.size());
        }
        finally {
            EnvironmentEdgeManager.reset();
            this.truncateIndexToolTables();
        }
    }

    @Test
    public void testOverrideIndexRebuildPageSizeFromIndexTool() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            int NROWS = 16;
            for (int i = 0; i < 16; ++i) {
                IndexToolIT.upsertRow(stmt1, i);
            }
            conn.commit();
            String stmtString2 = String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            Configuration conf = new Configuration(IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration());
            conf.set("phoenix.index.rebuild_page_size_in_rows", Long.toString(2L));
            IndexTool indexTool = IndexToolIT.runIndexTool(conf, false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, IndexTool.IndexDisableLoggingType.NONE, new String[0]);
            Assert.assertEquals((long)16L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)16L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)16L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration())) {
                Assert.assertEquals((long)16L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
                Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            } else {
                Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
                Assert.assertEquals((long)16L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            }
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
        }
    }

    @Test
    public void testPointDeleteRebuildWithPageSize() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullDataTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR)");
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'a'");
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'b'");
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'c'");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (v) ASYNC " + this.indexDDLOptions, indexTableName, fullDataTableName));
            Configuration conf = new Configuration(IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration());
            conf.set("phoenix.index.rebuild_page_size_in_rows", Long.toString(1L));
            IndexTool indexTool = IndexToolIT.runIndexTool(conf, false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, IndexTool.IndexDisableLoggingType.NONE, new String[0]);
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
        }
    }

    @Test
    public void testIncrementalRebuildWithPageSize() throws Exception {
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl());){
            long minTs = EnvironmentEdgeManager.currentTimeMillis();
            conn.createStatement().execute("CREATE TABLE " + fullDataTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR)");
            conn.createStatement().execute("UPSERT INTO " + fullDataTableName + " VALUES('a','aa')");
            conn.createStatement().execute("UPSERT INTO " + fullDataTableName + " VALUES('b','bb')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'a'");
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'b'");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + fullDataTableName + " VALUES('a','aaa')");
            conn.createStatement().execute("UPSERT INTO " + fullDataTableName + " VALUES('b','bbb')");
            conn.createStatement().execute("DELETE FROM " + fullDataTableName + " WHERE k = 'c'");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (v) ASYNC " + this.indexDDLOptions, indexTableName, fullDataTableName));
            Configuration conf = new Configuration(IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration());
            conf.set("phoenix.index.rebuild_page_size_in_rows", Long.toString(2L));
            IndexTool indexTool = IndexToolIT.runIndexTool(conf, false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, IndexTool.IndexDisableLoggingType.NONE, "-st", String.valueOf(minTs), "-et", String.valueOf(EnvironmentEdgeManager.currentTimeMillis()));
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
        }
    }

    @Test
    public void testUpdatablePKFilterViewIndexRebuild() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String view1Name = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String view1FullName = SchemaUtil.getTableName((String)schemaName, (String)view1Name);
        String view2Name = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String view2FullName = SchemaUtil.getTableName((String)schemaName, (String)view2Name);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String createTable = "CREATE TABLE IF NOT EXISTS " + dataTableFullName + " (\n    ORGANIZATION_ID VARCHAR NOT NULL,\n    KEY_PREFIX CHAR(3) NOT NULL,\n    CREATED_BY VARCHAR,\n    CONSTRAINT PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        KEY_PREFIX\n    )\n) VERSIONS=1, COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(createTable);
            String createView1 = "CREATE VIEW IF NOT EXISTS " + view1FullName + " (\n VIEW_COLA VARCHAR NOT NULL,\n VIEW_COLB CHAR(1) CONSTRAINT PKVIEW PRIMARY KEY (\n VIEW_COLA\n )) AS \n SELECT * FROM " + dataTableFullName + " WHERE KEY_PREFIX = 'aaa'";
            conn.createStatement().execute(createView1);
            String createView2 = "CREATE VIEW IF NOT EXISTS " + view2FullName + " (\n VIEW_COL1 VARCHAR NOT NULL,\n VIEW_COL2 CHAR(1) CONSTRAINT PKVIEW PRIMARY KEY (\n VIEW_COL1\n )) AS \n SELECT * FROM " + dataTableFullName + " WHERE KEY_PREFIX = 'ccc'";
            conn.createStatement().execute(createView2);
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'A', 'G')");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'C', 'I')");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'D', 'J')");
            conn.createStatement().execute("UPSERT INTO " + view2FullName + "(ORGANIZATION_ID, VIEW_COL1, VIEW_COL2) VALUES('ORG2', 'B', 'H')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + view1FullName + " WHERE ORGANIZATION_ID = 'ORG1' AND VIEW_COLA = 'C'");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'D', NULL)");
            conn.commit();
            String createViewIndex = "CREATE INDEX IF NOT EXISTS " + indexTableName + " ON " + view1FullName + " (VIEW_COLB) ASYNC " + this.indexDDLOptions;
            conn.createStatement().execute(createViewIndex);
            conn.commit();
            IndexToolIT.runIndexTool(false, schemaName, view1Name, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableFullName);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Pair<Integer, Integer> putsAndDeletes = this.countPutsAndDeletes("_IDX_" + dataTableFullName);
            Assert.assertEquals((long)4L, (long)((Integer)putsAndDeletes.getFirst()).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)putsAndDeletes.getSecond()).intValue());
        }
    }

    @Test
    public void testUpdatableNonPkFilterViewIndexRebuild() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String view1Name = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String view1FullName = SchemaUtil.getTableName((String)schemaName, (String)view1Name);
        String view2Name = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String view2FullName = SchemaUtil.getTableName((String)schemaName, (String)view2Name);
        String indexTableName = IndexToolForNonTxGlobalIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexToolForNonTxGlobalIndexIT.getUrl(), props);){
            String createTable = "CREATE TABLE IF NOT EXISTS " + dataTableFullName + " (\n    ORGANIZATION_ID VARCHAR NOT NULL,\n    KEY_PREFIX CHAR(3) NOT NULL,\n    CREATED_BY VARCHAR,\n    CONSTRAINT PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        KEY_PREFIX\n    )\n) VERSIONS=1, COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(createTable);
            String createView1 = "CREATE VIEW IF NOT EXISTS " + view1FullName + " (\n VIEW_COLA VARCHAR NOT NULL,\n VIEW_COLB CHAR(1) CONSTRAINT PKVIEW PRIMARY KEY (\n VIEW_COLA\n )) AS \n SELECT * FROM " + dataTableFullName + " WHERE CREATED_BY = 'foo'";
            conn.createStatement().execute(createView1);
            String createView2 = "CREATE VIEW IF NOT EXISTS " + view2FullName + " (\n VIEW_COL1 VARCHAR NOT NULL,\n VIEW_COL2 CHAR(1) CONSTRAINT PKVIEW PRIMARY KEY (\n VIEW_COL1\n )) AS \n SELECT * FROM " + dataTableFullName + " WHERE CREATED_BY = 'bar'";
            conn.createStatement().execute(createView2);
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, KEY_PREFIX, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'aaa', 'A', 'G')");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, KEY_PREFIX, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'ccc', 'C', 'I')");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, KEY_PREFIX, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'ddd', 'D', 'J')");
            conn.createStatement().execute("UPSERT INTO " + view2FullName + "(ORGANIZATION_ID, KEY_PREFIX, VIEW_COL1, VIEW_COL2) VALUES('ORG2', 'bbb', 'B', 'H')");
            conn.commit();
            conn.createStatement().execute("DELETE FROM " + view1FullName + " WHERE ORGANIZATION_ID = 'ORG1' AND VIEW_COLA = 'C'");
            conn.createStatement().execute("UPSERT INTO " + view1FullName + "(ORGANIZATION_ID, KEY_PREFIX, VIEW_COLA, VIEW_COLB) VALUES('ORG1', 'ddd', 'D', NULL)");
            conn.commit();
            String createViewIndex = "CREATE INDEX IF NOT EXISTS " + indexTableName + " ON " + view1FullName + " (VIEW_COLB) ASYNC " + this.indexDDLOptions;
            conn.createStatement().execute(createViewIndex);
            conn.commit();
            IndexToolIT.runIndexTool(false, schemaName, view1Name, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableFullName);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Pair<Integer, Integer> putsAndDeletes = this.countPutsAndDeletes("_IDX_" + dataTableFullName);
            Assert.assertEquals((long)4L, (long)((Integer)putsAndDeletes.getFirst()).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)putsAndDeletes.getSecond()).intValue());
        }
    }

    private Pair<Integer, Integer> countPutsAndDeletes(String tableName) throws Exception {
        int numPuts = 0;
        int numDeletes = 0;
        try (Connection hcon = ConnectionFactory.createConnection((Configuration)config);){
            Table htable = hcon.getTable(TableName.valueOf((String)tableName));
            Scan scan = new Scan();
            scan.setRaw(true);
            ResultScanner scanner = htable.getScanner(scan);
            Result result = scanner.next();
            while (result != null) {
                for (Cell cell : result.rawCells()) {
                    if (cell.getType().equals((Object)Cell.Type.Put)) {
                        ++numPuts;
                        continue;
                    }
                    if (!cell.getType().equals((Object)Cell.Type.DeleteFamily)) continue;
                    ++numDeletes;
                }
                result = scanner.next();
            }
        }
        return new Pair((Object)numPuts, (Object)numDeletes);
    }

    public void deleteAllRows(java.sql.Connection conn, TableName tableName) throws SQLException, IOException, InterruptedException {
        Scan scan = new Scan();
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        Connection hbaseConn = admin.getConnection();
        Table table = hbaseConn.getTable(tableName);
        boolean deletedRows = false;
        try (ResultScanner scanner = table.getScanner(scan);){
            for (Result r : scanner) {
                Delete del = new Delete(r.getRow());
                table.delete(del);
                deletedRows = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deletedRows) {
            IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().flush(tableName);
            TestUtil.majorCompact(IndexToolForNonTxGlobalIndexIT.getUtility(), tableName);
        }
    }

    private void truncateIndexAndIndexToolTables(String indexTableFullName) throws IOException {
        this.truncateIndexToolTables();
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().disableTable(TableName.valueOf((String)indexTableFullName));
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().truncateTable(TableName.valueOf((String)indexTableFullName), true);
    }

    private void truncateIndexToolTables() throws IOException {
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().disableTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().truncateTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL"), true);
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().disableTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"));
        IndexToolForNonTxGlobalIndexIT.getUtility().getAdmin().truncateTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"), true);
    }

    private void assertDisableLogging(java.sql.Connection conn, int expectedRows, IndexTool.IndexVerifyType verifyType, IndexTool.IndexDisableLoggingType disableLoggingType, byte[] expectedPhase, String schemaName, String dataTableName, String indexTableName, String indexTableFullName, int expectedStatus) throws Exception {
        IndexTool tool = IndexToolIT.runIndexTool(IndexToolForNonTxGlobalIndexIT.getUtility().getConfiguration(), false, schemaName, dataTableName, indexTableName, null, expectedStatus, verifyType, disableLoggingType, new String[0]);
        Assert.assertNotNull((Object)tool);
        byte[] indexTableFullNameBytes = Bytes.toBytes((String)indexTableFullName);
        IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(indexTableFullNameBytes, conn);
        List rows = outputRepository.getAllOutputRows();
        try {
            Assert.assertEquals((long)expectedRows, (long)rows.size());
        }
        catch (AssertionError e) {
            TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            throw e;
        }
        if (expectedRows > 0) {
            Assert.assertArrayEquals((byte[])expectedPhase, (byte[])((IndexVerificationOutputRow)rows.get(0)).getPhaseValue());
        }
    }

    private void deleteOneRowFromResultTable(java.sql.Connection conn, Long scn, String indexTable) throws SQLException, IOException {
        Table hIndexToolTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
        Scan s = new Scan();
        s.setRowPrefixFilter(Bytes.toBytes((String)String.format("%s%s%s", scn, "|", indexTable)));
        ResultScanner rs = hIndexToolTable.getScanner(s);
        hIndexToolTable.delete(new Delete(rs.next().getRow()));
    }

    private List<String> verifyRunStatusFromResultTable(java.sql.Connection conn, Long scn, String indexTable, int totalRows, List<String> expectedStatus) throws SQLException, IOException {
        Table hIndexToolTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
        Assert.assertEquals((long)totalRows, (long)TestUtil.getRowCount(hIndexToolTable, false));
        ArrayList<String> output = new ArrayList<String>();
        Scan s = new Scan();
        s.setRowPrefixFilter(Bytes.toBytes((String)String.format("%s%s%s", scn, "|", indexTable)));
        ResultScanner rs = hIndexToolTable.getScanner(s);
        int count = 0;
        for (Result r : rs) {
            Assert.assertNotNull((Object)r);
            List cells = r.getColumnCells(IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, IndexVerificationResultRepository.INDEX_TOOL_RUN_STATUS_BYTES);
            Assert.assertEquals((long)cells.size(), (long)1L);
            Assert.assertTrue((boolean)Bytes.toString((byte[])CellUtil.cloneRow((Cell)((Cell)cells.get(0)))).startsWith(String.valueOf(scn)));
            output.add(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells.get(0)))));
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        for (int i = 0; i < count; ++i) {
            Assert.assertEquals((Object)expectedStatus.get(i), output.get(i));
        }
        return output;
    }

    public static class FastFailRegionObserver
    implements RegionObserver,
    RegionCoprocessor {
        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
            throw new DoNotRetryIOException("I'm just a coproc that's designed to fail fast");
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

