/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.end2end.IndexScrutinyToolBaseIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapperForTest;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTableOutput;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class IndexScrutinyToolIT
extends IndexScrutinyToolBaseIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexScrutinyToolIT.class);
    public static final String MISSING_ROWS_QUERY_TEMPLATE = "SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"NAME\" , \"EMPLOY_DATE\" , \"ZIP\" , \":ID\" , \"0:NAME\" , \"0:EMPLOY_DATE\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"NAME\" VARCHAR,\"EMPLOY_DATE\" TIMESTAMP,\"ZIP\" INTEGER,\":ID\" INTEGER,\"0:NAME\" VARCHAR,\"0:EMPLOY_DATE\" DECIMAL,\"0:ZIP\" INTEGER) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\", \"HAS_TARGET_ROW\") IN (('[TableName]','[IndexName]',[ScrutinyTs],[HasTargetRow]))";
    public static final String BEYOND_MAX_LOOKBACK_QUERY_TEMPLATE = "SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"NAME\" , \"EMPLOY_DATE\" , \"ZIP\" , \":ID\" , \"0:NAME\" , \"0:EMPLOY_DATE\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"NAME\" VARCHAR,\"EMPLOY_DATE\" TIMESTAMP,\"ZIP\" INTEGER,\":ID\" INTEGER,\"0:NAME\" VARCHAR,\"0:EMPLOY_DATE\" DECIMAL,\"0:ZIP\" INTEGER) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\", \"HAS_TARGET_ROW\", \"BEYOND_MAX_LOOKBACK\") IN (('[TableName]','[IndexName]',[ScrutinyTs],false,true))";
    private String dataTableDdl;
    private String indexTableDdl;
    private static final String UPSERT_SQL = "UPSERT INTO %s VALUES(?,?,?,?)";
    private static final String INDEX_UPSERT_SQL = "UPSERT INTO %s (\"0:NAME\", \":ID\", \"0:ZIP\", \"0:EMPLOY_DATE\") values (?,?,?,?)";
    private static final String DELETE_SQL = "DELETE FROM %s ";
    private String schemaName;
    private String dataTableName;
    private String dataTableFullName;
    private String indexTableName;
    private String indexTableFullName;
    private Connection conn;
    private PreparedStatement dataTableUpsertStmt;
    private PreparedStatement indexTableUpsertStmt;
    private long testTime;
    private Properties props;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER, EMPLOY_DATE TIMESTAMP, EMPLOYER VARCHAR) ", "CREATE INDEX %s ON %s (NAME, EMPLOY_DATE) INCLUDE (ZIP) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2"}, {"CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER, EMPLOY_DATE TIMESTAMP, EMPLOYER VARCHAR)", "CREATE LOCAL INDEX %s ON %s (NAME, EMPLOY_DATE) INCLUDE (ZIP)"}, {"CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER, EMPLOY_DATE TIMESTAMP, EMPLOYER VARCHAR) SALT_BUCKETS=2", "CREATE INDEX %s ON %s (NAME, EMPLOY_DATE) INCLUDE (ZIP)"}, {"CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER, EMPLOY_DATE TIMESTAMP, EMPLOYER VARCHAR) SALT_BUCKETS=2", "CREATE LOCAL INDEX %s ON %s (NAME, EMPLOY_DATE) INCLUDE (ZIP)"});
    }

    public IndexScrutinyToolIT(String dataTableDdl, String indexTableDdl) throws Exception {
        this.dataTableDdl = dataTableDdl;
        this.indexTableDdl = indexTableDdl;
        if (this.isOnlyIndexSingleCell()) {
            indexRegionObserverEnabled = Boolean.TRUE.toString();
            IndexScrutinyToolIT.doSetup();
        } else {
            indexRegionObserverEnabled = Boolean.FALSE.toString();
            IndexScrutinyToolIT.doSetup();
        }
    }

    @Before
    public void setup() throws SQLException {
        this.generateUniqueTableNames();
        IndexScrutinyToolIT.createTestTable(IndexScrutinyToolIT.getUrl(), String.format(this.dataTableDdl, this.dataTableFullName));
        IndexScrutinyToolIT.createTestTable(IndexScrutinyToolIT.getUrl(), String.format(this.indexTableDdl, this.indexTableName, this.dataTableFullName));
        this.props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(IndexScrutinyToolIT.getUrl(), this.props);
        String dataTableUpsert = String.format(UPSERT_SQL, this.dataTableFullName);
        this.dataTableUpsertStmt = this.conn.prepareStatement(dataTableUpsert);
        String indexTableUpsert = String.format(INDEX_UPSERT_SQL, this.indexTableFullName);
        this.indexTableUpsertStmt = this.conn.prepareStatement(indexTableUpsert);
        this.conn.setAutoCommit(false);
        this.testTime = EnvironmentEdgeManager.currentTimeMillis() - 1000L;
    }

    @After
    public void teardown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private boolean isOnlyIndexSingleCell() {
        return this.indexTableDdl.contains(PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.toString()) && !this.dataTableDdl.contains(PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.toString());
    }

    @Test
    public void testValidIndex() throws Exception {
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 94010);
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95123);
        this.conn.commit();
        int numDataRows = this.countRows(this.conn, this.dataTableFullName);
        int numIndexRows = this.countRows(this.conn, this.indexTableFullName);
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        Assert.assertEquals((long)numDataRows, (long)this.countRows(this.conn, this.dataTableFullName));
        Assert.assertEquals((long)numIndexRows, (long)this.countRows(this.conn, this.indexTableFullName));
    }

    @Test
    @Ignore(value="PHOENIX-4378 Unable to set KEEP_DELETED_CELLS to true on RS scanner")
    public void testScrutinyWhileTakingWrites() throws Exception {
        for (int id = 0; id < 1000; ++id) {
            int index = 1;
            this.dataTableUpsertStmt.setInt(index++, id);
            this.dataTableUpsertStmt.setString(index++, "name-" + id);
            this.dataTableUpsertStmt.setInt(index++, id);
            this.dataTableUpsertStmt.setTimestamp(index++, new Timestamp(this.testTime));
            this.dataTableUpsertStmt.executeUpdate();
        }
        this.conn.commit();
        long scrutinyTS = EnvironmentEdgeManager.currentTimeMillis();
        final Random random = new Random(0L);
        Runnable backgroundUpserts = new Runnable(){

            @Override
            public void run() {
                int idToUpsert = random.nextInt(1000);
                try (Connection conn = DriverManager.getConnection(IndexScrutinyToolIT.getUrl(), IndexScrutinyToolIT.this.props);){
                    PreparedStatement dataPS = conn.prepareStatement(String.format(IndexScrutinyToolIT.UPSERT_SQL, IndexScrutinyToolIT.this.dataTableFullName));
                    IndexScrutinyToolIT.this.upsertRow(dataPS, idToUpsert, "modified-" + idToUpsert, idToUpsert + 1000);
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable backgroundDeletes = new Runnable(){

            @Override
            public void run() {
                int idToDelete = random.nextInt(1000);
                try (Connection conn = DriverManager.getConnection(IndexScrutinyToolIT.getUrl(), IndexScrutinyToolIT.this.props);){
                    String deleteSql = String.format(IndexScrutinyToolIT.DELETE_SQL, IndexScrutinyToolIT.this.indexTableFullName) + "WHERE \":ID\"=" + idToDelete;
                    conn.createStatement().executeUpdate(deleteSql);
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(2);
        scheduledThreadPool.scheduleWithFixedDelay(backgroundUpserts, 200L, 200L, TimeUnit.MILLISECONDS);
        scheduledThreadPool.scheduleWithFixedDelay(backgroundDeletes, 200L, 200L, TimeUnit.MILLISECONDS);
        List<Job> completedJobs = this.runScrutinyCurrentSCN(this.schemaName, this.dataTableName, this.indexTableName, scrutinyTS);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)1000L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        scheduledThreadPool.shutdown();
        scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testEqualRowCountIndexIncorrect() throws Exception {
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 94010);
        this.conn.commit();
        this.disableIndex();
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95123);
        this.conn.commit();
        this.upsertIndexRow("badName", 2, 9999);
        this.conn.commit();
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
    }

    @Test
    public void testCoveredValueIncorrect() throws Exception {
        if (this.isOnlyIndexSingleCell()) {
            return;
        }
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 94010);
        this.conn.commit();
        this.disableIndex();
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95123);
        this.conn.commit();
        this.upsertIndexRow("name-2", 2, 9999);
        this.conn.commit();
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.BAD_COVERED_COL_VAL_COUNT));
    }

    @Test
    public void testBatching() throws Exception {
        int numTestRows = 1001;
        for (int i = 0; i < numTestRows; ++i) {
            this.upsertRow(this.dataTableUpsertStmt, i, "name-" + i, i + 1000);
        }
        this.conn.commit();
        this.disableIndex();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            int idToDelete = random.nextInt(numTestRows);
            this.deleteRow(this.indexTableFullName, "WHERE \":ID\"=" + idToDelete);
        }
        this.conn.commit();
        int numRows = this.countRows(this.conn, this.indexTableFullName);
        int numDeleted = numTestRows - numRows;
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName, 10L);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)(numTestRows - numDeleted), (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)numDeleted, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        Assert.assertEquals((long)(numTestRows / 10 + numTestRows % 10), (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.BATCHES_PROCESSED_COUNT));
    }

    @Test
    public void testMoreDataRows() throws Exception {
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 95123);
        this.conn.commit();
        this.disableIndex();
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95124);
        this.upsertRow(this.dataTableUpsertStmt, 3, "name-3", 95125);
        this.conn.commit();
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
    }

    @Test
    public void testMoreIndexRows() throws Exception {
        if (this.isOnlyIndexSingleCell()) {
            return;
        }
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 95123);
        this.conn.commit();
        this.disableIndex();
        this.upsertIndexRow("name-2", 2, 95124);
        this.upsertIndexRow("name-3", 3, 95125);
        this.conn.commit();
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName, 10L, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
        Job job = completedJobs.get(0);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counters counters = job.getCounters();
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
    }

    @Test
    public void testBothDataAndIndexAsSource() throws Exception {
        if (this.isOnlyIndexSingleCell()) {
            return;
        }
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 94010);
        this.conn.commit();
        this.disableIndex();
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95123);
        this.conn.commit();
        this.upsertIndexRow("badName", 2, 9999);
        this.conn.commit();
        List<Job> completedJobs = this.runScrutiny(this.schemaName, this.dataTableName, this.indexTableName, 10L, IndexScrutinyTool.SourceTable.BOTH);
        Assert.assertEquals((long)2L, (long)completedJobs.size());
        for (Job job : completedJobs) {
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutputInvalidRowsToFile() throws Exception {
        if (this.isOnlyIndexSingleCell()) {
            return;
        }
        this.insertOneValid_OneBadVal_OneMissingTarget();
        String[] argValues = this.getArgValues(this.schemaName, this.dataTableName, this.indexTableName, 10L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE, true, IndexScrutinyTool.OutputFormat.FILE, null);
        this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        Path outputPath = CsvBulkImportUtil.getOutputPath((Path)new Path(this.outputDir), (String)this.dataTableFullName);
        DistributedFileSystem fs = IndexScrutinyToolIT.getUtility().getDFSCluster().getFileSystem();
        ArrayList paths = Lists.newArrayList();
        Path firstPart = null;
        for (FileStatus outputFile : fs.listStatus(outputPath)) {
            if (!outputFile.getPath().getName().startsWith("part")) continue;
            if (firstPart == null) {
                firstPart = outputFile.getPath();
                continue;
            }
            paths.add(outputFile.getPath());
        }
        if (this.dataTableDdl.contains("SALT_BUCKETS")) {
            fs.concat(firstPart, paths.toArray(new Path[0]));
        }
        Path outputFilePath = firstPart;
        Assert.assertTrue((boolean)fs.exists(outputFilePath));
        FSDataInputStream fsDataInputStream = fs.open(outputFilePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream));
        TreeSet lines = Sets.newTreeSet();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((InputStream)fsDataInputStream);
        }
        Iterator lineIterator = lines.iterator();
        Assert.assertEquals((Object)("[2, name-2, " + new Timestamp(this.testTime).toString() + ", 95123]\t[2, name-2, " + new Timestamp(this.testTime).toString() + ", 9999]"), lineIterator.next());
        Assert.assertEquals((Object)("[3, name-3, " + new Timestamp(this.testTime).toString() + ", 95123]\tTarget row not found"), lineIterator.next());
    }

    @Test
    public void testOutputInvalidRowsToTable() throws Exception {
        if (this.isOnlyIndexSingleCell()) {
            return;
        }
        this.insertOneValid_OneBadVal_OneMissingTarget();
        String[] argValues = this.getArgValues(this.schemaName, this.dataTableName, this.indexTableName, 10L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE, true, IndexScrutinyTool.OutputFormat.TABLE, null);
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        long scrutinyTimeMillis = PhoenixConfigurationUtil.getScrutinyExecuteTimestamp((Configuration)completedJobs.get(0).getConfiguration());
        String invalidRowsQuery = IndexScrutinyTableOutput.getSqlQueryAllInvalidRows((Connection)this.conn, (SourceTargetColumnNames)this.getColNames(), (long)scrutinyTimeMillis);
        String missingRowsQuery = this.getMissingRowsQuery(scrutinyTimeMillis);
        String invalidColsQuery = this.getInvalidColsQuery(scrutinyTimeMillis);
        String beyondMaxLookbackQuery = this.getBeyondMaxLookbackQuery(scrutinyTimeMillis);
        ResultSet rs = this.conn.createStatement().executeQuery(invalidRowsQuery + " ORDER BY ID asc");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)this.dataTableFullName, (Object)rs.getString("SOURCE_TABLE"));
        Assert.assertEquals((Object)this.indexTableFullName, (Object)rs.getString("TARGET_TABLE"));
        Assert.assertTrue((boolean)rs.getBoolean("HAS_TARGET_ROW"));
        Assert.assertEquals((long)2L, (long)rs.getInt("ID"));
        Assert.assertEquals((long)2L, (long)rs.getInt(":ID"));
        Assert.assertEquals((long)95123L, (long)rs.getInt("ZIP"));
        Assert.assertEquals((long)9999L, (long)rs.getInt("0:ZIP"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)this.dataTableFullName, (Object)rs.getString("SOURCE_TABLE"));
        Assert.assertEquals((Object)this.indexTableFullName, (Object)rs.getString("TARGET_TABLE"));
        Assert.assertFalse((boolean)rs.getBoolean("HAS_TARGET_ROW"));
        Assert.assertFalse((boolean)rs.getBoolean("BEYOND_MAX_LOOKBACK"));
        Assert.assertEquals((long)3L, (long)rs.getInt("ID"));
        Assert.assertEquals(null, (Object)rs.getObject(":ID"));
        Assert.assertFalse((boolean)rs.next());
        this.assertMetadataTableValues(argValues, scrutinyTimeMillis, invalidRowsQuery, missingRowsQuery, invalidColsQuery, beyondMaxLookbackQuery);
    }

    private String getMissingRowsQuery(long scrutinyTimeMillis) {
        return MISSING_ROWS_QUERY_TEMPLATE.replace("[TableName]", this.dataTableFullName).replace("[IndexName]", this.indexTableFullName).replace("[ScrutinyTs]", Long.toString(scrutinyTimeMillis)).replace("[HasTargetRow]", "false");
    }

    private String getInvalidColsQuery(long scrutinyTimeMillis) {
        return MISSING_ROWS_QUERY_TEMPLATE.replace("[TableName]", this.dataTableFullName).replace("[IndexName]", this.indexTableFullName).replace("[ScrutinyTs]", Long.toString(scrutinyTimeMillis)).replace("[HasTargetRow]", "true");
    }

    private String getBeyondMaxLookbackQuery(long scrutinyTimeMillis) {
        return BEYOND_MAX_LOOKBACK_QUERY_TEMPLATE.replace("[TableName]", this.dataTableFullName).replace("[IndexName]", this.indexTableFullName).replace("[ScrutinyTs]", Long.toString(scrutinyTimeMillis));
    }

    @Test
    public void testMaxOutputRows() throws Exception {
        this.insertOneValid_OneBadVal_OneMissingTarget();
        String[] argValues = this.getArgValues(this.schemaName, this.dataTableName, this.indexTableName, 10L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE, true, IndexScrutinyTool.OutputFormat.TABLE, new Long(1L));
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        long scrutinyTimeMillis = PhoenixConfigurationUtil.getScrutinyExecuteTimestamp((Configuration)completedJobs.get(0).getConfiguration());
        String invalidRowsQuery = IndexScrutinyTableOutput.getSqlQueryAllInvalidRows((Connection)this.conn, (SourceTargetColumnNames)this.getColNames(), (long)scrutinyTimeMillis);
        ResultSet rs = this.conn.createStatement().executeQuery(invalidRowsQuery);
        Assert.assertTrue((boolean)rs.next());
        if (this.dataTableDdl.contains("SALT_BUCKETS")) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        } else {
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private SourceTargetColumnNames getColNames() throws SQLException {
        PTable pdataTable = this.conn.unwrap(PhoenixConnection.class).getTable(this.dataTableFullName);
        PTable pindexTable = this.conn.unwrap(PhoenixConnection.class).getTable(this.indexTableFullName);
        SourceTargetColumnNames.DataSourceColNames columnNames = new SourceTargetColumnNames.DataSourceColNames(pdataTable, pindexTable);
        return columnNames;
    }

    private void insertOneValid_OneBadVal_OneMissingTarget() throws SQLException {
        this.upsertRow(this.dataTableUpsertStmt, 1, "name-1", 94010);
        this.conn.commit();
        this.disableIndex();
        this.upsertRow(this.dataTableUpsertStmt, 2, "name-2", 95123);
        this.upsertRow(this.dataTableUpsertStmt, 3, "name-3", 95123);
        this.conn.commit();
        this.upsertIndexRow("name-2", 2, 9999);
        this.conn.commit();
    }

    private void assertMetadataTableValues(String[] argValues, long scrutinyTimeMillis, String invalidRowsQuery, String missingRowsQuery, String invalidColValuesQuery, String beyondMaxLookbackQuery) throws SQLException {
        ResultSet metadataRs = IndexScrutinyTableOutput.queryAllMetadata((Connection)this.conn, (String)this.dataTableFullName, (String)this.indexTableFullName, (long)scrutinyTimeMillis);
        Assert.assertTrue((boolean)metadataRs.next());
        List<Serializable> expected = Arrays.asList(this.dataTableFullName, this.indexTableFullName, scrutinyTimeMillis, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.name(), Arrays.toString(argValues), 3L, 0L, 1L, 2L, 1L, 1L, "[\"ID\" INTEGER, \"NAME\" VARCHAR, \"EMPLOY_DATE\" TIMESTAMP, \"ZIP\" INTEGER]", "[\":ID\" INTEGER, \"0:NAME\" VARCHAR, \"0:EMPLOY_DATE\" DECIMAL, \"0:ZIP\" INTEGER]", invalidRowsQuery, missingRowsQuery, invalidColValuesQuery, beyondMaxLookbackQuery, 0L);
        if (this.dataTableDdl.contains("SALT_BUCKETS")) {
            expected = Arrays.asList(this.dataTableFullName, this.indexTableFullName, scrutinyTimeMillis, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.name(), Arrays.toString(argValues), 3L, 0L, 1L, 2L, 1L, 2L, "[\"ID\" INTEGER, \"NAME\" VARCHAR, \"EMPLOY_DATE\" TIMESTAMP, \"ZIP\" INTEGER]", "[\":ID\" INTEGER, \"0:NAME\" VARCHAR, \"0:EMPLOY_DATE\" DECIMAL, \"0:ZIP\" INTEGER]", invalidRowsQuery, missingRowsQuery, invalidColValuesQuery, beyondMaxLookbackQuery, 0L);
        }
        this.assertRsValues(metadataRs, expected);
        String missingTargetQuery = metadataRs.getString("INVALID_ROWS_QUERY_MISSING_TARGET");
        ResultSet rs = this.conn.createStatement().executeQuery(missingTargetQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt("ID"));
        Assert.assertFalse((boolean)rs.next());
        String badCoveredColQuery = metadataRs.getString("INVALID_ROWS_QUERY_BAD_COVERED_COL_VAL");
        rs = this.conn.createStatement().executeQuery(badCoveredColQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt("ID"));
        Assert.assertFalse((boolean)rs.next());
        String lookbackQuery = metadataRs.getString("INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK");
        rs = this.conn.createStatement().executeQuery(lookbackQuery);
        Assert.assertFalse((boolean)rs.next());
    }

    private void assertRsValues(ResultSet rs, List<? extends Object> expected) throws SQLException {
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((String)("Failed comparing 1-based column " + (i + 1) + " out of " + expected.size()), (Object)expected.get(i), (Object)rs.getObject(i + 1));
        }
    }

    private void generateUniqueTableNames() {
        this.schemaName = IndexScrutinyToolIT.generateUniqueName();
        this.dataTableName = "TBL" + IndexScrutinyToolIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.indexTableName = "IDX_" + IndexScrutinyToolIT.generateUniqueName();
        this.indexTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexTableName);
    }

    private void upsertIndexRow(String name, int id, int zip) throws SQLException {
        this.indexTableUpsertStmt.setString(1, name);
        this.indexTableUpsertStmt.setInt(2, id);
        this.indexTableUpsertStmt.setInt(3, zip);
        this.indexTableUpsertStmt.setTimestamp(4, new Timestamp(this.testTime));
        this.indexTableUpsertStmt.executeUpdate();
    }

    private void disableIndex() throws SQLException {
        this.conn.createStatement().execute(String.format("ALTER INDEX %s ON %S disable", this.indexTableName, this.dataTableFullName));
        this.conn.commit();
    }

    private String[] getArgValues(String schemaName, String dataTable, String indxTable, Long batchSize, IndexScrutinyTool.SourceTable sourceTable, boolean outputInvalidRows, IndexScrutinyTool.OutputFormat outputFormat, Long maxOutputRows) {
        return this.getArgValues(schemaName, dataTable, indxTable, batchSize, sourceTable, outputInvalidRows, outputFormat, maxOutputRows, null, Long.MAX_VALUE);
    }

    private List<Job> runScrutinyCurrentSCN(String schemaName, String dataTableName, String indexTableName, Long scrutinyTS) throws Exception {
        return this.runScrutiny(IndexScrutinyMapperForTest.class, this.getArgValues(schemaName, dataTableName, indexTableName, null, IndexScrutinyTool.SourceTable.BOTH, false, null, null, null, scrutinyTS));
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName) throws Exception {
        return this.runScrutiny(schemaName, dataTableName, indexTableName, null, null);
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName, Long batchSize) throws Exception {
        return this.runScrutiny(schemaName, dataTableName, indexTableName, batchSize, null);
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName, Long batchSize, IndexScrutinyTool.SourceTable sourceTable) throws Exception {
        String[] cmdArgs = this.getArgValues(schemaName, dataTableName, indexTableName, batchSize, sourceTable, false, null, null, null, Long.MAX_VALUE);
        return this.runScrutiny(IndexScrutinyMapperForTest.class, cmdArgs);
    }

    private void upsertRow(PreparedStatement stmt, int id, String name, int zip) throws SQLException {
        int index = 1;
        stmt.setInt(index++, id);
        stmt.setString(index++, name);
        stmt.setInt(index++, zip);
        stmt.setTimestamp(index++, new Timestamp(this.testTime));
        stmt.executeUpdate();
    }

    private int deleteRow(String fullTableName, String whereCondition) throws SQLException {
        String deleteSql = String.format(DELETE_SQL, this.indexTableFullName) + whereCondition;
        PreparedStatement deleteStmt = this.conn.prepareStatement(deleteSql);
        return deleteStmt.executeUpdate();
    }
}

