/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.end2end.IndexScrutinyToolBaseIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapperForTest;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexScrutinyToolForTenantIT
extends IndexScrutinyToolBaseIT {
    private Connection connGlobal = null;
    private Connection connTenant = null;
    private String tenantId;
    private String tenantViewName;
    private String indexNameTenant;
    private String multiTenantTable;
    private String viewIndexTableName;
    private final String createViewStr = "CREATE VIEW %s AS SELECT * FROM %s";
    private final String upsertQueryStr = "UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')";
    private final String createIndexStr = "CREATE INDEX %s ON %s (NAME) ";

    @Before
    public void setup() throws SQLException {
        this.tenantId = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.tenantViewName = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.indexNameTenant = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.multiTenantTable = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.viewIndexTableName = "_IDX_" + this.multiTenantTable;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.connGlobal = DriverManager.getConnection(IndexScrutinyToolForTenantIT.getUrl(), props);
        props.setProperty("TenantId", this.tenantId);
        this.connTenant = DriverManager.getConnection(IndexScrutinyToolForTenantIT.getUrl(), props);
        String createTblStr = "CREATE TABLE %s (COL1 VARCHAR(15) NOT NULL,ID INTEGER NOT NULL, NAME VARCHAR, CONSTRAINT PK_1 PRIMARY KEY (COL1, ID)) MULTI_TENANT=true";
        IndexScrutinyToolForTenantIT.createTestTable(IndexScrutinyToolForTenantIT.getUrl(), String.format(createTblStr, this.multiTenantTable));
        this.connTenant.createStatement().execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", this.tenantViewName, this.multiTenantTable));
        String idxStmtTenant = String.format("CREATE INDEX %s ON %s (NAME) ", this.indexNameTenant, this.tenantViewName);
        this.connTenant.createStatement().execute(idxStmtTenant);
        this.connTenant.commit();
        this.connGlobal.commit();
    }

    @After
    public void teardown() throws Exception {
        boolean refCountLeaked = IndexScrutinyToolForTenantIT.isAnyStoreRefCountLeaked();
        if (this.connGlobal != null) {
            this.connGlobal.close();
        }
        if (this.connTenant != null) {
            this.connTenant.close();
        }
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testTenantViewAndIndexEqual() throws Exception {
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 1, "x"));
        this.connTenant.commit();
        String[] argValues = this.getArgValues("", this.tenantViewName, this.indexNameTenant, 10L, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE, false, null, null, this.tenantId, EnvironmentEdgeManager.currentTimeMillis());
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        Assert.assertEquals((long)1L, (long)completedJobs.size());
        for (Job job : completedJobs) {
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }

    @Test
    public void testGlobalViewOnMultiTenantTable() throws Exception {
        String globalViewName = IndexScrutinyToolForTenantIT.generateUniqueName();
        String indexNameGlobal = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.connGlobal.createStatement().execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", globalViewName, this.multiTenantTable));
        String idxStmtGlobal = String.format("CREATE INDEX %s ON %s (NAME) ", indexNameGlobal, globalViewName);
        this.connGlobal.createStatement().execute(idxStmtGlobal);
        this.connGlobal.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", globalViewName, "global", 5, "x"));
        this.connGlobal.commit();
        String[] argValues = this.getArgValues("", globalViewName, indexNameGlobal, 10L, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE, false, null, null, null, EnvironmentEdgeManager.currentTimeMillis());
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        Assert.assertEquals((long)1L, (long)completedJobs.size());
        for (Job job : completedJobs) {
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }

    @Test
    public void testColumnsForSelectQueryOnMultiTenantTable() throws Exception {
        String indexNameGlobal = IndexScrutinyToolForTenantIT.generateUniqueName();
        this.connGlobal.createStatement().execute(String.format("CREATE INDEX %s ON %s (NAME) ", indexNameGlobal, this.multiTenantTable));
        PhoenixConnection pconn = this.connGlobal.unwrap(PhoenixConnection.class);
        PTable pDataTable = pconn.getTable(new PTableKey(null, this.multiTenantTable));
        PTable pIndexTable = pconn.getTable(new PTableKey(null, indexNameGlobal));
        SourceTargetColumnNames.IndexSourceColNames columnNames = new SourceTargetColumnNames.IndexSourceColNames(pDataTable, pIndexTable);
        String targetPksCsv = Joiner.on((String)",").join((Iterable)SchemaUtil.getEscapedFullColumnNames((List)columnNames.getTargetPkColNames()));
        String selectQuery = QueryUtil.constructSelectStatement((String)indexNameGlobal, (List)columnNames.getCastedTargetColNames(), (String)targetPksCsv, (HintNode.Hint)HintNode.Hint.NO_INDEX, (boolean)false);
        Assert.assertEquals((Object)selectQuery, (Object)("SELECT /*+ NO_INDEX */ CAST(\"COL1\" AS VARCHAR(15)) , CAST(\"ID\" AS INTEGER) , CAST(\"0\".\"NAME\" AS VARCHAR) FROM " + indexNameGlobal + " WHERE (\"COL1\",\"ID\")"));
    }

    @Test
    public void testOneValidOneInvalidUsingBothAsSource() throws Exception {
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 1, "x"));
        this.connTenant.commit();
        this.connTenant.createStatement().execute(String.format("ALTER INDEX %s ON %S disable", this.indexNameTenant, this.tenantViewName));
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 2, "x2"));
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (\":ID\", \"0:NAME\") values (%d, '%s')", this.indexNameTenant, 5555, "wrongName"));
        this.connTenant.commit();
        String[] argValues = this.getArgValues("", this.tenantViewName, this.indexNameTenant, 10L, IndexScrutinyTool.SourceTable.BOTH, false, null, null, this.tenantId, EnvironmentEdgeManager.currentTimeMillis());
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        Assert.assertEquals((long)2L, (long)completedJobs.size());
        for (Job job : completedJobs) {
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }

    @Test
    public void testWithEmptyIndexTableOutputToFile() throws Exception {
        this.testWithOutput(IndexScrutinyTool.OutputFormat.FILE);
    }

    @Test
    public void testWithEmptyIndexTableOutputToTable() throws Exception {
        this.testWithOutput(IndexScrutinyTool.OutputFormat.TABLE);
        Assert.assertEquals((long)3L, (long)this.countRows(this.connGlobal, "PHOENIX_INDEX_SCRUTINY"));
    }

    private void testWithOutput(IndexScrutinyTool.OutputFormat outputFormat) throws Exception {
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 1, "x"));
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 2, "x2"));
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (COL1, ID, NAME) VALUES('%s' , %d, '%s')", this.tenantViewName, this.tenantId, 3, "x3"));
        this.connTenant.createStatement().execute(String.format("UPSERT INTO %s (\":ID\", \"0:NAME\") values (%d, '%s')", this.indexNameTenant, 5555, "wrongName"));
        this.connTenant.commit();
        ConnectionQueryServices queryServices = this.connGlobal.unwrap(PhoenixConnection.class).getQueryServices();
        Admin admin = queryServices.getAdmin();
        TableName tableName = TableName.valueOf((String)this.viewIndexTableName);
        admin.disableTable(tableName);
        admin.truncateTable(tableName, false);
        String[] argValues = this.getArgValues("", this.tenantViewName, this.indexNameTenant, 10L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE, true, outputFormat, null, this.tenantId, EnvironmentEdgeManager.currentTimeMillis());
        List<Job> completedJobs = this.runScrutiny(IndexScrutinyMapperForTest.class, argValues);
        Assert.assertEquals((long)1L, (long)completedJobs.size());
        for (Job job : completedJobs) {
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)3L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }
}

