/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapper;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapperForTest;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;

public class IndexScrutinyToolBaseIT
extends BaseTest {
    protected String outputDir;
    protected static String indexRegionObserverEnabled;
    private static String previousIndexRegionObserverEnabled;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMap();
        serverProps.put(HConstants.MAJOR_COMPACTION_PERIOD, "0");
        HashMap clientProps = Maps.newHashMap();
        clientProps.put("phoenix.index.region.observer.enabled", indexRegionObserverEnabled);
        if (!previousIndexRegionObserverEnabled.equals(indexRegionObserverEnabled)) {
            driver = null;
        }
        IndexScrutinyToolBaseIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        previousIndexRegionObserverEnabled = indexRegionObserverEnabled;
    }

    protected List<Job> runScrutiny(Class<? extends IndexScrutinyMapper> mapperClass, String[] cmdArgs) throws Exception {
        IndexScrutinyTool scrutiny = new IndexScrutinyTool(mapperClass);
        Configuration conf = new Configuration(IndexScrutinyToolBaseIT.getUtility().getConfiguration());
        scrutiny.setConf(conf);
        int status = scrutiny.run(cmdArgs);
        Assert.assertEquals((long)0L, (long)status);
        for (Job job : scrutiny.getJobs()) {
            Assert.assertTrue((boolean)job.waitForCompletion(true));
        }
        return scrutiny.getJobs();
    }

    public String[] getArgValues(String schemaName, String dataTable, String indxTable, Long batchSize, IndexScrutinyTool.SourceTable sourceTable, boolean outputInvalidRows, IndexScrutinyTool.OutputFormat outputFormat, Long maxOutputRows, String tenantId, Long scrutinyTs) {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("-s");
            args.add(schemaName);
        }
        args.add("-dt");
        args.add(dataTable);
        args.add("-it");
        args.add(indxTable);
        if (IndexScrutinyTool.OutputFormat.FILE.equals((Object)outputFormat)) {
            args.add("-op");
            this.outputDir = "/tmp/" + UUID.randomUUID().toString();
            args.add(this.outputDir);
        }
        args.add("-t");
        args.add(String.valueOf(scrutinyTs));
        args.add("-run-foreground");
        if (batchSize != null) {
            args.add("-b");
            args.add(String.valueOf(batchSize));
        }
        args.add("-src");
        if (sourceTable == null) {
            args.add(IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.name());
        } else {
            args.add(sourceTable.name());
        }
        if (outputInvalidRows) {
            args.add("-o");
        }
        if (outputFormat != null) {
            args.add("-of");
            args.add(outputFormat.name());
        }
        if (maxOutputRows != null) {
            args.add("-om");
            args.add(maxOutputRows.toString());
        }
        if (tenantId != null) {
            args.add("-tenant");
            args.add(tenantId);
        }
        return args.toArray(new String[0]);
    }

    public static List<Job> runScrutinyTool(String schemaName, String dataTableName, String indexTableName, Long batchSize, IndexScrutinyTool.SourceTable sourceTable) throws Exception {
        IndexScrutinyToolBaseIT it = new IndexScrutinyToolBaseIT();
        String[] cmdArgs = it.getArgValues(schemaName, dataTableName, indexTableName, batchSize, sourceTable, false, null, null, null, Long.MAX_VALUE);
        return it.runScrutiny(IndexScrutinyMapperForTest.class, cmdArgs);
    }

    protected long getCounterValue(Counters counters, Enum<PhoenixScrutinyJobCounters> counter) {
        return counters.findCounter(counter).getValue();
    }

    protected int countRows(Connection conn, String tableFullName) throws SQLException {
        ResultSet count = conn.createStatement().executeQuery("select count(*) from " + tableFullName);
        count.next();
        int numRows = count.getInt(1);
        return numRows;
    }

    static {
        previousIndexRegionObserverEnabled = indexRegionObserverEnabled = Boolean.FALSE.toString();
    }
}

