/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexExtendedIT
extends BaseTest {
    private final boolean localIndex;
    private final boolean useViewIndex;
    private final String tableDDLOptions;
    private final String indexDDLOptions;
    private final boolean mutable;
    private final boolean useSnapshot;

    public IndexExtendedIT(boolean mutable, boolean localIndex, boolean useViewIndex, boolean useSnapshot) {
        this.localIndex = localIndex;
        this.useViewIndex = useViewIndex;
        this.mutable = mutable;
        this.useSnapshot = useSnapshot;
        StringBuilder optionBuilder = new StringBuilder();
        StringBuilder indexOptionBuilder = new StringBuilder();
        if (!mutable) {
            optionBuilder.append(" IMMUTABLE_ROWS=true ");
        }
        if (!localIndex) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=0 ");
            indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS,COLUMN_ENCODED_BYTES=2 ");
        }
        optionBuilder.append(" SPLIT ON(1,2)");
        this.indexDDLOptions = indexOptionBuilder.toString();
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        IndexExtendedIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="mutable = {0} , localIndex = {1}, useViewIndex = {2}, useSnapshot = {3}")
    public static synchronized Collection<Boolean[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        for (boolean mutable : Booleans = new boolean[]{false, true}) {
            for (boolean localIndex : Booleans) {
                for (boolean useViewIndex : Booleans) {
                    for (boolean useSnapshot : Booleans) {
                        if (localIndex && useSnapshot) continue;
                        list.add(new Boolean[]{mutable, localIndex, useViewIndex, useSnapshot});
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutableIndexWithUpdates() throws Exception {
        if (!this.mutable) {
            return;
        }
        String schemaName = IndexExtendedIT.generateUniqueName();
        String dataTableName = IndexExtendedIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexExtendedIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexExtendedIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(String.format("CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) %s", dataTableFullName, this.tableDDLOptions));
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            int id = 1;
            IndexToolIT.upsertRow(stmt1, id++);
            IndexToolIT.upsertRow(stmt1, id++);
            conn.commit();
            stmt.execute(String.format("CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX %s ON %s (UPPER(NAME, 'en_US')) ASYNC %s", indexTableName, dataTableFullName, this.indexDDLOptions));
            stmt1.setInt(1, 1);
            stmt1.setString(2, "uname" + String.valueOf(10));
            stmt1.setInt(3, 95051);
            stmt1.executeUpdate();
            conn.commit();
            String selectSql = String.format("SELECT ID FROM %s WHERE UPPER(NAME, 'en_US') ='UNAME2'", dataTableFullName);
            ExplainPlan plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)dataTableFullName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"SERVER FILTER BY UPPER(NAME, 'en_US') = 'UNAME2'", (Object)explainPlanAttributes.getServerWhereFilter());
            ResultSet rs = stmt1.executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName);
            plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            String expectedTableName = this.localIndex ? indexTableFullName + "(" + dataTableFullName + ")" : indexTableFullName;
            Assert.assertEquals((Object)expectedTableName, (Object)explainPlanAttributes.getTableName());
            rs = stmt.executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testDeleteFromImmutable() throws Exception {
        if (this.mutable) {
            return;
        }
        if (this.localIndex) {
            return;
        }
        String schemaName = IndexExtendedIT.generateUniqueName();
        String dataTableName = IndexExtendedIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IDX_" + IndexExtendedIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexExtendedIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (\n        pk1 VARCHAR NOT NULL,\n        pk2 VARCHAR NOT NULL,\n        pk3 VARCHAR\n        CONSTRAINT PK PRIMARY KEY \n        (\n        pk1,\n        pk2,\n        pk3\n        )\n        ) " + this.tableDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableFullName + " (pk1, pk2, pk3) values ('a', '1', '1')");
            conn.createStatement().execute("upsert into " + dataTableFullName + " (pk1, pk2, pk3) values ('b', '2', '2')");
            conn.commit();
            conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexTableName + " ON " + dataTableFullName + " (pk3, pk2) ASYNC " + this.indexDDLOptions);
            conn.createStatement().execute("delete from " + dataTableFullName + " where pk1 = 'a'");
            conn.commit();
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName);
            conn.createStatement().execute("upsert into " + dataTableFullName + " (pk1, pk2, pk3) values ('a', '3', '3')");
            conn.createStatement().execute("upsert into " + dataTableFullName + " (pk1, pk2, pk3) values ('b', '4', '4')");
            conn.commit();
            String query = "SELECT pk3 from " + dataTableFullName + " ORDER BY pk3";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)indexTableFullName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"4", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDisabledIndex() throws Exception {
        if (this.localIndex || this.useSnapshot) {
            return;
        }
        String schemaName = IndexExtendedIT.generateUniqueName();
        String dataTableName = IndexExtendedIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexName = "I_" + IndexExtendedIT.generateUniqueName();
        String indexFullName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String viewName = "V_" + IndexExtendedIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexExtendedIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(String.format("CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) %s", dataTableFullName, this.tableDDLOptions));
            if (this.useViewIndex) {
                stmt.execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", viewFullName, dataTableFullName));
            }
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            int id = 1;
            IndexToolIT.upsertRow(stmt1, id++);
            IndexToolIT.upsertRow(stmt1, id++);
            conn.commit();
            String baseTableNameOfIndex = dataTableName;
            String baseTableFullNameOfIndex = dataTableFullName;
            String physicalTableNameOfIndex = indexFullName;
            if (this.useViewIndex) {
                baseTableFullNameOfIndex = viewFullName;
                baseTableNameOfIndex = viewName;
                physicalTableNameOfIndex = "_IDX_" + dataTableFullName;
            }
            Table hIndexTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)physicalTableNameOfIndex));
            stmt.execute(String.format("CREATE INDEX %s ON %s (UPPER(NAME, 'en_US')) %s", indexName, baseTableFullNameOfIndex, this.indexDDLOptions));
            long dataCnt = TestUtil.getRowCount(conn, dataTableFullName);
            long indexCnt = IndexExtendedIT.getUtility().countRows(hIndexTable);
            Assert.assertEquals((long)dataCnt, (long)indexCnt);
            stmt.execute(String.format("ALTER INDEX  %s ON %s DISABLE", indexName, baseTableFullNameOfIndex));
            IndexToolIT.upsertRow(stmt1, id++);
            conn.commit();
            dataCnt = TestUtil.getRowCount(conn, baseTableFullNameOfIndex);
            indexCnt = IndexExtendedIT.getUtility().countRows(hIndexTable);
            Assert.assertEquals((long)dataCnt, (long)(indexCnt + 1L));
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, baseTableNameOfIndex, indexName);
            dataCnt = TestUtil.getRowCount(conn, baseTableFullNameOfIndex);
            indexCnt = IndexExtendedIT.getUtility().countRows(hIndexTable);
            Assert.assertEquals((long)dataCnt, (long)indexCnt);
            TestUtil.checkIndexState(conn, indexFullName, PIndexState.ACTIVE, 0L);
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testIndexStateOnException() throws Exception {
        if (this.localIndex || this.useSnapshot || this.useViewIndex) {
            return;
        }
        String schemaName = IndexExtendedIT.generateUniqueName();
        String dataTableName = IndexExtendedIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexExtendedIT.generateUniqueName();
        String indexFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexExtendedIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute(String.format("CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) %s", dataTableFullName, this.tableDDLOptions));
            stmt.execute(String.format("UPSERT INTO %s VALUES(1, 'Phoenix', 12345)", dataTableFullName));
            conn.commit();
            IndexRebuildRegionScanner.setIgnoreIndexRebuildForTesting((boolean)true);
            stmt.execute(String.format("CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) ASYNC %s", indexTableName, dataTableFullName, this.indexDDLOptions));
            Assert.assertFalse((boolean)TestUtil.checkIndexState(conn, indexFullName, PIndexState.ACTIVE, 0L));
            if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled((Configuration)IndexExtendedIT.getUtility().getConfiguration())) {
                IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, -1, IndexTool.IndexVerifyType.AFTER, new String[0]);
                Assert.assertFalse((boolean)TestUtil.checkIndexState(conn, indexFullName, PIndexState.ACTIVE, 0L));
            }
            IndexRebuildRegionScanner.setIgnoreIndexRebuildForTesting((boolean)false);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            Assert.assertTrue((boolean)TestUtil.checkIndexState(conn, indexFullName, PIndexState.ACTIVE, 0L));
        }
    }
}

