/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class IndexBuildTimestampIT
extends BaseTest {
    private final boolean localIndex;
    private final boolean async;
    private final boolean view;
    private final boolean snapshot;
    private final boolean transactional;
    private final String tableDDLOptions;
    private String scnPropName;

    public IndexBuildTimestampIT(String transactionProvider, boolean mutable, boolean localIndex, boolean async, boolean view, boolean snapshot) {
        this.localIndex = localIndex;
        this.async = async;
        this.view = view;
        this.snapshot = snapshot;
        this.transactional = transactionProvider != null;
        StringBuilder optionBuilder = new StringBuilder();
        if (!mutable) {
            optionBuilder.append(" IMMUTABLE_ROWS=true ");
        }
        if (this.transactional) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'");
        }
        optionBuilder.append(" SPLIT ON(1,2)");
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void setup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        IndexBuildTimestampIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="transactionProvider={0},mutable={1},localIndex={2},async={3},view={4},snapshot={5}")
    public static synchronized Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (boolean mutable : Booleans = new boolean[]{false, true}) {
            for (boolean localIndex : Booleans) {
                for (boolean async : Booleans) {
                    for (boolean view : Booleans) {
                        for (boolean snapshot : Booleans) {
                            for (String transactionProvider : new String[]{"OMID", null}) {
                                if (snapshot || transactionProvider != null || (localIndex || !async) && snapshot) continue;
                                list.add(new Object[]{transactionProvider, mutable, localIndex, async, view, snapshot});
                            }
                        }
                    }
                }
            }
        }
        return list;
    }

    public static void assertExplainPlan(Connection conn, boolean localIndex, String selectSql, String dataTableFullName, String indexTableFullName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(localIndex, actualExplainPlan, dataTableFullName, indexTableFullName);
    }

    private void populateTable(String tableName, MyClock clock1, MyClock clock2) throws Exception {
        Connection conn = DriverManager.getConnection(IndexBuildTimestampIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val varchar(10), ts timestamp)" + this.tableDDLOptions);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock1);
        conn.createStatement().execute("upsert into " + tableName + " values ('aaa', 'abc', current_date())");
        conn.commit();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock2);
        conn.createStatement().execute("upsert into " + tableName + " values ('bbb', 'bcd', current_date())");
        conn.commit();
        conn.close();
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(clock1.initialTime()));
        conn = DriverManager.getConnection(IndexBuildTimestampIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select * from " + tableName);
        Assert.assertFalse((boolean)rs.next());
        conn.close();
        props.setProperty("CurrentSCN", Long.toString(clock2.initialTime()));
        conn = DriverManager.getConnection(IndexBuildTimestampIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("select * from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
        Assert.assertNotNull((Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
        props.setProperty("CurrentSCN", Long.toString(clock2.currentTime()));
        conn = DriverManager.getConnection(IndexBuildTimestampIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("select * from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
        Assert.assertNotNull((Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"bbb", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
        Assert.assertNotNull((Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellTimestamp() throws Exception {
        EnvironmentEdgeManager.reset();
        try {
            MyClock clock1 = new MyClock(100000L);
            MyClock clock2 = new MyClock(200000L);
            String dataTableName = IndexBuildTimestampIT.generateUniqueName();
            this.populateTable(dataTableName, clock1, clock2);
            MyClock clock3 = new MyClock(300000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock3);
            Properties props = new Properties();
            props.setProperty("phoenix.client.enable.server.upsert.mutations", "true");
            props.setProperty("phoenix.client.enable.server.delete.mutations", "true");
            PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(IndexBuildTimestampIT.getUrl(), props);
            String viewName = null;
            if (this.view) {
                viewName = IndexBuildTimestampIT.generateUniqueName();
                conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTableName);
            }
            String indexName = IndexBuildTimestampIT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + " INDEX " + indexName + " on " + (this.view ? viewName : dataTableName) + " (val) include (ts)" + (this.async ? "ASYNC" : ""));
            conn.close();
            if (this.async) {
                IndexToolIT.runIndexTool(this.snapshot, null, this.view ? viewName : dataTableName, indexName);
            }
            String selectSql = String.format("SELECT * FROM %s WHERE val = 'abc'", this.view ? viewName : dataTableName);
            conn = (PhoenixConnection)DriverManager.getConnection(IndexBuildTimestampIT.getUrl());
            IndexBuildTimestampIT.assertExplainPlan((Connection)conn, this.localIndex, selectSql, dataTableName, this.view && !this.localIndex ? "_IDX_" + dataTableName : indexName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() < clock2.initialTime() && rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() >= clock1.initialTime() ? 1 : 0) != 0);
            selectSql = String.format("SELECT * FROM %s WHERE val = 'bcd'", this.view ? viewName : dataTableName);
            IndexBuildTimestampIT.assertExplainPlan((Connection)conn, this.localIndex, selectSql, dataTableName, this.view && !this.localIndex ? "_IDX_" + dataTableName : indexName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() < clock3.initialTime() && rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() >= clock2.initialTime() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
            PTable pIndexTable = conn.getTable(indexName);
            Table table = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().getTable(pIndexTable.getPhysicalName().getBytes());
            Scan scan = new Scan();
            scan.setTimeRange(clock3.initialTime(), clock3.currentTime());
            ResultScanner scanner = table.getScanner(scan);
            Assert.assertTrue((scanner.next() == null ? 1 : 0) != 0);
            scan = new Scan();
            scan.setTimeRange(clock2.initialTime(), clock3.initialTime());
            scanner = table.getScanner(scan);
            Assert.assertTrue((scanner.next() != null ? 1 : 0) != 0);
            scan = new Scan();
            scan.setTimeRange(clock1.initialTime(), clock2.initialTime());
            scanner = table.getScanner(scan);
            Assert.assertTrue((scanner.next() != null ? 1 : 0) != 0);
            conn.close();
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private class MyClock
    extends EnvironmentEdge {
        long initialTime;
        long delta;

        public MyClock(long delta) {
            this.initialTime = System.currentTimeMillis() + delta;
            this.delta = delta;
        }

        public long currentTime() {
            return System.currentTimeMillis() + this.delta;
        }

        public long initialTime() {
            return this.initialTime;
        }
    }
}

