/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class GroupByIT
extends BaseQueryIT {
    public GroupByIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) {
        super(indexDDL, columnEncoded, keepDeletedCells);
    }

    @Parameterized.Parameters(name="GroupByIT_{index}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupedAggregation() throws Exception {
        String query = "SELECT a_string as a_string, count(1), 'foo' FROM " + tableName + " WHERE organization_id=? GROUP BY a_string";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"a");
            Assert.assertEquals((long)rs.getLong(2), (long)4L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((long)rs.getLong(2), (long)4L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"c");
            Assert.assertEquals((long)rs.getLong(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctGroupedAggregation() throws Exception {
        String query = "SELECT DISTINCT a_string, count(1), 'foo' FROM " + tableName + " WHERE organization_id=? GROUP BY a_string, b_string ORDER BY a_string, count(1)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"a");
            Assert.assertEquals((long)rs.getLong(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"a");
            Assert.assertEquals((long)rs.getLong(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((long)rs.getLong(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((long)rs.getLong(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"c");
            Assert.assertEquals((long)rs.getLong(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctLimitedGroupedAggregation() throws Exception {
        String query = "SELECT /*+ NO_INDEX */ DISTINCT a_string, count(1), 'foo' FROM " + tableName + " WHERE organization_id=? GROUP BY a_string, b_string ORDER BY count(1) desc,a_string LIMIT 2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"a");
            Assert.assertEquals((long)rs.getLong(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((long)rs.getLong(2), (long)2L);
            Assert.assertEquals((Object)rs.getString(3), (Object)"foo");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistinctUngroupedAggregation() throws Exception {
        String query = "SELECT DISTINCT count(1), 'foo' FROM " + tableName + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupedLimitedAggregation() throws Exception {
        String query = "SELECT a_string, count(1) FROM " + tableName + " WHERE organization_id=? GROUP BY a_string LIMIT 2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"a");
            Assert.assertEquals((long)4L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((long)4L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void zTestGroupByWithIntegerDivision1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        String table = GroupByIT.generateUniqueName();
        String ddl = "create table " + table + "(\"time\" integer not null, hostname varchar not null,usage float,period integer constraint pk PRIMARY KEY(\"time\", hostname))";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + table + " values(1439853462,'qa9',8.27,1439853462)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853461,'qa9',8.27,1439853362)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853461,'qa9',5.27,1439853461)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853451,'qa9',4.27,1439853451)");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        stmt = conn.prepareStatement("select \"time\"/10 as tm, hostname, avg(usage) from " + table + " group by hostname, tm");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)143985345L, (long)rs.getInt(1));
        Assert.assertEquals((double)4.2699, (double)rs.getDouble(3), (double)0.1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)143985346L, (long)rs.getInt(1));
        Assert.assertEquals((double)6.77, (double)rs.getDouble(3), (double)0.1);
    }

    @Test
    public void zTestGroupByWithIntegerDivision2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        String table = GroupByIT.generateUniqueName();
        String ddl = "create table " + table + "(\"time\" integer not null, hostname varchar not null,usage float,period integer constraint pk PRIMARY KEY(\"time\", hostname))";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + table + " values(1439853462,'qa9',8.27,1439853462)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853461,'qa9',8.27,1439853362)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853461,'qa9',5.27,1439853461)");
        stmt.execute();
        stmt = conn.prepareStatement("upsert into " + table + " values(1439853451,'qa9',4.27,1439853451)");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        stmt = conn.prepareStatement("select period/10 as tm, hostname, avg(usage) from " + table + " group by hostname, tm");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)143985345L, (long)rs.getInt(1));
        Assert.assertEquals((double)4.2699, (double)rs.getDouble(3), (double)0.1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)143985346L, (long)rs.getInt(1));
        Assert.assertEquals((double)6.77, (double)rs.getDouble(3), (double)0.1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByCondition() throws Exception {
        ArrayList expectedResults;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        PreparedStatement statement = conn.prepareStatement("SELECT count(*) FROM " + tableName + " WHERE organization_id=? GROUP BY a_integer=6");
        statement.setString(1, tenantId);
        ResultSet rs = statement.executeQuery();
        this.assertValueEqualsResultSet(rs, Arrays.asList(1L, 8L));
        try {
            statement = conn.prepareStatement("SELECT count(*),a_integer=6 FROM " + tableName + " WHERE organization_id=? and (a_integer IN (5,6) or a_integer is null) GROUP BY a_integer=6");
            statement.setString(1, tenantId);
            rs = statement.executeQuery();
            expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList(1L, false), Arrays.asList(1L, true)});
            GroupByIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
        finally {
            conn.close();
        }
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        try {
            statement = conn.prepareStatement("UPSERT into " + tableName + " (organization_id,entity_id,a_integer) values(?,?,null)");
            statement.setString(1, tenantId);
            statement.setString(2, "00A323122312312");
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            conn.close();
        }
        conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
        statement = conn.prepareStatement("SELECT count(*) FROM " + tableName + " WHERE organization_id=? GROUP BY a_integer=6");
        statement.setString(1, tenantId);
        rs = statement.executeQuery();
        this.assertValueEqualsResultSet(rs, Arrays.asList(1L, 1L, 7L));
        statement = conn.prepareStatement("SELECT a_integer, entity_id FROM " + tableName + " WHERE organization_id=? and (a_integer IN (5,6) or a_integer is null)");
        statement.setString(1, tenantId);
        rs = statement.executeQuery();
        expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList(null, "00A323122312312"), Arrays.asList(5, "00B523122312312"), Arrays.asList(6, "00B623122312312")});
        GroupByIT.assertValuesEqualsResultSet(rs, expectedResults);
        try {
            statement = conn.prepareStatement("SELECT count(*),a_integer=6 FROM " + tableName + " WHERE organization_id=? and (a_integer IN (5,6) or a_integer is null) GROUP BY a_integer=6");
            statement.setString(1, tenantId);
            rs = statement.executeQuery();
            expectedResults = Lists.newArrayList((Object[])new List[]{Arrays.asList(1L, null), Arrays.asList(1L, false), Arrays.asList(1L, true)});
            GroupByIT.assertValuesEqualsResultSet(rs, expectedResults);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByHavingWithAlias() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
            conn.setAutoCommit(false);
            String tableName = GroupByIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + " (a_string varchar not null, col1 integer CONSTRAINT pk PRIMARY KEY (a_string))";
            GroupByIT.createTestTable(GroupByIT.getUrl(), ddl);
            String dml = "UPSERT INTO " + tableName + " VALUES(?, ?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "a");
            stmt.setInt(2, 40);
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setInt(2, 20);
            stmt.execute();
            stmt.setString(1, "c");
            stmt.setInt(2, 30);
            stmt.execute();
            stmt.execute();
            conn.commit();
            String query = "SELECT a_string, sum(col1) as sumCol1 FROM " + tableName + " GROUP BY a_string HAVING sumCol1>20 ORDER BY sumCol1";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByHavingWithAlias2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(GroupByIT.getUrl(), props);){
            conn = DriverManager.getConnection(GroupByIT.getUrl(), props);
            conn.setAutoCommit(false);
            String tableName = GroupByIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + " (a_string varchar not null, col1 integer not null, col2 varchar, col3 integer CONSTRAINT pk PRIMARY KEY (a_string, col1))";
            GroupByIT.createTestTable(GroupByIT.getUrl(), ddl);
            String dml = "UPSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "a1xyz");
            stmt.setInt(2, 40);
            stmt.setString(3, "col2xyz1");
            stmt.setInt(4, 50);
            stmt.execute();
            stmt.setString(1, "b1xyz");
            stmt.setInt(2, 20);
            stmt.setString(3, "col2xyz2");
            stmt.setInt(4, 60);
            stmt.execute();
            stmt.setString(1, "c1xyz");
            stmt.setInt(2, 30);
            stmt.setString(3, "col2xyz3");
            stmt.setInt(4, 70);
            stmt.execute();
            conn.commit();
            String query = "SELECT a_string, col1, sum(col1) as sumCol1 FROM " + tableName + " GROUP BY a_string, col1 HAVING sumCol1 > 20 ORDER BY sumCol1";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c1xyz", (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertEquals((long)30L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a1xyz", (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertEquals((long)40L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

