/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GlobalConnectionTenantTableIT
extends BaseTest {
    private static final String SCHEMA_NAME = "SCHEMA1";
    private static final String TABLE_NAME = GlobalConnectionTenantTableIT.generateUniqueName();
    private static final String TENANT_NAME = "TENANT_A";
    private static final String VIEW_NAME = "VIEW1";
    private static final String INDEX_NAME = "INDEX1";
    private static final String VIEW_INDEX_COL = "v2";
    private static final String FULL_VIEW_NAME = SchemaUtil.getTableName((String)"SCHEMA1", (String)"VIEW1");
    private static final String FULL_INDEX_NAME = SchemaUtil.getTableName((String)"SCHEMA1", (String)"INDEX1");

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        GlobalConnectionTenantTableIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        GlobalConnectionTenantTableIT.createBaseTable(SCHEMA_NAME, TABLE_NAME, true, null, null);
        try (Connection conn = GlobalConnectionTenantTableIT.getTenantConnection(TENANT_NAME);){
            GlobalConnectionTenantTableIT.createView(conn, SCHEMA_NAME, VIEW_NAME, TABLE_NAME);
            GlobalConnectionTenantTableIT.createViewIndex(conn, SCHEMA_NAME, INDEX_NAME, VIEW_NAME, VIEW_INDEX_COL);
        }
    }

    @Test
    public void testGetLatestTenantTable() throws SQLException {
        try (PhoenixConnection conn = (PhoenixConnection)GlobalConnectionTenantTableIT.getConnection();){
            PTable table = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, null);
            Assert.assertNotNull((Object)table);
            table = null;
            table = conn.getTable(TENANT_NAME, FULL_INDEX_NAME, null);
            Assert.assertNotNull((Object)table);
        }
    }

    @Test
    public void testGetTenantViewAtTimestamp() throws SQLException {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        try (PhoenixConnection conn = (PhoenixConnection)GlobalConnectionTenantTableIT.getConnection();){
            PTable table = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, null);
            long tableTimestamp = table.getTimeStamp();
            try (Connection tenantConn = GlobalConnectionTenantTableIT.getTenantConnection(TENANT_NAME);){
                String alterView = "ALTER VIEW " + FULL_VIEW_NAME + " ADD new_col INTEGER";
                tenantConn.createStatement().execute(alterView);
            }
            PTable newTable = conn.getTable(TENANT_NAME, FULL_VIEW_NAME);
            Assert.assertNotNull((Object)newTable);
            Assert.assertTrue((newTable.getTimeStamp() > tableTimestamp ? 1 : 0) != 0);
            Assert.assertEquals((long)newTable.getColumns().size(), (long)(table.getColumns().size() + 1));
            PTable oldTable = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, Long.valueOf(startTime));
            Assert.assertNotNull((Object)oldTable);
            Assert.assertEquals((long)oldTable.getTimeStamp(), (long)tableTimestamp);
        }
    }

    @Test
    public void testGetTableWithoutTenantId() throws SQLException {
        try (PhoenixConnection conn = (PhoenixConnection)GlobalConnectionTenantTableIT.getConnection();){
            PTable table = conn.getTable(null, SchemaUtil.getTableName((String)SCHEMA_NAME, (String)TABLE_NAME));
            Assert.assertNotNull((Object)table);
            try {
                table = conn.getTable(null, FULL_VIEW_NAME);
                Assert.fail((String)"Expected TableNotFoundException for trying to get tenant specific view without tenantid");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode());
            }
        }
    }

    @Test
    public void testTableNotFound() throws SQLException {
        try (PhoenixConnection conn = (PhoenixConnection)GlobalConnectionTenantTableIT.getConnection();){
            try {
                PTable table = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, Long.valueOf(1L));
                Assert.fail((String)"Expected TableNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode());
            }
        }
    }

    @Test
    public void testGetTableFromCache() throws SQLException {
        try (PhoenixConnection conn = (PhoenixConnection)GlobalConnectionTenantTableIT.getConnection();){
            PTable table = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, null);
            PTable newTable = conn.getTable(TENANT_NAME, FULL_VIEW_NAME, null);
            Assert.assertNotNull((Object)newTable);
            Assert.assertTrue((newTable == table ? 1 : 0) != 0);
        }
    }

    private static void createBaseTable(String schemaName, String tableName, boolean multiTenant, Integer saltBuckets, String splits) throws SQLException {
        String ddlOptions;
        Connection conn = GlobalConnectionTenantTableIT.getConnection();
        String ddl = "CREATE TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + " (t_id VARCHAR NOT NULL,\nk1 VARCHAR NOT NULL,\nk2 INTEGER NOT NULL,\nv1 VARCHAR,\n" + VIEW_INDEX_COL + " INTEGER,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n";
        String string = ddlOptions = multiTenant ? "MULTI_TENANT=true" : "";
        if (saltBuckets != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ",") + "salt_buckets=" + saltBuckets;
        }
        if (splits != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ",") + "splits=" + splits;
        }
        conn.createStatement().execute(ddl + ddlOptions);
        conn.close();
    }

    private static void createView(Connection conn, String schemaName, String viewName, String baseTableName) throws SQLException {
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)baseTableName);
        conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName);
        conn.commit();
    }

    private static void createViewIndex(Connection conn, String schemaName, String indexName, String viewName, String indexColumn) throws SQLException {
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullViewName + "(" + indexColumn + ")");
        conn.commit();
    }

    private static Connection getTenantConnection(String tenant) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenant);
        return DriverManager.getConnection(GlobalConnectionTenantTableIT.getUrl(), props);
    }

    private static Connection getConnection() throws SQLException {
        Properties props = new Properties();
        return DriverManager.getConnection(GlobalConnectionTenantTableIT.getUrl(), props);
    }
}

