/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class FunkyNamesIT
extends ParallelStatsDisabledIT {
    protected static String initTableValues(byte[][] splits) throws Exception {
        String tableName = FunkyNamesIT.generateUniqueName();
        FunkyNamesIT.ensureTableCreated(FunkyNamesIT.getUrl(), tableName, "FUNKY_NAMES", splits, null, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(FunkyNamesIT.getUrl(), props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    \"foo!\",     \"#@$\",     \"foo.bar-bas\",     \"_blah^\",    \"Value\",     \"VALUE\",     \"value\") VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "a");
        stmt.setString(2, "b");
        stmt.setString(3, "c");
        stmt.setString(4, "d");
        stmt.setInt(5, 1);
        stmt.setInt(6, 2);
        stmt.setInt(7, 3);
        stmt.executeUpdate();
        conn.close();
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnaliasedFunkyNames() throws Exception {
        String query = "SELECT \"foo!\",\"#@$\",\"foo.bar-bas\",\"_blah^\" FROM %s";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(FunkyNamesIT.getUrl(), props);){
            String tableName = FunkyNamesIT.initTableValues(null);
            PreparedStatement statement = conn.prepareStatement(String.format(query, tableName));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((Object)"c", (Object)rs.getString(3));
            Assert.assertEquals((Object)"d", (Object)rs.getString(4));
            Assert.assertEquals((Object)"a", (Object)rs.getString("foo!"));
            Assert.assertEquals((Object)"b", (Object)rs.getString("#@$"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("foo.bar-bas"));
            Assert.assertEquals((Object)"d", (Object)rs.getString("_blah^"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseSensitive() throws Exception {
        String query = "SELECT \"Value\",\"VALUE\",\"value\" FROM %s";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(FunkyNamesIT.getUrl(), props);){
            String tableName = FunkyNamesIT.initTableValues(null);
            PreparedStatement statement = conn.prepareStatement(String.format(query, tableName));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((long)3L, (long)rs.getInt(3));
            Assert.assertEquals((long)1L, (long)rs.getInt("Value"));
            Assert.assertEquals((long)2L, (long)rs.getInt("VALUE"));
            Assert.assertEquals((long)3L, (long)rs.getInt("value"));
            try {
                rs.getInt("vAlue");
                Assert.fail();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAliasedFunkyNames() throws Exception {
        String query = "SELECT \"1-3.4$\".\"foo!\" as \"1-2\",\"#@$\" as \"[3]\",\"foo.bar-bas\" as \"$$$\",\"_blah^\" \"0\" FROM %s \"1-3.4$\"";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(FunkyNamesIT.getUrl(), props);){
            String tableName = FunkyNamesIT.initTableValues(null);
            PreparedStatement statement = conn.prepareStatement(String.format(query, tableName));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString("1-2"));
            Assert.assertEquals((Object)"b", (Object)rs.getString("[3]"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("$$$"));
            Assert.assertEquals((Object)"d", (Object)rs.getString("0"));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

