/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.index.BaseLocalIndexIT;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlappingLocalIndexIT
extends BaseLocalIndexIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlappingLocalIndexIT.class);

    public FlappingLocalIndexIT(boolean isNamespaceMapped) {
        super(isNamespaceMapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWhenATableHasMultipleLocalIndexes() throws Exception {
        String tableName = this.schemaName + "." + FlappingLocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + FlappingLocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + "2 ON " + tableName + "(k3)");
            conn1.commit();
            conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl());
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanWithSmallChunks() throws Exception {
        String tableName = this.schemaName + "." + FlappingLocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + FlappingLocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, 3, null);
        Properties props = new Properties();
        props.setProperty("phoenix.query.scanResultChunkSize", "2");
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        try (java.sql.Connection conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl(), props);){
            int j;
            String[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            for (int i = 0; i < 26; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + tableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
            }
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + "_2 ON " + tableName + "(k3)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            String query = "SELECT t_id,k1,v1 FROM " + tableName;
            rs = conn1.createStatement().executeQuery(query);
            for (j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[25 - j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)(25 - j), (long)rs.getInt("k1"));
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("V1"));
            }
            query = "SELECT t_id,k1,k3 FROM " + tableName;
            rs = conn1.createStatement().executeQuery(query);
            Thread.sleep(1000L);
            for (j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)j, (long)rs.getInt("k1"));
                Assert.assertEquals((long)(j + 2), (long)rs.getInt("k3"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScan() throws Exception {
        String tableName = this.schemaName + "." + FlappingLocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + FlappingLocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('a',1,2,5,'y')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('e',1,2,3,'b')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Admin admin = driver.getConnectionQueryServices(FlappingLocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
            int numRegions = admin.getRegions(physicalTableName).size();
            int trimmedRegionLocations = admin.getConfiguration().getInt("phoenix.max.region.locations.size.explain.plan", -1);
            String query = "SELECT * FROM " + tableName + " where v1 like 'a%'";
            String explainPlanOutput = QueryUtil.getExplainPlan((ResultSet)conn1.createStatement().executeQuery("EXPLAIN WITH REGIONS " + query));
            LOGGER.info("Explain plan output: {}", (Object)explainPlanOutput);
            Assert.assertTrue((String)("Expected total " + numRegions + " regions"), (boolean)explainPlanOutput.contains("...total size = " + numRegions));
            ExplainPlan plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)("PARALLEL " + numRegions + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexTableName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1,'a'] - [1,'b']", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            Assert.assertEquals((long)trimmedRegionLocations, (long)explainPlanAttributes.getRegionLocations().size());
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2,V1 FROM " + tableName + " where v1='a'";
            plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)("PARALLEL " + numRegions + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexTableName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1,'a']", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2,V1, k3 FROM " + tableName + " where v1<='z' order by k3";
            plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)("PARALLEL " + numRegions + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexTableName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1,*] - [1,'z']", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            Assert.assertEquals((Object)"[\"K3\"]", (Object)explainPlanAttributes.getServerSortedBy());
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2,v1 from " + tableName + " order by V1,t_id";
            plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)("PARALLEL " + numRegions + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(indexTableName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            Assert.assertNull((Object)explainPlanAttributes.getServerSortedBy());
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"b", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"q", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"y", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
        }
    }

    @Test
    public void testBuildIndexWhenUserTableAlreadyHasData() throws Exception {
        String tableName = this.schemaName + "." + FlappingLocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + FlappingLocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        java.sql.Connection conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl());
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
        conn1.commit();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Admin admin = driver.getConnectionQueryServices(FlappingLocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        Connection hbaseConn = admin.getConnection();
        Table indexTable = hbaseConn.getTable(TableName.valueOf((String)indexPhysicalTableName));
        Pair startEndKeys = hbaseConn.getRegionLocator(TableName.valueOf((String)indexPhysicalTableName)).getStartEndKeys();
        byte[][] startKeys = (byte[][])startEndKeys.getFirst();
        byte[][] endKeys = (byte[][])startEndKeys.getSecond();
        for (int i = 0; i < startKeys.length; ++i) {
            Scan s = new Scan();
            s.addFamily(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
            s.withStartRow(startKeys[i]);
            s.withStopRow(endKeys[i]);
            ResultScanner scanner = indexTable.getScanner(s);
            int count = 0;
            for (Result r : scanner) {
                ++count;
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)count);
        }
        indexTable.close();
    }

    @Test
    public void testBuildingLocalIndexShouldHandleNoSuchColumnFamilyException() throws Exception {
        this.testBuildingLocalIndexShouldHandleNoSuchColumnFamilyException(false);
    }

    @Test
    public void testBuildingLocalCoveredIndexShouldHandleNoSuchColumnFamilyException() throws Exception {
        this.testBuildingLocalIndexShouldHandleNoSuchColumnFamilyException(true);
    }

    private void testBuildingLocalIndexShouldHandleNoSuchColumnFamilyException(boolean coveredIndex) throws Exception {
        String tableName = this.schemaName + "." + FlappingLocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + FlappingLocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        this.createBaseTable(tableName, null, null, coveredIndex ? "cf" : null);
        java.sql.Connection conn1 = DriverManager.getConnection(FlappingLocalIndexIT.getUrl());
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
        conn1.commit();
        Admin admin = driver.getConnectionQueryServices(FlappingLocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        TableDescriptor tableDescriptor = admin.getDescriptor(physicalTableName);
        tableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor).setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)DeleyOpenRegionObserver.class.getName()).setPriority(0x2FFFFFFD).setProperties(Collections.emptyMap()).build()).build();
        admin.disableTable(physicalTableName);
        admin.modifyTable(tableDescriptor);
        admin.enableTable(physicalTableName);
        DeleyOpenRegionObserver.DELAY_OPEN = true;
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(k3)" + (coveredIndex ? " include(cf.v1)" : ""));
        DeleyOpenRegionObserver.DELAY_OPEN = false;
        ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
    }

    public static class DeleyOpenRegionObserver
    implements RegionObserver {
        public static volatile boolean DELAY_OPEN = false;
        private int retryCount = 0;
        private CountDownLatch latch = new CountDownLatch(1);

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            if (DELAY_OPEN) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e1) {
                    throw new DoNotRetryIOException((Throwable)e1);
                }
            }
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
            if (DELAY_OPEN && this.retryCount == 1) {
                this.latch.countDown();
            }
            ++this.retryCount;
        }
    }
}

