/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class FlappingAlterTableIT
extends ParallelStatsDisabledIT {
    private String dataTableFullName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        FlappingAlterTableIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void setupTableNames() throws Exception {
        String schemaName = "";
        String dataTableName = FlappingAlterTableIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
    }

    @Test
    public void testAddColumnForNewColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2))";
        Connection conn1 = DriverManager.getConnection(FlappingAlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD CF.STRING VARCHAR";
        conn1.createStatement().execute(ddl);
        TestUtil.assertTTLValue(conn1, this.dataTableFullName, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
        try (Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
            Assert.assertEquals((long)2L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[0].getTimeToLive());
            Assert.assertEquals((Object)"CF", (Object)columnFamilies[1].getNameAsString());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[1].getTimeToLive());
        }
    }

    @Test
    public void testNewColumnFamilyInheritsTTLOfEmptyCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) TTL = 1000";
        Connection conn1 = DriverManager.getConnection(FlappingAlterTableIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " ADD CF.STRING VARCHAR";
        conn1.createStatement().execute(ddl);
        TestUtil.assertTTLValue(conn1, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(1000));
        try (Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
            ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
            Assert.assertEquals((long)2L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)1000L, (long)columnFamilies[0].getTimeToLive());
            Assert.assertEquals((Object)"CF", (Object)columnFamilies[1].getNameAsString());
            Assert.assertEquals((long)1000L, (long)columnFamilies[1].getTimeToLive());
        }
    }
}

