/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.phoenix.coprocessor.PhoenixRegionServerEndpoint;
import org.apache.phoenix.coprocessor.generated.RegionServerEndpointProtos;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailingPhoenixRegionServerEndpoint
extends PhoenixRegionServerEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailingPhoenixRegionServerEndpoint.class);
    private boolean throwException;
    private boolean shouldSleep;
    private boolean failFirstAndThenSucceed;
    private int attempt = 0;

    public void invalidateServerMetadataCache(RpcController controller, RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest request, RpcCallback<RegionServerEndpointProtos.InvalidateServerMetadataCacheResponse> done) {
        long metadataCacheInvalidationTimeoutMs = this.conf.getLong("phoenix.metadata.cache.invalidation.timeoutMs", 10000L);
        if (this.throwException) {
            IOException ioe = new IOException("On purpose");
            ProtobufUtil.setControllerException((RpcController)controller, (IOException)ioe);
            return;
        }
        if (this.shouldSleep) {
            try {
                Thread.sleep(metadataCacheInvalidationTimeoutMs + 2000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Exception while sleeping in FailingPhoenixRegionServerEndpoint", (Throwable)e);
            }
        } else if (this.failFirstAndThenSucceed) {
            if (this.attempt == 0) {
                IOException ioe = new IOException("On purpose");
                ProtobufUtil.setControllerException((RpcController)controller, (IOException)ioe);
                ++this.attempt;
            }
        } else {
            LOGGER.info("Invalidating server metadata cache");
        }
    }

    public void throwException() {
        this.reset();
        this.throwException = true;
    }

    public void sleep() {
        this.reset();
        this.shouldSleep = true;
    }

    public void failFirstAndThenSucceed() {
        this.reset();
        this.failFirstAndThenSucceed = true;
    }

    private void reset() {
        this.shouldSleep = false;
        this.throwException = false;
        this.failFirstAndThenSucceed = false;
    }
}

