/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ExtendedQueryExecIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToDateFunctionBind() throws Exception {
        Date date = new Date(1L);
        String tenantId = ExtendedQueryExecIT.getOrganizationId();
        String tableName = ExtendedQueryExecIT.initATableValues(null, tenantId, ExtendedQueryExecIT.getDefaultSplits(tenantId), date, null, ExtendedQueryExecIT.getUrl(), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ExtendedQueryExecIT.getUrl(), props);){
            String query = "SELECT a_date FROM " + tableName + " WHERE organization_id='" + tenantId + "' and a_date < TO_DATE(?)";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "1970-1-1 12:00:00");
            ResultSet rs = statement.executeQuery();
            this.verifyDateResultSet(rs, date, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Test code.")
    public void testTypeMismatchToDateFunctionBind() throws Exception {
        String tenantId = ExtendedQueryExecIT.getOrganizationId();
        String tableName = ExtendedQueryExecIT.initATableValues(null, tenantId, ExtendedQueryExecIT.getDefaultSplits(tenantId), null, null, ExtendedQueryExecIT.getUrl(), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ExtendedQueryExecIT.getUrl(), props);){
            String query = "SELECT a_date FROM " + tableName + " WHERE organization_id='" + tenantId + "' and a_date < TO_DATE(?)";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setDate(1, new Date(2L));
            statement.executeQuery();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateFunctions() throws Exception {
        Date date = new Date(1L);
        String tenantId = ExtendedQueryExecIT.getOrganizationId();
        String tableName = ExtendedQueryExecIT.initATableValues(null, tenantId, ExtendedQueryExecIT.getDefaultSplits(tenantId), date, null, ExtendedQueryExecIT.getUrl(), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ExtendedQueryExecIT.getUrl(), props);){
            String queryPrefix = "SELECT a_date FROM " + tableName + "  WHERE organization_id='" + tenantId + "' and ";
            String queryDateArg = "a_date < TO_DATE('1970-1-1 12:00:00')";
            ResultSet rs = this.getResultSet(conn, queryPrefix + queryDateArg);
            this.verifyDateResultSet(rs, date, 3);
            queryDateArg = "a_date >= TO_DATE('1970-1-2 23:59:59') and a_date <= TO_DATE('1970-1-3 0:0:1')";
            rs = this.getResultSet(conn, queryPrefix + queryDateArg);
            this.verifyDateResultSet(rs, new Date(date.getTime() + 172800000L), 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateGroupBy() throws Exception {
        Date date = new Date(1L);
        String tenantId = ExtendedQueryExecIT.getOrganizationId();
        String tableName = ExtendedQueryExecIT.initATableValues(null, tenantId, ExtendedQueryExecIT.getDefaultSplits(tenantId), date, null, ExtendedQueryExecIT.getUrl(), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ExtendedQueryExecIT.getUrl(), props);){
            String query = "SELECT a_date, count(1) FROM " + tableName + "  WHERE organization_id='" + tenantId + "' group by a_date";
            ResultSet rs = this.getResultSet(conn, query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)date, (Object)rs.getDate(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private ResultSet getResultSet(Connection conn, String query) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        return rs;
    }

    private void verifyDateResultSet(ResultSet rs, Date date, int rowCount) throws SQLException {
        for (int i = 0; i < rowCount; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)date, (Object)rs.getDate(1));
        }
        Assert.assertFalse((boolean)rs.next());
    }
}

