/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class ExplainPlanWithStatsEnabledIT
extends ParallelStatsEnabledIT {
    private static String tableA;
    private static String tableB;
    private static String tableWithLargeGPWidth;
    private static String indexOnA;
    private static final long largeGpWidth = 2000000L;

    @BeforeClass
    public static synchronized void createTables() throws Exception {
        tableA = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        ExplainPlanWithStatsEnabledIT.initDataAndStats(tableA, 20L);
        tableB = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        ExplainPlanWithStatsEnabledIT.initDataAndStats(tableB, 20L);
        tableWithLargeGPWidth = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        ExplainPlanWithStatsEnabledIT.initDataAndStats(tableWithLargeGPWidth, 2000000L);
        indexOnA = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        ExplainPlanWithStatsEnabledIT.createIndex(indexOnA, tableA, 20L);
    }

    private static void createIndex(String indexName, String table, long guidePostWidth) throws Exception {
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + table + " (c1.a) INCLUDE (c2.b) ");
            conn.createStatement().execute("UPDATE STATISTICS " + indexName);
        }
    }

    private static void initDataAndStats(String tableName, Long guidePostWidth) throws Exception {
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (k INTEGER PRIMARY KEY, c1.a bigint, c2.b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth);
            conn.createStatement().execute("upsert into " + tableName + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + tableName + " values (101,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (102,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (103,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (104,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (105,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (106,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (107,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (108,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (109,2,4)");
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + tableName);
        }
    }

    private static Connection getTenantConnection(String tenantId) throws SQLException {
        String url = ExplainPlanWithStatsEnabledIT.getUrl() + ';' + "TenantId" + '=' + tenantId;
        return DriverManager.getConnection(url);
    }

    @Test
    public void testBytesRowsForSelectWhenKeyOutOfRange() throws Exception {
        String sql = "SELECT * FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(200);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)0L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForPointSelectWithLimitGreaterThanPointLookupSize() throws Exception {
        String sql = "SELECT * FROM " + tableA + " where k in (? ,?) limit 4";
        ArrayList binds = Lists.newArrayList();
        binds.add(103);
        binds.add(104);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)200L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
        }
    }

    @Test
    public void testBytesRowsForSelectWithLimit() throws Exception {
        String sql = "SELECT * FROM " + tableA + " where c1.a in (?,?) limit 3";
        String noIndexSQL = "SELECT /*+ NO_INDEX */ * FROM " + tableA + " where c1.a in (?,?) limit 3";
        ArrayList binds = Lists.newArrayList();
        binds.add(1);
        binds.add(2);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)264L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)3L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, noIndexSQL, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForSelectWithLimitIgnored() throws Exception {
        String sql = "SELECT * FROM " + tableA + " where (c1.a > c2.b) limit 1";
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)691L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForSelectWhenKeyInRange() throws Exception {
        String sql = "SELECT * FROM " + tableB + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForSelectOnIndex() throws Exception {
        String sql = "SELECT * FROM " + tableA + " where c1.a >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(0);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                int paramIdx = 1;
                for (Object bind : binds) {
                    statement.setObject(paramIdx++, bind);
                }
                ResultSet rs = statement.executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)100L, (long)rs.getInt(1));
                Assert.assertEquals((long)1L, (long)rs.getInt(2));
                Assert.assertEquals((long)3L, (long)rs.getInt(3));
                Assert.assertTrue((boolean)rs.next());
            }
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)691L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForUnion() throws Exception {
        String sql = "SELECT /*+ NO_INDEX */ * FROM " + tableA + " UNION ALL SELECT * FROM " + tableB;
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Lists.newArrayList());
            Assert.assertEquals((Object)1268L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)20L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEstimatesForUnionWithTableWithLargeGpWidth() throws Exception {
        String sql = "SELECT /*+ NO_INDEX */ * FROM " + tableA + " UNION ALL SELECT * FROM " + tableB + " UNION ALL SELECT * FROM " + tableWithLargeGPWidth;
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Lists.newArrayList());
            Assert.assertEquals((Object)2001268L, (Object)info.estimatedBytes);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForHashJoin() throws Exception {
        String sql = "SELECT ta.c1.a, ta.c2.b FROM " + tableA + " ta JOIN " + tableB + " tb ON ta.k = tb.k";
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Lists.newArrayList());
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForSortMergeJoin() throws Exception {
        String sql = "SELECT /*+ NO_INDEX USE_SORT_MERGE_JOIN */ ta.c1.a, ta.c2.b FROM " + tableA + " ta JOIN " + tableB + " tb ON ta.k = tb.k";
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Lists.newArrayList());
            Assert.assertEquals((Object)1268L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)20L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForAggregateQuery() throws Exception {
        String sql = "SELECT count(*) FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForUpsertSelectServerSide() throws Exception {
        String sql = "UPSERT INTO " + tableA + " SELECT * FROM " + tableB;
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(true);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForUpsertSelectClientSide() throws Exception {
        String sql = "UPSERT INTO " + tableB + " SELECT * FROM " + tableB;
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(false);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForUpsertValues() throws Exception {
        String sql = "UPSERT INTO " + tableA + " VALUES (?, ?, ?)";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        binds.add(99);
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)0L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
        }
    }

    @Test
    public void testBytesRowsForDeleteServerSide() throws Exception {
        String sql = "DELETE FROM " + tableA + " where k >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(true);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)634L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info.estimatedRows);
            Assert.assertTrue((info.estimateInfoTs > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBytesRowsForDeleteClientSideExecutedSerially() throws Exception {
        String sql = "DELETE FROM " + tableA + " where k >= ? LIMIT 2";
        ArrayList binds = Lists.newArrayList();
        binds.add(99);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(false);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)200L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
        }
    }

    @Test
    public void testBytesRowsForPointDelete() throws Exception {
        String sql = "DELETE FROM " + tableA + " where k = ?";
        ArrayList binds = Lists.newArrayList();
        binds.add(100);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(false);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)0L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
        }
    }

    @Test
    public void testBytesRowsForSelectExecutedSerially() throws Exception {
        String sql = "SELECT * FROM " + tableA + " LIMIT 2";
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.setAutoCommit(false);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)176L, (Object)info.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info.estimatedRows);
            Assert.assertEquals((Object)0L, (Object)info.estimateInfoTs);
        }
    }

    public static Estimate getByteRowEstimates(Connection conn, String sql, List<Object> bindValues) throws Exception {
        String explainSql = "EXPLAIN " + sql;
        Long estimatedBytes = null;
        Long estimatedRows = null;
        Long estimateInfoTs = null;
        try (PreparedStatement statement = conn.prepareStatement(explainSql);){
            int paramIdx = 1;
            for (Object bind : bindValues) {
                statement.setObject(paramIdx++, bind);
            }
            ResultSet rs = statement.executeQuery(explainSql);
            rs.next();
            estimatedBytes = (Long)rs.getObject("EST_BYTES_READ");
            estimatedRows = (Long)rs.getObject("EST_ROWS_READ");
            estimateInfoTs = (Long)rs.getObject("EST_INFO_TS");
        }
        return new Estimate(estimatedRows, estimatedBytes, estimateInfoTs);
    }

    @Test
    public void testSettingUseStatsForParallelizationProperty() throws Exception {
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            String table = ExplainPlanWithStatsEnabledIT.generateUniqueName();
            String ddl = "CREATE TABLE " + table + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR) USE_STATS_FOR_PARALLELIZATION = false";
            conn.createStatement().execute(ddl);
            ExplainPlanWithStatsEnabledIT.assertUseStatsForQueryFlag(table, conn.unwrap(PhoenixConnection.class), false);
            ddl = "ALTER TABLE " + table + " SET USE_STATS_FOR_PARALLELIZATION = true";
            conn.createStatement().execute(ddl);
            ExplainPlanWithStatsEnabledIT.assertUseStatsForQueryFlag(table, conn.unwrap(PhoenixConnection.class), true);
            table = ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE TABLE " + table + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR) USE_STATS_FOR_PARALLELIZATION = false";
            conn.createStatement().execute(ddl);
            ExplainPlanWithStatsEnabledIT.assertUseStatsForQueryFlag(table, conn.unwrap(PhoenixConnection.class), false);
            table = ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE TABLE " + table + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)";
            conn.createStatement().execute(ddl);
            ExplainPlanWithStatsEnabledIT.assertUseStatsForQueryFlag(table, conn.unwrap(PhoenixConnection.class), null);
        }
    }

    private static void assertUseStatsForQueryFlag(String tableName, PhoenixConnection conn, Boolean expected) throws TableNotFoundException, SQLException {
        Assert.assertEquals((Object)expected, (Object)((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getMetaDataCache().getTableRef(new PTableKey(null, tableName)).getTable().useStatsForParallelization());
        String query = "SELECT USE_STATS_FOR_PARALLELIZATION FROM SYSTEM.CATALOG WHERE TABLE_NAME = ? AND COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL AND TENANT_ID IS NULL";
        PreparedStatement stmt = conn.prepareStatement(query);
        stmt.setString(1, tableName);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        boolean b = rs.getBoolean(1);
        if (expected == null) {
            Assert.assertTrue((boolean)rs.wasNull());
        } else {
            Assert.assertEquals((Object)expected, (Object)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesRowsForSelectOnTenantViews() throws Exception {
        Estimate info6;
        Throwable throwable;
        Connection conn;
        long prevTenantBytes;
        Estimate info2;
        String tenant1View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenant2View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenant3View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenant4View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String multiTenantBaseTable = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        String tenant3 = "tenant3";
        String tenant4 = "tenant4";
        MyClock clock = new MyClock(1000L);
        ExplainPlanWithStatsEnabledIT.createMultitenantTableAndViews(tenant1View, tenant2View, tenant3View, tenant4View, tenant1, tenant2, tenant3, tenant4, multiTenantBaseTable, clock);
        String sql = "SELECT * FROM " + multiTenantBaseTable + " WHERE ORGID >= ?";
        ArrayList binds = Lists.newArrayList();
        binds.add("tenant0");
        try (Connection conn2 = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            Estimate info3 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn2, sql, binds);
            Assert.assertEquals((Object)681L, (Object)info3.estimatedBytes);
            Assert.assertEquals((Object)10L, (Object)info3.estimatedRows);
            Assert.assertNull((Object)info3.estimateInfoTs);
        }
        binds.clear();
        try (Connection conn3 = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant1);){
            sql = "SELECT * FROM " + tenant1View;
            info2 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn3, sql, binds);
            Assert.assertEquals((Object)119L, (Object)info2.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info2.estimatedRows);
            Assert.assertNull((Object)info2.estimateInfoTs);
        }
        conn3 = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant2);
        var16_21 = null;
        try {
            sql = "SELECT * FROM " + tenant2View;
            info2 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn3, sql, binds);
            prevTenantBytes = 119L;
            Assert.assertEquals((Object)119L, (Object)info2.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info2.estimatedRows);
            Assert.assertEquals((Object)clock.currentTime(), (Object)info2.estimateInfoTs);
        }
        catch (Throwable info4) {
            var16_21 = info4;
            throw info4;
        }
        finally {
            if (conn3 != null) {
                if (var16_21 != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable info4) {
                        var16_21.addSuppressed(info4);
                    }
                } else {
                    conn3.close();
                }
            }
        }
        conn3 = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant3);
        var16_21 = null;
        try {
            sql = "SELECT * FROM " + tenant3View;
            info2 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn3, sql, binds);
            Assert.assertEquals((Object)443L, (Object)info2.estimatedBytes);
            Assert.assertEquals((Object)6L, (Object)info2.estimatedRows);
            Assert.assertEquals((Object)clock.currentTime(), (Object)info2.estimateInfoTs);
        }
        catch (Throwable info5) {
            var16_21 = info5;
            throw info5;
        }
        finally {
            if (conn3 != null) {
                if (var16_21 != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable info5) {
                        var16_21.addSuppressed(info5);
                    }
                } else {
                    conn3.close();
                }
            }
        }
        long prevGuidePostTimestamp = clock.currentTime();
        clock.advanceTime(1000L);
        try {
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant2);
            throwable = null;
            try {
                clock.setAdvance(false);
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (11, 11, 11)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (12, 12, 12)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (13, 13, 13)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (14, 14, 14)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (15, 15, 15)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant2View + " VALUES (16, 16, 16)");
                conn.commit();
                conn.createStatement().executeUpdate("UPDATE STATISTICS " + tenant2View);
                sql = "SELECT * FROM " + tenant2View;
                info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Collections.emptyList());
                Assert.assertTrue((info6.estimatedBytes > prevTenantBytes ? 1 : 0) != 0);
                Assert.assertEquals((Object)8L, (Object)info6.estimatedRows);
                Assert.assertEquals((Object)clock.currentTime(), (Object)info6.estimateInfoTs);
            }
            catch (Throwable info6) {
                throwable = info6;
                throw info6;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable info6) {
                            throwable.addSuppressed(info6);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant1);
        throwable = null;
        try {
            sql = "SELECT * FROM " + tenant1View;
            info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)119L, (Object)info6.estimatedBytes);
            Assert.assertEquals((Object)2L, (Object)info6.estimatedRows);
            Assert.assertNull((Object)info6.estimateInfoTs);
        }
        catch (Throwable info7) {
            throwable = info7;
            throw info7;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable info7) {
                        throwable.addSuppressed(info7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant3);
        throwable = null;
        try {
            sql = "SELECT * FROM " + tenant3View;
            info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)443L, (Object)info6.estimatedBytes);
            Assert.assertEquals((Object)6L, (Object)info6.estimatedRows);
            Assert.assertEquals((Object)prevGuidePostTimestamp, (Object)info6.estimateInfoTs);
        }
        catch (Throwable info8) {
            throwable = info8;
            throw info8;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable info8) {
                        throwable.addSuppressed(info8);
                    }
                } else {
                    conn.close();
                }
            }
        }
        binds.clear();
        binds.add("tenant0");
        conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());
        throwable = null;
        try {
            sql = "SELECT * FROM " + multiTenantBaseTable + " WHERE ORGID >= ?";
            info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)1167L, (Object)info6.estimatedBytes);
            Assert.assertEquals((Object)16L, (Object)info6.estimatedRows);
            Assert.assertNull((Object)info6.estimateInfoTs);
        }
        catch (Throwable info9) {
            throwable = info9;
            throw info9;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable info9) {
                        throwable.addSuppressed(info9);
                    }
                } else {
                    conn.close();
                }
            }
        }
        binds.clear();
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant4);
        throwable = null;
        try {
            sql = "SELECT * FROM " + tenant4View;
            info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            prevTenantBytes = 0L;
            Assert.assertEquals((Object)0L, (Object)info6.estimatedBytes);
            Assert.assertEquals((Object)0L, (Object)info6.estimatedRows);
            Assert.assertNull((Object)info6.estimateInfoTs);
        }
        catch (Throwable info10) {
            throwable = info10;
            throw info10;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable info10) {
                        throwable.addSuppressed(info10);
                    }
                } else {
                    conn.close();
                }
            }
        }
        clock.advanceTime(1000L);
        try {
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant4);
            throwable = null;
            try {
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant4View + " VALUES (6, 17,17)");
                conn.createStatement().executeUpdate("UPSERT INTO " + tenant4View + " VALUES (7, 17,17)");
                conn.commit();
                conn.createStatement().executeUpdate("UPDATE STATISTICS " + tenant4View);
                sql = "SELECT * FROM " + tenant4View;
                info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Collections.emptyList());
                Assert.assertTrue((info6.estimatedBytes > prevTenantBytes ? 1 : 0) != 0);
                Assert.assertEquals((Object)119L, (Object)info6.estimatedBytes);
                Assert.assertEquals((Object)2L, (Object)info6.estimatedRows);
                Assert.assertEquals((Object)clock.currentTime(), (Object)info6.estimateInfoTs);
                sql = "SELECT * FROM " + tenant4View + " WHERE pk2 >= 6";
                info6 = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, Collections.emptyList());
                Assert.assertEquals((Object)119L, (Object)info6.estimatedBytes);
                Assert.assertEquals((Object)2L, (Object)info6.estimatedRows);
                Assert.assertEquals((Object)clock.currentTime(), (Object)info6.estimateInfoTs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testEstimatesForAggregateQueries() throws Exception {
        String tableName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            int guidePostWidth = 20;
            String ddl = "CREATE TABLE " + tableName + " (k INTEGER PRIMARY KEY, a bigint, b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth + " SPLIT ON (102, 105, 108)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("upsert into " + tableName + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + tableName + " values (101,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (102,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (103,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (104,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (105,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (106,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (107,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (108,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (109,2,4)");
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + tableName + "");
        }
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            String sql = "SELECT COUNT(*)  FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertEquals((long)11L, (long)((List)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getScans().get(0)).size());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET USE_STATS_FOR_PARALLELIZATION = " + false);
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertEquals((long)4L, (long)((List)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getScans().get(0)).size());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            String viewName = "V_" + ExplainPlanWithStatsEnabledIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName + " USE_STATS_FOR_PARALLELIZATION = false");
            sql = "SELECT COUNT(*) FROM " + viewName;
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertEquals((long)4L, (long)((List)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getScans().get(0)).size());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET USE_STATS_FOR_PARALLELIZATION=true");
            sql = "SELECT COUNT(*) FROM " + tableName;
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertEquals((long)11L, (long)((List)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getScans().get(0)).size());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            conn.createStatement().execute("ALTER VIEW " + viewName + " SET USE_STATS_FOR_PARALLELIZATION=true");
            sql = "SELECT COUNT(*) FROM " + viewName;
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertEquals((long)11L, (long)((List)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getScans().get(0)).size());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectQueriesWithStatsForParallelizationOff() throws Exception {
        this.testSelectQueriesWithFilters(false);
    }

    @Test
    public void testSelectQueriesWithStatsForParallelizationOn() throws Exception {
        this.testSelectQueriesWithFilters(true);
    }

    private void testSelectQueriesWithFilters(boolean useStatsForParallelization) throws Exception {
        String tableName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            int guidePostWidth = 20;
            String ddl = "CREATE TABLE " + tableName + " (k INTEGER PRIMARY KEY, a bigint, b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth + ", USE_STATS_FOR_PARALLELIZATION=" + useStatsForParallelization + " SPLIT ON (102, 105, 108)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("upsert into " + tableName + " values (100,100,3)");
            conn.createStatement().execute("upsert into " + tableName + " values (101,101,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (102,102,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (103,103,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (104,104,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (105,105,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (106,106,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (107,107,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (108,108,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (109,109,4)");
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + tableName + "");
        }
        ArrayList binds = Lists.newArrayList();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            String sql = "SELECT a FROM " + tableName + " WHERE K >= 99";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            int i = 0;
            int numRows = 10;
            while (rs.next()) {
                Assert.assertEquals((long)(100 + i), (long)rs.getInt(1));
                ++i;
            }
            Assert.assertEquals((long)numRows, (long)i);
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)720L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K >= 110";
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 98";
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 110";
            rs = conn.createStatement().executeQuery(sql);
            i = 0;
            numRows = 10;
            while (rs.next()) {
                Assert.assertEquals((long)(100 + i), (long)rs.getInt(1));
                ++i;
            }
            Assert.assertEquals((long)numRows, (long)i);
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)720L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 90 AND K >= 80";
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 130 AND K >= 120";
            rs = conn.createStatement().executeQuery(sql);
            Assert.assertFalse((boolean)rs.next());
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)0L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 102 AND K >= 90";
            rs = conn.createStatement().executeQuery(sql);
            i = 0;
            numRows = 3;
            while (rs.next()) {
                Assert.assertEquals((long)(100 + i), (long)rs.getInt(1));
                ++i;
            }
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)3L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)160L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 120 AND K >= 100";
            rs = conn.createStatement().executeQuery(sql);
            i = 0;
            numRows = 10;
            while (rs.next()) {
                Assert.assertEquals((long)(100 + i), (long)rs.getInt(1));
                ++i;
            }
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)720L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
            sql = "SELECT a FROM " + tableName + " WHERE K <= 109 AND K >= 100";
            rs = conn.createStatement().executeQuery(sql);
            i = 0;
            numRows = 10;
            while (rs.next()) {
                Assert.assertEquals((long)(100 + i), (long)rs.getInt(1));
                ++i;
            }
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertEquals((Object)720L, (Object)info.getEstimatedBytes());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createMultitenantTableAndViews(String tenant1View, String tenant2View, String tenant3View, String tenant4View, String tenant1, String tenant2, String tenant3, String tenant4, String multiTenantTable, MyClock clock) throws Exception {
        byte[][] splits = new byte[][]{ByteUtil.concat((byte[])Bytes.toBytes((String)tenant1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)1)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenant2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)1)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenant3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)1)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenant4), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)6)})};
        String ddl = "CREATE TABLE " + multiTenantTable + " (orgId CHAR(7) NOT NULL, pk2 integer NOT NULL, c1.a bigint, c2.b bigint CONSTRAINT PK PRIMARY KEY (ORGID, PK2)) MULTI_TENANT=true, GUIDE_POSTS_WIDTH=2";
        try {
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
            try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
                PreparedStatement stmt = conn.prepareStatement(ddl + " SPLIT ON (?,?,?,?)");
                for (int i = 0; i < splits.length; ++i) {
                    stmt.setBytes(i + 1, splits[i]);
                }
                stmt.executeUpdate();
                clock.advanceTime(1000L);
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant1 + "',1,1,1)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant1 + "',2,2,2)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant2 + "',1,3,3)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant2 + "',2,4,4)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',1,5,5)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',2,6,6)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',3,7,7)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',4,8,8)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',5,9,9)");
                conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenant3 + "',6,10,10)");
                conn.commit();
            }
            clock.setAdvance(false);
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant1);
            var13_13 = null;
            try {
                conn.createStatement().execute("CREATE VIEW " + tenant1View + " AS SELECT * FROM " + multiTenantTable);
                conn.createStatement().execute("UPDATE STATISTICS " + tenant1View);
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var13_13 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant2);
            var13_13 = null;
            try {
                conn.createStatement().execute("CREATE VIEW " + tenant2View + " AS SELECT * FROM " + multiTenantTable);
                conn.createStatement().execute("UPDATE STATISTICS " + tenant2View);
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var13_13 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant3);
            var13_13 = null;
            try {
                conn.createStatement().execute("CREATE VIEW " + tenant3View + " AS SELECT * FROM " + multiTenantTable);
                conn.createStatement().execute("UPDATE STATISTICS " + tenant3View);
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var13_13 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenant4);
            var13_13 = null;
            try {
                conn.createStatement().execute("CREATE VIEW " + tenant4View + " AS SELECT * FROM " + multiTenantTable);
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var13_13 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testPartialStatsForTenantViews() throws Exception {
        Throwable throwable;
        String tenant1View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenant2View = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String multiTenantTable = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenantId1 = "00Dabcdetenant1";
        String tenantId2 = "00Dabcdetenant2";
        String ddl = "CREATE TABLE " + multiTenantTable + " (orgId CHAR(15) NOT NULL, pk2 CHAR(3) NOT NULL, a bigint, b bigint CONSTRAINT PK PRIMARY KEY (ORGID, PK2)) MULTI_TENANT=true, GUIDE_POSTS_WIDTH=20";
        ExplainPlanWithStatsEnabledIT.createTestTable(ExplainPlanWithStatsEnabledIT.getUrl(), ddl, null, null);
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            throwable = null;
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                byte[] splitKey = Bytes.toBytes((String)"00Dabcdetenant200B");
                admin.split(TableName.valueOf((String)multiTenantTable), splitKey);
            }
            catch (Throwable splitKey) {
                throwable = splitKey;
                throw splitKey;
            }
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId1 + "','00A',1,1)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId1 + "','00B',2,2)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00A',3,3)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00B',4,4)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00C',5,5)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00D',6,6)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00E',7,7)");
            conn.createStatement().execute("upsert into " + multiTenantTable + " values ('" + tenantId2 + "','00F',8,8)");
            conn.commit();
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenantId1);
        var8_8 = null;
        try {
            conn.createStatement().execute("CREATE VIEW " + tenant1View + " AS SELECT * FROM " + multiTenantTable);
        }
        catch (Throwable admin) {
            var8_8 = admin;
            throw admin;
        }
        finally {
            if (conn != null) {
                if (var8_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable admin) {
                        var8_8.addSuppressed(admin);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenantId2);
        var8_8 = null;
        try {
            conn.createStatement().execute("CREATE VIEW " + tenant2View + " AS SELECT * FROM " + multiTenantTable);
        }
        catch (Throwable admin) {
            var8_8 = admin;
            throw admin;
        }
        finally {
            if (conn != null) {
                if (var8_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable admin) {
                        var8_8.addSuppressed(admin);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String sql = "";
        ArrayList binds = Lists.newArrayList();
        throwable = null;
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            String disableCompaction = "ALTER TABLE " + multiTenantTable + " SET COMPACTION_ENABLED = false";
            conn.createStatement().executeUpdate(disableCompaction);
            String delete = "DELETE FROM SYSTEM.STATS WHERE PHYSICAL_NAME = '" + multiTenantTable + "'";
            conn.createStatement().executeUpdate(delete);
            conn.commit();
            conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
        }
        catch (Throwable disableCompaction) {
            throwable = disableCompaction;
            throw disableCompaction;
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenantId1);
        throwable = null;
        try {
            conn.createStatement().execute("UPDATE STATISTICS " + tenant1View);
        }
        catch (Throwable disableCompaction) {
            throwable = disableCompaction;
            throw disableCompaction;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable disableCompaction) {
                        throwable.addSuppressed(disableCompaction);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = ExplainPlanWithStatsEnabledIT.getTenantConnection(tenantId2);
        throwable = null;
        try {
            sql = "SELECT * FROM " + tenant2View;
            Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)1L, (Object)info.estimatedRows);
            conn.createStatement().execute("UPDATE STATISTICS " + tenant2View);
            info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)6L, (Object)info.estimatedRows);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testIndexesUseStatsIfOnForParentTable() throws Exception {
        this.testIndexesInheritUseStatsPropFromParentTable(true);
    }

    @Test
    public void testIndexesDontUseStatsIfOffForParentTable() throws Exception {
        this.testIndexesInheritUseStatsPropFromParentTable(false);
    }

    private void testIndexesInheritUseStatsPropFromParentTable(boolean useStats) throws Exception {
        String baseTable = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            String ddl = "CREATE TABLE " + baseTable + " (k INTEGER PRIMARY KEY, a bigint, b bigint, c bigint) GUIDE_POSTS_WIDTH=20, USE_STATS_FOR_PARALLELIZATION=" + useStats;
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("upsert into " + baseTable + " values (100,1,1,1)");
            conn.createStatement().execute("upsert into " + baseTable + " values (101,2,2,2)");
            conn.createStatement().execute("upsert into " + baseTable + " values (102,3,3,3)");
            conn.createStatement().execute("upsert into " + baseTable + " values (103,4,4,4)");
            conn.createStatement().execute("upsert into " + baseTable + " values (104,5,5,5)");
            conn.createStatement().execute("upsert into " + baseTable + " values (105,6,6,6)");
            conn.createStatement().execute("upsert into " + baseTable + " values (106,7,7,7)");
            conn.createStatement().execute("upsert into " + baseTable + " values (107,8,8,8)");
            conn.createStatement().execute("upsert into " + baseTable + " values (108,9,9,9)");
            conn.createStatement().execute("upsert into " + baseTable + " values (109,10,10,10)");
            conn.commit();
            String globalIndex = "GI_" + ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE INDEX " + globalIndex + " ON " + baseTable + " (a) INCLUDE (b) ";
            conn.createStatement().execute(ddl);
            String localIndex = "LI_" + ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + baseTable + " (b) INCLUDE (c) ";
            conn.createStatement().execute(ddl);
            String view = "V_" + ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE VIEW " + view + " AS SELECT * FROM " + baseTable + " USE_STATS_FOR_PARALLELIZATION=" + useStats;
            conn.createStatement().execute(ddl);
            String viewIndex = "VI_" + ExplainPlanWithStatsEnabledIT.generateUniqueName();
            ddl = "CREATE INDEX " + viewIndex + " ON " + view + " (b)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPDATE STATISTICS " + baseTable);
            String query = "SELECT /*+ NO_INDEX */ COUNT(*) FROM " + baseTable;
            PhoenixResultSet rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)baseTable, (Object)rs.getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            query = "SELECT B FROM " + baseTable + " WHERE A > 0";
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)globalIndex, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            query = "SELECT C FROM " + baseTable + " WHERE B > 0";
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)localIndex, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            query = "SELECT * FROM " + view;
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)view, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            query = "SELECT 1 FROM " + view + " WHERE B > 0";
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)viewIndex, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            conn.createStatement().execute("ALTER VIEW " + view + " SET USE_STATS_FOR_PARALLELIZATION=" + !useStats);
            query = "SELECT * FROM " + view;
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)view, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(!useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
            query = "SELECT 1 FROM " + view + " WHERE B > 0";
            rs = conn.createStatement().executeQuery(query).unwrap(PhoenixResultSet.class);
            Assert.assertEquals((Object)viewIndex, (Object)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)(!useStats ? 11L : 1L), (long)((List)((PhoenixResultSet)rs.unwrap(PhoenixResultSet.class)).getStatement().getQueryPlan().getScans().get(0)).size());
        }
    }

    @Test
    public void testQueryingWithUseStatsForParallelizationOnOff() throws SQLException {
        this.testUseStatsForParallelizationOnSaltedTable(true, true);
        this.testUseStatsForParallelizationOnSaltedTable(true, false);
        this.testUseStatsForParallelizationOnSaltedTable(false, true);
        this.testUseStatsForParallelizationOnSaltedTable(false, false);
    }

    private void testUseStatsForParallelizationOnSaltedTable(boolean useStatsFlag, boolean salted) throws SQLException {
        String tableName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());
        conn.createStatement().execute("create table " + tableName + "(k varchar not null primary key, v varchar) " + (salted ? " SALT_BUCKETS=2," : "") + " USE_STATS_FOR_PARALLELIZATION=" + useStatsFlag);
        conn.createStatement().execute("upsert into " + tableName + " values ('1', 'B')");
        conn.createStatement().execute("upsert into " + tableName + " values ('2', 'A')");
        conn.commit();
        String query = "SELECT V FROM " + tableName + " ORDER BY V";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"A", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"B", (Object)rs.getString(1));
        conn.createStatement().execute("UPDATE STATISTICS " + tableName);
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"A", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"B", (Object)rs.getString(1));
    }

    @Test
    public void testUseStatsForParallelizationProperyOnViewIndex() throws SQLException {
        String tableName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String viewName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String tenantViewName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        String viewIndexName = ExplainPlanWithStatsEnabledIT.generateUniqueName();
        boolean useStats = false;
        try (Connection conn = DriverManager.getConnection(ExplainPlanWithStatsEnabledIT.getUrl());){
            conn.createStatement().execute("create table " + tableName + "(tenantId CHAR(15) NOT NULL, pk1 integer NOT NULL, v varchar CONSTRAINT PK PRIMARY KEY (tenantId, pk1)) MULTI_TENANT=true");
            try (Connection tenantConn = ExplainPlanWithStatsEnabledIT.getTenantConnection("tenant1");){
                conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
                conn.createStatement().execute("CREATE INDEX " + viewIndexName + " on " + viewName + " (v) ");
                tenantConn.createStatement().execute("CREATE VIEW " + tenantViewName + " AS SELECT * FROM " + viewName);
                conn.createStatement().execute("ALTER TABLE " + tableName + " set USE_STATS_FOR_PARALLELIZATION=" + useStats);
                this.validatePropertyOnViewIndex(viewName, viewIndexName, useStats, conn, tenantConn);
            }
        }
    }

    private void validatePropertyOnViewIndex(String viewName, String viewIndexName, boolean useStats, Connection conn, Connection tenantConn) throws SQLException, TableNotFoundException {
        tenantConn.unwrap(PhoenixConnection.class).getTableNoCache(viewName);
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        PTable viewIndex = phxConn.getTable(new PTableKey(phxConn.getTenantId(), viewIndexName));
        Assert.assertEquals((String)"USE_STATS_FOR_PARALLELIZATION property set incorrectly", (Object)useStats, (Object)ScanUtil.getStatsForParallelizationProp((PhoenixConnection)tenantConn.unwrap(PhoenixConnection.class), (PTable)viewIndex));
    }

    private static class MyClock
    extends EnvironmentEdge {
        public volatile long time;
        private boolean shouldAdvance = true;

        public MyClock(long time) {
            this.time = time;
        }

        public long currentTime() {
            if (this.shouldAdvance) {
                return this.time++;
            }
            return this.time;
        }

        public void setAdvance(boolean val) {
            this.shouldAdvance = val;
        }

        public void advanceTime(long t) {
            this.time += t;
        }
    }

    public static class Estimate {
        final Long estimatedBytes;
        final Long estimatedRows;
        final Long estimateInfoTs;

        public Long getEstimatedBytes() {
            return this.estimatedBytes;
        }

        public Long getEstimatedRows() {
            return this.estimatedRows;
        }

        public Long getEstimateInfoTs() {
            return this.estimateInfoTs;
        }

        Estimate(Long rows, Long bytes, Long ts) {
            this.estimatedBytes = bytes;
            this.estimatedRows = rows;
            this.estimateInfoTs = ts;
        }
    }
}

