/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class EncodeFunctionIT
extends ParallelStatsDisabledIT {
    private void testEncodeHelper(Connection conn, String tableName, String colName, List<String> expectedOutputList, String sortOrder) throws Exception {
        for (int id = 0; id < expectedOutputList.size(); ++id) {
            String sql = String.format("SELECT ENCODE(%s, 'base62') FROM " + tableName + "_%s WHERE id=?", colName, sortOrder);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setInt(1, id);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((String)"Expected exactly one row to be returned ", (boolean)rs.next());
            Assert.assertEquals((String)"ENCODE returned incorrect result ", (Object)expectedOutputList.get(id), (Object)rs.getString(1));
            Assert.assertFalse((String)"Expected exactly one row to be returned ", (boolean)rs.next());
        }
    }

    private void testEncode(Connection conn, List<Object> inputList, List<String> expectedOutputList) throws Exception {
        String tableName = TestUtil.initTables(conn, "BIGINT", inputList);
        this.testEncodeHelper(conn, tableName, "pk", expectedOutputList, "ASC");
        this.testEncodeHelper(conn, tableName, "pk", expectedOutputList, "DESC");
    }

    @Test
    public void testEncode() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        this.testEncode(conn, Lists.newArrayList((Object[])new Object[]{Long.MAX_VALUE, 62, 10, 1, 0, -1, -10, -62, Long.MIN_VALUE}), Lists.newArrayList((Object[])new String[]{"AzL8n0Y58m7", "10", "A", "1", "0", "-1", "-A", "-10", "-AzL8n0Y58m8"}));
    }

    @Test
    public void testEncodeNullInput() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = TestUtil.initTables(conn, "BIGINT", Collections.singletonList(0L));
        this.testEncodeHelper(conn, tableName, "kv", Collections.singletonList(null), "ASC");
        this.testEncodeHelper(conn, tableName, "kv", Collections.singletonList(null), "DESC");
    }

    @Test
    public void testUpperCaseEncodingType() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = EncodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( pk VARCHAR(10) NOT NULL CONSTRAINT PK PRIMARY KEY (pk))";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + tableName + " (pk) VALUES (?)");
        ps.setString(1, "1");
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE pk = ENCODE(1, 'BASE62')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testNullEncodingType() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = EncodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( pk VARCHAR(10) NOT NULL CONSTRAINT PK PRIMARY KEY (pk))";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE pk = ENCODE(1, NULL)");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNullValue() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = EncodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( pk VARCHAR(10) NOT NULL, val INTEGER CONSTRAINT PK PRIMARY KEY (pk))";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + tableName + " (pk,val) VALUES (?,?)");
        ps.setString(1, "1");
        ps.setNull(2, 4);
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE(val, 'BASE62') FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        rs.getInt(1);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnsupportedEncodingType() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = EncodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( pk VARCHAR(10) NOT NULL CONSTRAINT PK PRIMARY KEY (pk))";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE pk = ENCODE(1, 'HEX')");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testInvalidEncodingType() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeFunctionIT.getUrl());
        String tableName = EncodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE some_column = ENCODE(1, 'invalidEncodingFormat')");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

