/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class EncodeBinaryFunctionIT
extends ParallelStatsDisabledIT {
    private static String testTable;
    private static final byte[] originalBytes;
    private static final String encoded48String = "48656c6c6f50686f656e6978";
    private static final String helloPhoenixString = "HelloPhoenix";
    private static final String expectedBase64Chunk = "SGVsbG9QaG9lbml4";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        testTable = EncodeBinaryFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (id INTEGER PRIMARY KEY, data VARBINARY)";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (1, ?)");
        ps.setBytes(1, originalBytes);
        ps.execute();
        PreparedStatement ps2 = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (2, X'48656c6c6f50686f656e6978')");
        ps2.execute();
        conn.commit();
        conn.close();
    }

    @Test
    public void testEncodeHex() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'HEX') FROM " + testTable + " WHERE ID=2");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)encoded48String, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMixedCaseHexDecoding() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'HEX') FROM " + testTable + " WHERE ID=2");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)encoded48String, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testEncodeBase64() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'BASE64') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)expectedBase64Chunk, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLongBase64Decoding() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        StringBuilder base64String = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            base64String.append(helloPhoenixString);
        }
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (3, ?)");
        ps.setBytes(1, base64String.toString().getBytes());
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'BASE64') FROM " + testTable + " WHERE ID=3");
        Assert.assertTrue((boolean)rs.next());
        StringBuilder expectedString = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            expectedString.append(expectedBase64Chunk);
        }
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)expectedString.toString(), (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testEncodeHBase() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'HBASE') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        String actualString = rs.getString(1);
        Assert.assertEquals((Object)helloPhoenixString, (Object)actualString);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testInvalidDecodingFormat() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        try {
            conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'INVALIDFORMAT') FROM " + testTable);
            Assert.fail((String)"Expected an exception for invalid encoding format");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testNullAndEmptyStringDecoding() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'HEX') FROM " + testTable + " WHERE ID=-10");
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (4, ?)");
        ps.setBytes(1, new byte[0]);
        ps.execute();
        conn.commit();
        ResultSet rs2 = conn.createStatement().executeQuery("SELECT ENCODE_BINARY(data, 'HEX') FROM " + testTable + " WHERE ID=4");
        Assert.assertTrue((boolean)rs2.next());
        String actualString = rs2.getString(1);
        Assert.assertEquals(null, (Object)actualString);
        Assert.assertFalse((boolean)rs2.next());
    }

    @Test
    public void testEncodeDecodeRoundHex() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(ENCODE_BINARY(data, 'HEX'), 'HEX') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        byte[] roundTripEncoded = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals(originalBytes, roundTripEncoded));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testEncodeDecodeRoundBase64() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(ENCODE_BINARY(data, 'BASE64'), 'BASE64') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        byte[] roundTripEncoded = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals(originalBytes, roundTripEncoded));
    }

    @Test
    public void testEncodeDecodeRoundHbase() throws Exception {
        Connection conn = DriverManager.getConnection(EncodeBinaryFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE_BINARY(ENCODE_BINARY(data, 'HBASE'), 'HBASE') FROM " + testTable + " WHERE ID=1");
        Assert.assertTrue((boolean)rs.next());
        byte[] roundTripEncoded = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals(originalBytes, roundTripEncoded));
        Assert.assertFalse((boolean)rs.next());
    }

    static {
        originalBytes = helloPhoenixString.getBytes();
    }
}

