/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
@SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Designed to ignore.")
public class DynamicFamilyIT
extends ParallelStatsDisabledIT {
    private static final String WEB_STATS = DynamicFamilyIT.generateUniqueName();
    private static final String WEB_STATS_SCHEMA_NAME = "";
    private static final byte[] A_CF = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"A"));
    private static final byte[] B_CF = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"B"));
    private static final String USER_ID1 = "u0001";
    private static final String USER_ID2 = "u0002";
    private static final String USER_ID3 = "u0003";
    private static final byte[] USER_ID1_BYTES = Bytes.toBytes((String)"u0001");
    private static final byte[] USER_ID2_BYTES = Bytes.toBytes((String)"u0002");
    private static final byte[] USER_ID3_BYTES = Bytes.toBytes((String)"u0003");
    private static final String MAX_CLICK_COUNT_PREFIX = SchemaUtil.normalizeIdentifier((String)"MaxClickCount_");
    private static final byte[] MAX_CLICK_COUNT_DYNCOL_PREFIX = Bytes.toBytes((String)MAX_CLICK_COUNT_PREFIX);
    private static final Integer ENTRY1_CLICK_COUNT = 12;
    private static final Integer ENTRY2_CLICK_COUNT = 34;
    private static final Integer ENTRY3_CLICK_COUNT = 56;
    private static final String LAST_LOGIN_TIME_PREFIX = SchemaUtil.normalizeIdentifier((String)"LastLoginTime_");
    private static final byte[] LAST_LOGIN_TIME_DYNCOL_PREFIX = Bytes.toBytes((String)LAST_LOGIN_TIME_PREFIX);
    private static final Time ENTRY1_USER_ID1_LOGIN_TIME = new Time(System.currentTimeMillis() + 60000L);
    private static final Time ENTRY1_USER_ID2_LOGIN_TIME = new Time(System.currentTimeMillis() + 120000L);
    private static final Time ENTRY2_USER_ID2_LOGIN_TIME = new Time(System.currentTimeMillis() + 180000L);
    private static final Time ENTRY2_USER_ID3_LOGIN_TIME = new Time(System.currentTimeMillis() + 240000L);
    private static final Time ENTRY3_USER_ID1_LOGIN_TIME = new Time(System.currentTimeMillis() + 300000L);
    private static final Time ENTRY3_USER_ID2_LOGIN_TIME = new Time(System.currentTimeMillis() + 360000L);
    private static final Time ENTRY3_USER_ID3_LOGIN_TIME = new Time(System.currentTimeMillis() + 420000L);

    @Before
    public void doBeforeTestSetup() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(DynamicFamilyIT.getUrl(), props);
        String ddl = "create table if not exists  " + WEB_STATS + "   (entry varchar not null primary key,    a.dummy varchar,    b.dummy varchar)";
        conn.createStatement().execute(ddl);
        conn.close();
        DynamicFamilyIT.initTableValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableValues() throws Exception {
        ConnectionQueryServices services = driver.getConnectionQueryServices(DynamicFamilyIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        try (Table hTable = services.getTable(SchemaUtil.getTableNameAsBytes((String)WEB_STATS_SCHEMA_NAME, (String)WEB_STATS));){
            ArrayList<Put> mutations = new ArrayList<Put>();
            Put put = new Put(Bytes.toBytes((String)"entry1"));
            put.addColumn(A_CF, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, ByteUtil.EMPTY_BYTE_ARRAY);
            put.addColumn(A_CF, ByteUtil.concat((byte[])MAX_CLICK_COUNT_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID2_BYTES}), PInteger.INSTANCE.toBytes((Object)ENTRY1_CLICK_COUNT));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID1_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY1_USER_ID1_LOGIN_TIME));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID2_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY1_USER_ID2_LOGIN_TIME));
            mutations.add(put);
            put = new Put(Bytes.toBytes((String)"entry2"));
            put.addColumn(A_CF, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, ByteUtil.EMPTY_BYTE_ARRAY);
            put.addColumn(A_CF, ByteUtil.concat((byte[])MAX_CLICK_COUNT_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID3_BYTES}), PInteger.INSTANCE.toBytes((Object)ENTRY2_CLICK_COUNT));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID2_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY2_USER_ID2_LOGIN_TIME));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID3_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY2_USER_ID3_LOGIN_TIME));
            mutations.add(put);
            put = new Put(Bytes.toBytes((String)"entry3"));
            put.addColumn(A_CF, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, ByteUtil.EMPTY_BYTE_ARRAY);
            put.addColumn(A_CF, ByteUtil.concat((byte[])MAX_CLICK_COUNT_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID1_BYTES}), PInteger.INSTANCE.toBytes((Object)ENTRY3_CLICK_COUNT));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID1_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY3_USER_ID1_LOGIN_TIME));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID2_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY3_USER_ID2_LOGIN_TIME));
            put.addColumn(B_CF, ByteUtil.concat((byte[])LAST_LOGIN_TIME_DYNCOL_PREFIX, (byte[][])new byte[][]{USER_ID3_BYTES}), PTime.INSTANCE.toBytes((Object)ENTRY3_USER_ID3_LOGIN_TIME));
            mutations.add(put);
            hTable.batch(mutations, null);
        }
    }

    private static Pair<String, Integer> getMaxClickCountValue(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i);
            if (!colName.startsWith(MAX_CLICK_COUNT_PREFIX)) continue;
            String userId = colName.substring(MAX_CLICK_COUNT_PREFIX.length());
            Integer clickCount = rs.getInt(colName);
            return new Pair((Object)userId, (Object)clickCount);
        }
        return null;
    }

    private static Time getLastLoginTimeValue(ResultSet rs, String userId) throws SQLException {
        String colName = LAST_LOGIN_TIME_PREFIX + userId;
        try {
            return rs.getTime(colName);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode()) {
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllDynColsInFamily() throws Exception {
        String query = "SELECT A.* FROM " + WEB_STATS + " WHERE entry='entry1'";
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Pair<String, Integer> maxClickCountUserIdAndValue = DynamicFamilyIT.getMaxClickCountValue(rs);
            Assert.assertEquals((Object)USER_ID2_BYTES, (Object)maxClickCountUserIdAndValue.getFirst());
            Assert.assertEquals((Object)ENTRY1_CLICK_COUNT, (Object)maxClickCountUserIdAndValue.getSecond());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllDynCols() throws Exception {
        String query = "SELECT * FROM " + WEB_STATS + "WHERE entry='entry1'";
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Pair<String, Integer> maxClickCountUserIdAndValue = DynamicFamilyIT.getMaxClickCountValue(rs);
            Assert.assertEquals((Object)USER_ID2_BYTES, (Object)maxClickCountUserIdAndValue.getFirst());
            Assert.assertEquals((Object)ENTRY1_CLICK_COUNT, (Object)maxClickCountUserIdAndValue.getSecond());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCaseInsensitiveDynCol() throws Exception {
        String query = "SELECT B.* FROM " + WEB_STATS + "(B." + LAST_LOGIN_TIME_PREFIX + USER_ID2 + " TIME,B." + LAST_LOGIN_TIME_PREFIX + USER_ID3 + " TIME) WHERE entry='entry2'";
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, USER_ID2));
            Assert.assertEquals(null, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, USER_ID3));
            Assert.assertEquals(null, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, USER_ID1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCaseSensitiveDynCol() throws Exception {
        String query = "SELECT B.* FROM " + WEB_STATS + "(B.\"" + LAST_LOGIN_TIME_PREFIX + USER_ID2 + "\" TIME,B.\"" + LAST_LOGIN_TIME_PREFIX + USER_ID3 + "\" TIME) WHERE entry='entry2'";
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ENTRY2_USER_ID2_LOGIN_TIME, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, USER_ID2));
            Assert.assertEquals((Object)ENTRY2_USER_ID3_LOGIN_TIME, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, USER_ID3));
            Assert.assertEquals(null, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, Bytes.toString((byte[])USER_ID1_BYTES)));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectStaticAndDynamic() throws Exception {
        String query = "SELECT ENTRY, A.DUMMY, B.DUMMY, A.*,B.* FROM " + WEB_STATS + " WHERE entry='entry3'";
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entry3", (Object)rs.getString(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Pair<String, Integer> clickCountUserIdAndValue = DynamicFamilyIT.getMaxClickCountValue(rs);
            Assert.assertEquals((Object)USER_ID1_BYTES, (Object)clickCountUserIdAndValue.getFirst());
            Assert.assertEquals((Object)ENTRY3_CLICK_COUNT, (Object)clickCountUserIdAndValue.getSecond());
            Assert.assertEquals((Object)ENTRY3_USER_ID1_LOGIN_TIME, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, Bytes.toString((byte[])USER_ID1_BYTES)));
            Assert.assertEquals((Object)ENTRY3_USER_ID2_LOGIN_TIME, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, Bytes.toString((byte[])USER_ID2_BYTES)));
            Assert.assertEquals((Object)ENTRY3_USER_ID3_LOGIN_TIME, (Object)DynamicFamilyIT.getLastLoginTimeValue(rs, Bytes.toString((byte[])USER_ID3_BYTES)));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ColumnFamilyNotFoundException.class)
    public void testDynamicFamilyException() throws Exception {
        String query = "SELECT C.* FROM " + WEB_STATS;
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=PhoenixParserException.class)
    public void testDynamicFamilyFunctionException() throws Exception {
        String query = "SELECT count(C.*) FROM " + WEB_STATS;
        String url = DynamicFamilyIT.getUrl() + ";";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.executeQuery();
        }
    }

    @Test
    public void testSelectEntireColumnFamily() throws Exception {
        Connection conn = DriverManager.getConnection(DynamicFamilyIT.getUrl());
        conn.setAutoCommit(true);
        String tableName = DynamicFamilyIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (Id VARCHAR NOT NULL PRIMARY KEY, COLFAM1.A VARCHAR, COLFAM1.B VARCHAR, COLFAM2.A VARCHAR )");
        conn.createStatement().execute("UPSERT INTO " + tableName + " (Id, COLFAM1.A, COLFAM1.B, COLFAM2.A) values ('row-2', '100', '200', '300')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT COLFAM1.A,COLFAM1.B FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        Assert.assertEquals((Object)"200", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT COLFAM1.* FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        Assert.assertEquals((Object)"200", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT COLFAM1.*,COLFAM1.A FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        Assert.assertEquals((Object)"200", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }
}

