/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DynamicColumnIT
extends ParallelStatsDisabledIT {
    private static final byte[] FAMILY_NAME_A = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"A"));
    private static final byte[] FAMILY_NAME_B = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"B"));
    private String tableName;

    @Before
    public void initTable() throws Exception {
        this.tableName = DynamicColumnIT.generateUniqueName();
        try (PhoenixConnection pconn = DriverManager.getConnection(DynamicColumnIT.getUrl()).unwrap(PhoenixConnection.class);){
            ConnectionQueryServices services = pconn.getQueryServices();
            try (Admin admin = services.getAdmin();){
                TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.tableName));
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES));
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME_A));
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME_B));
                admin.createTable(builder.build());
            }
            var5_7 = null;
            try (Table hTable = services.getTable(Bytes.toBytes((String)this.tableName));){
                ArrayList<Put> mutations = new ArrayList<Put>();
                byte[] dv = Bytes.toBytes((String)"DV");
                byte[] first = Bytes.toBytes((String)"F");
                byte[] f1v1 = Bytes.toBytes((String)"F1V1");
                byte[] f1v2 = Bytes.toBytes((String)"F1V2");
                byte[] f2v1 = Bytes.toBytes((String)"F2V1");
                byte[] f2v2 = Bytes.toBytes((String)"F2V2");
                byte[] key = Bytes.toBytes((String)"entry1");
                Put put = new Put(key);
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, dv, Bytes.toBytes((String)"default"));
                put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, first, Bytes.toBytes((String)"first"));
                put.addColumn(FAMILY_NAME_A, f1v1, Bytes.toBytes((String)"f1value1"));
                put.addColumn(FAMILY_NAME_A, f1v2, Bytes.toBytes((String)"f1value2"));
                put.addColumn(FAMILY_NAME_B, f2v1, Bytes.toBytes((String)"f2value1"));
                put.addColumn(FAMILY_NAME_B, f2v2, Bytes.toBytes((String)"f2value2"));
                mutations.add(put);
                hTable.batch(mutations, null);
                pconn.createStatement().execute("create table " + this.tableName + "   (entry varchar not null,    F varchar,    A.F1v1 varchar,    A.F1v2 varchar,    B.F2v1 varchar    CONSTRAINT pk PRIMARY KEY (entry)) COLUMN_ENCODED_BYTES=NONE");
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicColums() throws Exception {
        String query = "SELECT * FROM " + this.tableName + " (DV varchar)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entry1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"first", (Object)rs.getString(2));
            Assert.assertEquals((Object)"f1value1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"f1value2", (Object)rs.getString(4));
            Assert.assertEquals((Object)"f2value1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"default", (Object)rs.getString(6));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicColumsFamily() throws Exception {
        String query = "SELECT * FROM " + this.tableName + " (DV varchar,B.F2V2 varchar)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entry1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"first", (Object)rs.getString(2));
            Assert.assertEquals((Object)"f1value1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"f1value2", (Object)rs.getString(4));
            Assert.assertEquals((Object)"f2value1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"default", (Object)rs.getString(6));
            Assert.assertEquals((Object)"f2value2", (Object)rs.getString(7));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicColumsSpecificQuery() throws Exception {
        String query = "SELECT entry,F2V2 FROM " + this.tableName + " (DV varchar,B.F2V2 varchar)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"entry1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"f2value2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ColumnAlreadyExistsException.class)
    public void testAmbiguousStaticSelect() throws Exception {
        String upsertquery = "Select * FROM " + this.tableName + "(A.F1V1 INTEGER)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(upsertquery);
            statement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ColumnFamilyNotFoundException.class)
    public void testFakeCFDynamicUpsert() throws Exception {
        String upsertquery = "Select * FROM " + this.tableName + "(fakecf.DynCol VARCHAR)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(upsertquery);
            statement.executeQuery();
        }
    }

    @Test
    public void testDynamicColumnOnNewTable() throws Exception {
        String tableName = DynamicColumnIT.generateUniqueName();
        String ddl = "create table " + tableName + "   (entry varchar not null,    F varchar,    A.F1v1 varchar,    A.F1v2 varchar,    B.F2v1 varchar    CONSTRAINT pk PRIMARY KEY (entry))";
        String dml = "UPSERT INTO " + tableName + " values (?, ?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(DynamicColumnIT.getUrl());){
            ResultSet rs;
            conn.createStatement().execute(ddl);
            try (PreparedStatement stmt = conn.prepareStatement(dml);){
                stmt.setString(1, "entry");
                stmt.setString(2, "a");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setString(5, "d");
                stmt.executeUpdate();
                conn.commit();
            }
            dml = "UPSERT INTO " + tableName + "(entry, F, A.F1V1, A.F1v2, B.F2V1, DYNCOL1 VARCHAR, DYNCOL2 VARCHAR) VALUES (?, ?, ?, ?, ?, ?, ?)";
            stmt = conn.prepareStatement(dml);
            var7_9 = null;
            try {
                stmt.setString(1, "dynentry");
                stmt.setString(2, "a");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setString(5, "d");
                stmt.setString(6, "e");
                stmt.setString(7, "f");
                stmt.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var7_9 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            String query = "SELECT entry, F from " + tableName + " (DYNCOL1 VARCHAR, DYNCOL2 VARCHAR)  WHERE DYNCOL1 = ?";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, "e");
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"dynentry", (Object)rs.getString(1));
                Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            query = "SELECT entry, dyncol1, dyncol2 from " + tableName + " (DYNCOL1 VARCHAR, DYNCOL2 VARCHAR) ";
            stmt = conn.prepareStatement(query);
            var8_14 = null;
            try {
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"dynentry", (Object)rs.getString(1));
                Assert.assertEquals((Object)"e", (Object)rs.getString(2));
                Assert.assertEquals((Object)"f", (Object)rs.getString(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"entry", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var8_14 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var8_14 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var8_14.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }
}

