/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DropTableIT
extends ParallelStatsDisabledIT {
    @Test
    public void testRepeatedDropTable() throws Exception {
        String tableName = DropTableIT.generateUniqueName();
        String url = DropTableIT.getUrl();
        try (Connection conn = DriverManager.getConnection(url);
             Statement stmt = conn.createStatement();){
            Assert.assertFalse((boolean)stmt.execute(String.format("CREATE TABLE %s(pk varchar not null primary key)", tableName)));
            String dropTable = String.format("DROP TABLE IF EXISTS %s", tableName);
            for (int i = 0; i < 5; ++i) {
                Assert.assertFalse((boolean)stmt.execute(dropTable));
            }
        }
    }
}

