/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class DropSchemaIT
extends BaseTest {
    private String schema;

    public DropSchemaIT(String schema) {
        this.schema = schema;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.schema.dropMetaData", Boolean.toString(true));
        DropSchemaIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="DropSchemaIT_schema={0}")
    public static synchronized Collection<String> data() {
        return Arrays.asList(DropSchemaIT.generateUniqueName().toUpperCase(), "\"" + DropSchemaIT.generateUniqueName().toLowerCase() + "\"");
    }

    @Test
    public void testDropSchema() throws Exception {
        String tableName = DropSchemaIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        String normalizeSchemaIdentifier = SchemaUtil.normalizeIdentifier((String)this.schema);
        String ddl = "DROP SCHEMA " + this.schema;
        try (Connection conn = DriverManager.getConnection(DropSchemaIT.getUrl(), props);
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                // empty catch block
            }
            conn.createStatement().execute("CREATE SCHEMA " + this.schema);
            conn.createStatement().execute("CREATE TABLE " + this.schema + "." + tableName + "(id INTEGER PRIMARY KEY)");
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.CANNOT_MUTATE_SCHEMA.getErrorCode());
            }
            Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)normalizeSchemaIdentifier));
            conn.createStatement().execute("DROP TABLE " + this.schema + "." + tableName);
            conn.createStatement().execute(ddl);
            Assert.assertFalse((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)normalizeSchemaIdentifier));
            conn.createStatement().execute("DROP SCHEMA IF EXISTS " + this.schema);
            admin.createNamespace(NamespaceDescriptor.create((String)normalizeSchemaIdentifier).build());
            conn.createStatement().execute("DROP SCHEMA IF EXISTS " + this.schema);
            Assert.assertTrue((boolean)ClientUtil.isHBaseNamespaceAvailable((Admin)admin, (String)normalizeSchemaIdentifier));
            conn.createStatement().execute("CREATE SCHEMA " + this.schema);
            conn.createStatement().execute("DROP SCHEMA " + this.schema);
            try {
                conn.createStatement().execute("DROP SCHEMA " + this.schema);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.SCHEMA_NOT_FOUND.getErrorCode());
            }
        }
    }
}

