/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DistinctPrefixFilterIT
extends ParallelStatsDisabledIT {
    private static final String PREFIX = "SERVER DISTINCT PREFIX";
    private String testTableF;
    private String testTableV;
    private String testSeq;
    private Connection conn;

    @Before
    public void initTables() throws Exception {
        this.testTableF = DistinctPrefixFilterIT.generateUniqueName();
        this.testTableV = DistinctPrefixFilterIT.generateUniqueName();
        this.testSeq = "SEQ_" + DistinctPrefixFilterIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(DistinctPrefixFilterIT.getUrl(), props);
        this.conn.setAutoCommit(false);
        String ddl = "CREATE TABLE " + this.testTableF + "  (prefix1 INTEGER NOT NULL, prefix2 INTEGER NOT NULL, prefix3 INTEGER NOT NULL, col1 FLOAT, col2 INTEGER, CONSTRAINT pk PRIMARY KEY(prefix1, prefix2, prefix3)) DISABLE_WAL=true, IMMUTABLE_ROWS=true";
        DistinctPrefixFilterIT.createTestTable(DistinctPrefixFilterIT.getUrl(), ddl);
        ddl = "CREATE TABLE " + this.testTableV + "  (prefix1 varchar NOT NULL, prefix2 varchar NOT NULL, prefix3 INTEGER NOT NULL, col1 FLOAT, col2 INTEGER, CONSTRAINT pk PRIMARY KEY(prefix1, prefix2, prefix3)) DISABLE_WAL=true, IMMUTABLE_ROWS=true, SALT_BUCKETS=8";
        DistinctPrefixFilterIT.createTestTable(DistinctPrefixFilterIT.getUrl(), ddl);
        this.conn.prepareStatement("CREATE INDEX " + this.testTableF + "_idx ON " + this.testTableF + "(col2) DISABLE_WAL=true").execute();
        this.conn.prepareStatement("CREATE LOCAL INDEX " + this.testTableV + "_idx ON " + this.testTableV + "(col2) DISABLE_WAL=true").execute();
        this.conn.prepareStatement("CREATE SEQUENCE " + this.testSeq + " CACHE 1000").execute();
        this.insertPrefixF(1, 1);
        this.insertPrefixF(1, 2);
        this.insertPrefixF(1, 3);
        this.insertPrefixF(2, 1);
        this.insertPrefixF(2, 2);
        this.insertPrefixF(2, 3);
        this.insertPrefixF(3, 1);
        this.insertPrefixF(3, 2);
        this.insertPrefixF(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.insertPrefixF(3, Integer.MAX_VALUE);
        this.insertPrefixF(3, 3);
        this.conn.commit();
        this.insertPrefixV("1", "1");
        this.insertPrefixV("1", "2");
        this.insertPrefixV("1", "3");
        this.insertPrefixV("2", "1");
        this.insertPrefixV("2", "2");
        this.insertPrefixV("2", "3");
        this.insertPrefixV("22", "1");
        this.insertPrefixV("3", "22");
        this.insertPrefixV("3", "1");
        this.insertPrefixV("3", "2");
        this.insertPrefixV("3", "3");
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("select /*+ NO_INDEX */ count(*) from " + this.testTableV);
        Assert.assertTrue((boolean)rs.next());
        long count1 = rs.getLong(1);
        rs = this.conn.createStatement().executeQuery("select count(*) from " + this.testTableV + "_idx");
        Assert.assertTrue((boolean)rs.next());
        long count2 = rs.getLong(1);
        Assert.assertEquals((long)count1, (long)count2);
        this.multiply();
        this.multiply();
        this.multiply();
        this.multiply();
        this.multiply();
        this.multiply();
        this.multiply();
        this.multiply();
    }

    @Test
    public void testCornerCases() throws Exception {
        String testTable = DistinctPrefixFilterIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + "  (prefix1 INTEGER NOT NULL, prefix2 SMALLINT NOT NULL, prefix3 INTEGER NOT NULL, col1 FLOAT, CONSTRAINT pk PRIMARY KEY(prefix1, prefix2, prefix3))";
        DistinctPrefixFilterIT.createTestTable(DistinctPrefixFilterIT.getUrl(), ddl);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + testTable + "(prefix1, prefix2, prefix3, col1) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand())");
        stmt.setInt(1, 1);
        stmt.setInt(2, 2);
        stmt.execute();
        stmt = this.conn.prepareStatement("UPSERT INTO " + testTable + "(prefix1, prefix2, prefix3, col1) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand())");
        stmt.setInt(1, 2);
        stmt.setInt(2, Short.MAX_VALUE);
        stmt.execute();
        stmt = this.conn.prepareStatement("UPSERT INTO " + testTable + "(prefix1, prefix2, prefix3, col1) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand())");
        stmt.setInt(1, 3);
        stmt.setInt(2, 1);
        stmt.execute();
        stmt = this.conn.prepareStatement("UPSERT INTO " + testTable + "(prefix1, prefix2, prefix3, col1) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand())");
        stmt.setInt(1, 3);
        stmt.setInt(2, 2);
        stmt.execute();
        this.conn.commit();
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1 ORDER BY prefix1 DESC", 3);
        this.testSkipRange("SELECT %s DISTINCT prefix1 FROM " + testTable + " ORDER BY prefix1 DESC", 3);
        this.testSkipRange("SELECT %s DISTINCT prefix1 FROM " + testTable + " ORDER BY prefix1 DESC LIMIT 2", 2);
    }

    @Test
    public void testPlans() throws Exception {
        this.testPlan("SELECT DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (1,2)", true);
        this.testPlan("SELECT prefix1, 1, 2 FROM " + this.testTableF + " GROUP BY prefix1 HAVING prefix1 = 1", true);
        this.testPlan("SELECT prefix1 FROM " + this.testTableF + " GROUP BY prefix1, TRUNC(prefix1), TRUNC(prefix2)", true);
        this.testPlan("SELECT DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('1','2')", true);
        this.testPlan("SELECT prefix1, 1, 2 FROM " + this.testTableV + " GROUP BY prefix1 HAVING prefix1 = '1'", true);
        this.testPlan("SELECT DISTINCT SUM(prefix1) FROM " + this.testTableF + " GROUP BY prefix1", false);
        this.testCommonPlans(this.testTableF, PREFIX);
        this.testCommonPlans(this.testTableV, PREFIX);
    }

    private void testCommonPlans(String testTable, String contains) throws Exception {
        this.testPlan("SELECT DISTINCT prefix1 FROM " + testTable, true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable, true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1), COUNT(DISTINCT prefix2) FROM " + testTable, true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1), COUNT(DISTINCT (prefix1,prefix2)) FROM " + testTable, true);
        this.testPlan("SELECT COUNT(prefix1), COUNT(DISTINCT prefix1) FROM " + testTable, false);
        this.testPlan("SELECT COUNT(*) FROM (SELECT DISTINCT(prefix1) FROM " + testTable + ")", true);
        this.testPlan("SELECT /*+ RANGE_SCAN */ DISTINCT prefix1 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT prefix1, prefix2 FROM " + testTable, true);
        this.testPlan("SELECT DISTINCT prefix1, prefix2, prefix3 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT (prefix1, prefix2, prefix3) FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT prefix1, prefix2, col1, prefix3 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT prefix1, prefix2, col1 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT col1, prefix1, prefix2 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT col1 FROM " + testTable, false);
        this.testPlan("SELECT COUNT(DISTINCT col1) FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT col2 FROM " + testTable, true);
        this.testPlan("SELECT COUNT(DISTINCT col2) FROM " + testTable, true);
        this.testPlan("SELECT prefix1 FROM " + testTable + " GROUP BY prefix1", true);
        this.testPlan("SELECT COUNT(prefix1) FROM (SELECT prefix1 FROM " + testTable + " GROUP BY prefix1)", true);
        this.testPlan("SELECT prefix1, count(*) FROM " + testTable + " GROUP BY prefix1", false);
        this.testPlan("SELECT prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2", true);
        this.testPlan("SELECT prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2, prefix3", false);
        this.testPlan("SELECT (prefix1, prefix2, prefix3) FROM " + testTable + " GROUP BY (prefix1, prefix2, prefix3)", false);
        this.testPlan("SELECT prefix1, 1, 2 FROM " + testTable + " GROUP BY prefix1", true);
        this.testPlan("SELECT prefix1 FROM " + testTable + " GROUP BY prefix1, col1", false);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " HAVING COUNT(col1) > 10", false);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " ORDER BY COUNT(col1)", true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " ORDER BY COUNT(prefix1)", true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " ORDER BY COUNT(prefix2)", true);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " HAVING COUNT(DISTINCT prefix2) > 10", false);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) FROM " + testTable + " HAVING COUNT(DISTINCT prefix1) > 10", false);
        this.testPlan("SELECT COUNT(DISTINCT prefix1) / 10 FROM " + testTable, false);
        this.testPlan("SELECT DISTINCT prefix1, prefix2 FROM " + testTable + " WHERE col1 > 0.5", false);
    }

    private void testPlan(String query, boolean optimizable) throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("EXPLAIN " + query);
        Assert.assertEquals((Object)optimizable, (Object)QueryUtil.getExplainPlan((ResultSet)rs).contains(PREFIX));
    }

    @Test
    public void testGroupBy() throws Exception {
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " GROUP BY prefix1, prefix2 HAVING prefix1 IN (1,2)", 6);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " GROUP BY prefix1, prefix2 HAVING prefix1 IN (1,2) AND prefix2 IN (1,2)", 4);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " GROUP BY prefix1, prefix2 HAVING prefix2 = 2", 3);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " GROUP BY prefix1, prefix2 HAVING prefix2 = 2147483647", 2);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " GROUP BY prefix1, prefix2 HAVING prefix1 = 2147483647", 1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " WHERE col1 > 0.99 GROUP BY prefix1, prefix2 HAVING prefix2 = 2", -1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableF + " WHERE col1 >=0 and col2 > 990 GROUP BY prefix1, prefix2 HAVING prefix2 = 2", -1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " GROUP BY prefix1, prefix2 HAVING prefix1 IN ('1','2')", 6);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " GROUP BY prefix1, prefix2 HAVING prefix1 IN ('1','2') AND prefix2 IN ('1','2')", 4);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " GROUP BY prefix1, prefix2 HAVING prefix2 = '2'", 3);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " GROUP BY prefix1, prefix2 HAVING prefix2 = '22'", 1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " GROUP BY prefix1, prefix2 HAVING prefix1 = '22'", 1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " WHERE col1 > 0.99 GROUP BY prefix1, prefix2 HAVING prefix2 = '2'", -1);
        this.testSkipRange("SELECT %s prefix1 FROM " + this.testTableV + " WHERE col1 >= 0 and col2 > 990 GROUP BY prefix1, prefix2 HAVING prefix2 = '2'", -1);
        this.testCommonGroupBy(this.testTableF);
        this.testCommonGroupBy(this.testTableV);
    }

    private void testCommonGroupBy(String testTable) throws Exception {
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1", 4);
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1 ORDER BY prefix1 DESC", 4);
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2", 11);
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2 ORDER BY prefix1 DESC", 11);
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2 ORDER BY prefix2 DESC", 11);
        this.testSkipRange("SELECT %s prefix1 FROM " + testTable + " GROUP BY prefix1, prefix2 ORDER BY prefix1, prefix2 DESC", 11);
    }

    @Test
    public void testDistinct() throws Exception {
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (1,2)", 6);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (3,2147483647)", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (3,2147483647) ORDER BY prefix1 DESC", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (3,2147483647) ORDER BY prefix2 DESC", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE prefix1 IN (2147483647,2147483647)", 1);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableF + " WHERE col1 > 0.99 AND prefix1 IN (1,2)", -1);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1), COUNT(DISTINCT (prefix1, prefix2)) FROM " + this.testTableF + " WHERE prefix2=2", 3, 3);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1), COUNT(DISTINCT (prefix1, prefix2)) FROM " + this.testTableF + " WHERE prefix1=2", 1, 3);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('1','2')", 6);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('3','22')", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('3','22') ORDER BY prefix1 DESC", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('3','22') ORDER BY prefix2 DESC", 5);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE prefix1 IN ('2','22')", 4);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + this.testTableV + " WHERE col1 > 0.99 AND prefix1 IN ('1','2')", -1);
        this.testCommonDistinct(this.testTableF);
        this.testCommonDistinct(this.testTableV);
    }

    private void testCommonDistinct(String testTable) throws Exception {
        this.testSkipRange("SELECT %s DISTINCT prefix1 FROM " + testTable, 4);
        this.testSkipRange("SELECT %s DISTINCT prefix1 FROM " + testTable + " ORDER BY prefix1 DESC", 4);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable, 11);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " ORDER BY prefix1 DESC", 11);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " ORDER BY prefix2 DESC", 11);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " ORDER BY prefix1, prefix2 DESC", 11);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " WHERE col1 > 0.99", -1);
        this.testSkipRange("SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " WHERE col1 > 0.99 ORDER BY prefix1, prefix2 DESC", -1);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1) FROM " + testTable, 4);
        this.testCount("SELECT COUNT(*) FROM (SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + ")", 11);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1) FROM " + testTable + " WHERE col1 > 0.99", -1);
        this.testCount("SELECT COUNT(*) FROM (SELECT %s DISTINCT prefix1, prefix2 FROM " + testTable + " WHERE col1 > 0.99)", -1);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1), COUNT(DISTINCT prefix2) FROM " + testTable, 4, 4);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1), COUNT(DISTINCT (prefix1, prefix2)) FROM " + testTable, 4, 11);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1), COUNT(DISTINCT (prefix1, prefix2)) FROM " + testTable + " WHERE col1 > 0.99", -1, -1);
        this.testCount("SELECT %s COUNT(DISTINCT col1) FROM " + testTable, -1);
        this.testCount("SELECT %s COUNT(DISTINCT col2) FROM " + testTable, -1);
        this.testCount("SELECT %s COUNT(DISTINCT prefix1) FROM " + testTable + " WHERE col1 < 0", -1);
    }

    @Test
    public void testRVC() throws Exception {
        int count = 0;
        ResultSet res1 = this.conn.createStatement().executeQuery("SELECT (prefix1, prefix2) FROM " + this.testTableF + " GROUP BY (prefix1, prefix2)");
        ResultSet res2 = this.conn.createStatement().executeQuery("SELECT /*+ RANGE_SCAN */ (prefix1, prefix2) FROM " + this.testTableF + " GROUP BY (prefix1, prefix2)");
        ResultSet res3 = this.conn.createStatement().executeQuery("SELECT DISTINCT(prefix1, prefix2) FROM " + this.testTableF);
        ResultSet res4 = this.conn.createStatement().executeQuery("SELECT /*+ RANGE_SCAN */ DISTINCT(prefix1, prefix2) FROM " + this.testTableF);
        while (res1.next()) {
            byte[] r1 = res1.getBytes(1);
            Assert.assertTrue((boolean)res2.next());
            byte[] r2 = res2.getBytes(1);
            Assert.assertArrayEquals((byte[])r1, (byte[])r2);
            Assert.assertTrue((boolean)res3.next());
            byte[] r3 = res3.getBytes(1);
            Assert.assertArrayEquals((byte[])r1, (byte[])r3);
            Assert.assertTrue((boolean)res4.next());
            byte[] r4 = res4.getBytes(1);
            Assert.assertArrayEquals((byte[])r1, (byte[])r4);
            ++count;
        }
        Assert.assertFalse((boolean)res2.next());
        Assert.assertFalse((boolean)res3.next());
        Assert.assertFalse((boolean)res4.next());
        Assert.assertEquals((long)11L, (long)count);
    }

    private void testSkipRange(String q, int expected) throws SQLException {
        String q1 = String.format(q, "");
        PreparedStatement stmt = this.conn.prepareStatement(q1);
        ResultSet res = stmt.executeQuery();
        int count = 0;
        while (res.next()) {
            ++count;
        }
        if (expected > 0) {
            Assert.assertEquals((long)expected, (long)count);
        }
        q1 = String.format(q, "/*+ RANGE_SCAN */");
        stmt = this.conn.prepareStatement(q1);
        res = stmt.executeQuery();
        int count1 = 0;
        while (res.next()) {
            ++count1;
        }
        Assert.assertEquals((long)count, (long)count1);
    }

    private void testCount(String q, int ... expected) throws SQLException {
        int i;
        String q1 = String.format(q, "");
        PreparedStatement stmt = this.conn.prepareStatement(q1);
        ResultSet res = stmt.executeQuery();
        int[] count = new int[expected.length];
        Assert.assertTrue((boolean)res.next());
        for (i = 0; i < expected.length; ++i) {
            count[i] = res.getInt(i + 1);
            if (expected[i] <= 0) continue;
            Assert.assertEquals((long)expected[i], (long)count[i]);
        }
        Assert.assertFalse((boolean)res.next());
        q1 = String.format(q, "/*+ RANGE_SCAN */");
        stmt = this.conn.prepareStatement(q1);
        res = stmt.executeQuery();
        Assert.assertTrue((boolean)res.next());
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)count[i], (long)res.getInt(i + 1));
        }
        Assert.assertFalse((boolean)res.next());
    }

    private void insertPrefixF(int prefix1, int prefix2) throws SQLException {
        String query = "UPSERT INTO " + this.testTableF + "(prefix1, prefix2, prefix3, col1, col2) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand(), trunc(rand()*1000))";
        PreparedStatement stmt = this.conn.prepareStatement(query);
        stmt.setInt(1, prefix1);
        stmt.setInt(2, prefix2);
        stmt.execute();
    }

    private void insertPrefixV(String prefix1, String prefix2) throws SQLException {
        String query = "UPSERT INTO " + this.testTableV + "(prefix1, prefix2, prefix3, col1, col2) VALUES(?,?,NEXT VALUE FOR " + this.testSeq + ",rand(), trunc(rand()*1000))";
        PreparedStatement stmt = this.conn.prepareStatement(query);
        stmt.setString(1, prefix1);
        stmt.setString(2, prefix2);
        stmt.execute();
    }

    private void multiply() throws SQLException {
        this.conn.prepareStatement("UPSERT INTO " + this.testTableF + " SELECT prefix1,prefix2,NEXT VALUE FOR " + this.testSeq + ",rand(), trunc(rand()*1000) FROM " + this.testTableF).execute();
        this.conn.prepareStatement("UPSERT INTO " + this.testTableV + " SELECT prefix1,prefix2,NEXT VALUE FOR " + this.testSeq + ",rand(), trunc(rand()*1000) FROM " + this.testTableV).execute();
        this.conn.commit();
    }
}

