/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DisableLocalIndexIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledLocalIndexes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.index.allowLocalIndex", Boolean.FALSE.toString());
        Connection conn = DriverManager.getConnection(DisableLocalIndexIT.getUrl(), props);
        conn.setAutoCommit(true);
        String baseName = DisableLocalIndexIT.generateUniqueName();
        String tableName = baseName + "_TABLE";
        String viewName = baseName + "_VIEW";
        String indexName1 = baseName + "_INDEX1";
        String indexName2 = baseName + "_INDEX2";
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2)) MULTI_TENANT=true");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('t1','x')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('t2','y')");
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        Assert.assertFalse((boolean)admin.tableExists(TableName.valueOf((String)("_LOCAL_IDX_" + tableName))));
        admin.close();
        try {
            Table t = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)("_LOCAL_IDX_" + tableName)));
            t.getDescriptor();
            Assert.fail((String)"Local index table should not have been created");
        }
        catch (TableNotFoundException t) {
        }
        finally {
            admin.close();
        }
        Properties tsconnProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tsconnProps.setProperty("phoenix.index.allowLocalIndex", Boolean.FALSE.toString());
        tsconnProps.setProperty("TenantId", "t1");
        Connection tsconn = DriverManager.getConnection(DisableLocalIndexIT.getUrl(), tsconnProps);
        tsconn.createStatement().execute("CREATE VIEW " + viewName + "(V1 VARCHAR) AS SELECT * FROM " + tableName);
        tsconn.createStatement().execute("CREATE INDEX " + indexName1 + " ON " + viewName + "(V1)");
        tsconn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)("_IDX_" + tableName)));
        try {
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName2 + " ON " + tableName + "(k2)");
            Assert.fail((String)"Should not allow creation of local index");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.UNALLOWED_LOCAL_INDEXES.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            tsconn.createStatement().execute("CREATE LOCAL INDEX " + indexName2 + " ON " + viewName + "(k2, v1)");
            Assert.fail((String)"Should not allow creation of local index");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.UNALLOWED_LOCAL_INDEXES.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

