/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DefaultColumnValueIT
extends ParallelStatsDisabledIT {
    private String sharedTable1;
    private String sharedTable2;
    private String DEFAULT_CURRENCY_SYMBOL = DecimalFormatSymbols.getInstance().getCurrencySymbol();

    @Before
    public void init() {
        this.sharedTable1 = DefaultColumnValueIT.generateUniqueName();
        this.sharedTable2 = DefaultColumnValueIT.generateUniqueName();
    }

    @Test
    public void testDefaultColumnValue() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable1 + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("ALTER TABLE " + this.sharedTable1 + " ADD test2 INTEGER DEFAULT 5, est3 INTEGER");
        String dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (11, 12, 13, 14, null, 16)";
        conn.createStatement().execute(dml);
        conn.commit();
        String projection = "*";
        ResultSet rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)10L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)5L, (long)rs.getInt(5));
        Assert.assertEquals((long)0L, (long)rs.getInt(6));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)12L, (long)rs.getInt(2));
        Assert.assertEquals((long)13L, (long)rs.getInt(3));
        Assert.assertEquals((long)14L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)16L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultColumnValueOnView() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable1 + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, test2 INTEGER DEFAULT 5, test3 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("CREATE VIEW " + this.sharedTable2 + "(pk4 INTEGER NOT NULL DEFAULT 20 PRIMARY KEY, test4 VARCHAR DEFAULT 'foo') AS SELECT * FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        String dml = "UPSERT INTO " + this.sharedTable2 + "(pk2) VALUES (2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk1,pk2,pk3,pk4,test2,test4 FROM " + this.sharedTable2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)10L, (long)rs.getInt(3));
        Assert.assertEquals((long)20L, (long)rs.getInt(4));
        Assert.assertEquals((long)5L, (long)rs.getInt(5));
        Assert.assertEquals((Object)"foo", (Object)rs.getString(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultColumnValueProjected() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable1 + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, test2 INTEGER DEFAULT 5, test3 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (11, 12, 13, 14, null, 16)";
        conn.createStatement().execute(dml);
        conn.commit();
        String projection = "pk1, pk2, pk3, test1, test2, test3";
        ResultSet rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)10L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)5L, (long)rs.getInt(5));
        Assert.assertEquals((long)0L, (long)rs.getInt(6));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)12L, (long)rs.getInt(2));
        Assert.assertEquals((long)13L, (long)rs.getInt(3));
        Assert.assertEquals((long)14L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)16L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
        projection = "pk1, pk3, pk2, test1, test3, test2";
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)5L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT " + projection + " FROM " + this.sharedTable1 + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)13L, (long)rs.getInt(2));
        Assert.assertEquals((long)12L, (long)rs.getInt(3));
        Assert.assertEquals((long)14L, (long)rs.getInt(4));
        Assert.assertEquals((long)16L, (long)rs.getInt(5));
        Assert.assertEquals((long)0L, (long)rs.getInt(6));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMultipleDefaults() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL DEFAULT 5, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, test2 INTEGER DEFAULT 50, test3 INTEGER DEFAULT 100, test4 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + table + " VALUES (11, 12, 13, 21, null, null, 24)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertEquals((long)10L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)50L, (long)rs.getInt(5));
        Assert.assertEquals((long)100L, (long)rs.getInt(6));
        Assert.assertEquals((long)0L, (long)rs.getInt(7));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)12L, (long)rs.getInt(2));
        Assert.assertEquals((long)13L, (long)rs.getInt(3));
        Assert.assertEquals((long)21L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(6));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)24L, (long)rs.getInt(7));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultImmutableRows() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL DEFAULT 5, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, test2 INTEGER DEFAULT 50, test3 INTEGER DEFAULT 100, test4 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))IMMUTABLE_ROWS=true";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + table + " VALUES (11, 12, 13, 21, null, null, 24)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertEquals((long)10L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)50L, (long)rs.getInt(5));
        Assert.assertEquals((long)100L, (long)rs.getInt(6));
        Assert.assertEquals((long)0L, (long)rs.getInt(7));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)12L, (long)rs.getInt(2));
        Assert.assertEquals((long)13L, (long)rs.getInt(3));
        Assert.assertEquals((long)21L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(6));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)24L, (long)rs.getInt(7));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testTrailingNullOverwritingDefault() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table + " (pk INTEGER PRIMARY KEY, mid INTEGER, def INTEGER DEFAULT 10)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1, 10, null)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertEquals((long)0L, (long)rs.getInt(3));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultReinit() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable1 + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL DEFAULT 10, test1 INTEGER, test2 INTEGER DEFAULT 5, test3 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + this.sharedTable1 + " VALUES (11, 12, 13, 14, null, 16)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk3, test2 FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
        Connection conn2 = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        rs = conn2.createStatement().executeQuery("SELECT pk3, test2 FROM " + this.sharedTable1 + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultMiddlePrimaryKey() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL DEFAULT 100, pk3 INTEGER NOT NULL, test1 INTEGER, CONSTRAINT NAME_PK PRIMARY KEY (pk1, pk2, pk3))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        try {
            conn.createStatement().execute(dml);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CONSTRAINT_VIOLATION.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(table));
        }
        dml = "UPSERT INTO " + table + " VALUES (1, 2)";
        try {
            conn.createStatement().execute(dml);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CONSTRAINT_VIOLATION.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(table));
        }
        dml = "UPSERT INTO " + table + " VALUES (1, 2, 3)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + table + " (pk1, pk3) VALUES (11, 13)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)3L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk1 = 11");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)100L, (long)rs.getInt(2));
        Assert.assertEquals((long)13L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultMiddleKeyValueCol() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 50,c3 INTEGER)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + table + " (pk, c3) VALUES (10, 100)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)50L, (long)rs.getInt(3));
        Assert.assertEquals((long)0L, (long)rs.getInt(4));
        Assert.assertTrue((boolean)rs.wasNull());
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 10");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)50L, (long)rs.getInt(3));
        Assert.assertEquals((long)100L, (long)rs.getInt(4));
    }

    @Test
    public void testDefaultAllDataTypesKeyValueCol() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER PRIMARY KEY,int INTEGER DEFAULT -100,uint UNSIGNED_INT DEFAULT 100, bint BIGINT DEFAULT -200,ubint UNSIGNED_LONG DEFAULT 200,tint TINYINT DEFAULT -50,utint UNSIGNED_TINYINT DEFAULT 50,sint SMALLINT DEFAULT -10,usint UNSIGNED_SMALLINT DEFAULT 10,flo FLOAT DEFAULT -100.8,uflo UNSIGNED_FLOAT DEFAULT 100.9,doub DOUBLE DEFAULT -200.5,udoubl UNSIGNED_DOUBLE DEFAULT 200.8,dec DECIMAL DEFAULT -654624562.3462642362,bool BOOLEAN DEFAULT true,tim TIME DEFAULT time '1900-10-01 14:03:22.559',dat DATE DEFAULT date '1900-10-01 14:03:22.559',timest TIMESTAMP DEFAULT timestamp '1900-10-01 14:03:22.559',utim UNSIGNED_TIME DEFAULT time '2005-10-01 14:03:22.559',udat UNSIGNED_DATE DEFAULT date '2005-10-01 14:03:22.559',utimest UNSIGNED_TIMESTAMP DEFAULT timestamp '2005-10-01 14:03:22.559',vc VARCHAR DEFAULT 'ABCD',c CHAR(5) DEFAULT 'EF',bin BINARY(5) DEFAULT 'MNOP',varbin VARBINARY DEFAULT 'QR')";
        this.testDefaultAllDataTypes(table, ddl);
    }

    @Test
    public void testDefaultAllDataTypesPrimaryKey() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER NOT NULL,int INTEGER NOT NULL DEFAULT -100,uint UNSIGNED_INT NOT NULL DEFAULT 100, bint BIGINT NOT NULL DEFAULT -200,ubint UNSIGNED_LONG NOT NULL DEFAULT 200,tint TINYINT NOT NULL DEFAULT -50,utint UNSIGNED_TINYINT NOT NULL DEFAULT 50,sint SMALLINT NOT NULL DEFAULT -10,usint UNSIGNED_SMALLINT NOT NULL DEFAULT 10,flo FLOAT NOT NULL DEFAULT -100.8,uflo UNSIGNED_FLOAT NOT NULL DEFAULT 100.9,doub DOUBLE NOT NULL DEFAULT -200.5,udoub UNSIGNED_DOUBLE NOT NULL DEFAULT 200.8,dec DECIMAL NOT NULL DEFAULT -654624562.3462642362,bool BOOLEAN NOT NULL DEFAULT true,tim TIME NOT NULL DEFAULT time '1900-10-01 14:03:22.559',dat DATE NOT NULL DEFAULT date '1900-10-01 14:03:22.559',timest TIMESTAMP NOT NULL DEFAULT timestamp '1900-10-01 14:03:22.559',utim UNSIGNED_TIME NOT NULL DEFAULT time '2005-10-01 14:03:22.559',udat UNSIGNED_DATE NOT NULL DEFAULT date '2005-10-01 14:03:22.559',utimest UNSIGNED_TIMESTAMP NOT NULL DEFAULT timestamp '2005-10-01 14:03:22.559',vc VARCHAR NOT NULL DEFAULT 'ABCD',c CHAR(5) NOT NULL DEFAULT 'EF',bin BINARY(5) NOT NULL DEFAULT 'MNOP',varbin VARBINARY NOT NULL DEFAULT 'QR'CONSTRAINT pk_final PRIMARY KEY (pk, int, uint, bint, ubint, tint, utint,sint, usint, flo, uflo, doub, udoub, dec, bool,tim, dat, timest, utim, udat, utimest,vc, c, bin, varbin))";
        this.testDefaultAllDataTypes(table, ddl);
    }

    private void testDefaultAllDataTypes(String table, String ddl) throws SQLException {
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)-100L, (long)rs.getInt(2));
        Assert.assertEquals((long)100L, (long)rs.getInt(3));
        Assert.assertEquals((long)-200L, (long)rs.getLong(4));
        Assert.assertEquals((long)200L, (long)rs.getLong(5));
        Assert.assertEquals((long)-50L, (long)rs.getByte(6));
        Assert.assertEquals((long)50L, (long)rs.getByte(7));
        Assert.assertEquals((long)-10L, (long)rs.getShort(8));
        Assert.assertEquals((long)10L, (long)rs.getShort(9));
        Assert.assertEquals((float)new Float(-100.8).floatValue(), (float)rs.getFloat(10), (float)0.0f);
        Assert.assertEquals((float)new Float(100.9).floatValue(), (float)rs.getFloat(11), (float)0.0f);
        Assert.assertEquals((double)-200.5, (double)rs.getDouble(12), (double)0.0);
        Assert.assertEquals((double)200.8, (double)rs.getDouble(13), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal("-654624562.3462642362"), (Object)rs.getBigDecimal(14));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(15));
        Assert.assertEquals((Object)DateUtil.parseTime((String)"1900-10-01 14:03:22.559"), (Object)rs.getTime(16));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1900-10-01 14:03:22.559"), (Object)rs.getDate(17));
        Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"1900-10-01 14:03:22.559"), (Object)rs.getTimestamp(18));
        Assert.assertEquals((Object)DateUtil.parseTime((String)"2005-10-01 14:03:22.559"), (Object)rs.getTime(19));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2005-10-01 14:03:22.559"), (Object)rs.getDate(20));
        Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2005-10-01 14:03:22.559"), (Object)rs.getTimestamp(21));
        Assert.assertEquals((Object)"ABCD", (Object)rs.getString(22));
        Assert.assertEquals((Object)"EF", (Object)rs.getString(23));
        Assert.assertArrayEquals((byte[])ByteUtil.fillKey((byte[])new byte[]{77, 78, 79, 80}, (int)rs.getBytes(24).length), (byte[])rs.getBytes(24));
        Assert.assertArrayEquals((byte[])new byte[]{81, 82}, (byte[])rs.getBytes(25));
    }

    @Test
    public void testDefaultExpression() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable2 + " (pk INTEGER PRIMARY KEY,c1 INTEGER DEFAULT 1 + 9,c2 DOUBLE DEFAULT SQRT(91506.25),c3 DECIMAL DEFAULT TO_NUMBER('" + this.DEFAULT_CURRENCY_SYMBOL + "123.33', '\u00a4###.##'),c4 VARCHAR DEFAULT 'AB' || 'CD',c5 CHAR(5) DEFAULT 'E' || 'F',c6 INTEGER DEFAULT \"MONTH\"(TO_TIMESTAMP('2015-6-05')))";
        this.verifyDefaultExpression(this.sharedTable2, ddl);
    }

    @Test
    public void testDefaultExpressionPrimaryKey() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER NOT NULL,c1 INTEGER NOT NULL DEFAULT 1 + 9,c2 DOUBLE NOT NULL DEFAULT SQRT(91506.25),c3 DECIMAL NOT NULL DEFAULT TO_NUMBER('" + this.DEFAULT_CURRENCY_SYMBOL + "123.33', '\u00a4###.##'),c4 VARCHAR NOT NULL DEFAULT 'AB' || 'CD',c5 CHAR(5) NOT NULL DEFAULT 'E' || 'F',c6 INTEGER NOT NULL DEFAULT \"MONTH\"(TO_TIMESTAMP('2015-6-05')),CONSTRAINT pk_key PRIMARY KEY (pk,c1,c2,c3,c4,c5,c6))";
        this.verifyDefaultExpression(table, ddl);
    }

    private void verifyDefaultExpression(String table, String ddl) throws SQLException {
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertEquals((double)302.5, (double)rs.getDouble(3), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal("123.33"), (Object)rs.getBigDecimal(4));
        Assert.assertEquals((Object)"ABCD", (Object)rs.getString(5));
        Assert.assertEquals((Object)"EF", (Object)rs.getString(6));
        Assert.assertEquals((long)6L, (long)rs.getInt(7));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultUpsertSelectPrimaryKey() throws Exception {
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        String selectTable = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + selectTable + " (pk INTEGER PRIMARY KEY)";
        conn.createStatement().execute(ddl);
        String table = DefaultColumnValueIT.generateUniqueName();
        ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL DEFAULT 100,CONSTRAINT pk_key PRIMARY KEY(pk1, pk2))";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + selectTable + " VALUES (1)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + selectTable + " VALUES (2)";
        conn.createStatement().execute(dml);
        conn.commit();
        dml = "UPSERT INTO " + table + " (pk1) SELECT pk FROM " + selectTable;
        conn.createStatement().executeUpdate(dml);
        dml = "UPSERT INTO " + table + " SELECT pk,pk FROM " + selectTable;
        conn.createStatement().executeUpdate(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + selectTable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT * FROM " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)100L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)100L, (long)rs.getInt(2));
    }

    @Test
    public void testDefaultArrays() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER PRIMARY KEY,int INTEGER[5] DEFAULT ARRAY[-100, 50],uint UNSIGNED_INT[5] DEFAULT ARRAY[100, 50], bint BIGINT[5] DEFAULT ARRAY[-200, 100],ubint UNSIGNED_LONG[5] DEFAULT ARRAY[200, 100],tint TINYINT[5] DEFAULT ARRAY[-50, 25],utint UNSIGNED_TINYINT[5] DEFAULT ARRAY[50, 25],sint SMALLINT[5] DEFAULT ARRAY[-10, 5],usint UNSIGNED_SMALLINT[5] DEFAULT ARRAY[10, 5],flo FLOAT[5] DEFAULT ARRAY[-100.8, 50.4],uflo UNSIGNED_FLOAT[5] DEFAULT ARRAY[100.9, 50.45],doub DOUBLE[5] DEFAULT ARRAY[-200.5, 100.25],udoubl UNSIGNED_DOUBLE[5] DEFAULT ARRAY[200.8, 100.4],dec DECIMAL[5] DEFAULT ARRAY[-654624562.3462642362, 3462642362.654624562],bool BOOLEAN[5] DEFAULT ARRAY[true, false],tim TIME[5] DEFAULT ARRAY[time '1900-10-01 14:03:22.559',time '1990-10-01 14:03:22.559'],dat DATE[5] DEFAULT ARRAY[date '1900-10-01 14:03:22.559',date '1990-10-01 14:03:22.559'],timest TIMESTAMP[5] DEFAULT ARRAY[timestamp '1900-10-01 14:03:22.559',timestamp '1990-10-01 14:03:22.559'],utim UNSIGNED_TIME[5] DEFAULT ARRAY[time '2005-10-01 14:03:22.559',time '2006-10-01 14:03:22.559'],udat UNSIGNED_DATE[5] DEFAULT ARRAY[date '2005-10-01 14:03:22.559',date '2006-10-01 14:03:22.559'],utimest UNSIGNED_TIMESTAMP[5] DEFAULT ARRAY[timestamp '2005-10-01 14:03:22.559',timestamp '2006-10-01 14:03:22.559'],vc VARCHAR[5] DEFAULT ARRAY['ABCD', 'XY'],c CHAR(5)[5] DEFAULT ARRAY['EF', 'Z'],bin BINARY(5)[5] DEFAULT ARRAY ['MNOP', 'mnop'])";
        this.verifyArrays(table, ddl);
    }

    @Test
    public void testDefaultArraysPrimaryKey() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER NOT NULL,int INTEGER[5] DEFAULT ARRAY[-100, 50],uint UNSIGNED_INT[5] DEFAULT ARRAY[100, 50], bint BIGINT[5] DEFAULT ARRAY[-200, 100],ubint UNSIGNED_LONG[5] DEFAULT ARRAY[200, 100],tint TINYINT[5] DEFAULT ARRAY[-50, 25],utint UNSIGNED_TINYINT[5] DEFAULT ARRAY[50, 25],sint SMALLINT[5] DEFAULT ARRAY[-10, 5],usint UNSIGNED_SMALLINT[5] DEFAULT ARRAY[10, 5],flo FLOAT[5] DEFAULT ARRAY[-100.8, 50.4],uflo UNSIGNED_FLOAT[5] DEFAULT ARRAY[100.9, 50.45],doub DOUBLE[5] DEFAULT ARRAY[-200.5, 100.25],udoubl UNSIGNED_DOUBLE[5] DEFAULT ARRAY[200.8, 100.4],dec DECIMAL[5] DEFAULT ARRAY[-654624562.3462642362, 3462642362.654624562],bool BOOLEAN[5] DEFAULT ARRAY[true, false],tim TIME[5] DEFAULT ARRAY[time '1900-10-01 14:03:22.559',time '1990-10-01 14:03:22.559'],dat DATE[5] DEFAULT ARRAY[date '1900-10-01 14:03:22.559',date '1990-10-01 14:03:22.559'],timest TIMESTAMP[5] DEFAULT ARRAY[timestamp '1900-10-01 14:03:22.559',timestamp '1990-10-01 14:03:22.559'],utim UNSIGNED_TIME[5] DEFAULT ARRAY[time '2005-10-01 14:03:22.559',time '2006-10-01 14:03:22.559'],udat UNSIGNED_DATE[5] DEFAULT ARRAY[date '2005-10-01 14:03:22.559',date '2006-10-01 14:03:22.559'],utimest UNSIGNED_TIMESTAMP[5] DEFAULT ARRAY[timestamp '2005-10-01 14:03:22.559',timestamp '2006-10-01 14:03:22.559'],vc VARCHAR[5] DEFAULT ARRAY['ABCD', 'XY'],c CHAR(5)[5] DEFAULT ARRAY['EF', 'Z'],bin BINARY(5)[5] NOT NULL DEFAULT ARRAY ['MNOP', 'mnop'],CONSTRAINT pk_key PRIMARY KEY (pk, bin))";
        this.verifyArrays(table, ddl);
    }

    private void verifyArrays(String table, String ddl) throws SQLException {
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertArrayEquals((int[])new int[]{-100, 50}, (int[])((int[])rs.getArray(2).getArray()));
        Assert.assertArrayEquals((int[])new int[]{100, 50}, (int[])((int[])rs.getArray(3).getArray()));
        Assert.assertArrayEquals((long[])new long[]{-200L, 100L}, (long[])((long[])rs.getArray(4).getArray()));
        Assert.assertArrayEquals((long[])new long[]{200L, 100L}, (long[])((long[])rs.getArray(5).getArray()));
        Assert.assertArrayEquals((byte[])new byte[]{-50, 25}, (byte[])((byte[])rs.getArray(6).getArray()));
        Assert.assertArrayEquals((byte[])new byte[]{50, 25}, (byte[])((byte[])rs.getArray(7).getArray()));
        Assert.assertArrayEquals((short[])new short[]{-10, 5}, (short[])((short[])rs.getArray(8).getArray()));
        Assert.assertArrayEquals((short[])new short[]{10, 5}, (short[])((short[])rs.getArray(9).getArray()));
        Assert.assertArrayEquals((float[])new float[]{new Float(-100.8).floatValue(), new Float(50.4).floatValue()}, (float[])((float[])rs.getArray(10).getArray()), (float)0.0f);
        Assert.assertArrayEquals((float[])new float[]{new Float(100.9).floatValue(), new Float(50.45).floatValue()}, (float[])((float[])rs.getArray(11).getArray()), (float)0.0f);
        Assert.assertArrayEquals((double[])new double[]{-200.5, 100.25}, (double[])((double[])rs.getArray(12).getArray()), (double)0.0);
        Assert.assertArrayEquals((double[])new double[]{200.8, 100.4}, (double[])((double[])rs.getArray(13).getArray()), (double)0.0);
        Assert.assertArrayEquals((Object[])new BigDecimal[]{new BigDecimal("-654624562.3462642362"), new BigDecimal("3462642362.654624562")}, (Object[])((BigDecimal[])rs.getArray(14).getArray()));
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false}, (boolean[])((boolean[])rs.getArray(15).getArray()));
        Assert.assertArrayEquals((Object[])new Time[]{DateUtil.parseTime((String)"1900-10-01 14:03:22.559"), DateUtil.parseTime((String)"1990-10-01 14:03:22.559")}, (Object[])((Time[])rs.getArray(16).getArray()));
        Assert.assertArrayEquals((Object[])new Date[]{DateUtil.parseDate((String)"1900-10-01 14:03:22.559"), DateUtil.parseDate((String)"1990-10-01 14:03:22.559")}, (Object[])((Date[])rs.getArray(17).getArray()));
        Assert.assertArrayEquals((Object[])new Timestamp[]{DateUtil.parseTimestamp((String)"1900-10-01 14:03:22.559"), DateUtil.parseTimestamp((String)"1990-10-01 14:03:22.559")}, (Object[])((Timestamp[])rs.getArray(18).getArray()));
        Assert.assertArrayEquals((Object[])new Time[]{DateUtil.parseTime((String)"2005-10-01 14:03:22.559"), DateUtil.parseTime((String)"2006-10-01 14:03:22.559")}, (Object[])((Time[])rs.getArray(19).getArray()));
        Assert.assertArrayEquals((Object[])new Date[]{DateUtil.parseDate((String)"2005-10-01 14:03:22.559"), DateUtil.parseDate((String)"2006-10-01 14:03:22.559")}, (Object[])((Date[])rs.getArray(20).getArray()));
        Assert.assertArrayEquals((Object[])new Timestamp[]{DateUtil.parseTimestamp((String)"2005-10-01 14:03:22.559"), DateUtil.parseTimestamp((String)"2006-10-01 14:03:22.559")}, (Object[])((Timestamp[])rs.getArray(21).getArray()));
        Assert.assertArrayEquals((Object[])new String[]{"ABCD", "XY"}, (Object[])((String[])rs.getArray(22).getArray()));
        Object[] expected = new String[]{"EF", "Z"};
        Array array = conn.createArrayOf("CHAR", expected);
        Assert.assertTrue((boolean)rs.getArray(23).equals(array));
        byte[][] expectedByteArray = new byte[][]{ByteUtil.fillKey((byte[])new byte[]{77, 78, 79, 80}, (int)5), ByteUtil.fillKey((byte[])new byte[]{109, 110, 111, 112}, (int)5)};
        Assert.assertArrayEquals((Object[])expectedByteArray, (Object[])((byte[][])rs.getArray(24).getArray()));
    }

    @Test
    public void testDefaultArrayWithNull() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER PRIMARY KEY,c1 VARCHAR[5] DEFAULT ARRAY[NULL, 'ABCD', 'XY'],c2 VARCHAR[5] DEFAULT ARRAY['ABCD', NULL, 'XY'],c3 VARCHAR[5] DEFAULT ARRAY['ABCD', 'XY', NULL])";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertArrayEquals((Object[])new String[]{null, "ABCD", "XY"}, (Object[])((String[])rs.getArray(2).getArray()));
        Assert.assertArrayEquals((Object[])new String[]{"ABCD", null, "XY"}, (Object[])((String[])rs.getArray(3).getArray()));
        Assert.assertArrayEquals((Object[])new String[]{"ABCD", "XY", null}, (Object[])((String[])rs.getArray(4).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultArrayWithFixedWidthNull() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + "(pk INTEGER PRIMARY KEY,c1 INTEGER[5] DEFAULT ARRAY[NULL, 2, 3],c2 INTEGER[5] DEFAULT ARRAY[1, NULL, 3],c3 INTEGER[5] DEFAULT ARRAY[1, 2, NULL])";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertArrayEquals((int[])new int[]{0, 2, 3}, (int[])((int[])rs.getArray(2).getArray()));
        Assert.assertArrayEquals((int[])new int[]{1, 0, 3}, (int[])((int[])rs.getArray(3).getArray()));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 0}, (int[])((int[])rs.getArray(4).getArray()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultNull() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table + " (pk INTEGER PRIMARY KEY, def INTEGER DEFAULT NULL)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table + " WHERE pk = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultCoveredColumn() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = DefaultColumnValueIT.generateUniqueName();
        ddl = "CREATE INDEX " + idx + " on " + table + " (c1) INCLUDE (c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c1 = 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultIndexed() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = DefaultColumnValueIT.generateUniqueName();
        ddl = "CREATE INDEX " + idx + " on " + table + " (c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 100");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 5");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultLocalIndexed() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = DefaultColumnValueIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + idx + " on " + table + " (c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 100");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c2 = 5");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultFunctionalIndexed() throws Exception {
        String table = DefaultColumnValueIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + table + " (pk INTEGER PRIMARY KEY,c1 INTEGER,c2 INTEGER DEFAULT 100)";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.commit();
        String idx = DefaultColumnValueIT.generateUniqueName();
        ddl = "CREATE INDEX " + idx + " on " + table + " (c1 + c2)";
        conn.createStatement().execute(ddl);
        conn.commit();
        String dml = "UPSERT INTO " + table + " VALUES (1, 2)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c2 FROM " + table + " WHERE c1 + c2 = 102");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDefaultSelectWhere() throws Exception {
        String ddl = "CREATE TABLE IF NOT EXISTS " + this.sharedTable2 + " (pk INTEGER PRIMARY KEY,c1 INTEGER DEFAULT 1 + 9,c2 DOUBLE DEFAULT SQRT(91506.25),c3 DECIMAL DEFAULT TO_NUMBER('" + this.DEFAULT_CURRENCY_SYMBOL + "123.33', '\u00a4###.##'),c4 VARCHAR DEFAULT 'AB' || 'CD',c5 CHAR(5) DEFAULT 'E' || 'F',c6 INTEGER DEFAULT \"MONTH\"(TO_TIMESTAMP('2015-6-05')))";
        Connection conn = DriverManager.getConnection(DefaultColumnValueIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.sharedTable2 + " VALUES (1)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT c1 FROM " + this.sharedTable2 + " WHERE c1 = 10");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT c4 FROM " + this.sharedTable2 + " WHERE c4 = 'ABCD'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ABCD", (Object)rs.getString(1));
    }
}

