/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DecodeFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void shouldPass() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (some_column) VALUES (?)");
        byte[] kk = Bytes.add((byte[])PUnsignedLong.INSTANCE.toBytes((Object)2232594215L), (byte[])PInteger.INSTANCE.toBytes((Object)-8));
        ps.setBytes(1, kk);
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('000000008512af277ffffff8', 'hex')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void upperCaseHexEncoding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (some_column) VALUES (?)");
        byte[] kk = Bytes.add((byte[])PUnsignedLong.INSTANCE.toBytes((Object)2232594215L), (byte[])PInteger.INSTANCE.toBytes((Object)-8));
        ps.setBytes(1, kk);
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('000000008512af277ffffff8', 'HEX')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void invalidCharacters() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('zzxxuuyyzzxxuuyy', 'hex')");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void invalidLength() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('8', 'hex')");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void nullEncoding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('8', NULL)");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void invalidEncoding() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " ( some_column BINARY(12) NOT NULL CONSTRAINT PK PRIMARY KEY (some_column))";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().executeQuery("SELECT * FROM " + testTable + " WHERE some_column = DECODE('8', 'someNonexistFormat')");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TYPE_MISMATCH.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testDecodeBase642() throws Exception {
        Connection conn = DriverManager.getConnection(DecodeFunctionIT.getUrl());
        String testTable = DecodeFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (id INTEGER PRIMARY KEY, data VARCHAR)";
        conn.createStatement().execute(ddl);
        PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + testTable + " (id, data) VALUES (1, 'SGVsbG9QaG9lbml4')");
        ps.execute();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT DECODE(data, 'BASE64') FROM " + testTable);
        Assert.assertTrue((boolean)rs.next());
        byte[] actualBytes = rs.getBytes(1);
        Assert.assertTrue((boolean)Arrays.equals("HelloPhoenix".getBytes(), actualBytes));
        Assert.assertFalse((boolean)rs.next());
    }
}

