/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DateTimeIT
extends ParallelStatsDisabledIT {
    private static final String PRODUCT_METRICS_NAME = "PRODUCT_METRICS";
    private static final Date SPLIT1 = DateTimeIT.toDate("1970-01-01 01:30:00");
    private static final Date SPLIT2 = DateTimeIT.toDate("1970-01-01 02:00:00");
    private static final String R1 = "R1";
    private static final String R2 = "R2";
    protected Connection conn;
    protected Date date = new Date(System.currentTimeMillis());
    protected static final String tenantId = DateTimeIT.getOrganizationId();
    protected static final String ROW10 = "00D123122312312";
    protected String tableName;

    private static void initDateTableValues(String tablename, Connection conn, String tenantId, Date startDate) throws Exception {
        double dateIncrement = 2.0;
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + "(    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,     TRANSACTIONS,     CPU_UTILIZATION,     DB_UTILIZATION,     REGION,     IO_TIME)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "A");
        stmt.setInt(4, 10);
        stmt.setLong(5, 100L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(0.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.2));
        stmt.setString(8, R2);
        stmt.setNull(9, -5);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "B");
        stmt.setInt(4, 20);
        stmt.setLong(5, 200L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(1.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.4));
        stmt.setString(8, null);
        stmt.setLong(9, 2000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "C");
        stmt.setInt(4, 30);
        stmt.setLong(5, 300L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(2.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.6));
        stmt.setString(8, R1);
        stmt.setNull(9, -5);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "D");
        stmt.setInt(4, 40);
        stmt.setLong(5, 400L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.8));
        stmt.setString(8, R1);
        stmt.setLong(9, 4000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "E");
        stmt.setInt(4, 50);
        stmt.setLong(5, 500L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.2));
        stmt.setString(8, R2);
        stmt.setLong(9, 5000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "F");
        stmt.setInt(4, 60);
        stmt.setLong(5, 600L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(4.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.4));
        stmt.setString(8, null);
        stmt.setNull(9, -5);
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDateTableValues(String tablename, String tenantId, byte[][] splits, Date startDate) throws Exception {
        DateTimeIT.ensureTableCreated(DateTimeIT.getUrl(), tablename, PRODUCT_METRICS_NAME, splits, null, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            DateTimeIT.initDateTableValues(tablename, conn, tenantId, startDate);
            conn.commit();
        }
    }

    @Before
    public void setUp() throws SQLException {
        this.conn = DriverManager.getConnection(DateTimeIT.getUrl());
        this.tableName = this.initAtable();
    }

    @After
    public void tearDown() throws Exception {
        boolean refCountLeaked = DateTimeIT.isAnyStoreRefCountLeaked();
        this.conn.close();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    private String initAtable() throws SQLException {
        String tableName = DateTimeIT.generateUniqueName();
        DateTimeIT.ensureTableCreated(DateTimeIT.getUrl(), tableName, "ATABLE", null, null);
        PreparedStatement stmt = this.conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     A_STRING,     B_STRING,     A_INTEGER,     A_DATE,     X_DECIMAL,     X_LONG,     X_INTEGER,    Y_INTEGER,    A_BYTE,    A_SHORT,    A_FLOAT,    A_DOUBLE,    A_UNSIGNED_FLOAT,    A_UNSIGNED_DOUBLE)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A123122312312");
        stmt.setString(3, "a");
        stmt.setString(4, "b");
        stmt.setInt(5, 1);
        stmt.setDate(6, this.date);
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)1);
        stmt.setShort(12, (short)128);
        stmt.setFloat(13, 0.01f);
        stmt.setDouble(14, 1.0E-4);
        stmt.setFloat(15, 0.01f);
        stmt.setDouble(16, 1.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A223122312312");
        stmt.setString(3, "a");
        stmt.setString(4, "c");
        stmt.setInt(5, 2);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 86400000L));
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)2);
        stmt.setShort(12, (short)129);
        stmt.setFloat(13, 0.02f);
        stmt.setDouble(14, 2.0E-4);
        stmt.setFloat(15, 0.02f);
        stmt.setDouble(16, 2.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A323122312312");
        stmt.setString(3, "a");
        stmt.setString(4, "e");
        stmt.setInt(5, 3);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 172800000L));
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)3);
        stmt.setShort(12, (short)130);
        stmt.setFloat(13, 0.03f);
        stmt.setDouble(14, 3.0E-4);
        stmt.setFloat(15, 0.03f);
        stmt.setDouble(16, 3.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A423122312312");
        stmt.setString(3, "a");
        stmt.setString(4, "b");
        stmt.setInt(5, 4);
        stmt.setDate(6, this.date == null ? null : this.date);
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)4);
        stmt.setShort(12, (short)131);
        stmt.setFloat(13, 0.04f);
        stmt.setDouble(14, 4.0E-4);
        stmt.setFloat(15, 0.04f);
        stmt.setDouble(16, 4.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B523122312312");
        stmt.setString(3, "b");
        stmt.setString(4, "c");
        stmt.setInt(5, 5);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 86400000L));
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)5);
        stmt.setShort(12, (short)132);
        stmt.setFloat(13, 0.05f);
        stmt.setDouble(14, 5.0E-4);
        stmt.setFloat(15, 0.05f);
        stmt.setDouble(16, 5.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B623122312312");
        stmt.setString(3, "b");
        stmt.setString(4, "e");
        stmt.setInt(5, 6);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 172800000L));
        stmt.setBigDecimal(7, null);
        stmt.setNull(8, -5);
        stmt.setNull(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)6);
        stmt.setShort(12, (short)133);
        stmt.setFloat(13, 0.06f);
        stmt.setDouble(14, 6.0E-4);
        stmt.setFloat(15, 0.06f);
        stmt.setDouble(16, 6.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B723122312312");
        stmt.setString(3, "b");
        stmt.setString(4, "b");
        stmt.setInt(5, 7);
        stmt.setDate(6, this.date == null ? null : this.date);
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.1));
        stmt.setLong(8, 5L);
        stmt.setInt(9, 5);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)7);
        stmt.setShort(12, (short)134);
        stmt.setFloat(13, 0.07f);
        stmt.setDouble(14, 7.0E-4);
        stmt.setFloat(15, 0.07f);
        stmt.setDouble(16, 7.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B823122312312");
        stmt.setString(3, "b");
        stmt.setString(4, "c");
        stmt.setInt(5, 8);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 86400000L));
        stmt.setBigDecimal(7, BigDecimal.valueOf(3.9));
        long l = -2147483649L;
        assert (l < Integer.MIN_VALUE);
        stmt.setLong(8, l);
        stmt.setInt(9, 4);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)8);
        stmt.setShort(12, (short)135);
        stmt.setFloat(13, 0.08f);
        stmt.setDouble(14, 8.0E-4);
        stmt.setFloat(15, 0.08f);
        stmt.setDouble(16, 8.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, "00C923122312312");
        stmt.setString(3, "c");
        stmt.setString(4, "e");
        stmt.setInt(5, 9);
        stmt.setDate(6, this.date == null ? null : new Date(this.date.getTime() + 172800000L));
        stmt.setBigDecimal(7, BigDecimal.valueOf(3.3));
        l = 0x80000000L;
        assert (l > Integer.MAX_VALUE);
        stmt.setLong(8, l);
        stmt.setInt(9, 3);
        stmt.setInt(10, 300);
        stmt.setByte(11, (byte)9);
        stmt.setShort(12, (short)0);
        stmt.setFloat(13, 0.09f);
        stmt.setDouble(14, 9.0E-4);
        stmt.setFloat(15, 0.09f);
        stmt.setDouble(16, 9.0E-4);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setString(2, ROW10);
        stmt.setString(3, "b");
        stmt.setString(4, "b");
        stmt.setInt(5, 7);
        stmt.setDate(6, null);
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.1));
        stmt.setLong(8, 5L);
        stmt.setInt(9, 5);
        stmt.setNull(10, 4);
        stmt.setByte(11, (byte)7);
        stmt.setShort(12, (short)134);
        stmt.setFloat(13, 0.07f);
        stmt.setDouble(14, 7.0E-4);
        stmt.setFloat(15, 0.07f);
        stmt.setDouble(16, 7.0E-4);
        stmt.execute();
        this.conn.commit();
        return tableName;
    }

    @Test
    public void selectBetweenDates() throws Exception {
        Format formatter = DateUtil.getDateFormatter((String)"yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        java.util.Date dateToday = cal.getTime();
        cal.add(6, 1);
        java.util.Date dateTomorrow = cal.getTime();
        String tableName = DateTimeIT.generateUniqueName();
        String today = formatter.format(dateToday);
        String tomorrow = formatter.format(dateTomorrow);
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE a_integer < 4 AND a_date BETWEEN date '" + today + "' AND date '" + tomorrow + "' ";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNowWithSubquery() throws Exception {
        String query = "SELECT now(), reference_date FROM (select now() as reference_date union all select now() as reference_date) limit 1";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((Math.abs(rs.getTime(1).getTime() - rs.getTime(2).getTime()) < 10000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)rs.getDate(2).toString(), (Object)rs.getDate(1).toString());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectLiteralDate() throws Exception {
        String s = DateUtil.DEFAULT_DATE_FORMATTER.format(this.date);
        String query = "SELECT DATE '" + s + "' FROM " + this.tableName;
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)this.date, (Object)rs.getDate(1));
    }

    @Test
    public void testSelectLiteralDateCompare() throws Exception {
        String query = "SELECT (DATE '" + this.date + "' = DATE '" + this.date + "') FROM " + this.tableName;
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getBoolean(1));
    }

    @Test
    public void testSelectWhereDatesEqual() throws Exception {
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE  a_integer < 4 AND DATE '" + this.date + "' = DATE '" + this.date + "'";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSelectWhereDateAndToDateEqual() throws Exception {
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE  a_integer < 4 AND DATE '" + this.date + "' = TO_DATE ('" + this.date + "')";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSelectWhereDateAndTimestampEqual() throws Exception {
        String timestamp = "2012-09-08 07:08:23";
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE  a_integer < 4 AND DATE '" + "2012-09-08 07:08:23" + "' = TIMESTAMP '" + "2012-09-08 07:08:23" + "'";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSelectWhereSameDatesUnequal() throws Exception {
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE  a_integer < 4 AND DATE '" + this.date + "' > DATE '" + this.date + "'";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDateInList() throws Exception {
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE a_date IN (?,?) AND a_integer < 4";
        PreparedStatement statement = this.conn.prepareStatement(query);
        statement.setDate(1, new Date(0L));
        statement.setDate(2, this.date);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDateBetweenLiterals() throws Exception {
        Format formatter = DateUtil.getDateFormatter((String)"yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        java.util.Date dateToday = cal.getTime();
        cal.add(6, 1);
        java.util.Date dateTomorrow = cal.getTime();
        String today = formatter.format(dateToday);
        String tomorrow = formatter.format(dateTomorrow);
        String query = "SELECT entity_id FROM " + this.tableName + " WHERE a_integer < 4 AND a_date BETWEEN date '" + today + "' AND date '" + tomorrow + "' ";
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    private static int callYearFunction(Connection conn, String invocation) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format("SELECT %s FROM \"SYSTEM\".\"CATALOG\" LIMIT 1", invocation));
        Assert.assertTrue((boolean)rs.next());
        int returnValue = rs.getInt(1);
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
        return returnValue;
    }

    private int callYearFunction(String invocation) throws SQLException {
        return DateTimeIT.callYearFunction(this.conn, invocation);
    }

    @Test
    public void testYearFunctionDate() throws SQLException {
        Assert.assertEquals((long)2008L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2008-01-01', 'yyyy-MM-dd'))"));
        Assert.assertEquals((long)2004L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2004-12-13 10:13:18', 'yyyy-MM-dd hh:mm:ss'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2015-01-27T16:17:57+00:00'))"));
        Assert.assertEquals((long)2005L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2005-12-13 10:13:18'))"));
        Assert.assertEquals((long)2006L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2006-12-13'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('2015-W05'))"));
        Assert.assertEquals((long)2008L, (long)this.callYearFunction("\"YEAR\"(TO_DATE('Sat, 3 Feb 2008 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'UTC'))"));
    }

    @Test
    public void testYearFunctionTimestamp() throws SQLException {
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2015-01-27T16:17:57+00:00'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2015-01-27T16:17:57Z'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2015-W10-3'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2015-W05'))"));
        Assert.assertEquals((long)2015L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2015-063'))"));
        Assert.assertEquals((long)2006L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2006-12-13'))"));
        Assert.assertEquals((long)2004L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('2004-12-13 10:13:18', 'yyyy-MM-dd hh:mm:ss'))"));
        Assert.assertEquals((long)2008L, (long)this.callYearFunction("\"YEAR\"(TO_TIMESTAMP('Sat, 3 Feb 2008 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'UTC'))"));
    }

    @Test
    public void testYearFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME, unsignedDates UNSIGNED_DATE, unsignedTimestamps UNSIGNED_TIMESTAMP, unsignedTimes UNSIGNED_TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-03-01 00:00:00'), TO_TIMESTAMP('2006-02-01 00:00:00'), TO_TIME('2008-02-01 00:00:00'), TO_DATE('2010-03-01 00:00:00:896', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-02-01'), TO_TIME('2015-02-01 00:00:00'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2005-03-01 00:00:00'), TO_TIMESTAMP('2006-02-01 00:00:00'), TO_TIME('2008-02-01 00:00:00'), TO_DATE('2010-03-01 00:00:00:896', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-02-01'), TO_TIME('2015-02-01 00:00:00'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TO_DATE('2006-03-01 00:00:00'), TO_TIMESTAMP('2006-02-01 00:00:00'), TO_TIME('2008-02-01 00:00:00'), TO_DATE('2010-03-01 00:00:00:896', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-02-01'), TO_TIME('2015-02-01 00:00:00'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, \"YEAR\"(timestamps), \"YEAR\"(times), \"YEAR\"(unsignedDates), \"YEAR\"(unsignedTimestamps), \"YEAR\"(unsignedTimes) FROM " + tableName + " where \"YEAR\"(dates) = 2004");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2006L, (long)rs.getInt(2));
        Assert.assertEquals((long)2008L, (long)rs.getInt(3));
        Assert.assertEquals((long)2010L, (long)rs.getInt(4));
        Assert.assertEquals((long)2012L, (long)rs.getInt(5));
        Assert.assertEquals((long)2015L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMonthFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME, unsignedDates UNSIGNED_DATE, unsignedTimestamps UNSIGNED_TIMESTAMP, unsignedTimes UNSIGNED_TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-03-10 00:00:00'), TO_TIMESTAMP('2006-04-12 00:00:00'), TO_TIME('2008-05-16 00:00:00'), TO_DATE('2010-06-20 00:00:00:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:00'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2004-04-10 00:00:00'), TO_TIMESTAMP('2006-04-12 00:00:00'), TO_TIME('2008-05-16 00:00:00'), TO_DATE('2010-06-20 00:00:00:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:00'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TO_DATE('2004-05-10 00:00:00'), TO_TIMESTAMP('2006-04-12 00:00:00'), TO_TIME('2008-05-16 00:00:00'), TO_DATE('2010-06-20 00:00:00:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:00'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, \"MONTH\"(timestamps), \"MONTH\"(times), \"MONTH\"(unsignedDates), \"MONTH\"(unsignedTimestamps), \"MONTH\"(unsignedTimes) FROM " + tableName + " where \"MONTH\"(dates) = 3");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertEquals((long)5L, (long)rs.getInt(3));
        Assert.assertEquals((long)6L, (long)rs.getInt(4));
        Assert.assertEquals((long)7L, (long)rs.getInt(5));
        Assert.assertEquals((long)12L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnsignedTimeDateWithLiteral() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + "  (k1 INTEGER NOT NULL,unsignedDates UNSIGNED_DATE, unsignedTimestamps UNSIGNED_TIMESTAMP, unsignedTimes UNSIGNED_TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, '2010-06-20 12:00:00', '2012-07-28 12:00:00', '2015-12-25 12:00:00')";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, unsignedDates, unsignedTimestamps, unsignedTimes FROM " + tableName + " where k1 = 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2010-06-20 12:00:00"), (Object)rs.getDate(2));
        Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2012-07-28 12:00:00"), (Object)rs.getTimestamp(3));
        Assert.assertEquals((Object)DateUtil.parseTime((String)"2015-12-25 12:00:00"), (Object)rs.getTime(4));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSecondFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME, unsignedDates UNSIGNED_DATE, unsignedTimestamps UNSIGNED_TIMESTAMP, unsignedTimes UNSIGNED_TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-03-01 00:00:10'), TO_TIMESTAMP('2006-04-12 00:00:20'), TO_TIME('2008-05-16 10:00:30'), TO_DATE('2010-06-20 00:00:40:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:50'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + "  VALUES (2, TO_DATE('2004-03-01 00:00:10'), TO_TIMESTAMP('2006-04-12 00:20:30'), TO_TIME('2008-05-16 10:00:30'), TO_DATE('2010-06-20 00:00:40:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:50'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TO_DATE('2004-03-01 00:00:10'), TO_TIMESTAMP('2006-04-12 00:50:30'), TO_TIME('2008-05-16 10:00:30'), TO_DATE('2010-06-20 00:00:40:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:00:50'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, SECOND(dates), SECOND(times), SECOND(unsignedDates), SECOND(unsignedTimestamps), SECOND(unsignedTimes) FROM " + tableName + " where SECOND(timestamps)=20");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertEquals((long)30L, (long)rs.getInt(3));
        Assert.assertEquals((long)40L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertEquals((long)50L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testWeekFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + "  (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-01-10 10:00:10'), TO_TIMESTAMP('2006-04-12 08:00:20'), TO_TIME('2008-05-16 10:00:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2004-01-10 10:00:10'), TO_TIMESTAMP('2006-05-18 08:00:20'), TO_TIME('2008-05-16 10:00:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TO_DATE('2004-01-10 10:00:10'), TO_TIMESTAMP('2006-05-18 08:00:20'), TO_TIME('2008-05-16 10:00:30'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, \"WEEK\"(dates), \"WEEK\"(times) FROM " + tableName + " where \"WEEK\"(timestamps)=15");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)20L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testHourFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('Sat, 3 Feb 2008 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'UTC'), TO_TIMESTAMP('2006-04-12 15:10:20'), TO_TIME('2008-05-16 20:40:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('Sat, 3 Feb 2008 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'UTC'), TO_TIMESTAMP('2006-04-12 10:10:20'), TO_TIME('2008-05-16 20:40:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TO_DATE('Sat, 3 Feb 2008 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'UTC'), TO_TIMESTAMP('2006-04-12 08:10:20'), TO_TIME('2008-05-16 20:40:30'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, \"HOUR\"(dates), \"HOUR\"(times) FROM " + tableName + " where \"HOUR\"(timestamps)=15");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertEquals((long)20L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNowFunction() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        Date date = new Date(System.currentTimeMillis());
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, timestamps TIMESTAMP CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        PreparedStatement stmt = this.conn.prepareStatement(dml);
        stmt.setInt(1, 1);
        stmt.setDate(2, new Date(date.getTime() - 500L));
        stmt.execute();
        stmt.setInt(1, 2);
        stmt.setDate(2, new Date(date.getTime() + 600000L));
        stmt.execute();
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT * from " + tableName + "  where now() > timestamps");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)new Date(date.getTime() - 500L), (Object)rs.getDate(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMinuteFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME, unsignedDates UNSIGNED_DATE, unsignedTimestamps UNSIGNED_TIMESTAMP, unsignedTimes UNSIGNED_TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-03-01 00:10:10'), TO_TIMESTAMP('2006-04-12 00:20:20'), TO_TIME('2008-05-16 10:30:30'), TO_DATE('2010-06-20 00:40:40:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:50:50'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2004-03-01 00:10:10'), TO_TIMESTAMP('2006-04-12 00:50:20'), TO_TIME('2008-05-16 10:30:30'), TO_DATE('2010-06-20 00:40:40:789', 'yyyy-MM-dd HH:mm:ss:SSS'), TO_TIMESTAMP('2012-07-28'), TO_TIME('2015-12-25 00:50:50'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, \"MINUTE\"(dates), \"MINUTE\"(times), \"MINUTE\"(unsignedDates), \"MINUTE\"(unsignedTimestamps), \"MINUTE\"(unsignedTimes) FROM " + tableName + " where \"MINUTE\"(timestamps)=20");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)10L, (long)rs.getInt(2));
        Assert.assertEquals((long)30L, (long)rs.getInt(3));
        Assert.assertEquals((long)40L, (long)rs.getInt(4));
        Assert.assertEquals((long)0L, (long)rs.getInt(5));
        Assert.assertEquals((long)50L, (long)rs.getInt(6));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDayOfMonthFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2004-01-08 10:00:10'), TO_TIMESTAMP('2006-04-12 08:00:20'), TO_TIME('2008-05-26 11:00:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2004-01-18 10:00:10'), TO_TIMESTAMP('2006-05-22 08:00:20'), TO_TIME('2008-12-30 11:00:30'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, DAYOFMONTH(dates), DAYOFMONTH(times) FROM " + tableName + " where DAYOFMONTH(timestamps)=12");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)8L, (long)rs.getInt(2));
        Assert.assertEquals((long)26L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDayOfWeekFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2012-03-08 11:01:10'), TO_TIMESTAMP('2013-06-16 12:02:20'), TO_TIME('2014-09-23 13:03:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2013-04-09 11:02:10'), TO_TIMESTAMP('2014-05-18 12:03:20'), TO_TIME('2015-06-27 13:04:30'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, DAYOFWEEK(dates), DAYOFWEEK(timestamps) FROM " + tableName + " where DAYOFWEEK(times)=6");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)7L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDayOfYearFuncAgainstColumns() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL, dates DATE, timestamps TIMESTAMP, times TIME CONSTRAINT pk PRIMARY KEY (k1))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TO_DATE('2012-03-01 11:01:10'), TO_TIMESTAMP('2013-02-01 12:02:20'), TO_TIME('2014-01-15 13:03:30'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TO_DATE('2013-04-09 11:02:10'), TO_TIMESTAMP('2014-05-18 12:03:20'), TO_TIME('2015-06-27 13:04:30'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1, DAYOFYEAR(dates), DAYOFYEAR(timestamps) FROM " + tableName + " where DAYOFYEAR(times)=15");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)61L, (long)rs.getInt(2));
        Assert.assertEquals((long)32L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNullDate() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT a_date, entity_id from " + this.tableName + " WHERE entity_id = '" + ROW10 + "'");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)ROW10, (Object)rs.getString(2));
        Assert.assertNull((Object)rs.getDate(1));
        Assert.assertNull((Object)rs.getDate(1, GregorianCalendar.getInstance()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCurrentDateWithNoTable() throws Exception {
        long expectedTime = System.currentTimeMillis();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT CURRENT_DATE()");
        Assert.assertTrue((boolean)rs.next());
        long actualTime = rs.getDate(1).getTime();
        Assert.assertTrue((Math.abs(actualTime - expectedTime) < 86400000L ? 1 : 0) != 0);
    }

    @Test
    public void testSelectBetweenNanos() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER NOT NULL PRIMARY KEY, ts TIMESTAMP(3))";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1, TIMESTAMP'2015-01-01 00:00:00.111111111')";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2, TIMESTAMP'2015-01-01 00:00:00.111111115')";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3, TIMESTAMP'2015-01-01 00:00:00.111111113')";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k1,ts from " + tableName + " where ts between TIMESTAMP'2015-01-01 00:00:00.111111112' AND TIMESTAMP'2015-01-01 00:00:00.111111114'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals((long)111111113L, (long)rs.getTimestamp(2).getNanos());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCurrentTimeWithProjectedTable() throws Exception {
        String tableName1 = DateTimeIT.generateUniqueName();
        String tableName2 = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName1 + " ( ID integer primary key)";
        this.conn.createStatement().execute(ddl);
        ddl = "CREATE TABLE " + tableName2 + " ( ID integer primary key)";
        this.conn.createStatement().execute(ddl);
        String ups = "UPSERT INTO " + tableName1 + " VALUES (1)";
        this.conn.createStatement().execute(ups);
        ups = "UPSERT INTO " + tableName2 + " VALUES (1)";
        this.conn.createStatement().execute(ups);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("select /*+ USE_SORT_MERGE_JOIN */ op.id, current_time() from " + tableName1 + " op where op.id in (select id from " + tableName2 + ")");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)new java.util.Date().getYear(), (long)rs.getTimestamp(2).getYear());
    }

    @Test
    public void testLiteralDateComparison() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("select DATE '2016-05-10 00:00:00' > DATE '2016-05-11 00:00:00'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLiteralTimestampComparison() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("select TIMESTAMP '2016-05-10 00:00:00' > TIMESTAMP '2016-05-11 00:00:00'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLiteralDateTimestampComparison() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("select \"DATE\" '2016-05-10 00:00:00' > \"TIMESTAMP\" '2016-05-11 00:00:00'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLiteralDateTimestampComparison2() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("select \"TIMESTAMP\" '2016-05-10 00:00:00' > \"DATE\" '2016-05-11 00:00:00'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testFunctionOnNullDate() throws Exception {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT \"YEAR\"(a_date), entity_id from " + this.tableName + " WHERE entity_id = '" + ROW10 + "'");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)ROW10, (Object)rs.getString(2));
        Assert.assertNull((Object)rs.getDate(1));
        Assert.assertNull((Object)rs.getDate(1, GregorianCalendar.getInstance()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedDateTimestampUnequal() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates DATE, timestamps TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setDate(2, new Date(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedTimeTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, times TIME, timestamps TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setTime(2, new Time(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT times = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedDateTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates DATE, times TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = times FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedDateUnsignedTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates DATE, timestamps UNSIGNED_TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setDate(2, new Date(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedTimeUnsignedTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, times TIME, timestamps UNSIGNED_TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setTime(2, new Time(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT times = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedDateUnsignedTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates DATE, times UNSIGNED_TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = times FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedDateTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates UNSIGNED_DATE, timestamps TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setDate(2, new Date(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedTimeTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, times UNSIGNED_TIME, timestamps TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setTime(2, new Time(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT times = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedDateTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates UNSIGNED_DATE, times TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = times FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedDateUnsignedTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates UNSIGNED_DATE, timestamps UNSIGNED_TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setDate(2, new Date(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_DATE('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedTimeUnsignedTimestampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, times UNSIGNED_TIME, timestamps UNSIGNED_TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        stmt.setTime(2, new Time(1000L));
        Timestamp ts = new Timestamp(1000L);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIME('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT times = timestamps FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedDateUnsignedTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, dates UNSIGNED_DATE, times UNSIGNED_TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT dates = times FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedDateDateCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, date1 DATE, date2 DATE)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_DATE('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_DATE('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_DATE('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT date1 = date2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedDateUnsignedDateCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, date1 UNSIGNED_DATE, date2 UNSIGNED_DATE)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_DATE('2004-02-04 00:10:10'),TO_DATE('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_DATE('2004-02-04 00:10:10'), TO_DATE('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_DATE('2004-02-04 00:10:10'), TO_DATE('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT date1 = date2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedTimeTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, time1 TIME, time2 TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_TIME('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT time1 = time2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedTimeUnsignedTimeCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, time1 UNSIGNED_TIME, time2 UNSIGNED_TIME)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIME('2004-02-04 00:10:10'),TO_TIME('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIME('2004-02-04 00:10:10'), TO_TIME('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (3,TO_TIME('2004-02-04 00:10:10'), TO_TIME('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT time1 = time2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedTimeStampTimeStampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, timestamp1 TIMESTAMP, timestamp2 TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIMESTAMP('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIMESTAMP('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        Timestamp ts = new Timestamp(1000L);
        stmt.setTimestamp(2, ts);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIMESTAMP('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT timestamp1 = timestamp2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testProjectedUnsignedTimeStampUnsignedTimeStampCompare() throws Exception {
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (k1 INTEGER PRIMARY KEY, timestamp1 UNSIGNED_TIMESTAMP, timestamp2 UNSIGNED_TIMESTAMP)";
        this.conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (1,TO_TIMESTAMP('2004-02-04 00:10:10'),TO_TIMESTAMP('2006-04-12 00:10:10'))";
        this.conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES (2,TO_TIMESTAMP('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 15:10:20'))";
        this.conn.createStatement().execute(dml);
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?)");
        stmt.setInt(1, 3);
        Timestamp ts = new Timestamp(1000L);
        stmt.setTimestamp(2, ts);
        ts.setNanos(100);
        stmt.setTimestamp(3, ts);
        stmt.execute();
        dml = "UPSERT INTO " + tableName + " VALUES (4,TO_TIMESTAMP('2004-02-04 00:10:10'), TO_TIMESTAMP('2004-02-04 00:10:10'))";
        this.conn.createStatement().execute(dml);
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT timestamp1 = timestamp2 FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)true, (Object)rs.getBoolean(1));
        Assert.assertFalse((boolean)rs.next());
    }

    private static byte[][] getSplits(String tenantId) {
        return new byte[][]{ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)SPLIT1)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)SPLIT2)})};
    }

    private static Date toDate(String dateString) {
        return DateUtil.parseDate((String)dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateSubtractionCompareNumber() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and ? - \"DATE\" > 3";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            Date endDate = new Date(startDate.getTime() + 518400000L);
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, endDate);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"A", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"B", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateSubtractionLongToDecimalCompareNumber() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and ? - \"DATE\" - 1.5 > 3";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            Date endDate = new Date(startDate.getTime() + 777600000L);
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, endDate);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"A", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"B", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"C", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateSubtractionCompareDate() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and date - 1 >= ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            Date endDate = new Date(startDate.getTime() + 777600000L);
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, endDate);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"F", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateAddCompareDate() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and date + 1 >= ?";
        try (Connection conn = DriverManager.getConnection(url);){
            Date startDate = new Date(System.currentTimeMillis());
            Date endDate = new Date(startDate.getTime() + 691200000L);
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, endDate);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"E", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"F", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentDate() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and \"DATE\" - current_date() > 8";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"F", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentTime() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String tenantId = DateTimeIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and \"DATE\" - current_time() > 8";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            DateTimeIT.initDateTableValues(tablename, tenantId, DateTimeIT.getSplits(tenantId), startDate);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"F", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCastTimeStampToDate() throws Exception {
        String tablename = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tablename + " (PK INTEGER PRIMARY KEY, A_TIMESTAMP TIMESTAMP)";
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", TimeZone.getDefault().toString());
        Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        String localTime = LocalDate.now().toString();
        conn.createStatement().execute("UPSERT INTO " + tablename + " VALUES(1,TO_TIMESTAMP('" + localTime + "'))");
        conn.setAutoCommit(true);
        try {
            PreparedStatement statement = conn.prepareStatement("SELECT CAST(A_TIMESTAMP AS DATE) as A_DATE FROM " + tablename);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.getString(1).contains(localTime));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestamp() throws Exception {
        String updateStmt = "upsert into " + this.tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_TIMESTAMP) VALUES (?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection upsertConn = DriverManager.getConnection(url, props);
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A423122312312");
        Timestamp tsValue1 = new Timestamp(5000L);
        byte[] ts1 = PTimestamp.INSTANCE.toBytes((Object)tsValue1);
        stmt.setTimestamp(3, tsValue1);
        stmt.execute();
        Connection conn1 = DriverManager.getConnection(url, props);
        TestUtil.analyzeTable(conn1, this.tableName);
        conn1.close();
        updateStmt = "upsert into " + this.tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_TIMESTAMP,    A_TIME) VALUES (?, ?, ?, ?)";
        stmt = upsertConn.prepareStatement(updateStmt);
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B523122312312");
        Timestamp tsValue2 = new Timestamp(5000L);
        tsValue2.setNanos(200);
        byte[] ts2 = PTimestamp.INSTANCE.toBytes((Object)tsValue2);
        stmt.setTimestamp(3, tsValue2);
        stmt.setTime(4, new Time(tsValue2.getTime()));
        stmt.execute();
        upsertConn.close();
        Assert.assertTrue((boolean)TestUtil.compare(CompareOperator.GREATER, new ImmutableBytesWritable(ts2), new ImmutableBytesWritable(ts1)));
        Assert.assertFalse((boolean)TestUtil.compare(CompareOperator.GREATER, new ImmutableBytesWritable(ts1), new ImmutableBytesWritable(ts1)));
        String query = "SELECT entity_id, a_timestamp, a_time FROM " + this.tableName + " WHERE organization_id=? and a_timestamp > ?";
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setTimestamp(2, new Timestamp(5000L));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B523122312312");
            Assert.assertEquals((Object)rs.getTimestamp("A_TIMESTAMP"), (Object)tsValue2);
            Assert.assertEquals((Object)rs.getTime("A_TIME"), (Object)new Time(tsValue2.getTime()));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDateFormatTimeZone() throws Exception {
        String[] timeZoneIDs;
        for (String timeZoneID : timeZoneIDs = new String[]{"GMT", "Asia/Yerevan", "Australia/Adelaide", "Asia/Tokyo"}) {
            this.testDateFormatTimeZone(timeZoneID);
        }
    }

    private String getFormattedDate(List<String> dateList) {
        return String.join((CharSequence)"-", dateList.subList(0, 3)) + " " + String.join((CharSequence)":", dateList.subList(3, 6)) + "." + dateList.get(6);
    }

    @Test
    public void testAncientDates() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        Statement stmt = conn.createStatement();
        String tableName = DateTimeIT.generateUniqueName();
        List<String> date1list = Arrays.asList("0010", "10", "10", "10", "10", "10", "111");
        List<String> date2list = Arrays.asList("1001", "02", "03", "04", "05", "06", "000");
        List<String> date3list = Arrays.asList("0001", "12", "31", "23", "59", "59", "000");
        List<List> dateLists = Arrays.asList(date1list, date2list, date3list, date2list);
        String date1 = this.getFormattedDate(date1list);
        String date2 = this.getFormattedDate(date2list);
        String date3 = this.getFormattedDate(date3list);
        List<String> dates = Arrays.asList(date1, date2, date3, date2);
        stmt.execute("CREATE TABLE " + tableName + " ( id INTEGER not null PRIMARY KEY, date DATE, time TIME, timestamp TIMESTAMP)");
        stmt.execute("UPSERT INTO " + tableName + " VALUES(1, TO_DATE('" + date1 + "'), TO_TIME('" + date1 + "'), TO_TIMESTAMP('" + date1 + "'))");
        PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values (?, ?, ?, ?)");
        pstmt.setInt(1, 2);
        Timestamp t = new Timestamp(DateUtil.parseDate((String)date2).getTime());
        pstmt.setDate(2, new Date(t.getTime()));
        pstmt.setTime(3, new Time(t.getTime()));
        pstmt.setTimestamp(4, t);
        pstmt.execute();
        pstmt.setInt(1, 3);
        t = new Timestamp(DateUtil.parseDate((String)date3).getTime());
        pstmt.setDate(2, new Date(t.getTime()));
        pstmt.setTime(3, new Time(t.getTime()));
        pstmt.setTimestamp(4, t);
        pstmt.execute();
        String f = " GMT', 'yyyy-MM-dd HH:mm:ss.SSS z', 'UTC";
        stmt.execute("UPSERT INTO " + tableName + " VALUES(4, TO_DATE('" + date2 + f + "'), TO_TIME('" + date2 + f + "'), TO_TIMESTAMP('" + date2 + f + "'))");
        conn.commit();
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " ORDER BY id");
        for (int i = 0; i < dates.size(); ++i) {
            Assert.assertTrue((boolean)rs.next());
            String actualDate = dates.get(i);
            Timestamp expectedTimestamp = DateUtil.parseTimestamp((String)actualDate);
            Assert.assertEquals((long)(i + 1), (long)rs.getInt(1));
            Date expectedDate = new Date(expectedTimestamp.getTime());
            Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(2));
            Assert.assertEquals((Object)rs.getDate(2), (Object)rs.getObject(2));
            Assert.assertEquals((Object)actualDate, (Object)rs.getString(2));
            Time expectedTime = new Time(expectedTimestamp.getTime());
            Assert.assertEquals((Object)new Timestamp(expectedTime.getTime()), (Object)new Timestamp(rs.getTime(3).getTime()));
            Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(3));
            Assert.assertEquals((Object)rs.getTime(3), (Object)rs.getObject(3));
            Assert.assertEquals((Object)actualDate, (Object)rs.getString(3));
            Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(4));
            Assert.assertEquals((Object)rs.getTimestamp(4), (Object)rs.getObject(4));
            Assert.assertEquals((Object)actualDate, (Object)rs.getString(4));
        }
        String query = "SELECT year(timestamp), month(timestamp), dayofmonth(timestamp), hour(timestamp), minute(timestamp), second(timestamp) FROM " + tableName + " ORDER BY id";
        rs = stmt.executeQuery(query);
        for (int i = 0; i < dates.size(); ++i) {
            Assert.assertTrue((boolean)rs.next());
            List dateList = dateLists.get(i);
            for (int j = 0; j < 6; ++j) {
                int expected = Integer.parseInt((String)dateList.get(j));
                int value = rs.getInt(j + 1);
                String readFunc = query.split("\\s+")[j + 1];
                Assert.assertTrue((String)("Expected for " + readFunc.substring(0, readFunc.length() - 1) + ": " + expected + ", got: " + value), (expected == value ? 1 : 0) != 0);
            }
        }
        pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values (?, ?, ?, ?)");
        pstmt.setInt(1, 5);
        long l = -123456789100000L;
        Timestamp inserted = new Timestamp(l);
        pstmt.setDate(2, new Date(inserted.getTime()));
        pstmt.setTime(3, new Time(inserted.getTime()));
        pstmt.setTimestamp(4, inserted);
        pstmt.execute();
        conn.commit();
        rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id=5 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Timestamp read = rs.getTimestamp(4);
        Assert.assertEquals((Object)inserted, (Object)read);
    }

    @Test
    public void testAncientDatesWithJavaTime() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        Statement stmt = conn.createStatement();
        String tableName = DateTimeIT.generateUniqueName();
        stmt.execute("CREATE TABLE " + tableName + " ( id INTEGER not null PRIMARY KEY,timestamp TIMESTAMP)");
        String date = "0010-10-10T10:10:10.111Z";
        Instant instant = Instant.parse(date);
        PreparedStatement pstmt = conn.prepareStatement("UPSERT INTO " + tableName + " values (?, ?)");
        pstmt.setInt(1, 1);
        Timestamp inserted = new Timestamp(instant.toEpochMilli());
        pstmt.setTimestamp(2, inserted);
        pstmt.execute();
        conn.commit();
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id=1");
        Assert.assertTrue((boolean)rs.next());
        Timestamp read = rs.getTimestamp(2);
        Assert.assertEquals((Object)inserted, (Object)read);
        Assert.assertEquals((Object)instant, (Object)Instant.ofEpochMilli(read.getTime()));
        Assert.assertEquals((long)instant.toEpochMilli(), (long)read.getTime());
        Assert.assertEquals((Object)read.toString().split("\\s+")[0], (Object)"0010-10-12");
        Assert.assertEquals((Object)instant.toString().split("T")[0], (Object)"0010-10-10");
        LocalDateTime localDateTime = LocalDateTime.of(10, 10, 10, 10, 10, 10);
        pstmt.setInt(1, 2);
        inserted = Timestamp.valueOf(localDateTime);
        pstmt.setTimestamp(2, inserted);
        pstmt.execute();
        conn.commit();
        rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id=2");
        Assert.assertTrue((boolean)rs.next());
        read = rs.getTimestamp(2);
        Assert.assertEquals((Object)inserted, (Object)read);
        Assert.assertEquals((Object)localDateTime, (Object)read.toLocalDateTime());
        Assert.assertEquals((long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)read.toLocalDateTime().toEpochSecond(ZoneOffset.UTC));
        Assert.assertEquals((Object)read.toString().split("\\s+")[0], (Object)"0010-10-10");
        Assert.assertEquals((Object)instant.toString().split("T")[0], (Object)"0010-10-10");
        Assert.assertNotEquals((long)instant.toEpochMilli(), (long)read.getTime());
        pstmt.setInt(1, 3);
        LocalDateTime localDateTime1 = LocalDateTime.ofInstant(instant, ZoneId.of("GMT"));
        inserted = Timestamp.valueOf(localDateTime1);
        pstmt.setTimestamp(2, inserted);
        pstmt.execute();
        conn.commit();
        rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id=3");
        Assert.assertTrue((boolean)rs.next());
        read = rs.getTimestamp(2);
        Assert.assertEquals((Object)inserted, (Object)read);
        Assert.assertEquals((Object)localDateTime1, (Object)read.toLocalDateTime());
        Assert.assertEquals((Object)read.toString().split("\\s+")[0], (Object)"0010-10-10");
        Assert.assertEquals((Object)localDateTime1.toString().split("T")[0], (Object)"0010-10-10");
        Instant inst = localDateTime1.toInstant(ZoneOffset.UTC);
        Assert.assertEquals((Object)instant, (Object)inst);
        Assert.assertNotEquals((long)inst.toEpochMilli(), (long)inserted.getTime());
        String query = "SELECT dayofmonth(timestamp) FROM " + tableName;
        rs = stmt.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)12L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateFormatTimeZone(String timeZoneId) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", timeZoneId);
        Connection conn1 = DriverManager.getConnection(DateTimeIT.getUrl(), props);
        String tableName = DateTimeIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (k1 INTEGER PRIMARY KEY, v_date DATE, v_time TIME, v_timestamp TIMESTAMP)";
        try {
            conn1.createStatement().execute(ddl);
            PhoenixConnection pConn = conn1.unwrap(PhoenixConnection.class);
            this.verifyTimeZoneIDWithConn(pConn, (PDataType)PDate.INSTANCE, timeZoneId);
            this.verifyTimeZoneIDWithConn(pConn, (PDataType)PTime.INSTANCE, timeZoneId);
            this.verifyTimeZoneIDWithConn(pConn, (PDataType)PTimestamp.INSTANCE, timeZoneId);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZoneId));
            cal.setTime(this.date);
            String dateStr = DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(this.date);
            String dml = "UPSERT INTO " + tableName + " VALUES (1,'" + dateStr + "','" + dateStr + "','" + dateStr + "')";
            conn1.createStatement().execute(dml);
            conn1.commit();
            PhoenixStatement stmt = conn1.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT v_date, v_time, v_timestamp FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getDate(1).toString(), (Object)new Date(cal.getTimeInMillis()).toString());
            Assert.assertEquals((Object)rs.getTime(2).toString(), (Object)new Time(cal.getTimeInMillis()).toString());
            Assert.assertEquals((long)rs.getTimestamp(3).getTime(), (long)cal.getTimeInMillis());
            Assert.assertFalse((boolean)rs.next());
            StatementContext stmtContext = stmt.getQueryPlan().getContext();
            this.verifyTimeZoneIDWithFormatter(stmtContext.getDateFormatter(), timeZoneId);
            this.verifyTimeZoneIDWithFormatter(stmtContext.getTimeFormatter(), timeZoneId);
            this.verifyTimeZoneIDWithFormatter(stmtContext.getTimestampFormatter(), timeZoneId);
            stmt.close();
        }
        finally {
            conn1.close();
        }
    }

    private void verifyTimeZoneIDWithConn(PhoenixConnection conn, PDataType dataType, String timeZoneId) {
        Format formatter = conn.getFormatter(dataType);
        this.verifyTimeZoneIDWithFormatter(formatter, timeZoneId);
    }

    private void verifyTimeZoneIDWithFormatter(Format formatter, String timeZoneId) {
        Assert.assertTrue((boolean)(formatter instanceof FastDateFormat));
        Assert.assertEquals((Object)((FastDateFormat)formatter).getTimeZone().getID(), (Object)timeZoneId);
    }

    @Test
    public void testJdbc42ApiWithoutDisplacement() throws SQLException {
        this.testJdbc42Api(false);
    }

    @Test
    public void testJdbc42ApiWithDisplacement() throws SQLException {
        this.testJdbc42Api(true);
    }

    private void testJdbc42Api(boolean withDisplacement) throws SQLException {
        ZoneId testZoneId;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        if (withDisplacement) {
            testZoneId = ZoneOffset.systemDefault();
            props.setProperty("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        } else {
            testZoneId = ZoneId.of("UTC");
        }
        try (Connection conn = DriverManager.getConnection(DateTimeIT.getUrl(), props);){
            String tableName = DateTimeIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, D DATE, T TIME, S TIMESTAMP, UD UNSIGNED_DATE, UT UNSIGNED_TIME, US UNSIGNED_TIMESTAMP)";
            LocalDateTime localDateTime = LocalDateTime.now();
            LocalDateTime localDateTimeMs = localDateTime.withNano(localDateTime.getNano() / 1000000 * 1000000);
            LocalDate localDate = localDateTime.toLocalDate();
            LocalTime localTime = localDateTime.toLocalTime();
            LocalTime localTimeMs = localTime.withNano(localDateTime.getNano() / 1000000 * 1000000);
            Timestamp javaSqlTimestampFull = Timestamp.from(localDateTime.atZone(testZoneId).toInstant());
            Timestamp javaSqlTimestampFullMs = new Timestamp(javaSqlTimestampFull.getTime());
            Timestamp javaSqlTimestampDatePart = Timestamp.from(localDate.atStartOfDay().atZone(testZoneId).toInstant());
            Timestamp javaSqlTimestampTimePart = Timestamp.from(localTime.atDate(DateUtil.LD_EPOCH).atZone(testZoneId).toInstant());
            Timestamp javaSqlTimestampTimePartMs = new Timestamp(javaSqlTimestampTimePart.getTime());
            java.util.Date javaUtilDateFull = new java.util.Date(javaSqlTimestampFull.getTime());
            java.util.Date javaUtilDateDatePart = new java.util.Date(javaSqlTimestampDatePart.getTime());
            java.util.Date javaUtilDateTimePart = new java.util.Date(javaSqlTimestampTimePart.getTime());
            Date javaSqlDateFull = new Date(javaSqlTimestampFull.getTime());
            Time javaSqlTimeFull = new Time(javaSqlTimestampFull.getTime());
            String dml = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (Statement stmt = conn.createStatement();
                 PreparedStatement ps = conn.prepareStatement(dml);){
                int i;
                stmt.executeUpdate(ddl);
                ps.setInt(1, 1);
                ps.setObject(2, localDateTime);
                ps.setObject(3, localDateTime);
                ps.setObject(4, localDateTime);
                ps.setObject(5, localDateTime);
                ps.setObject(6, localDateTime);
                ps.setObject(7, localDateTime);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                ps.setInt(1, 2);
                ps.setObject(2, localDate);
                ps.setObject(3, localDate);
                ps.setObject(4, localDate);
                ps.setObject(5, localDate);
                ps.setObject(6, localDate);
                ps.setObject(7, localDate);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                ps.setInt(1, 3);
                ps.setObject(2, localTime);
                ps.setObject(3, localTime);
                ps.setObject(4, localTime);
                ps.setObject(5, localTime);
                ps.setObject(6, localTime);
                ps.setObject(7, localTime);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                ps.setInt(1, 4);
                ps.setObject(2, javaSqlTimestampFull);
                ps.setObject(3, javaSqlTimestampFull);
                ps.setObject(4, javaSqlTimestampFull);
                ps.setObject(5, javaSqlTimestampFull);
                ps.setObject(6, javaSqlTimestampFull);
                ps.setObject(7, javaSqlTimestampFull);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                ps.setInt(1, 5);
                ps.setObject(2, javaSqlDateFull);
                ps.setObject(3, javaSqlDateFull);
                ps.setObject(4, javaSqlDateFull);
                ps.setObject(5, javaSqlDateFull);
                ps.setObject(6, javaSqlDateFull);
                ps.setObject(7, javaSqlDateFull);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                ps.setInt(1, 6);
                ps.setObject(2, javaSqlTimeFull);
                ps.setObject(3, javaSqlTimeFull);
                ps.setObject(4, javaSqlTimeFull);
                ps.setObject(5, javaSqlTimeFull);
                ps.setObject(6, javaSqlTimeFull);
                ps.setObject(7, javaSqlTimeFull);
                Assert.assertEquals((long)1L, (long)ps.executeUpdate());
                conn.commit();
                ResultSet rs = stmt.executeQuery("select * from " + tableName + " order by id");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    if (i == 4 || i == 7) {
                        Assert.assertEquals((Object)javaSqlTimestampFull, (Object)rs.getTimestamp(i));
                        Assert.assertEquals((Object)localDateTime, (Object)rs.getObject(i, LocalDateTime.class));
                        Assert.assertEquals((Object)localTime, (Object)rs.getObject(i, LocalTime.class));
                    } else {
                        Assert.assertEquals((Object)javaSqlDateFull, (Object)rs.getTimestamp(i));
                        Assert.assertEquals((Object)localDateTimeMs, (Object)rs.getObject(i, LocalDateTime.class));
                        Assert.assertEquals((Object)localTimeMs, (Object)rs.getObject(i, LocalTime.class));
                    }
                    Assert.assertEquals((Object)localDate, (Object)rs.getObject(i, LocalDate.class));
                    Assert.assertEquals((Object)javaUtilDateFull, (Object)rs.getObject(i, java.util.Date.class));
                }
                Assert.assertEquals((Object)localDateTimeMs, (Object)rs.getObject("D", LocalDateTime.class));
                Assert.assertEquals((Object)localDateTimeMs, (Object)rs.getObject("T", LocalDateTime.class));
                Assert.assertEquals((Object)localDateTime, (Object)rs.getObject("S", LocalDateTime.class));
                Assert.assertEquals((Object)localDateTimeMs, (Object)rs.getObject("UD", LocalDateTime.class));
                Assert.assertEquals((Object)localDateTimeMs, (Object)rs.getObject("UT", LocalDateTime.class));
                Assert.assertEquals((Object)localDateTime, (Object)rs.getObject("US", LocalDateTime.class));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    Assert.assertEquals((Object)javaSqlTimestampDatePart, (Object)rs.getTimestamp(i));
                    Assert.assertEquals((Object)javaUtilDateDatePart, (Object)rs.getObject(i, java.util.Date.class));
                }
                Assert.assertEquals((Object)localDate, (Object)rs.getObject(2, LocalDate.class));
                Assert.assertEquals((Object)localDate, (Object)rs.getObject(5, LocalDate.class));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    if (i == 4 || i == 7) {
                        Assert.assertEquals((Object)javaSqlTimestampTimePart, (Object)rs.getTimestamp(i));
                        Assert.assertEquals((Object)localTime, (Object)rs.getObject(i, LocalTime.class));
                    } else {
                        Assert.assertEquals((Object)javaSqlTimestampTimePartMs, (Object)rs.getTimestamp(i));
                    }
                    Assert.assertEquals((Object)javaUtilDateTimePart, (Object)rs.getObject(i, java.util.Date.class));
                }
                Assert.assertEquals((Object)localTimeMs, (Object)rs.getObject(3, LocalTime.class));
                Assert.assertEquals((Object)localTimeMs, (Object)rs.getObject(6, LocalTime.class));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    if (i == 4 || i == 7) {
                        Assert.assertEquals((Object)javaSqlTimestampFull, (Object)rs.getObject(i, Timestamp.class));
                        continue;
                    }
                    Assert.assertEquals((Object)javaSqlTimestampFullMs, (Object)rs.getObject(i, Timestamp.class));
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)5L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    Assert.assertEquals((Object)javaSqlDateFull, (Object)rs.getObject(i, Date.class));
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)6L, (long)rs.getInt(1));
                for (i = 2; i <= 7; ++i) {
                    Assert.assertEquals((long)javaSqlTimeFull.getTime(), (long)rs.getObject(i, Time.class).getTime());
                }
            }
        }
    }
}

