/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class CursorWithRowValueConstructorIT
extends ParallelStatsDisabledIT {
    private String tableName = CursorWithRowValueConstructorIT.generateUniqueName();

    public void createAndInitializeTestTable() throws SQLException {
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());
        this.tableName = CursorWithRowValueConstructorIT.generateUniqueName();
        PreparedStatement stmt = conn.prepareStatement("CREATE TABLE " + this.tableName + "(a_id INTEGER NOT NULL, a_data INTEGER, CONSTRAINT my_pk PRIMARY KEY (a_id))");
        stmt.execute();
        conn.commit();
        Random rand = new Random();
        stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + "(a_id, a_data) VALUES (?,?)");
        for (int rowCount = 0; rowCount < 100; ++rowCount) {
            stmt.setInt(1, rowCount);
            stmt.setInt(2, rand.nextInt(501));
            stmt.execute();
        }
        conn.commit();
        conn.close();
    }

    @Test
    public void testCursorsOnTestTablePK() throws SQLException {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            this.createAndInitializeTestTable();
            String querySQL = "SELECT a_id FROM " + this.tableName;
            String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR " + querySQL;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "OPEN " + cursorName;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursorSQL).executeQuery();
            int rowID = 0;
            while (rs.next()) {
                Assert.assertEquals((long)rowID, (long)rs.getInt(1));
                ++rowID;
                rs = conn.createStatement().executeQuery(cursorSQL);
            }
            conn.prepareStatement("CLOSE " + cursorName).execute();
        }
    }

    @Test
    public void testCursorsOnRandomTableData() throws SQLException {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            this.createAndInitializeTestTable();
            String querySQL = "SELECT a_id,a_data FROM " + this.tableName + " ORDER BY a_data";
            String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR " + querySQL;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "OPEN " + cursorName;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "FETCH NEXT FROM " + cursorName;
            ResultSet cursorRS = conn.prepareStatement(cursorSQL).executeQuery();
            ResultSet rs = conn.prepareStatement(querySQL).executeQuery();
            int rowCount = 0;
            while (rs.next() && cursorRS.next()) {
                Assert.assertEquals((long)rs.getInt(2), (long)cursorRS.getInt(2));
                ++rowCount;
                cursorRS = conn.prepareStatement(cursorSQL).executeQuery();
            }
            Assert.assertEquals((long)100L, (long)rowCount);
            conn.prepareStatement("CLOSE " + cursorName).execute();
        }
    }

    @Test
    public void testCursorsOnTestTablePKDesc() throws SQLException {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            this.createAndInitializeTestTable();
            String dummySQL = "SELECT a_id FROM " + this.tableName + " ORDER BY a_id DESC";
            String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR " + dummySQL;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "OPEN " + cursorName;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursorSQL).executeQuery();
            int rowCount = 0;
            while (rs.next()) {
                Assert.assertEquals((long)(99 - rowCount), (long)rs.getInt(1));
                rs = conn.prepareStatement(cursorSQL).executeQuery();
                ++rowCount;
            }
            Assert.assertEquals((long)100L, (long)rowCount);
            conn.prepareStatement("CLOSE " + cursorName).execute();
        }
    }

    @Test
    public void testCursorsOnTestTableNonPKDesc() throws SQLException {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            this.createAndInitializeTestTable();
            String dummySQL = "SELECT a_data FROM " + this.tableName + " ORDER BY a_data DESC";
            String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR " + dummySQL;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "OPEN " + cursorName;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursorSQL).executeQuery();
            int rowCount = 0;
            while (rs.next()) {
                rs = conn.prepareStatement(cursorSQL).executeQuery();
                ++rowCount;
            }
            Assert.assertEquals((long)100L, (long)rowCount);
            conn.prepareStatement("CLOSE " + cursorName).execute();
        }
    }

    @Test
    public void testCursorsOnWildcardSelect() throws SQLException {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            this.createAndInitializeTestTable();
            String querySQL = "SELECT * FROM " + this.tableName;
            ResultSet rs = conn.prepareStatement(querySQL).executeQuery();
            String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR " + querySQL;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "OPEN " + cursorName;
            conn.prepareStatement(cursorSQL).execute();
            cursorSQL = "FETCH NEXT FROM " + cursorName;
            ResultSet cursorRS = conn.prepareStatement(cursorSQL).executeQuery();
            int rowCount = 0;
            while (rs.next() && cursorRS.next()) {
                Assert.assertEquals((long)rs.getInt(1), (long)cursorRS.getInt(1));
                ++rowCount;
                cursorRS = conn.prepareStatement(cursorSQL).executeQuery();
            }
            Assert.assertEquals((long)100L, (long)rowCount);
            conn.prepareStatement("CLOSE " + cursorName).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsWithBindings() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE ?=organization_id AND (a_integer, x_integer) = (7, 5)";
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl());){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                PreparedStatement statement = conn.prepareStatement(cursor);
                statement.setString(1, tenantId);
                statement.execute();
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().equalsIgnoreCase("Cannot declare cursor, internal SELECT statement contains bindings!"));
                Assert.assertFalse((boolean)CursorUtil.cursorDeclared((String)cursorName));
                if (conn != null) {
                    if (var6_6 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
                return;
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsInWhereWithEqualsExpression() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id AND (a_integer, x_integer) = (7, 5)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    Assert.assertTrue((rs.getInt(1) == 7 ? 1 : 0) != 0);
                    Assert.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertTrue((count == 1 ? 1 : 0) != 0);
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsInWhereWithGreaterThanExpression() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id  AND (a_integer, x_integer) >= (4, 4)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    Assert.assertTrue((rs.getInt(1) >= 4 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)(rs.getInt(1) == 4 ? rs.getInt(2) >= 4 : rs.getInt(2) >= 0));
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertTrue((count == 5 ? 1 : 0) != 0);
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsInWhereWithUnEqualNumberArgs() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id  AND (a_integer, x_integer, y_integer) >= (7, 5)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                double startTime = System.nanoTime();
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    Assert.assertTrue((rs.getInt(1) >= 7 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)(rs.getInt(1) == 7 ? rs.getInt(2) >= 5 : rs.getInt(2) >= 0));
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertTrue((count == 3 ? 1 : 0) != 0);
                double endTime = System.nanoTime();
                System.out.println("Method Time in milliseconds: " + Double.toString((endTime - startTime) / 1000000.0));
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsOnLHSAndLiteralExpressionOnRHS() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id  AND (a_integer, x_integer) >= 7";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertTrue((count == 3 ? 1 : 0) != 0);
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsOnRHSLiteralExpressionOnLHS() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id  AND 7 <= (a_integer, x_integer)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertTrue((count == 3 ? 1 : 0) != 0);
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsOnBuiltInFunctionOperatingOnIntegerLiteral() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + aTable + " WHERE '" + tenantId + "'=organization_id  AND (a_integer, x_integer) >= to_number('7')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);){
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            try {
                conn.prepareStatement(cursor).execute();
                cursor = "OPEN " + cursorName;
                conn.prepareStatement(cursor).execute();
                cursor = "FETCH NEXT FROM " + cursorName;
                ResultSet rs = conn.prepareStatement(cursor).executeQuery();
                int count = 0;
                while (rs.next()) {
                    ++count;
                    rs = conn.prepareStatement(cursor).executeQuery();
                }
                Assert.assertEquals((long)3L, (long)count);
            }
            finally {
                cursor = "CLOSE " + cursorName;
                conn.prepareStatement(cursor).execute();
            }
        }
    }

    @Test
    public void testCursorsWithDateDatatypeFilter() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        long currentTime = System.currentTimeMillis();
        Date date = new Date(currentTime);
        String strCurrentDate = date.toString();
        while (date.toString().equals(strCurrentDate)) {
            date = new Date(--currentTime);
        }
        date = new Date(currentTime + 2L);
        Date midnight = new Date(currentTime + 1L);
        String tableName = CursorWithRowValueConstructorIT.initEntityHistoryTableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), date, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        String query = "select parent_id from " + tableName + " WHERE (organization_id, parent_id, created_date, entity_history_id) IN ((?,?,?,?),(?,?,?,?))";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'0500x0000000003'");
        query = query.replaceFirst("\\?", "TO_DATE('" + DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(date) + "')");
        query = query.replaceFirst("\\?", "'017x00000000003'");
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'0500x0000000007'");
        query = query.replaceFirst("\\?", "TO_DATE('" + DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(date) + "')");
        query = query.replaceFirst("\\?", "'017x00000000007'");
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
        conn.prepareStatement(cursor).execute();
        cursor = "OPEN " + cursorName;
        conn.prepareStatement(cursor).execute();
        cursor = "FETCH NEXT FROM " + cursorName;
        ResultSet rs = conn.prepareStatement(cursor).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"0500x0000000003", (Object)rs.getString(1));
        rs = conn.prepareStatement(cursor).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"0500x0000000007", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        query = "select parent_id from " + tableName + " WHERE (organization_id, parent_id, created_date, entity_history_id) IN ((?,?,?,?),(?,?,?,?))";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'0500x0000000003'");
        query = query.replaceFirst("\\?", "TO_DATE('" + DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(midnight) + "')");
        query = query.replaceFirst("\\?", "'017x00000000003'");
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'0500x0000000007'");
        query = query.replaceFirst("\\?", "TO_DATE('" + DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(midnight) + "')");
        query = query.replaceFirst("\\?", "'017x00000000007'");
        String cursorName2 = CursorWithRowValueConstructorIT.generateUniqueName();
        cursor = "DECLARE " + cursorName2 + " CURSOR FOR " + query;
        conn.prepareStatement(cursor).execute();
        cursor = "OPEN " + cursorName2;
        conn.prepareStatement(cursor).execute();
        cursor = "FETCH NEXT FROM " + cursorName2;
        rs = conn.prepareStatement(cursor).executeQuery();
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        String sql = "CLOSE " + cursorName;
        conn.prepareStatement(sql).execute();
        sql = "CLOSE " + cursorName2;
        conn.prepareStatement(sql).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsWithNonLeadingPkColsOfTypesTimeStampAndVarchar() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String updateStmt = "upsert into " + aTable + "(    ORGANIZATION_ID,     ENTITY_ID,     A_TIMESTAMP) VALUES (?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection upsertConn = DriverManager.getConnection(url, props);
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A423122312312");
        Timestamp tsValue = new Timestamp(System.nanoTime());
        stmt.setTimestamp(3, tsValue);
        stmt.execute();
        String query = "SELECT a_timestamp, a_string FROM " + aTable + " WHERE ?=organization_id  AND (a_timestamp, a_string) = (?, 'a')";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "TO_DATE('" + DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(tsValue) + "')");
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        try {
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            conn.prepareStatement(cursor).execute();
            cursor = "OPEN " + cursorName;
            conn.prepareStatement(cursor).execute();
            cursor = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursor).executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((boolean)rs.getTimestamp(1).equals(tsValue));
                Assert.assertTrue((rs.getString(2).compareTo("a") == 0 ? 1 : 0) != 0);
                ++count;
                rs = conn.prepareStatement(cursor).executeQuery();
            }
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        }
        finally {
            String sql = "CLOSE " + cursorName;
            conn.prepareStatement(sql).execute();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsQueryMoreWithInListClausePossibleNullValues() throws Exception {
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String updateStmt = "upsert into " + aTable + "(ORGANIZATION_ID, ENTITY_ID, Y_INTEGER, X_INTEGER) VALUES (?, ?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection upsertConn = DriverManager.getConnection(url, props);
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A423122312312");
        stmt.setInt(3, 4);
        stmt.setInt(4, 5);
        stmt.execute();
        String query = "SELECT x_integer, y_integer FROM " + aTable + " WHERE ? = organization_id AND (x_integer) IN ((5))";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        try {
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            conn.prepareStatement(cursor).execute();
            cursor = "OPEN " + cursorName;
            conn.prepareStatement(cursor).execute();
            cursor = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursor).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            rs = conn.prepareStatement(cursor).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
        }
        finally {
            String sql = "CLOSE " + cursorName;
            conn.prepareStatement(sql).execute();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsWithColsOfTypesDecimal() throws Exception {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT x_decimal FROM " + aTable + " WHERE ?=organization_id AND entity_id IN (?,?,?)";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'00B723122312312'");
        query = query.replaceFirst("\\?", "'00B823122312312'");
        query = query.replaceFirst("\\?", "'00C923122312312'");
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        try {
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            conn.prepareStatement(cursor).execute();
            cursor = "OPEN " + cursorName;
            conn.prepareStatement(cursor).execute();
            cursor = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursor).executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((BigDecimal.valueOf(0.1).equals(rs.getBigDecimal(1)) || BigDecimal.valueOf(3.9).equals(rs.getBigDecimal(1)) || BigDecimal.valueOf(3.3).equals(rs.getBigDecimal(1)) ? 1 : 0) != 0);
                if (++count == 3) break;
                rs = conn.prepareStatement(cursor).executeQuery();
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
        finally {
            String sql = "CLOSE " + cursorName;
            conn.prepareStatement(sql).execute();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorsWithColsOfTypesTinyintSmallintFloatDouble() throws Exception {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String tenantId = CursorWithRowValueConstructorIT.getOrganizationId();
        String aTable = CursorWithRowValueConstructorIT.initATableValues(null, tenantId, CursorWithRowValueConstructorIT.getDefaultSplits(tenantId), null, null, CursorWithRowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_byte,a_short,a_float,a_double FROM " + aTable + " WHERE ?=organization_id AND entity_id IN (?,?,?)";
        query = query.replaceFirst("\\?", "'" + tenantId + "'");
        query = query.replaceFirst("\\?", "'00A123122312312'");
        query = query.replaceFirst("\\?", "'00A223122312312'");
        query = query.replaceFirst("\\?", "'00A323122312312'");
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        try {
            String cursor = "DECLARE " + cursorName + " CURSOR FOR " + query;
            conn.prepareStatement(cursor).execute();
            cursor = "OPEN " + cursorName;
            conn.prepareStatement(cursor).execute();
            cursor = "FETCH NEXT FROM " + cursorName;
            ResultSet rs = conn.prepareStatement(cursor).executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((1 == rs.getByte(1) || 2 == rs.getByte(1) || 3 == rs.getByte(1) ? 1 : 0) != 0);
                Assert.assertTrue((128 == rs.getShort(2) || 129 == rs.getShort(2) || 130 == rs.getShort(2) ? 1 : 0) != 0);
                Assert.assertTrue((0.01f == rs.getFloat(3) || 0.02f == rs.getFloat(3) || 0.03f == rs.getFloat(3) ? 1 : 0) != 0);
                Assert.assertTrue((1.0E-4 == rs.getDouble(4) || 2.0E-4 == rs.getDouble(4) || 3.0E-4 == rs.getDouble(4) ? 1 : 0) != 0);
                if (++count == 3) break;
                rs = conn.prepareStatement(cursor).executeQuery();
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
        finally {
            String sql = "CLOSE " + cursorName;
            conn.prepareStatement(sql).execute();
            conn.close();
        }
    }

    @Test
    public void testCursorWithIndex() throws Exception {
        String cursorName = CursorWithRowValueConstructorIT.generateUniqueName();
        String tableName = CursorWithRowValueConstructorIT.generateUniqueName();
        String indexName = CursorWithRowValueConstructorIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(CursorWithRowValueConstructorIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        String createTable = "CREATE TABLE IF NOT EXISTS " + tableName + "\n(  \n   ID                             VARCHAR    NOT NULL,\n   NAME                           VARCHAR    ,\n   ANOTHER_VALUE                  VARCHAR    ,\n   TRANSACTION_TIME               TIMESTAMP  ,\n   CONSTRAINT pk PRIMARY KEY(ID)\n)";
        stmt.execute(createTable);
        String createIndex = "CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(NAME, TRANSACTION_TIME DESC) INCLUDE(ANOTHER_VALUE)";
        stmt.execute(createIndex);
        DecimalFormat dmf = new DecimalFormat("0000");
        String prefix = "ReferenceData.Country/";
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                PreparedStatement prstmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?,?)");
                prstmt.setString(1, UUID.randomUUID().toString());
                prstmt.setString(2, "ReferenceData.Country/" + dmf.format(i + j * 1000));
                prstmt.setString(3, UUID.randomUUID().toString());
                prstmt.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                prstmt.execute();
                conn.commit();
                prstmt.close();
            }
        }
        String countSQL = "SELECT COUNT(1) AS TOTAL_ITEMS FROM " + tableName + " where NAME like 'ReferenceData.Country/2%' ";
        ResultSet rs = stmt.executeQuery(countSQL);
        rs.next();
        int totalCount = rs.getInt("TOTAL_ITEMS");
        rs.close();
        String cursorSQL = "DECLARE " + cursorName + " CURSOR FOR SELECT NAME,ANOTHER_VALUE FROM " + tableName + " where NAME like 'ReferenceData.Country/2%' ORDER BY TRANSACTION_TIME DESC";
        PreparedStatement cursorStatement = conn.prepareStatement(cursorSQL);
        cursorStatement.execute();
        PreparedStatement openCursorStatement = conn.prepareStatement("OPEN " + cursorName);
        openCursorStatement.execute();
        rs = stmt.executeQuery("EXPLAIN FETCH NEXT 10 ROWS FROM " + cursorName);
        rs.next();
        Assert.assertTrue((boolean)rs.getString(1).contains("CLIENT PARALLEL 1-WAY RANGE SCAN"));
        PreparedStatement next10Rows = conn.prepareStatement("FETCH NEXT 10 ROWS FROM " + cursorName);
        int itemsReturnedByCursor = 0;
        do {
            ResultSet cursorRS = next10Rows.executeQuery();
            int rowsReadBeforeEmpty = 0;
            while (cursorRS.next()) {
                ++itemsReturnedByCursor;
                ++rowsReadBeforeEmpty;
            }
            if (rowsReadBeforeEmpty <= 0) {
                conn.prepareStatement("CLOSE " + cursorName).executeUpdate();
                break;
            }
            cursorRS.close();
        } while (itemsReturnedByCursor <= totalCount * 3);
        Assert.assertEquals((long)totalCount, (long)itemsReturnedByCursor);
    }
}

