/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.BaseOwnClusterIT;
import org.apache.phoenix.end2end.LogicalTableNameIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.CsvBulkLoadTool;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CsvBulkLoadToolIT
extends BaseOwnClusterIT {
    private static Connection conn;
    private static String zkQuorum;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.FALSE.toString());
        CsvBulkLoadToolIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS, new ReadOnlyProps(clientProps.entrySet().iterator()));
        zkQuorum = "localhost:" + CsvBulkLoadToolIT.getUtility().getZkCluster().getClientPort();
        conn = DriverManager.getConnection(CsvBulkLoadToolIT.getUrl());
    }

    @Test
    public void testBasicImport() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE S.TABLE1 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE) SPLIT ON (1,2)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.println("2,Name 2,1970/01/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv", "--table", "table1", "--schema", "s", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM s.table1 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithGlobalIndex() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE S.TABLE1 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE) SPLIT ON (1,2)");
        stmt.execute("CREATE INDEX glob_idx ON S.TABLE1(ID, T)");
        conn.commit();
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.println("2,Name 2,1970/01/02");
        printWriter.close();
        fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        outputStream = fs.create(new Path("/tmp/input2.csv"));
        printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("3,Name 3,1970/01/03");
        printWriter.println("4,Name 4,1970/01/04");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv", "--table", "table1", "--schema", "s", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        try {
            exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input2.csv", "--table", "table1", "--schema", "s", "--zookeeper", zkQuorum});
            Assert.assertTrue((String)"Bulk loading error should have happened earlier", (exitCode != 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)"Tools should return non-zero exit codes on failure instead of throwing an exception");
        }
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM s.table1 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input2.csv", "--table", "table1", "--schema", "s", "--zookeeper", zkQuorum, "--corruptindexes"});
        Assert.assertEquals((long)0L, (long)exitCode);
        rs = stmt.executeQuery("SELECT id, name, t FROM s.table1 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 3", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-03"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 4", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-04"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithRowTimestamp() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE S.TABLE9 (ID INTEGER NOT NULL , NAME VARCHAR, T DATE NOT NULL, CONSTRAINT PK PRIMARY KEY (ID, T ROW_TIMESTAMP))");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.println("2,Name 2,1971/01/01");
        printWriter.println("3,Name 2,1972/01/01");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv", "--table", "table9", "--schema", "s", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM s.table9 WHERE T < to_date('1972-01-01') AND T > to_date('1970-01-01') ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1971-01-01"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithTabs() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE8 (ID INTEGER NOT NULL PRIMARY KEY, NAME1 VARCHAR, NAME2 VARCHAR)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input8.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1\tName 1a\tName 2a");
        printWriter.println("2\tName 2a\tName 2b");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input8.csv", "--table", "table8", "--zookeeper", zkQuorum, "--delimiter", "\\t"});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name1, name2 FROM table8 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1a", (Object)rs.getString(2));
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithTabsAndEmptyQuotes() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE8 (ID INTEGER NOT NULL PRIMARY KEY, NAME1 VARCHAR, NAME2 VARCHAR)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input8.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1\t\"\\t123\tName 2a");
        printWriter.println("2\tName 2a\tName 2b");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input8.csv", "--table", "table8", "--zookeeper", zkQuorum, "-q", "", "-e", "", "--delimiter", "\\t"});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name1, name2 FROM table8 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"\"\\t123", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Name 2a", (Object)rs.getString(3));
        rs.close();
        stmt.close();
    }

    @Test
    public void testFullOptionImport() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE2 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, NAMES VARCHAR ARRAY)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input2.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1|Name 1a;Name 1b");
        printWriter.println("2|Name 2a;Name 2b");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input2.csv", "--table", "table2", "--zookeeper", zkQuorum, "--delimiter", "|", "--array-delimiter", ";", "--import-columns", "ID,NAMES"});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, names FROM table2 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Name 1a", "Name 1b"}, (Object[])((Object[])rs.getArray(2).getArray()));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertArrayEquals((Object[])new Object[]{"Name 2a", "Name 2b"}, (Object[])((Object[])rs.getArray(2).getArray()));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testMultipleInputFiles() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE7 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE) SPLIT ON (1,2)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.close();
        outputStream = fs.create(new Path("/tmp/input2.csv"));
        printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("2,Name 2,1970/01/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv,/tmp/input2.csv", "--table", "table7", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM table7 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithIndex() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE3 (ID INTEGER NOT NULL PRIMARY KEY, FIRST_NAME VARCHAR, LAST_NAME VARCHAR)");
        String ddl = "CREATE INDEX TABLE3_IDX ON TABLE3  (FIRST_NAME ASC) INCLUDE (LAST_NAME)";
        stmt.execute(ddl);
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input3.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,FirstName 1,LastName 1");
        printWriter.println("2,FirstName 2,LastName 2");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input3.csv", "--table", "table3", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, FIRST_NAME FROM TABLE3 where first_name='FirstName 2'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"FirstName 2", (Object)rs.getString(2));
        rs.close();
        stmt.close();
        IndexTestUtil.assertRowsForEmptyColValue(conn, "TABLE3_IDX", QueryConstants.VERIFIED_BYTES);
    }

    @Test
    public void testImportWithLocalIndex() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TABLE6 (ID INTEGER NOT NULL PRIMARY KEY, FIRST_NAME VARCHAR, LAST_NAME VARCHAR) SPLIt ON (1,2)");
        String ddl = "CREATE LOCAL INDEX TABLE6_IDX ON TABLE6  (FIRST_NAME ASC)";
        stmt.execute(ddl);
        ddl = "CREATE LOCAL INDEX TABLE6_IDX2 ON TABLE6  (LAST_NAME ASC)";
        stmt.execute(ddl);
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input3.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,FirstName 1,LastName 1");
        printWriter.println("2,FirstName 2,LastName 2");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input3.csv", "--table", "table6", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, FIRST_NAME FROM TABLE6 where first_name='FirstName 2'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"FirstName 2", (Object)rs.getString(2));
        rs = stmt.executeQuery("SELECT LAST_NAME FROM TABLE6  where last_name='LastName 1'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LastName 1", (Object)rs.getString(1));
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportOneIndexTable() throws Exception {
        this.testImportOneIndexTable("TABLE4", false);
    }

    @Test
    public void testImportOneLocalIndexTable() throws Exception {
        this.testImportOneIndexTable("TABLE5", true);
    }

    public void testImportOneIndexTable(String tableName, boolean localIndex) throws Exception {
        String indexTableName = String.format("%s_IDX", tableName);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + tableName + "(ID INTEGER NOT NULL PRIMARY KEY, FIRST_NAME VARCHAR, LAST_NAME VARCHAR)");
        String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexTableName + " ON " + tableName + "(FIRST_NAME ASC)";
        stmt.execute(ddl);
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input4.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,FirstName 1,LastName 1");
        printWriter.println("2,FirstName 2,LastName 2");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input4.csv", "--table", tableName, "--index-table", indexTableName, "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
        Assert.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("SELECT FIRST_NAME FROM " + tableName + " where FIRST_NAME='FirstName 1'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FirstName 1", (Object)rs.getString(1));
        rs.close();
        stmt.close();
        if (!localIndex) {
            IndexTestUtil.assertRowsForEmptyColValue(conn, indexTableName, QueryConstants.VERIFIED_BYTES);
        }
    }

    @Test
    public void testImportWithDifferentPhysicalName() throws Exception {
        String schemaName = "S_" + CsvBulkLoadToolIT.generateUniqueName();
        String tableName = "TBL_" + CsvBulkLoadToolIT.generateUniqueName();
        String indexTableName = String.format("%s_IDX", tableName);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexTableName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + fullTableName + "(ID INTEGER NOT NULL PRIMARY KEY, FIRST_NAME VARCHAR, LAST_NAME VARCHAR)");
        String ddl = "CREATE  INDEX " + indexTableName + " ON " + fullTableName + "(FIRST_NAME ASC)";
        stmt.execute(ddl);
        String newTableName = "NEW_TBL_" + CsvBulkLoadToolIT.generateUniqueName();
        String fullNewTableName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            String snapshotName = tableName + "-Snapshot";
            admin.snapshot(snapshotName, TableName.valueOf((String)fullTableName));
            admin.cloneSnapshot(snapshotName, TableName.valueOf((String)fullNewTableName));
        }
        LogicalTableNameIT.renameAndDropPhysicalTable(conn, "NULL", schemaName, tableName, newTableName, false);
        String csvName = "/tmp/input_logical_name.csv";
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path(csvName));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,FirstName 1,LastName 1");
        printWriter.println("2,FirstName 2,LastName 2");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", csvName, "--table", tableName, "--schema", schemaName, "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT /*+ NO_INDEX */ id, FIRST_NAME FROM " + fullTableName + " where first_name='FirstName 2'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"FirstName 2", (Object)rs.getString(2));
        String selectFromIndex = "SELECT FIRST_NAME FROM " + fullTableName + " where FIRST_NAME='FirstName 1'";
        rs = stmt.executeQuery("EXPLAIN " + selectFromIndex);
        Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains(indexTableName));
        rs = stmt.executeQuery(selectFromIndex);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FirstName 1", (Object)rs.getString(1));
        String csvNameForIndex = "/tmp/input_logical_name_index.csv";
        outputStream = fs.create(new Path(csvNameForIndex));
        printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("3,FirstName 3,LastName 3");
        printWriter.close();
        exitCode = csvBulkLoadTool.run(new String[]{"--input", csvNameForIndex, "--table", tableName, "--schema", schemaName, "--index-table", indexTableName, "--zookeeper", zkQuorum, "--corruptindexes"});
        Assert.assertEquals((long)0L, (long)exitCode);
        selectFromIndex = "SELECT FIRST_NAME FROM " + fullTableName + " where FIRST_NAME='FirstName 3'";
        rs = stmt.executeQuery("EXPLAIN " + selectFromIndex);
        Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains(indexTableName));
        rs = stmt.executeQuery(selectFromIndex);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FirstName 3", (Object)rs.getString(1));
        rs.close();
        stmt.close();
        IndexTestUtil.assertRowsForEmptyColValue(conn, fullIndexTableName, QueryConstants.VERIFIED_BYTES);
    }

    @Test
    public void testInvalidArguments() {
        String tableName = "TABLE8";
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
        try {
            int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input4.csv", "--table", tableName, "--zookeeper", zkQuorum});
            Assert.assertTrue((String)String.format("Table %s not created, hence should fail", tableName), (exitCode != 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)"Tools should return non-zero exit codes on failure instead of throwing an exception");
        }
    }

    @Test
    public void testAlreadyExistsOutputPath() {
        String tableName = "TABLE9";
        String outputPath = "/tmp/output/tabl9";
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + "(ID INTEGER NOT NULL PRIMARY KEY, FIRST_NAME VARCHAR, LAST_NAME VARCHAR)");
            FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
            fs.create(new Path(outputPath));
            FSDataOutputStream outputStream = fs.create(new Path("/tmp/input9.csv"));
            PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
            printWriter.println("1,FirstName 1,LastName 1");
            printWriter.println("2,FirstName 2,LastName 2");
            printWriter.close();
            CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
            csvBulkLoadTool.setConf(CsvBulkLoadToolIT.getUtility().getConfiguration());
            int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input9.csv", "--output", outputPath, "--table", tableName, "--zookeeper", zkQuorum});
            Assert.assertTrue((String)String.format("Output path %s already exists. hence, should fail", outputPath), (exitCode != 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)"Tools should return non-zero exit codes when fail, instead of throwing an exception");
        }
    }

    @Test
    public void testImportInImmutableTable() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE IMMUTABLE TABLE S.TABLE10 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE, CF1.T2 DATE, CF2.T3 DATE) ");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input10.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01,1970/02/01,1970/03/01");
        printWriter.println("2,Name 2,1970/01/02,1970/02/02,1970/03/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input10.csv", "--table", "table10", "--schema", "s", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t, CF1.T2, CF2.T3 FROM s.table10 ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-02-01"), (Object)rs.getDate(4));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-03-01"), (Object)rs.getDate(5));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-02-02"), (Object)rs.getDate(4));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-03-02"), (Object)rs.getDate(5));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportInSingleCellArrayWithOffsetsTable() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE IMMUTABLE TABLE S.TABLE12 (ID INTEGER NOT NULL PRIMARY KEY, CF0.NAME VARCHAR, CF0.T DATE, CF1.T2 DATE, CF2.T3 DATE) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS");
        PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
        PTable table = phxConn.getTable(new PTableKey(null, "S.TABLE12"));
        Assert.assertEquals((Object)PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, (Object)table.getImmutableStorageScheme());
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/inputSCAWO.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01,1970/02/01,1970/03/01");
        printWriter.println("2,Name 2,1970/01/02,1970/02/02,1970/03/02");
        printWriter.println("3,Name 1,1970/01/01,1970/02/03,1970/03/01");
        printWriter.println("4,Name 2,1970/01/02,1970/02/04,1970/03/02");
        printWriter.println("5,Name 1,1970/01/01,1970/02/05,1970/03/01");
        printWriter.println("6,Name 2,1970/01/02,1970/02/06,1970/03/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/inputSCAWO.csv", "--table", "table12", "--schema", "s", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT COUNT(1) FROM S.TABLE12");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getInt(1));
        rs.close();
        stmt.close();
    }

    @Test
    public void testIgnoreCsvHeader() throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE S.TABLE13 (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR)");
            Configuration conf = new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration());
            FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
            FSDataOutputStream outputStream = fs.create(new Path("/tmp/input13.csv"));
            try (PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);){
                printWriter.println("id,name");
                printWriter.println("1,Name 1");
                printWriter.println("2,Name 2");
                printWriter.println("3,Name 3");
            }
            CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
            csvBulkLoadTool.setConf(conf);
            int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input13.csv", "--table", "table13", "--schema", "s", "--zookeeper", zkQuorum, "--skip-header"});
            Assert.assertEquals((long)0L, (long)exitCode);
            try (ResultSet rs = stmt.executeQuery("SELECT COUNT(1) FROM S.TABLE13");){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testImportWithUpperCaseSchemaNameAndLowerCaseTableName() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE S.\"t\" (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE) SPLIT ON (1,2)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.println("2,Name 2,1970/01/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv", "--table", "\"t\"", "--schema", "S", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM S.\"t\" ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testImportWithLowerCaseSchemaNameAndUpperCaseTableName() throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE \"s\".T (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, T DATE) SPLIT ON (1,2)");
        FileSystem fs = FileSystem.get((Configuration)CsvBulkLoadToolIT.getUtility().getConfiguration());
        FSDataOutputStream outputStream = fs.create(new Path("/tmp/input1.csv"));
        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
        printWriter.println("1,Name 1,1970/01/01");
        printWriter.println("2,Name 2,1970/01/02");
        printWriter.close();
        CsvBulkLoadTool csvBulkLoadTool = new CsvBulkLoadTool();
        csvBulkLoadTool.setConf(new Configuration(CsvBulkLoadToolIT.getUtility().getConfiguration()));
        csvBulkLoadTool.getConf().set("phoenix.query.dateFormat", "yyyy/MM/dd");
        int exitCode = csvBulkLoadTool.run(new String[]{"--input", "/tmp/input1.csv", "--table", "T", "--schema", "\"s\"", "--zookeeper", zkQuorum});
        Assert.assertEquals((long)0L, (long)exitCode);
        ResultSet rs = stmt.executeQuery("SELECT id, name, t FROM \"s\".T ORDER BY id");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 1", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-01"), (Object)rs.getDate(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"Name 2", (Object)rs.getString(2));
        Assert.assertEquals((Object)DateUtil.parseDate((String)"1970-01-02"), (Object)rs.getDate(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }
}

